/*
	tsrlib.H

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#pragma inline

#include <ctype.H>
#include <dir.H>
#include <dos.H>
#include <fcntl.H>
#include <io.H>
#include <stdio.H>
#include <stdlib.H>
#include <string.H>

#undef isalnum
#undef isalpha
#undef isdigit
#undef islower
#undef isspace
#undef isupper
#undef isxdigit
#undef randomize

// =================================
// Event Handler Constants and Types
// =================================

#define NONE                            0
#define KEY                             1
#define MOUSE                           2
#define TIMER                           3

/* MCM - Mouse Cursor Moved     */
/* LBP - Left Button Pressed    */
/* LBR - Left Button Released   */
/* RBP - Right Button Pressed   */
/* RBR - Right Button Released  */
/* MBP - Middle Button Pressed  */
/* MBR - Middle Button Released */

#define ME_MCM                          1
#define ME_LBP                          2
#define ME_LBR                          4
#define ME_RBP                          8
#define ME_RBR                          16
#define ME_MBP                          32
#define ME_MBR                          64

typedef struct
	{
	   int type;
	   int parm1;
	   int parm2;
	   int parm3;
	   int parm4;
	}
	event;

#define NTIMER                          8

// ================================
// Format Directory Entry Constants
// ================================

#define DESIZE                          42

// ==============
// Graphics Types
// ==============

typedef struct RGB_color_typ
	{
	   unsigned char red;
	   unsigned char green;
	   unsigned char blue;
	}
	RGB_color, *RGB_color_ptr;

// ============
// Kernel Types
// ============

typedef struct
	{
	   long length;
	   unsigned srchandle;
	   long srcoffset;
	   unsigned desthandle;
	   long destoffset;
	}
	EMMS;                           // Extended Memory Move Structure

// ===================
// Keystroke Constants
// ===================

#define NUL                             0x0000
#define BS                              0x0008
#define TAB                             0x0009
#define LF                              0x000a
#define FF                              0x000c
#define CR                              0x000d
#define RET                             0x000d
#define ESC                             0x001b
#define STAB                            0x0f00
#define ALTA                            0x1e00
#define ALTB                            0x3000
#define ALTC                            0x2e00
#define ALTD                            0x2000
#define ALTE                            0x1200
#define ALTF                            0x2100
#define ALTG                            0x2200
#define ALTH                            0x2300
#define ALTI                            0x1700
#define ALTJ                            0x2400
#define ALTK                            0x2500
#define ALTL                            0x2600
#define ALTM                            0x3200
#define ALTN                            0x3100
#define ALTO                            0x1800
#define ALTP                            0x1900
#define ALTQ                            0x1000
#define ALTR                            0x1300
#define ALTS                            0x1f00
#define ALTT                            0x1400
#define ALTU                            0x1600
#define ALTV                            0x2f00
#define ALTW                            0x1100
#define ALTX                            0x2d00
#define ALTY                            0x1500
#define ALTZ                            0x2c00
#define F1                              0x3b00
#define F2                              0x3c00
#define F3                              0x3d00
#define F4                              0x3e00
#define F5                              0x3f00
#define F6                              0x4000
#define F7                              0x4100
#define F8                              0x4200
#define F9                              0x4300
#define F10                             0x4400
#define HOME                            0x4700
#define UP                              0x4800
#define PGUP                            0x4900
#define LEFT                            0x4b00
#define RIGHT                           0x4d00
#define END                             0x4f00
#define DOWN                            0x5000
#define PGDN                            0x5100
#define INS                             0x5200
#define DEL                             0x5300

// ==========================
// Video Constants and Macros
// ==========================

#define MDA                             0
#define CGA                             1
#define EGA_BW                          2
#define EGA_COLOR                       3
#define VGA_BW                          4
#define VGA_COLOR                       5

#define BW80                            2
#define C80                             3
#define MONO                            7

#define BLACK                           0
#define BLUE                            1
#define GREEN                           2
#define CYAN                            3
#define RED                             4
#define MAGENTA                         5
#define BROWN                           6
#define LIGHTGRAY                       7

#define DARKGRAY                        8
#define LIGHTBLUE                       9
#define LIGHTGREEN                      10
#define LIGHTCYAN                       11
#define LIGHTRED                        12
#define LIGHTMAGENTA                    13
#define YELLOW                          14
#define WHITE                           15

#define BLINK                           128

#define SINGLE_LINE                     0
#define DOUBLE_LINE                     1
#define BLOCK_LINE                      2
#define NOBORDER                        3

#define SCREEN_SAVE                     0
#define SCREEN_RESTORE                  1

#define SCROLL_UP                       0
#define SCROLL_DN                       1

#define center(x, y)                    ((((x)-(y))>>1)+1)

#define v_clear(a,b,c,d)                v_paint (' ', (a), (b), (c), (d))

#define VIDEO_INT                       asm { \
						push bp; \
						int 10h; \
						pop bp; \
					}

// ==========================
// Window Constants and Types
// ==========================

#define WINF_HBAR                       1
#define WINF_VBAR                       2

typedef struct
	{
	   int x;
	   int y;
	   int nx;
	   int ny;
	   int bdattr;
	   int tlattr;
	   int txattr;
	   int flags;
	   char *title;
	   char *scrn_buffer;
	   int scrn_x;
	   int scrn_y;
	   int curx;                    // current cursor x position
	   int cury;                    // current cursor y position
	}
	WINDOW;

// ==========================
// Kernel Function Prototypes
// ==========================

/* Installation Kernel */

int             cleanup                 (void);
int             parse                   (void);
void            setcseg                 (void);
void            setrseg                 (void);
int             setup                   (void);
void            skipws                  (void);
void            unparse                 (void);
int             xparse                  (int option);

/* Resident Kernel */

int             ismoudrv                (void);
int		isXMSdrv		(void);

void            beep                    (void);
void            nosound                 (void);
void            pause                   (unsigned ticks);
void            sound                   (unsigned frequency);

int             XMS_Alloc               (unsigned nkilos);
int             XMS_Copy                (EMMS *x);
int             XMS_Exists              (void);
int             XMS_Free                (unsigned handle);
long            XMS_Lock                (unsigned handle);
int             XMS_Query               (unsigned *nkilos,
					 unsigned *maxblocksize);
int             XMS_Realloc             (unsigned handle, unsigned nkilos);
int             XMS_Unlock              (unsigned handle);

// ===========================
// Library Function Prototypes
// ===========================

void            e_close                 (void);
void            e_fetch                 (event *e);
void            e_flush                 (void);
int             e_gettimer              (int id);
int             e_gettrigger            (void);
void            e_hide                  (void);
void            e_open                  (void);
void            e_settimer              (int id, int value);
void            e_settrigger            (int value);
void            e_show                  (void);
void            e_tresume               (int id);
void            e_tsuspend              (int id);
void            fde                     (struct ffblk *de, char *buffer);
int pascal      format                  (void (*func) (int),
					 const char *fmt, void *ap);
int             getstr                  (char *buffer,
					 unsigned char maxlen);
void            g_createcoolpalette     (void);
void            g_getpaletteregister    (int index, RGB_color_ptr color);
void            g_line                  (int x1, int y1, int x2, int y2,
					 int c);
void            g_lineto                (int x, int y, int c);
void            g_moveto                (int x, int y);
void            g_plot                  (int x, int y,
					 unsigned char color);
unsigned char   g_read                  (int x, int y);
void            g_setpaletteregister    (int index, RGB_color_ptr color);
void            g_writechr              (int c, int color, int ftrans);
void            g_writestr              (char *s, int color, int ftrans);
int             isleap                  (int year);
char            *_itoa                  (int value, char *string);
int             k_fetch                 (void);
int             k_iskey                 (void);
char            *_ltoa                  (long value, char *string);
void            memswap                 (void *addr1, void *addr2,
					 size_t n);
void            m_hide                  (void);
void            m_insttask              (unsigned mask, unsigned taskseg,
					 unsigned taskofs);
void            m_moveto                (int col, int row);
void		m_restorectx		(void);
void            m_rowrange              (int vmin, int vmax);
void		m_savectx		(void);
void            m_show                  (void);
void            randomize               (void);
int             sprintf                 (char *buffer,
					 const char *fmt, ...);
void            update_cursor           (void);
int             v_aa                    (void);
void            v_border                (int style, int x, int y, int nx,
					 int ny);
int             v_cprintf               (const char *fmt, ...);
int             v_cputs                 (const char *str);
int             v_getattr               (void);
int             v_getmode               (void);
int             v_getshape              (void);
void            v_gotoxy                (int x, int y);
void            v_paint                 (int c, int x, int y, int nx,
					 int ny);
int             v_putch                 (int c, int count);
void            v_screen                (int cmd, int x, int y, int nx,
					 int ny, void *buffer);
void            v_scroll                (int x, int y, int nx, int ny,
					 int dir, int nblines, int attr);
void            v_setattr               (int attr);
void            v_setshape              (int shape);
void            v_shadow                (int x1, int y1, int nx, int ny);
int             v_wherex                (void);
int             v_wherey                (void);
void            w_create                (WINDOW *w);
void            w_destroy               (WINDOW *w);
void            w_gotoxy                (WINDOW *w, int x, int y);
void            w_puts                  (WINDOW *w, char *text);
void            w_scroll                (WINDOW *w, int dir);
void            w_setscrollpos          (WINDOW *w, int bar, int pos);
