/*
	strncpy.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_STRNCPY

char *strncpy (char *dest, const char *src, size_t maxlen)
{
   _ES = _DS;

   asm cld

   _SI = _DI = (unsigned) src;
   _BX = _CX = (unsigned) maxlen;

   asm mov al, 0
   asm repnz scasb;             /* search for null terminator */

   _BX -= _CX;                  /* bx is actual length of string */
   _DI = (unsigned) dest;

   asm xchg cx, bx              /* bx is number of nulls to pad */
   asm repz movsb

   _CX = _BX;                   /* cx is number of nulls to pad */

   asm repz stosb;              /* pad with nulls */

   _AX = (unsigned) dest;       /* return destination */
}
