/*
	mouse.C

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#define INCL_MOUSE

struct
{
   char buffer [1000];
   int fcursor;
}
mouse_vars;

/* ---------------------- */
/* void m_hide (void);    */
/*                        */
/* Hide the mouse cursor. */
/* ---------------------- */

void m_hide (void)
{
   _AX = 2;
   geninterrupt(0x33);
}

/* -------------------------------------------------------------------- */
/* void m_insttask (unsigned mask, unsigned taskseg, unsigned taskofs); */
/*                                                                      */
/* Install a mouse task handler (also known as an interrupt handler).   */
/* Whenever a mouse button is pressed/released or the mouse is moved,   */
/* this handler will be called but only for those activities defined    */
/* by the mask argument.  Mask bits are interpreted as follows.         */
/*                                                                      */
/* Bit  Event                                                           */
/*  0    mouse cursor moved                                             */
/*  1    left button pressed                                            */
/*  2    left button released                                           */
/*  3    right button pressed                                           */
/*  4    right button released                                          */
/*  5    middle button pressed                                          */
/*  6    middle button released                                         */
/* -------------------------------------------------------------------- */

void m_insttask (unsigned mask, unsigned taskseg, unsigned taskofs)
{
   _CX = mask;
   _DX = taskofs;
   _ES = taskseg;
   _AX = 12;
   geninterrupt(0x33);
}

/* --------------------------------- */
/* void m_moveto (int col, int row); */
/*                                   */
/* Set the mouse cursor position.    */
/* The col and row arguments contain */
/* a position specified in pixels.   */
/* --------------------------------- */

void m_moveto (int col, int row)
{
   _CX = col;
   _DX = row;
   _AX = 4;
   geninterrupt(0x33);
}

/* ------------------------------------------------------------------ */
/* void m_restorectx (void);                                          */
/*                                                                    */
/* Restore the current mouse context to the previously saved context. */
/* ------------------------------------------------------------------ */

void m_restorectx (void)
{
   unsigned fcursor, i, n;

   if (!ismoudrv ())
       return;

   _AX = 36;            // Get the driver version number.
   geninterrupt(0x33);

   if (_BX >= 0x0702)
   {
       _AX = 42;        // Get the cursor hide/show status.
       geninterrupt(0x33);

       fcursor = _AX;

       if (fcursor < mouse_vars.fcursor)
       {
	   n = mouse_vars.fcursor-fcursor;
	   for (i = 0; i < n; i++)
		m_show ();      // Cursor hidden, previously visible.
       }
       else
       if (fcursor > mouse_vars.fcursor)
       {
	   n = fcursor-mouse_vars.fcursor;
	   for (i = 0; i < n; i++)
		m_hide ();      // Cursor visible, previously hidden.
       }
   }

   _ES = FP_SEG(mouse_vars.buffer);
   _DX = FP_OFF(mouse_vars.buffer);
   _AX = 0x17;
   geninterrupt(0x33);
}

/* ------------------------------------- */
/* void m_rowrange (int vmin, int vmax); */
/*                                       */
/* Set the range of screen rows that the */
/* mouse cursor can move around.         */
/* ------------------------------------- */

void m_rowrange (int vmin, int vmax)
{
   _CX = vmin;
   _DX = vmax;
   _AX = 8;
   geninterrupt(0x33);
}

/* ------------------------------- */
/* void m_savectx (void);          */
/*                                 */
/* Save the current mouse context. */
/* ------------------------------- */

void m_savectx (void)
{
   unsigned fcursor;

   if (!ismoudrv ())
       return;

   _ES = FP_SEG(mouse_vars.buffer);
   _DX = FP_OFF(mouse_vars.buffer);
   _AX = 0x16;
   geninterrupt(0x33);

   _AX = 36;            // Get the driver version number.
   geninterrupt(0x33);

   if (_BX >= 0x0702)
   {
       _AX = 42;        // Get the cursor hide/show status.
       geninterrupt(0x33);

       fcursor = _AX;
       mouse_vars.fcursor = fcursor;

       if (!fcursor)    // If cursor is visible, hide it.
	   m_hide ();
   }

   m_moveto (0, 0);
   m_rowrange (0, peekb (0x40, 0x84) << 3);
}

/* ---------------------- */
/* void m_show (void);    */
/*                        */
/* Show the mouse cursor. */
/* ---------------------- */

void m_show (void)
{
   _AX = 1;
   geninterrupt(0x33);
}
