/*
	memchr.C

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#define INCL_MEMCHR

void *memchr (const void *s, int c, size_t n)
{
   if (n)
   {
       _ES = _DS;
       _DI = (unsigned) s;
       _CX = (unsigned) n;
       _AL = (unsigned char) c;

       asm cld
       asm repnz scasb	/* scan for character */
       asm jz memchr1	/* branch if found */
   }

   _DI = 1;		/* setup for decrement to 0 (not found) */

memchr1:

   asm dec di		/* point to character or 0 if not found */

   return (void *) _DI;
}