/*
	graphics.C

	WARNING: This graphics package is for mode 13h
		 (320x200 - 256 color) only!

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#define INCL_GRAPHICS

#define	PALETTE_MASK		0x3C6
#define	PALETTE_REGISTER_RD	0x3C7
#define	PALETTE_REGISTER_WR	0x3C8
#define	PALETTE_DATA		0x3C9

struct
{
   int curx;
   int cury;
   unsigned char far *rom_char_set;
   unsigned char far *video_buffer;
}
graphics_vars = { 0, 0, (char far *)0xF000FA6EL, (char far *)0xA0000000L };

/* ----------------------------------------------------------------- */
/* void g_createcoolpalette (void);                                  */
/*                                                                   */
/* Create a cool palette consisting of 64 shades of gray, 64 of red, */
/* 64 of green, and 64 of blue.                                      */
/* ----------------------------------------------------------------- */

void g_createcoolpalette (void)
{
   int index;
   RGB_color color;

   for (index = 0; index < 64; index++)
   {
	// grays

	color.red   = index;
	color.green = index;
	color.blue  = index;

	g_setpaletteregister (index, (RGB_color_ptr) &color);

	// reds

	color.red   = index;
	color.green = 0;
	color.blue  = 0;

	g_setpaletteregister (index+64, (RGB_color_ptr) &color);

	// greens

	color.red   = 0;
	color.green = index;
	color.blue  = 0;

	g_setpaletteregister (index+128, (RGB_color_ptr) &color);

	// blues

	color.red   = 0;
	color.green = 0;
	color.blue  = index;

	g_setpaletteregister (index+192, (RGB_color_ptr) &color);
   }

   // make color 0 black

   color.red   = 0;
   color.green = 0;
   color.blue  = 0;

   g_setpaletteregister (0, (RGB_color_ptr) &color);
}

/* ----------------------------------------------------------- */
/* void g_getpaletteregister (int index, RGB_color_ptr c);     */
/*                                                             */
/* Get the data out of a color lookup register and store it in */
/* the memory location pointed to by c.                        */
/* ----------------------------------------------------------- */

void g_getpaletteregister (int index, RGB_color_ptr c)
{
   // Set the palette mask register.

   outportb (PALETTE_MASK, 0xff);

   // Tell VGA card which register we will be reading.

   outportb (PALETTE_REGISTER_RD, index);

   // Now extract the data.

   c->red   = inportb (PALETTE_DATA);
   c->green = inportb (PALETTE_DATA);
   c->blue  = inportb (PALETTE_DATA);
}

/* -------------------------------------------------------- */
/* void g_line (int x1, int y1, int x2, int y2, int c);     */
/*                                                          */
/* Draw a line from (x1, y1) to (x2, y2) using the color c. */
/* Update the current location with (x2, y2).               */
/* -------------------------------------------------------- */

void g_line (int x1, int y1, int x2, int y2, int c)
{
   int a, b, d, diag_inc, dx_diag, dy_diag;
   int dx_nondiag, dy_nondiag, i, nondiag_inc, xchg, x, y;

   x = x1;
   y = y1;
   a = x2-x1;
   b = y2-y1;

   if (a < 0)
   {
       a = -a;
       dx_diag = -1;
   }
   else
       dx_diag = 1;

   if (b < 0)
   {
       b = -b;
       dy_diag = -1;
   }
   else
       dy_diag = 1;

   if (a < b)
   {
       xchg = a;
       a = b;
       b = xchg;
       dx_nondiag = 0;
       dy_nondiag = dy_diag;
   }
   else
   {
       dx_nondiag = dx_diag;
       dy_nondiag = 0;
   }

   d = b+b-a;
   nondiag_inc = b+b;
   diag_inc = b+b-a-a;

   for (i = 0; i <= a; i++)
   {
	g_plot (x, y, c);

	if (d < 0)
	{
	    x += dx_nondiag;
	    y += dy_nondiag;
	    d += nondiag_inc;
	}
	else
	{
	    x += dx_diag;
	    y += dy_diag;
	    d += diag_inc;
	}
   }

   graphics_vars.curx = x2;
   graphics_vars.cury = y2;
}

/* ------------------------------------- */
/* void g_lineto (int x, int y, int c);  */
/*                                       */
/* Draw a line from the current position */
/* to (x, y) using color c.              */
/* ------------------------------------- */

void g_lineto (int x, int y, int c)
{
   g_line (graphics_vars.curx, graphics_vars.cury, x, y, c);
}

/* ----------------------------------- */
/* void g_moveto (int x, int y);       */
/*                                     */
/* Set the current position to (x, y). */
/* ----------------------------------- */

void g_moveto (int x, int y)
{
   graphics_vars.curx = x;
   graphics_vars.cury = y;
}

/* ------------------------------------------------------------------ */
/* g_plot                                                             */
/*                                                                    */
/* Plot a pixel of a specified color on the 320x200 256-color screen. */
/* ------------------------------------------------------------------ */

void g_plot (int x, int y, unsigned char c)
{
   graphics_vars.video_buffer [((y<<8) + (y<<6)) + x] = c;
}

/* -------------------------------------------- */
/* g_read                                       */
/*                                              */
/* Read the color of a pixel located at (x, y). */
/* -------------------------------------------- */

unsigned char g_read (int x, int y)
{
   return graphics_vars.video_buffer [((y<<8) + (y<<6)) + x];
}

/* ------------------------------------------------------------ */
/* void g_setpaletteregister (int index, RGB_color_ptr c);      */
/*                                                              */
/* Set the data in a color lookup register with the value found */
/* in the memory location pointed to by c.                      */
/* ------------------------------------------------------------ */

void g_setpaletteregister (int index, RGB_color_ptr c)
{
   // Set the palette register mask.

   outportb (PALETTE_MASK, 0xff);

   // Tell VGA card which register we will be updating.

   outportb (PALETTE_REGISTER_WR, index);

   // Now update the RGB triple.

   outportb (PALETTE_DATA, c->red);
   outportb (PALETTE_DATA, c->green);
   outportb (PALETTE_DATA, c->blue);
}

/* --------------------------------------------------------------- */
/* void g_writechr (int c, int color, int ftrans);                 */
/*                                                                 */
/* Write a character at the current cursor position (see g_moveto) */
/* in the specified color.  If ftrans is nonzero then paint the    */
/* background using color otherwise paint the background using 0.  */
/* --------------------------------------------------------------- */

void g_writechr (int c, int color, int ftrans)
{
   int offset, x, y;
   char far *work_char;
   unsigned char bit_mask = 0x80;

   work_char = graphics_vars.rom_char_set+(c << 3);

   offset = (graphics_vars.cury << 8) + (graphics_vars.cury << 6)
	    + graphics_vars.curx;

   for (y = 0; y < 8; y++)
   {
	bit_mask = 0x80;

	for (x = 0; x < 8; x++)
	{
	     if ((*work_char & bit_mask))
		 graphics_vars.video_buffer [offset+x] = color;
	     else
	     if (!ftrans)
		 graphics_vars.video_buffer [offset+x] = 0;

	     bit_mask >>= 1;
	}

	offset += 320;
	work_char++;
   }
}

/* ------------------------------------------------------------ */
/* void g_writestr (char *s, int color, int ftrans);            */
/*                                                              */
/* Write a string starting at the current cursor position (see  */
/* g_moveto) in the specified color.  If ftrans is nonzero then */
/* paint the background using color otherwise paint the back-   */
/* ground using 0.                                              */
/* ------------------------------------------------------------ */

void g_writestr (char *s, int color, int ftrans)
{
   int index;

   for (index = 0; s [index]; index++, graphics_vars.curx += 8)
	g_writechr (s [index], color, ftrans);
}
