/*
	fileleng.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_FILELENGTH

#ifndef INCL_LSEEK
#include "lseek.C"
#endif

#ifndef INCL_TELL
#include "tell.C"
#endif

long filelength (int handle)
{
   long current, end;

   if ((current = tell (handle)) == -1L)
       return -1L;

   if ((end = lseek (handle, 0L, SEEK_END)) == -1L)
       return -1L;

   if (lseek (handle, current, SEEK_SET) == -1L)
       return -1L;

   return end;
}
