// GENERAL
//
// This is an example C++ program which demonstrates how to interface your
// own executable programs with the~first byte.
//
// This typical user program (SECT.EXE) can be used as a template for future
// c++ programs: Note code marked //#### is generic to all C++ programs that
// interface with the~first byte.
//
// GENERIC FUNCTION
//
// Included on the installation disk are several useful C++ herader files
// which are used below and available for your convenience.
//
//    readset.h	  Reads the general setup file
//    readata.h	  Reads the module data file. This function is the main
//                interface with the~first byte
//    dbsdata.h   Reads the database files created by OTHER modules. The other
//                module names are passed to this module via command line
//                arguments.
//
//		  eg     SECT module_1.int, module_2.int .......module_5.int
//                a maximimum of 5 intermediate (.INT) database files can be
//                passed.
//
//    filename.h  Sets file name streams
//    savescr.h   Saves screen in memory before executing this code
//    restscr.h   restores screen previously saved in memory prior to returning
//                to program manager.
//
//####  Standard headers
#include <strstream.h>
#include <fstream.h>
#include <string.h>
#include <iomanip.h>
#include <conio.h>
#include <math.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include "general.h"
#include "manip.h"
//
//#### Main (SECT) routine starts here
int main(int argc, char *argv[], char *env[])
{
  ofstream out;     //####  module output file: named module(SECT).WRT
		    //      (programmer to write to this file).
  ofstream dbs;     //####  module database file: named module.INT
		    //      (programmer to write to this database file.)
  ofstream mess;    //####  Module summary/message/error file (programmer to
		    //      write to this file.

  ifstream dbase[5];//####  Maximum of five external database files previously
		    //      written by other user programs. The names of these
		    //      files are contained in argv[1]- argv[argc].

  ifstream in;      //####  input data file named: module(SECT).BAK

  char dbasdir[80]; //#### data base directory pathname(obtained from
		    //     THE=**** environment parameter

// datafile data defines as structure
  struct data {
      unsigned char textdat[132];  //#### contains contents of cell (string)
      float maxval;       //#### contains maximum allowable value
      float minval;       //#### contains minimum allowable value
      unsigned char units[9];      //#### contains current units (string)
      float conv1;        //#### contains conversion factor
      float conv2;        //#### contains conversion factor
      } data_in[150];     //#### maximum number of cells =150.

  float  cellval[151];     //#### contains contents of cell as a floating
			   //     point number converted back to default
			   //     dimension (SI definition) units

  float  dbaseval[5][50];  //##### 50 database floating point values per
			   //      database(5) file

  unsigned char dbasetxt[5][50][80];  // 25 database text strings per
				      // database file (5)

  int errcount=0;   //## initilise error counter

//### Include standard header files
#include "savescr.h"                 //#### save screen
#include "readset.h"                 //#### read standard setup file
#include "filename.h"                //#### set file names
#include "readata.h"                 //#### read module data file
#include "dbsdata.h"                 //#### read database files
//####  declare variables
///////////////////////////////////////////////////////////////////////////////
//
//  This section comprises the unique module code
//  Sect data is read from form file SECT.BAK - Note values are automatically
//  converted to base SI unit (first field in units.dat file).
//
//  cell No  1   Section elastic modulus        (N/m2)
//           2   Section linear mass            (kg/m)
//           3   Section 2nd moment of area     (m4)
//           4   Section top flange length      (m)
//           5   Web thickness                  (m)
//           6   Section depth                  (m)
//           7   Flange Thickness               (m)
//           8   Material density               (kg/m3)
//           9   Bottom flange length           (m)
//
//  output database file SECT.INT
//
//  No input database files required by this module
//
//  Start of module calculation
//
    float emod=0;
    float mass_per_length=0;
    float m_of_area_2=0;
    float ma2_flg_top=0;
    float ma2_flg_bot=0;
    float ma2_web=0;
    float ei=0;
    float flg_top_area=0;
    float flg_bot_area=0;
    float web_area=0;
    float total_area=0;
    float wd2_12=0;
    float n_axis=0;
    float density=0;
    float zt=0;
    float zb=0;

    mess << "\n SECT Module Message File\n";  //send message to message file

//  test relevant data must have :
//    cell 1
//  and either
//    cells 2 and 3
//  or
//    cells  8 and { (4 or 8) and 7) or (5 and 6)}

    if(cellval[1]<=0)
    {
//  > section elastic modulus not given
//    write message to message file and increment error count
      mess << "\n Data Error: \
	       \n             Elastic modulus has not been defined positively\n";
      errcount++;
    }
    emod=cellval[1];
//  set section propert flag  1 - mass/l and 2nd m of a given
//                            0 - mass/l and 2nd m of a calculated
    int sectflag=1;
    if(cellval[2]<0 || cellval[3]< 0)
    {
//  > either section linear mass or section 2nd moa is negative
//    write message to message file and increment error count
      mess << "\n Data Error: \
	       \n             Section linear mass and 2nd M of A must be defined positively\n\
	       \n             If Section properties to be calculated, then leave linear mass and\n\
	       \n             2nd M of A cells blank\n";

      errcount++;
      sectflag=-1;
    }
    else if(cellval[2]==0 || cellval[3]==0)
    {
//  > test section property data
      sectflag=0;
      if(cellval[8]<=0)
      {
	mess << "\n Data Error: \
		 \n             Section  material density has not been defined positively\n";
	errcount++;
	sectflag=-1;
      }
      if(cellval[6]<=0 || cellval[7]<=0)
      {
//    < cells 5 and 6 not valid
	if((cellval[5]<=0 && cellval[9]<=0) || cellval[8]<=0)
	{
	  mess << "\n Data Error: \
		   \n             Insufficient section goemetry data to calculate section properties\n";
	  errcount++;
	  sectflag=-1;
	}
      }
    }
//  test error count
    if(errcount)
    {
      mesbox1(13, 14, 0, " Incompatible data: Please check data entered in form;  ",
			 "                    values maybe out of range. ", WHITE, RED);
      mess << "\n Incompatible data: \
	       \n                    Please check data entered in form: SECT\n";
    }
    else if(sectflag==1)
    {
//  > section properties specified
      mass_per_length=cellval[2];
      m_of_area_2=cellval[3];
      ei=emod*cellval[3];
      n_axis=cellval[4];
      zt=cellval[3]/n_axis;
      zb=zt;
      out << "\n\n 1.0\t\tBeam Section Description\n\n\n";
      out << " 1.1\t\tBeam Properties\n\n";
      out << " \t\tMaterial Elastic Modulus:\t\t" << real(1)<< emod/1e9 << " GPa\n";
      out << " \t\tMaterial mass per unit length:\t\t" << real(1) << mass_per_length << " kg/m\n";
      out << " \t\t2nd Moment of Area:\t\t\t" << sci(3) << m_of_area_2*1e12 << " mm4\n";
      out << " \t\tDistance to neutral axis:\t\t" << real(1) << n_axis*1e3 << " mm\n\n\n";

      out << " 2.0\t\tBeam Section Properties\n\n";
      out << " \t\tFlexural Rigidity:\t\t\t" << sci(3) << ei << " Nm2\n";
      out << " \t\tSection Modulus\t\t\t\t" <<  sci(3)<< zt*1e9 << " mm3\n";
    }
    else if (sectflag==0)
    {
//  > Calculate section properties
      density=cellval[9];
      flg_top_area=cellval[5]*cellval[8];
      flg_bot_area=cellval[10]*cellval[8];
      web_area=(cellval[7]-2*cellval[8])*cellval[6];
      total_area=flg_top_area+flg_bot_area+web_area;
      mass_per_length=total_area*density;

//    neutral axis
      n_axis=(flg_top_area*(cellval[8]*1.5)+flg_bot_area*cellval[8]*.5+web_area*cellval[7]*.5)/total_area;

//    2nd M of A  (bd3/12)
      wd2_12=cellval[8]*cellval[8]/12;
      ma2_flg_top=flg_top_area*wd2_12;
      ma2_flg_bot=flg_bot_area*wd2_12;
      ma2_web=web_area*(cellval[7]-2*cellval[8])*(cellval[7]-2*cellval[8])/12;
      m_of_area_2=ma2_flg_bot+ma2_flg_top+ma2_web+
		  flg_top_area*pow((n_axis-(cellval[7]-cellval[8]*.5)),2)+
		  flg_bot_area*pow((n_axis-cellval[8]*.5),2);

//    flexural rigidity
      ei=emod*m_of_area_2;

//    section modulus
      zt=m_of_area_2/(cellval[7]-n_axis);
      zb=m_of_area_2/n_axis;


//    write output file (sect.wrt)

      out << "\n\n 1.0\t\tBeam Section Description\n\n\n";
      out << " 1.1\t\tBeam Properties\n\n";
      out << " \t\tMaterial Density:\t\t\t" << real(1) << density << " kg/m\n";
      out << " \t\tMaterial Elastic Modulus:\t\t" << real(1)<< emod/1e9 << " GPa\n";
      out << " \t\tMaterial mass per unit length:\t\t" << real(1) << mass_per_length << " kg/m\n\n\n";

      out << " 2.0\t\tBeam Section Properties\n\n";
      out << " \t\tSection area:\t\t\t\t" << real(1) << total_area*1e6 << " mm2\n";
      out << " \t\tNeutral Axis:\t\t\t\t" << real(1) << n_axis*1e3 << " mm\n";
      out << " \t\t2nd Moment of Area:\t\t\t" << sci(3) << m_of_area_2*1e12 << " mm4\n";
      out << " \t\tFlexural Rigidity:\t\t\t" << sci(3) << ei << " Nm2\n";
      out << " \t\tSection Modulus  -  top flange:\t\t" <<  sci(3)<< zt*1e9 << " mm3\n";
      out << " \t\t                 -  Bottom flange:\t" << sci(3)<< zb*1e9 << " mm3\n";
    }

//    write database file  (sect.int)
      dbs << mass_per_length*9.81  << "// section weight\n";
      dbs << density << "//  section density\n";
      dbs << emod << "//  Elastic modulus\n";
      dbs << mass_per_length << "//  mass per length\n";
      dbs << total_area << "//  total area\n";
      dbs << n_axis << "//  neutral axis (from bottom flange\n";
      dbs << m_of_area_2 << "//  2nd moment of area\n";
      dbs << ei << "//  Flexural rigidity\n";
      dbs << zt << "//  section modulus top\n";
      dbs << zb << "//  section modulus bottom\n";


///////////////////////////////////////////////////////////////////////////////
//#### close standard files
#include "restscr.h"                 //#### restore screen
#include "fclose.h"                  //#### close standard files

//#### return to the~first byte
  return(-errcount);  // return error flag to the~first byte
}

