// GENERAL
//
// This is a proforma to interface your own executable programs with
// the~first byte using C++ code.
//
//
// GENERIC Header files
//
// Included on the installation disk are several useful C++ header files
// which are used below and available for your convenience.
//
//    readset.h	  Reads the general setup file
//    readata.h	  Reads the module data file. This data file is the main
//                interface with the~first byte
//    dbsdata.h   Reads the database files created by OTHER modules. The other
//                module names are passed to this module via command line
//                arguments.
//
//    eg.         module.exe module_1.int, module_2.int .......module_5.int
//
//                A maximimum of 5 intermediate (.INT) database files can be
//                passed to the executable module.
//
//    filename.h  Sets file name streams
//    savescr.h   Saves screen in memory before executing this code
//    restscr.h   restores screen previously saved in memory prior to
//                returning control to the~first byte.
//    manip.h     Defines output format manipulators
//
//####  Standard headers
#include <strstream.h>
#include <fstream.h>
#include <string.h>
#include <iomanip.h>
#include <conio.h>
#include <dos.h>
#include <math.h>
#include <dir.h>
#include <stdlib.h>
#include "general.h"
//
//#### defines format manipulators
#include "manip.h"
//
//#### Main routine starts here
int main(int argc, char *argv[], char *env[])
{
  ofstream out;     //####  module output file: named module.WRT
		    //      (programmer to write to this file).
  ofstream dbs;     //####  module database file: named module.INT
		    //      (programmer to write to this database file.)
  ofstream mess;    //####  Module summary/message/error file (programmer to
		    //      write to this file.

  ifstream dbase[5];//####  Maximum of five external database files previously
		    //      written by other user programs. The names of these
		    //      files are contained in argv[1]- argv[argc].

  ifstream in;      //####  input data file named: module.BAK

//####  declare variables
  char dbasdir[80]; //#### data base directory pathname(obtained from
		    //     THE=**** environment parameter
// datafile data defines as structure
  struct data {
      unsigned char textdat[132];  //#### contains contents of cell (string)
      float maxval;                //#### contains maximum allowable value
      float minval;                //#### contains minimum allowable value
      unsigned char units[9];      //#### contains current units (string)
      float conv1;                 //#### contains conversion factor
      float conv2;                 //#### contains conversion factor
      } data_in[150];              //#### maximum number of cells =150.

  float  cellval[151];     //#### contains contents of cell as a floating
			   //     point number converted back to default
			   //     dimension (SI definition) units

  float  dbaseval[5][50];  //#### 50 database floating point values per
			   //     database(5) file

  unsigned char dbasetxt[5][50][80];  // 50 database text strings per
				      // database file (5)

  int errcount=0;          //#### initilise error counter

//### Include standard header files
#include "savescr.h"                 //#### save screen
#include "readset.h"                 //#### read standard setup file
#include "filename.h"                //#### set file names
#include "readata.h"                 //#### read module data file
#include "dbsdata.h"                 //#### read database files
///////////////////////////////////////////////////////////////////////////////
//
//  This next section comprises the unique module code
//
//  Database file module_n.INT created by the program module_n.EXE
//
//  array values dbasval[n][1]
//  where n= 1..5

//  Start of module calculation
//
  {
    mess << "\n XXXXX Module Message File\n";  //send message to message file

//  test error count
    if(errcount)
    {
      mesbox1(13, 14, 0, " Incompatible data: Please check data entered in form;  ",
			 "                    values maybe out of range. ", WHITE, RED);
      mess << "\n Incompatible data: \
	       \n                    Please check data entered in form: XXXX\n";
    }
    else
    {
//    write output file (module.wrt
      out << "\n\n Output file starts here\n\n\n";

//    write database file  (module.int)
      dbs << sci(7) <<  "// \n";
    }
  }
///////////////////////////////////////////////////////////////////////////////
#include "restscr.h"          //#### restore screen
#include "fclose.h"  	      //#### close standard files
//#### return to the~first byte
  return(-errcount);  // return error flag to the~first byte
}

