#define VIDMEM 0xB8000000
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
int setforg(int);
int setbackg(int);
int fbox1(int,int,int,int,int);
void prnstr(unsigned char[], int, int);
// externals
   int attrib;


int mesbox1(int rowt, int colt, int wide, unsigned char mess1[],
	    unsigned char mess2[], int forg,int backg)
/*
/  Draws a box on the screen using the following extended character
/  set ( ALT 217) ( ALT 218) ( ALT 191) ( ALT 192) ( ALT 196)
/
/  The box is defined by the top left corner (TLC) only and is 3 rows deep by
/  WIDE columns wide if WIDE is set to zero then message box is 4 columns
/  wider than message.
/
/  returns error code 0 if OK
*/                      
{      
   int height=3;
   int far *farptr;                                   
   int ir;   
   int ic;   
   int maxcol=80;
   int offset;
   int status;
   unsigned char tlc;
   unsigned char trc;
   unsigned char blc;
   unsigned char brc;
   unsigned char barv;
   unsigned char barh;   
      
/* test if second line of text input*/
   if (strlen(mess2) > 0)
     height=4;

/* test requested width of box*/
   if (wide == 0)             
/*>not specified  
/    calc width of box in characters*/
     wide=strlen(mess1)+4;
    
   else if (wide < strlen(mess1)+4)
/*>width specified is insufficient for message
/    return error 4 */
     return(4);
       
/* test if box position is specified correctly*/
   if (rowt< 1 || colt < 1)
/*> top corner out of bounds
/   return error code 1*/
    return(1);

   else if ((rowt+4) >25 || (colt+strlen(mess1)) > 80 )
/*> length or depth to great
/   return error code 2 */
    return(2);

   else
/*> corners ok 
    store current attribute and reset new */
    attrib=setforg(forg);
    attrib=setbackg(backg);

/*  fill box on screen with background colour*/
    fbox1(rowt,colt,(rowt+height-1),(colt+wide-1),backg);

/*  set box line draw characters*/
   {
    tlc  = 218; /*  */
    trc  = 191; /*  */
    barv = 179; /*  */
    barh = 196; /*  */
    blc  = 192; /*  */
    brc  = 217; /*  */

/* send top line to video memory */
   farptr= (int far *)VIDMEM ;
   offset= (rowt-1)*maxcol+colt-1;
   *(farptr+offset)=tlc | attrib<<8;
   for (ic=1; ic < wide; ic++)
   {
     *(farptr+offset+ic)=barh | attrib<<8;
   }
   *(farptr+offset+wide)=trc | attrib<<8;

/* send bottom line to video memory */
   farptr=(int far *) VIDMEM ;
   offset= (rowt+height-2)*maxcol+colt-1;
   *(farptr+offset)=blc | attrib<<8;
   for (ic=1; ic < wide; ic++)
   {
     *(farptr+offset+ic)=barh | attrib<<8;
   }
   *(farptr+offset+wide)=brc | attrib<<8;

/* send vertical lines to video memory */

   for (ir=rowt+1; ir< (rowt+height-1); ir++)
   {
     farptr= (int far *) VIDMEM;
     offset=(ir-1)*maxcol+ colt-1;
     *(farptr + offset)=barv | attrib<<8;
     *(farptr+ offset+wide)=barv | attrib<<8;
   }

/*  print message in box */
    prnstr(mess1,rowt+1,colt+3);
    if (height > 2)
    {
      prnstr(mess2,rowt+2,colt+3);
    }
    return(0);
   }
}


int setforg(int forg)
/* SETFORG  (FORG)
/
/  Sets the fore ground colour leaving other attributes unchanged.
/  All text written to video memory using the attrib variable will
/  aquire the new attributes after the call to this routine.
/
/  FORG  = 0  BLACK foreground colour
/          1  BLUE
/          2  GREEN
/          3  CYAN
/          4  RED
/          5  MAGENTA
/          6  BROWN
/          7  WHITE
/          8  GREY
/          9  LIGHT BLUE
/         10  LIGHT GREEN
/         11  LIGHT CYAN
/         12  LIGHT RED
/         13  LIGHT MAGENTA
/         14  YELLOW
/         15  INTENSE WHITE
/
/  returns error code -1 if error
*/
{
   int attrib;
/* test if colour is in range */
   if (forg < 0 || forg > 15)
/* > not a valid colour
/    exit program */
   {
     printf(" Invalid colour specified as argument <SETFORG>");
     exit(-1);
   }  

/* set foreground colour */
   attrib=attrib & 240;   /* mask foreground bits */
   attrib=attrib | forg; /* reset foreground attribute */
   return(attrib);
 }
int setbackg(int backg)
/* SETBACKG  (BACKG)
/
/  Sets the background colour leaving other attributes unchanged.
/  All text written to video memory using the attrib variable will
/  aquire the new attributes after the call to this routine.
/
/  BACKG = 0  BLACK Background colour
/          1  BLUE
/          2  GREEN
/          3  CYAN
/          4  RED
/          5  MAGENTA
/          6  BROWN
/          7  WHITE
/
*/
{
/* test if colour is in range */
   if (backg < 0 || backg > 7)
/* > not a valid colour
/    exit program */
   {
     printf(" Invalid colour specified as argument <SETBACKG>");
     exit(-1);
   }

/* set background colour */
   attrib=attrib & 143;   /* mask background bits */
   attrib=attrib | backg<<4; /* reset background attribute */
   return(attrib);
 }
int fbox1(int rowt, int colt, int rowb , int colb, int backg)
/* FBOX1  (ROWT, COLT, ROWB, COLB, backg)
/
/  sets the screen back ground colour BACKG over the area 
/  defined by the top left corner TLC and bottom right
/  corner (BRC). The TLC is at row ROWT and column COLT and the 
/  BRC is at row ROWB and column COLB
/
/  returns error code 0 if OK
*/                      
{    
   int att;      /* character attribute*/ 
   int ir;         
   int ic;
   int offset;
   int wide;     /* width of box*/
   int height;   /* height of box*/            
   int maxcol=80;
   int far *farptr;   
                                         
/* set background colour */
   att=setbackg(backg);

/* calc width of box in characters
/  calc height of box in charcaters */
   wide=colb-colt;
   height=rowb-rowt;


/* calculate stating address in video memory */
   farptr= (int far *) VIDMEM;
   
   for (ir=0; ir<=height; ir++)
   {   
     offset= (rowt-1+ir)*maxcol+colt-1;
     for (ic=0; ic <= wide; ic++)
     *(farptr+offset+ic)=32 | att<<8;  /* send space character to screen */                                  
   }
   return(0);
 }  
void prnstr(unsigned char text[], int row, int col)
/* PRNSTR  (STRING ROW COL)
/  
/  Print STRING to the screen starting at the current cursor position.
/  The string is printed using the current attribute setting stored
/  in the integer ATTRIB
*/                      
{           
   int is;                       
   int length;
   int offset;            
   int maxcol=80;
   int far *farptr;                                                            


/* set memory offset from top left corner of screen */
   farptr= (int far *)VIDMEM ;
   offset= (row-1)*maxcol+col-1;

// get length of string and print out string
   length=strlen(text);

// test if line feed CR is in string
   if(strchr(text,'\n')>NULL)
   {text[length-1]=NULL;}

   for (is=0; is <length; is++)
   {
     *(farptr+offset+is)=text[is] | attrib<<8;
   }                  
 }





    

