//   filtr()
//
//   Filters string text[] and separates data based on the following rules

//	  text field (string including white space) delimeted by character '
//	  literal character ' is preceded by character '
//   field separated by space or , if not embedded within in text field
//
//   examples:
//
//   'this is a string'  99.9,  -1, 'more text'
//
//    is parsed as
//
//    str[0]  =  this is a string
//    str[1]  =  99.9
//    str[2]  =  -1
//    str[3]  =  more text
//
//   and
//
//   'It's a string'
//
//   is parsed as:  It  because quotes do not match function returns error
//
//   'It''s a string' will parse:  It's a string
//
//
#include <string.h>
char* min(char* c1, char* c2);

int strfil(unsigned char text[], unsigned char str[][80], int *field_no)
{
   unsigned char *i;
   int text_del=0;
// initialise start of field address
   unsigned char *ptr;
   unsigned char *ptr_start;
   unsigned char work[132];

// initialise field counter 0
   *field_no=-1;

// initialise error flag 0
   int go=1;

// strip line feed character
   ptr=strchr(text,'\n');
   *ptr=0;
   strcpy(work,text);
   ptr=work;
   ptr_start=work;

// process length of input string
   while (*ptr!=NULL & go)
   {
     int comma=0;
     ptr=ptr_start+strlen(ptr_start);//   Find Next '
     i=strchr(ptr_start, 39);
     if(i!=NULL){ptr= (char*) min(i,ptr);}

//   test if text delimeter on
     if(!text_del)
     {
//   > text delimeter not on
//     Find Next ,
       i=strchr(ptr_start,44);
       if(i!=NULL){ptr=(char*) min(i,ptr);}

//     Find Next white space  (ws)
       i=strchr(ptr_start,32);
       if(i!=NULL){ptr=(char*) min(i,ptr);}
     }
     if(*ptr==NULL){go=0;}

//   Select which(lowest address) ' , or ws  character occurs first
//   case select
     if(*ptr==39)
     {
//   > ' character
//     test if text string delimeter on
       if(text_del)
       {
//     > text delimeter on
//       test next character
	 if(*(ptr+1)==39)
	 {
//       > next character is literal '
//         delete quota character from string
	   *(ptr+1)=0;
	   ptr+=2;
	   strcat(str[*field_no],ptr_start);
	   ptr_start=ptr;
	 }
	 else
	 {
//       > next character is not literal ' therefore end of text field found
//         increment field counter
//         save string
	   *ptr=0;  // terminate string
	   strcat(str[*field_no],ptr_start);
	   ptr=ptr+1;
//         strip leading whitespace and comma
	   while(*ptr==32)
	   {ptr++;}
	   if(*ptr==44){ptr++;}
	   while(*ptr==32)
	   {ptr++;}
	   ptr_start=ptr;
	   text_del=0;
	 }
       }
       else
       {
//     > text delimeter off
//       turn test delimeter on
	 text_del=1;
	 *field_no+=1;
	 strcpy(str[*field_no],"");
	 ptr+=1;
	 ptr_start=ptr;
       }
     }
     else
     {
//   > , or ws
//     test if text string delimeter on
       if(!text_del)
       {
//     > text delimeter off
//       test for ws
	 if(*ptr==32 & ptr==ptr_start)
	 {
//       > ws not a new string - just leading padding
	   ptr++;
	   ptr_start++;
	 }
	 else
	 {
//       > comma or ws new string
//         increment field counter
	   *field_no+=1;
// test if comma
	   if(*ptr==44){comma=1;}
//         save string
	   *ptr=0;  // terminate string
	   strcpy(str[*field_no],ptr_start);
	   ptr=ptr+1;
//         strip lagging whitespace and comma
	   while(*ptr==32)
	   {
	     ptr++;
	   }
	   if(*ptr==44 & !comma){ptr++;}
	   ptr_start=ptr;
	 }
       }
       else
       {
//     > text delimeter on
//       , must be a part of text field
	 *ptr=0;  // terminate string
       }
     }
   }
  *field_no+=1;
  return(-text_del);
}

char* min(char* c1, char* c2)
{
 return( (c1< c2) ? c1 : c2);
}