// GENERAL
//
// This is an example C++ program which demonstrates how to interface your
// own executable programs with the~first byte.
//
// This typical user program (BEAM.EXE) can be used as a proforma for future
// c++ programs: Note code marked //#### is generic to all C++ programs that
// interface with the~first byte.
//
// When you select the Run command, the first~byte executes the DOS command:
//
// c:\> beam sect.int
//
//
// GENERIC Header files
//
// Included on the installation disk are several useful C++ header files
// which are used below and available for your convenience.
//
//    readset.h	  Reads the general setup file
//    readata.h	  Reads the module data file. This data file is the main
//                interface with the~first byte
//    dbsdata.h   Reads the database files created by OTHER modules. The other
//                module names are passed to this module via command line
//                arguments.
//
//		  eg     BEAM module_1.int, module_2.int .......module_5.int
//                a maximimum of 5 intermediate (.INT) database files can be
//                passed to the executable module.
//
//    filename.h  Sets file name streams
//    savescr.h   Saves screen in memory before executing this code
//    restscr.h   restores screen previously saved in memory prior to
//                returning control to the~first byte.
//    manip.h     Defines output format manipulators
//
//####  Standard headers
#include <strstream.h>
#include <fstream.h>
#include <string.h>
#include <iomanip.h>
#include <conio.h>
#include <dos.h>
#include <math.h>
#include <dir.h>
#include <stdlib.h>
#include "general.h"
//
//#### defines format manipulators
#include "manip.h"
//
//#### Main (BEAM) routine starts here
int main(int argc, char *argv[], char *env[])
{
  ofstream out;     //####  module output file: named module(BEAM).WRT
		    //      (programmer to write to this file).
  ofstream dbs;     //####  module database file: named module.INT
		    //      (programmer to write to this database file.)
  ofstream mess;    //####  Module summary/message/error file (programmer to
		    //      write to this file.

  ifstream dbase[5];//####  Maximum of five external database files previously
		    //      written by other user programs. The names of these
		    //      files are contained in argv[1]- argv[argc].

  ifstream in;      //####  input data file named: module(BEAM).BAK

//####  declare variables
  char dbasdir[80]; //#### data base directory pathname(obtained from
		    //     THE=**** environment parameter
// datafile data defines as structure
  struct data {
      unsigned char textdat[132];  //#### contains contents of cell (string)
      float maxval;                //#### contains maximum allowable value
      float minval;                //#### contains minimum allowable value
      unsigned char units[9];      //#### contains current units (string)
      float conv1;                 //#### contains conversion factor
      float conv2;                 //#### contains conversion factor
      } data_in[150];              //#### maximum number of cells =150.

  float  cellval[151];     //#### contains contents of cell as a floating
			   //     point number converted back to default
			   //     dimension (SI definition) units

  float  dbaseval[5][50];  //#### 50 database floating point values per
			   //     database(5) file

  unsigned char dbasetxt[5][50][80];  // 50 database text strings per
				      // database file (5)

  int errcount=0;          //#### initilise error counter

//### Include standard header files
#include "savescr.h"                 //#### save screen
#include "readset.h"                 //#### read standard setup file
#include "filename.h"                //#### set file names
#include "readata.h"                 //#### read module data file
#include "dbsdata.h"                 //#### read database files
///////////////////////////////////////////////////////////////////////////////
//
//  This next section comprises the unique module code
//  Beam data is read from form file BEAM.BAK - Note values are automatically
//  converted to base SI unit (first field in units.dat file).
//
//  cell No  1   Beam Uniform distributed weight  (N/m)
//           2   Beam point load (N)
//           3   Beam length     (m)
//
//  database file SECT.INT created by the program SECT.EXE
//
//  array values dbasval[0][1]     Beam Weight            N/m
//                         [2]     section density        kg/m3
//                         [3]     Elastic modulus        N/m2
//                         [4]     mass per length        kg/m
//                         [5]     total area             m2
//                         [6]     neutral axis (from bottom flange) m
//                         [7]     2nd moment of area     m4
//			   [8]     Flexural rigidity      EI  Nm2
//			   [9]	   section modulus top    Nm2
//			   [10]	   section modulus bottom Nm2

//  Start of module calculation
//
    float ydef;
    float mom;
    float sf;
    float bst;
    float bsb;

    mess << "\n Beam Module Message File\n";  //send message to message file

//  test beam length
    if(cellval[3]<=0)
    {
//  > beam length less not positive
//    write message to message file and increment error count
      mess << "\n Data Error: \
	       \n             Length of beam must be specified positive with finite length\n";
      errcount++;
    }
    if(dbaseval[0][7]*dbaseval[0][8]*dbaseval[0][9]==0)
    {
      if(dbaseval[0][7]==0)
      {
	mess << "\n Data Error: \
	       \n             Zero section flexural rigidity\n";
	errcount++;
      }
      else
      {
	mess << "\n Data Error: \
	       \n             Zero section nodulus\n";
	errcount++;
      }
    }
//  test error count
    if(errcount)
    {
      mesbox1(13, 14, 0, " Incompatible data: Please check data entered in form;  ",
			 "                    values maybe out of range. ", WHITE, RED);
      mess << "\n Incompatible data: \
	       \n                    Please check data entered in form: BEAM\n";
    }
    else
    {
//    Calculate end deflection  wl3/3EI +3wl4/24EI
      ydef=(cellval[2]*pow(cellval[3],3)/3 +
	    cellval[1]*pow(cellval[3],4)/8)/dbaseval[0][7];

//    Calculate maximum Moment    wl2/s + wl
      mom=cellval[2]*cellval[3] + cellval[1]*cellval[3]*cellval[3]/2;

//    Calculate maximum shear force
      sf=cellval[2]+cellval[1]*cellval[3];

//    Calculated maximum bending stress  my/I
      bst=mom/dbaseval[0][8];
      bsb=mom/dbaseval[0][9];
//    write output file (beam.wrt
      out << "\n\n 1.0\t\tCantilever Beam Description\n\n\n";
      out << " 1.1\t\tCantilever Properties\n\n";
      out << " \t\tCantilever Length:\t\t\t" << real(2)<< cellval[3] << " m\n";
      out << " \t\tUniformly distributed load:\t\t" << real(2) << cellval[2] << " N/m\n";
      out << " \t\tPoint load at Cantilever end:\t\t" << real (2)<< cellval[1] << " N\n\n\n";
      out << " 1.2\t\tCantilever Section Properties\n\n";
      out.setf(ios::showpoint);
      out.setf(ios::fixed,ios::floatfield);

      out.precision(1);
      out << " \t\tDensity:\t\t\t\t" << real(1) << dbaseval[0][1] << " kg/m3\n";
      out << " \t\tElastic Modulus:\t\t\t" << real(1) << dbaseval[0][2]/1e9 << " GPa\n";
      out << " \t\t2nd Moment of Area:\t\t\t" << sci(4)<< dbaseval[0][6] << " m4\n\n\n\n";
      out << " 2.0\t\tDeflections, Shear Force and Stresses\n\n";

      out << " \t\tEnd Deflection:\t\t\t\t" << real(3) << ydef << " m\n";
      out << " \t\tMaximum Moment:\t\t\t\t" << real(3) <<  mom/1e3 << " kNm\n";
      out << " \t\tMaximum Shear Force:\t\t\t" << real(3)<< sf/1e3 << " kN\n";
      out << " \t\tBending Stress - Top:\t\t\t" << real(1)<< bst/1e6 << " MPa\n";
      out << " \t\tBending Stress - Bottom:\t\t" << real(1)<< bsb/1e6 << " MPa\n";

//    write database file  (beam.int)
      dbs << sci(7) <<  "// \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
      dbs << sci(7) <<  "//  \n";
   }
///////////////////////////////////////////////////////////////////////////////
//#### close standard files
#include "restscr.h"                 //#### restore screen
#include "fclose.h"

//#### return to the~first byte
  return(-errcount);  // return error flag to the~first byte
}

