/*
ͻ
 NAME      : TERMINAL.C                                                      
 FUNCTION  : A simple terminal emulator to show how to use STARCOMM.EXE when 
           : it is used as a DEVICE DRIVER.Uses the C interfacing procedures.
           : This emulator allows a direct link between two locals computers.
           : It may be used as a simple TTY emulator as well...              
 VERSION   : v2.10                                                           
 LANGAGE   : TURBO C version 1.0 and laters.                                 
 SYNTAX    : (path)> <path_pgm>CHEKLINK [<comm format>] [<options>]          
           :      <comm format>  = [COMi:][speed][,parity][,bits][,stop-bit] 
           :      <options>      =                                           
           :        /T............... <T>erminal: full screen emulation.     
           :        /A............... <A>larm has to ring on receipt errors. 
           :        /R ou /RALENTI... Strings are transmitted slowly.        
           :                      (use that for very slow distants stations) 
 REMARKS   : TERMINAL will always use COM1 as the default serial port when   
           : it is first executed. If this port doesn't exist or is unreacha-
           : -ble, or if the port specified in the command-line is unknown,  
           : the first accessible serial port will be used. If there is not  
           : any accessible serial port, TERMINAL immediately stops...       
 COPYRIGHT : HETRU Fabrice 1991-1995.                                        
ͼ
*/


/* ===== Headers, CONSTANTS and VARIABLES ===== */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include "STARINTF.C"


#define byte     unsigned char


#define Int1B     0x1B  /* BIOS interrupt number managing "Ctrl-Break".     */
#define Int24     0x24  /* Criticals system errors interrupt handler.       */
#define SHVL      0x100 /* Specials keys flag.                              */
#define PARITE    1     /* Parity indicator.                                */
#define NBOCTETS  2     /* Bytes number indicator.                          */
#define STOPBIT   3     /* Stop-bit number indicator.                       */
#define T_Delay   10    /* Delay length to slow down the transmissions.     */
#define EOS       0     /* End Of String indicator.                         */
#define FALSE     0     /* Logical FALSE...                                 */
#define TRUE      1     /* Logical TRUE...                                  */
#define StrLen    25    /* Maximum authorized size for the input strings.   */
#define MAXStrLen StrLen+1


/* Generals use variables. */
char     commande[127];
int      choix;
byte     n_car;
char     cr = 0x0D;
char     clrscreen = 0x0C;
byte     fin = FALSE;
byte     Saisie_Escape = FALSE;
byte     abandon = FALSE;
word     IO_err = FALSE;
/* Variables to manage the serial ports. */
byte     ver[5] ;
byte     voie = '1';
byte     parity = 'N';
byte     longueur = '8';
byte     stop_bit = '1';
long     vitesse = 9600;
word     InBuffSz, OutBuffSz;
word     engorge_err = 0;
word     pari_err    = 0;
word     stop_err    = 0;
word     brkint      = 0;
word     erreur;
short    resul;
byte     OldRdTimMAX = 0;
byte     OldWrTimMAX = 0;
byte     RdTimMAX[2] = {2,0};
byte     WrTimMAX[2] = {2,0};
byte     TimOut[2]   = {'1',0};
div_t    result;
byte     Lent = FALSE;
char     echo = TRUE;
byte     LF_Used = TRUE;
byte     CR_Used = TRUE;
/* Variables to manage the screen. */
word     seg_ecran, off_ecran;
word     mode_scr, page_scr;
int      xh, yh;
char     dos_scr[80 * 25 * 2];
byte     terminal = FALSE;


/* ===== INPUT/OUTPUT PROCEDURES ===== */

/* INTERRUPTS procedures to manage the local computer. */
/* --------------------------------------------------- */
void main_menu(); /* This procedure is used before beeing listed... */


void interrupt (*OldIError) ();


void interrupt IError()
  {
  int x0,y0;

  /* Error occurence flag is up-dated. */
  IO_err = TRUE;  /* Seted back to FALSE before ReadCOMM and WriteCOMM... */
  /* New process for the error handler. */
  x0 = wherex(); y0 = wherey();
  window(1,1,80,25);
  gotoxy(1,25);
  textbackground(WHITE);
  textcolor(LIGHTRED);
  clreol();
  gotoxy(21,25);
  switch(_DI)
    {
    case 0x0A: cputs("Writting time-out"); break;
    case 0x0B: cputs("    Reading error");
    }
  cputs(" on the serial port");
  delay(1000);
  main_menu();
  textbackground(BLUE);
  if (! terminal)
    {
    if (y0<14) window(1,4,80,13);
      else window(1,15,80,24);
    }
  else window(1,3,80,24);
  gotoxy(x0,y0);
  /* "interrupt" used to define the IError procedure makes PUSH:... */
  /* The following code is to destroy these unwanted PUSHes !...    */
  asm mov sp,bp
  asm pop bp
  asm pop di
  asm pop si
  asm pop ds
  asm pop es
  asm pop dx
  asm pop cx
  asm pop bx
  asm pop ax
  /* Get ready to return to the application without using the DOS. */
  asm pop ax /* Unstacking what is associated to the IRET system call... */
  asm pop ax /* CS:IP and Flags. */
  asm pop ax
  asm pop ax /* CPU protection. */
  asm pop bx
  asm pop cx
  asm pop dx
  asm pop si
  asm pop di
  asm pop bp
  asm pop ds
  asm pop es
  enable();  /* STI, then IRET... */
  asm iret
  /* In assembler, then follow the POP made by TCC; They will never be
     executed indeed !... (They all have been unstacked before...). */
  }


void interrupt (*OldIBreak) ();


void interrupt CtrlBreak()
  {
  abandon = TRUE;
  }


/* Local consol management procedures. */
/* ----------------------------------- */
int kb_hit()
  {
  inregs.h.ah = 1;
  int86(0x16,&inregs,&outregs);
  return( !(outregs.x.flags & 64) );
  }


int get_clav()
  {
  int h,l;

  if (kb_hit())
    {
    inregs.h.ah = 0;
    int86(0x16,&inregs,&outregs);
    l = outregs.h.al;
    h = outregs.h.ah;
    if (l==0) l = h+SHVL;
    if (l==3) abandon = TRUE;
    return(l);
    }
  else return(0);
  }


void scroll_down()
  {
  char scroll[3];

  scroll[1] = 0x0A;
  scroll[2] = 0x0D;
  scroll[3] = EOS;
  cputs(&scroll[1]);
  }


void blanchi(int x, int y, int l)
  {
  byte col;

  gotoxy(x,y);
  for (col=x; col<=x+l-1; col++) cputs(" ");
  gotoxy(x,y);
  }


void delete(char *ch,int pos,unsigned char Nb)
  {
  pos--;
  while ( (pos+Nb<=MAXStrLen) & (*(ch+pos)!=EOS) )
    {
    *(ch+pos) = *(ch+pos+Nb);
    pos++;
    }
  }


void Insert(char car,char *Chaine,int pos)
  {
  int i,j;

  if (pos<1) pos = 1;
  i = 0;
  while ( (*(Chaine+i)!=0) & (i<strlen(Chaine)) ) i++;
  if (i<StrLen)
    {
    i++;
    for (j=i;j>=pos;j--) *(Chaine+j) = *(Chaine+j-1);
    *(Chaine+j) = car;
    }
  }


void back(char *ch,int x,int l)
  {
  int k,x2;

  k = 0;
  x2 = wherex();
  if (x==x2) k=1;
  delete(ch,x2-x+k,1);
  blanchi(x,wherey(),l);
  cputs(ch);
  gotoxy(x2+k-1,wherey());
  }


void vid(char *ch,int x,int y,int l)
  {
  blanchi(x,y,l);
  strcpy(ch,"");
  }


void ReadCar(char *Car_lu,byte *Fonct_Touche)
  {
  int loc_car;

  Saisie_Escape = FALSE;
  *Fonct_Touche = FALSE;
  loc_car = 0;
  *Car_lu = ' ';
  while (!kb_hit());
  if ( (loc_car=get_clav())>=SHVL )
    {
    *Fonct_Touche = TRUE;
    *Car_lu = loc_car - SHVL;
    }
  else *Car_lu = toupper((char)loc_car);
  if (*Car_lu==0x1B) Saisie_Escape = TRUE;
  }


void Lit_chaine(char *chaine,int x,int y,int l)
  {
  char LocalChaine[MAXStrLen];
  char carac;
  byte Fonct_Touche;
  int oldx;

  textbackground(BLACK);
  if (*chaine!=0)
    {
    strcpy(LocalChaine,chaine);
    blanchi(x,y,l);
    cputs(LocalChaine);
    }
  else vid(LocalChaine,x,y,l);
  do
    {
    ReadCar(&carac,&Fonct_Touche);
    if (!Fonct_Touche)
      {
      if (carac==0x08)
        {
        if (strlen(LocalChaine)<l) back(LocalChaine,x,l);
          else
            {
            delete(LocalChaine,wherex()-x+1,1);
            blanchi(x,wherey(),l);
            cputs(LocalChaine);
            }
        }
      else
        {
        if ( (!Saisie_Escape) & (strlen(LocalChaine)<l) & (carac!=0x0D) )
          {
          Insert(carac,LocalChaine,wherex()-x+1);
          oldx = wherex();
          blanchi(x,y,l);
          cputs(LocalChaine);
          if (strlen(LocalChaine)<l) gotoxy(oldx+1,y);
            else gotoxy(x+l-1,y);
          }
        }
      }
    else
      {
      switch (carac)
        {
        case 0x47: /* Home */
          gotoxy(x,y);
          break;
        case 0x4F: /* End */
          if (strlen(LocalChaine)<l) gotoxy(x+strlen(LocalChaine),y);
            else gotoxy(x+l-1,y);
          break;
        case 0x4B: /* Left Arrow */
          if (wherex()>x) gotoxy(wherex()-1,y);
          break;
        case 0x4D: /* Right Arrow */
          if (wherex()<x+strlen(LocalChaine))
            {
            if (wherex()<x+l-1) gotoxy(wherex()+1,y);
              else gotoxy(x+l-1,y);
            }
          break;
        case 0x53: /* Del */
          delete(LocalChaine,wherex()-x+1,1);
          oldx = wherex();
          blanchi(x,y,l);
          cputs(LocalChaine);
          gotoxy(oldx,y);
        }
      }
    }
  while ( (carac!=0x0D) & (!Saisie_Escape) & (!abandon) );
  textbackground(BLUE);
  oldx = wherex();
  blanchi(x,y,l);
  if ( !(Saisie_Escape|abandon) )
    {
    cputs(LocalChaine);
    gotoxy(oldx,y);
    }
  else gotoxy(x,y);
  if ( (carac==0x0D) & (LocalChaine!="") ) strcpy(chaine,LocalChaine);
  scroll_down();
  }


void stock_commande_format()
  {
  /* Serial port to use. */
  if (strcmp(commande,"COM1:")==0) voie = '1';
  if (strcmp(commande,"COM2:")==0) voie = '2';
  if (strcmp(commande,"COM3:")==0) voie = '3';
  if (strcmp(commande,"COM4:")==0) voie = '4';
  if (strcmp(commande,"COM5:")==0) voie = '5';
  if (strcmp(commande,"COM6:")==0) voie = '6';
  if (strcmp(commande,"COM7:")==0) voie = '7';
  if (strcmp(commande,"COM8:")==0) voie = '8';
  /* Speed. */
  if (strcmp(commande,"110")==0) vitesse = 110;
  if (strcmp(commande,"150")==0) vitesse = 150;
  if (strcmp(commande,"300")==0) vitesse = 300;
  if (strcmp(commande,"600")==0) vitesse = 600;
  if (strcmp(commande,"1200")==0) vitesse = 1200;
  if (strcmp(commande,"2400")==0) vitesse = 2400;
  if (strcmp(commande,"4800")==0) vitesse = 4800;
  if (strcmp(commande,"9600")==0) vitesse = 9600;
  if (strcmp(commande,"19200")==0) vitesse = 19200;
  if (strcmp(commande,"28800")==0) vitesse = 28800;
  if (strcmp(commande,"38400")==0) vitesse = 38400;
  if (strcmp(commande,"57600")==0) vitesse = 57600;
  if (strcmp(commande,"115200")==0) vitesse = 115200;
  /* Parity. */
  if (strcmp(commande,"N")==0) parity = 'N';
  if (strcmp(commande,"I")==0) parity = 'I';
  if (strcmp(commande,"P")==0) parity = 'P';
  if (strcmp(commande,"T")==0) parity = 'T';
  if (strcmp(commande,"R")==0) parity = 'R';
  /* Bits number. */
  if (strcmp(commande,"5")==0) longueur = '5';
  if (strcmp(commande,"6")==0) longueur = '6';
  if (strcmp(commande,"7")==0) longueur = '7';
  if (strcmp(commande,"8")==0) longueur = '8';
  /* Stop-bit. */
  if (strcmp(commande,"1")==0) stop_bit = '1';
  if (strcmp(commande,"2")==0) stop_bit = '2';
  }


void setup_ecran_inprog()
  {
  inregs.h.ah = 0x0F;
  int86(0x10,&inregs,&outregs);
  mode_scr = outregs.h.al;
  page_scr = outregs.h.bh;
  if ( (mode_scr==0) | (mode_scr==1) | (mode_scr==2)
       | (mode_scr==3) | (mode_scr==7) )
    {
    xh = wherex();
    yh = wherey();
    if (mode_scr==7) seg_ecran = 0xB000;
      else seg_ecran = 0xB800;
    switch (mode_scr)
      {
      case 0:
      case 1: off_ecran = 40 * 25 * page_scr;
              break;
      case 2:
      case 3:
      case 7: off_ecran = 80 * 25 * page_scr;
      }
    movedata(seg_ecran,off_ecran,FP_SEG(&dos_scr[0]),FP_OFF(&dos_scr[0]),80*25*2);
    }
  if (mode_scr==7) textmode(7);
    else textmode(3);
  inregs.h.al = 0;
  inregs.h.ah = 5;
  int86(0x10,&inregs,&outregs);
  }


void setup_ecran_outprog()
  {
  inregs.h.al = mode_scr;
  inregs.h.ah = 0;
  int86(0x10,&inregs,&outregs);
  inregs.h.al = page_scr;
  inregs.h.ah = 5;
  int86(0x10,&inregs,&outregs);
  if ( (mode_scr==0) | (mode_scr==1) | (mode_scr==2)
       | (mode_scr==3) | (mode_scr==7) )
    {
    movedata(FP_SEG(&dos_scr[0]),FP_OFF(&dos_scr[0]),seg_ecran,off_ecran,80*25*2);
    gotoxy(xh,yh);
    }
  else clrscr();
  }


/* ===== POP-UP AND MENUS MANAGEMENT PROCEDURES ===== */

/* CopyRight/Help or Infos management procedures. */
/* ---------------------------------------------- */
void informations(byte num_page)
  {
  int  offscr, xinit, yinit;
  char bscr[80 * 15 * 2];
  char help[47 * 15] =
               "TERMINAL.COM(C)opyRight HETRU 1995Ŀ "
               " An utility to demonstrate STARCOMM.EXE use  "
               "------ Residant driver -> version      ----- "
               "F1...Help; F2...Infos/SetUp; F3...modem Cmde "
               "SetUp window (F2) commands to use are:       "
               " Tab,BackSpace ---> Time-out length select   "
               " Up/Dn/Lft/Rgt arrows ---> ACTIVE|INACTIVE.  "
               "Alt-P...permits to fix the comm. format.     "
               " port......: COM: number to use (1 to 8),    "
               " speed.....: between 110 and 115200 bits/sec "
               " structure.: <Parity>,<Bits_nb>,<Stop_bits>  "
               "Alt-F.....sends a test message already seted "
               "Alt-C...........Fully Clears the comm screen "
               "Alt-Q, Ctrl-Break or Ctrl-C...Stops TERMINAL "
               "Press any key";
  char infos[47 * 15] =
               "Ŀ "
               "   DSR:      CTS:      RI:      DCD:        "
               "  Communication errors accountment:         "
               "       overruns......        occurence(s)    "
               "       parity........        occurence(s)    "
               "       stop-bit......        occurence(s)    "
               "       break-int.....        occurence(s)    "
               "  Receipt TimeOut   1 2 3 4 5 6 7 8 9 sec. "
               "   Transmit TimeOut  1 2 3 4 5 6 7 8 9 sec. "
               "  Hardware hand-shaking...........          "
               "   Hand-shake Xon(' ')/Xoff(' ')...          "
               "  Local echo......................          "
               "   (1)LF:LFeed (2)CR:LFeed (3)LF|CR:LFeed   "
               "                                             "
               "'ESC' to escape !";
  byte Init_aff;
  byte H_Shk   ;
  byte *SendOK = 0;
  byte *NbXoff = 0;
  char code[2] = {' ',EOS};
  static byte StatusTOChg = 1;

  Init_aff = TRUE;
  choix = ' ';
  xinit = wherex(); yinit = wherey();
  offscr = 5 * 80 * 2;
  movedata(seg_ecran,offscr,FP_SEG(&bscr[0]),FP_OFF(&bscr[0]),80*15*2);
  window(18,6,64,20);
  textbackground(WHITE);
  textcolor(BLACK);
  clrscr();
  gotoxy(1,1);
  switch(num_page)
    {
    case 1:
      {
      cputs(help);
      gotoxy(36,3);
      cputs(ver);
      gotoxy(17,15);
      textbackground(BLACK);
      textcolor(WHITE);
      delay(150);
      cputs("Press any key");
      while (get_clav()==0);
      break;
      }
    case 2:
      {
      cputs(infos);
      textbackground(BLUE);
      textcolor(CYAN);
      gotoxy(2,14);
      cputs("Tab,BackSpace  Up/Dn/Lft/Rgt-arrow  1 to 3");
      textbackground(WHITE);
      textcolor(BLACK);
      gotoxy(38,10);
      if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
      (HandShake_Status(DTR_DSR,SendOK)==Inactif) ) cputs("All OFF");
      if (HandShake_Status(RTS_CTS,SendOK)!=Inactif) cputs("RTS/CTS");
      if (HandShake_Status(DTR_DSR,SendOK)!=Inactif) cputs("DTR/DSR");
      gotoxy(38,11);
      if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif) cputs(" ACTIVE ");
        else cputs("INACTIVE");
      gotoxy(38,12);
      if (echo) cputs(" ACTIVE ");
        else cputs("INACTIVE");
      code[0] = (char)Xon;
      gotoxy(21,11);cputs(code);
      code[0] = (char)Xoff;
      gotoxy(31,11);cputs(code);
      gotoxy(15,15);
      textbackground(BLACK);
      textcolor(WHITE);
      delay(150);
      cputs("'ESC' to escape ! ");
      gotoxy(25,4); cputs("     ");
      gotoxy(25,5); cputs("     ");
      gotoxy(25,6); cputs("     ");
      gotoxy(25,7); cputs("     ");
      RdTimMAX[0] = 0;
      WrTimMAX[0] = 0;
      ResetCOM_and_TimMAX(RdTimMAX[0],&OldRdTimMAX,WrTimMAX[0],&OldWrTimMAX);
      RdTimMAX[0] = OldRdTimMAX;
      WrTimMAX[0] = OldWrTimMAX;
      switch (RdTimMAX[0])
        {
        case 1:
          {
          gotoxy(22,8);
          cputs("");
          break;
          }
        default:
          {
          gotoxy(22+RdTimMAX[0],8);
          result = div(RdTimMAX[0],2);
          TimOut[0] = result.quot + 0x30;
          cputs(&TimOut[0]);
          }
        }
      switch (WrTimMAX[0])
        {
        case 1:
          {
          gotoxy(22,9);
          cputs("");
          break;
          }
        default:
          {
          gotoxy(22+WrTimMAX[0],9);
          result = div(WrTimMAX[0],2);
          TimOut[0] = result.quot + 0x30;
          cputs(&TimOut[0]);
          }
        }
      if (LF_Used & CR_Used)
        {
        gotoxy(30,13);
        cputs("(3)");
        }
      else
        {
        if (LF_Used)
          {
          gotoxy(6,13);
          cputs("(1)");
          }
        if (CR_Used)
          {
          gotoxy(18,13);
          cputs("(2)");
          }
        }
      switch (StatusTOChg)
        {
        case 1:
          {
          gotoxy(38,10);
          if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
          (HandShake_Status(DTR_DSR,SendOK)==Inactif) ) cputs("All OFF");
          if (HandShake_Status(RTS_CTS,SendOK)!=Inactif) cputs("RTS/CTS");
          if (HandShake_Status(DTR_DSR,SendOK)!=Inactif) cputs("DTR/DSR");
          break;
          }
        case 2:
          {
          gotoxy(38,11);
          if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif) cputs(" ACTIVE ");
            else cputs("INACTIVE");
          break;
          }
        case 3:
          {
          gotoxy(38,12);
          if (echo) cputs(" ACTIVE ");
            else cputs("INACTIVE");
          }
        }
      while ( (choix!=0x1B) & (!abandon) )
        {
        if ( (etat_du_modem()) | Init_aff )
          {
          gotoxy(10,2);
          if (Pret) cputs("YES");
            else
              {
              if (dDSR>0) { cputs("YES"); delay(10); gotoxy(10,2); }
              cputs("No ");
              }
          gotoxy(20,2);
          if (Clear_to_send) cputs("YES");
            else
              {
              if (dCTS>0) { cputs("YES"); delay(10); gotoxy(20,2); }
              cputs("No ");
              }
          gotoxy(29,2);
          if (Sonnerie) cputs("YES");
            else
              {
              if (dRI>0) { cputs("YES"); delay(10); gotoxy(29,2); }
              cputs("No ");
              }
          gotoxy(39,2);
          if (Porteuse) cputs("YES");
            else
              {
              if (dDCD>0) { cputs("YES"); delay(10); gotoxy(39,2); }
              cputs("No ");
              }
          gotoxy(33,15);
          }
        if ( (Errors_Report()) | Init_aff )
          {
          engorge_err = engorge_err + Engorgement;
          pari_err = pari_err + Parite;
          stop_err = stop_err + Stop_bit;
          brkint = brkint + Break_it;
          gotoxy(25,4); printf("%5u",engorge_err);
          gotoxy(25,5); printf("%5u",pari_err);
          gotoxy(25,6); printf("%5u",stop_err);
          gotoxy(25,7); printf("%5u",brkint);
          gotoxy(33,15);
          }
        Init_aff = FALSE;
        if ( (choix=get_clav()) != 0 )
          {
          if (choix==0x08) /* BackSpace: Receipt time-out setting... */
            {
            if (RdTimMAX[0]==1) RdTimMAX[0]++;
              else RdTimMAX[0] = RdTimMAX[0] + 2;
            if (RdTimMAX[0]>18) RdTimMAX[0]=1;
            ResetCOM_and_TimMAX(RdTimMAX[0],&OldRdTimMAX,
              WrTimMAX[0],&OldWrTimMAX);
            textbackground(WHITE);
            textcolor(BLACK);
            gotoxy(22,8);
            cputs(" 1 2 3 4 5 6 7 8 9");
            textbackground(BLACK);
            textcolor(WHITE);
            switch (RdTimMAX[0])
              {
              case 1:
                {
                gotoxy(22,8);
                cputs("");
                break;
                }
              default:
                {
                gotoxy(22+RdTimMAX[0],8);
                result = div(RdTimMAX[0],2);
                TimOut[0] = result.quot + 0x30;
                cputs(&TimOut[0]);
                }
              }
            }
          if (choix==0x09) /* Tab: Transmit time-out setting... */
            {
            if (WrTimMAX[0]==1) WrTimMAX[0]++;
              else WrTimMAX[0] = WrTimMAX[0] + 2;
            if (WrTimMAX[0]>18) WrTimMAX[0]=1;
            ResetCOM_and_TimMAX(RdTimMAX[0],&OldRdTimMAX,
              WrTimMAX[0],&OldWrTimMAX);
            textbackground(WHITE);
            textcolor(BLACK);
            gotoxy(22,9);
            cputs(" 1 2 3 4 5 6 7 8 9");
            textbackground(BLACK);
            textcolor(WHITE);
            switch (WrTimMAX[0])
              {
              case 1:
                {
                gotoxy(22,9);
                cputs("");
                break;
                }
              default:
                {
                gotoxy(22+WrTimMAX[0],9);
                result = div(WrTimMAX[0],2);
                TimOut[0] = result.quot + 0x30;
                cputs(&TimOut[0]);
                }
              }
            }
          if ( (choix>='1') & (choix<='3') )
            {
            textbackground(WHITE);
            textcolor(BLACK);
            gotoxy(6,13);
            cputs("(1)");
            gotoxy(18,13);
            cputs("(2)");
            gotoxy(30,13);
            cputs("(3)");
            textbackground(BLACK);
            textcolor(WHITE);
            switch (choix)
              {
              case '1': {
                 gotoxy(6,13);
                 cputs("(1)");
                 LF_Used = TRUE;
                 CR_Used = FALSE;
                 break;
                 }
              case '2': {
                 gotoxy(18,13);
                 cputs("(2)");
                 LF_Used = FALSE;
                 CR_Used = TRUE;
                 break;
                 }
              case '3': {
                 gotoxy(30,13);
                 cputs("(3)");
                 LF_Used = TRUE;
                 CR_Used = TRUE;
                 }
              }
            }
          if ( (choix==0x148) | (choix==0x150) ) /* Flche haut ou bas */
            {
            if (choix==0x148) StatusTOChg--;
              else StatusTOChg++;
            if (StatusTOChg>3) StatusTOChg=1;
            if (StatusTOChg<1) StatusTOChg=3;
            textbackground(WHITE);
            textcolor(BLACK);
            gotoxy(38,10);
            if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
            (HandShake_Status(DTR_DSR,SendOK)==Inactif) ) cputs("All OFF");
            if (HandShake_Status(RTS_CTS,SendOK)!=Inactif) cputs("RTS/CTS");
            if (HandShake_Status(DTR_DSR,SendOK)!=Inactif) cputs("DTR/DSR");
            gotoxy(38,11);
            if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif) cputs(" ACTIVE ");
              else cputs("INACTIVE");
            gotoxy(38,12);
            if (echo) cputs(" ACTIVE ");
              else cputs("INACTIVE");
            textbackground(BLACK);
            textcolor(WHITE);
            switch (StatusTOChg)
              {
              case 1:
                {
                gotoxy(38,10);
                if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
                (HandShake_Status(DTR_DSR,SendOK)==Inactif) ) cputs("All OFF");
                if(HandShake_Status(RTS_CTS,SendOK)!=Inactif) cputs("RTS/CTS");
                if(HandShake_Status(DTR_DSR,SendOK)!=Inactif) cputs("DTR/DSR");
                break;
                }
              case 2:
                {
                gotoxy(38,11);
                if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif)
                  cputs(" ACTIVE ");
                else cputs("INACTIVE");
                break;
                }
              case 3:
                {
                gotoxy(38,12);
                if (echo) cputs(" ACTIVE ");
                  else cputs("INACTIVE");
                }
              }
            }
          if ( (choix==0x14B) | (choix==0x14D) ) /* Left or right arrow */
            {
            switch (StatusTOChg)
              {
              case 1:
                {
                gotoxy(38,10);
                if (choix==0x14D)
                  {
                  if (HandShake_Status(RTS_CTS,SendOK)!=Inactif)
                    {
                    HandShake_Setup(RTS_CTS,FALSE);
                    HandShake_Setup(DTR_DSR,Bilateral);
                    textbackground(WHITE);
                    textcolor(BLACK);
                    cputs("RTS/CTS");
                    textbackground(BLACK);
                    textcolor(WHITE);
                    gotoxy(38,10);
                    cputs("DTR/DSR");
                    }
                  else
                    {
                    if (HandShake_Status(DTR_DSR,SendOK)!=Inactif)
                      {
                      HandShake_Setup(DTR_DSR,FALSE);
                      textbackground(WHITE);
                      textcolor(BLACK);
                      cputs("DTR/DSR");
                      textbackground(BLACK);
                      textcolor(WHITE);
                      gotoxy(38,10);
                      cputs("All OFF");
                      }
                    else
                      {
                      if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
                      (HandShake_Status(DTR_DSR,SendOK)==Inactif) )
                        {
                        HandShake_Setup(RTS_CTS,Bilateral);
                        textbackground(WHITE);
                        textcolor(BLACK);
                        cputs("All OFF");
                        textbackground(BLACK);
                        textcolor(WHITE);
                        gotoxy(38,10);
                        cputs("RTS/CTS");
                        }
                      }
                    }
                  }
                else
                  {
                  if (HandShake_Status(RTS_CTS,SendOK)!=Inactif)
                    {
                    HandShake_Setup(RTS_CTS,FALSE);
                    textbackground(WHITE);
                    textcolor(BLACK);
                    cputs("RTS/CTS");
                    textbackground(BLACK);
                    textcolor(WHITE);
                    gotoxy(38,10);
                    cputs("All OFF");
                    }
                  else
                    {
                    if (HandShake_Status(DTR_DSR,SendOK)!=Inactif)
                      {
                      HandShake_Setup(DTR_DSR,FALSE);
                      HandShake_Setup(RTS_CTS,Bilateral);
                      textbackground(WHITE);
                      textcolor(BLACK);
                      cputs("DTR/DSR");
                      textbackground(BLACK);
                      textcolor(WHITE);
                      gotoxy(38,10);
                      cputs("RTS/CTS");
                      }
                    else
                      {
                      if ( (HandShake_Status(RTS_CTS,SendOK)==Inactif) &
                      (HandShake_Status(DTR_DSR,SendOK)==Inactif) )
                        {
                        HandShake_Setup(DTR_DSR,Bilateral);
                        textbackground(WHITE);
                        textcolor(BLACK);
                        cputs("All OFF");
                        textbackground(BLACK);
                        textcolor(WHITE);
                        gotoxy(38,10);
                        cputs("DTR/DSR");
                        }
                      }
                    }
                  }
                break;
                }
              case 2:
                {
                gotoxy(38,11);
                if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif)
                  {
                  XonoffShaking_Setup(FALSE);
                  cputs("INACTIVE");
                  }
                else
                  {
                  XonoffShaking_Setup(Bilateral);
                  cputs(" ACTIVE ");
                  }
                break;
                }
              case 3:
                {
                echo = ! echo;
                gotoxy(38,12);
                if (echo) cputs(" ACTIVE ");
                  else cputs("INACTIVE");
                }
              }
            } /* End_if */
          } /* End_if */
        gotoxy(33,15);
        } /* End_while */
      choix = ' ';
      } /* End_case_2 */
    } /* End_switch */
  textbackground(BLUE);
  textcolor(WHITE);
  clrscr();
  if (! terminal)
    {
    if (yinit<14) window(1,4,80,13);
      else window(1,15,80,24);
    }
  else window(1,3,80,24);
  movedata(FP_SEG(&bscr[0]),FP_OFF(&bscr[0]),seg_ecran,offscr,80*15*2);
  gotoxy(xinit,yinit);
  }


/* Utilities procedures. */
/* --------------------- */
void main_menu()
  {
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(1,25);clreol();
  gotoxy(2,25);
  cputs(" Alt-Q Quit   Alt-P Parameters   Alt-F Fox...the test message   Alt-C ClrScr");
  textcolor(RED);
  gotoxy(3,25);cputs("Alt-Q");
  gotoxy(16,25);cputs("Alt-P");
  gotoxy(35,25);cputs("Alt-F");
  gotoxy(66,25);cputs("Alt-C");
  }


void page_de_fond()
  {
  textbackground(BLUE);
  clrscr();
  textbackground(WHITE);
  clreol();
  textbackground(LIGHTGRAY);
  gotoxy(1,25);
  clreol();
  textcolor(MAGENTA);
  gotoxy(1,1); clreol();
  cputs(" PROGRAM TO TEST THE ASYNCHRONOUS SERIAL LINK MANAGED BY STARCOMM");
  cputs(" version ");cputs(ver);
  if (! terminal)
    {
    gotoxy(1,3); cputs("");
    cputs("Transmissions");
    cputs("");
    gotoxy(1,14); cputs("");
    cputs("Receptions");
    cputs("");
    }
  /* Buttom menu. */
  main_menu();
  /* Top menu. */
  textbackground(BLACK);
  textcolor(LIGHTGRAY);
  gotoxy(1,2);
  cputs(" Port:        Speed:               Structure: parity    ,    bits,    stop-bit");
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(9,2); cputs("   ");
  gotoxy(9,2); printf(" %c ",voie);
  gotoxy(27,2);
  switch (vitesse)
    {
    case  110: cputs("   110  ");
               break;
    case  150: cputs("   150  ");
               break;
    case  300: cputs("   300  ");
               break;
    case  600: cputs("   600  ");
               break;
    case 1200: cputs("  1200  ");
               break;
    case 2400: cputs("  2400  ");
               break;
    case 4800: cputs("  4800  ");
               break;
    case 9600: cputs("  9600  ");
               break;
    case 19200: cputs("  19200 ");
                break;
    case 28800: cputs("  28800 ");
                break;
    case 38400: cputs("  38400 ");
                break;
    case 57600: cputs("  57600 ");
                break;
    case 115200: cputs(" 115200 ");
    }
  gotoxy(56,2); cputs("   ");
  gotoxy(60,2); cputs("   ");
  gotoxy(69,2); cputs("   ");
  gotoxy(57,2); printf("%c",parity);
  gotoxy(61,2); printf("%c",longueur);
  gotoxy(70,2); printf("%c",stop_bit);
  /* Setting the video parameters for the program. */
  textbackground(BLUE);
  if (terminal) window(1,3,80,24);
    else window(1,4,80,13);
  gotoxy(1,1);
  }


void set_up_menu()
  {
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(2,25);clreol();
  gotoxy(2,25);
  cputs("  Serial Port       ->Communication speed            Structure       Esc-FIN ");
  textcolor(RED);
  gotoxy(11,25);cputs("P");
  gotoxy(21,25);cputs("V");
  gotoxy(55,25);cputs("S");
  gotoxy(71,25);cputs("Esc");
  }


Port_serie()
  {
  byte previous_voie;

  choix = 0;
  /* Buttom menu. */
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(1,25);clreol();
  gotoxy(1,25);
  cputs(" To select the communication port:     to   OR             then");
  textcolor(RED);
  gotoxy(38,25); cputs("1");
  gotoxy(43,25); cputs("8");
  gotoxy(48,25); cputs("  or  ");
  gotoxy(50,25); printf("%c",16);
  gotoxy(55,25); printf("%c",17);
  gotoxy(65,25); cputs("Carriage return");
  textcolor(BLACK);
  gotoxy(10,2);
  /* Choice */
  while ( (choix!=0x0D) & (!abandon) )
    {
    while ( (choix=get_clav()) == 0 );
    switch (choix)
      {
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
        {
        previous_voie = voie;
        voie = choix;
        printf("%c",voie);
        delay(200);
        gotoxy(10,2);
        if (!ComExist[voie-0x31]) resul=1; else resul=0;
        if (resul!=0)
          {
          voie = previous_voie;
          printf("%c%c",voie,0x07);
          gotoxy(10,2);
          }
        else
          {
          erreur = Close_Port(TRUE);
          CommPort = voie-0x31;
          erreur = Open_Port();
          Voie_active = voie;
          IOStream_WRITE(0,0,0,0,0,0); /* Sets the DEVICE port in use...  */
          IOStream_WRITE(0,0,0,0,0,0); /* Resets the hand-shakings...     */
          resul = Init_Port(longueur,stop_bit,parity,vitesse,
                  &InBuffSz,&OutBuffSz);
          engorge_err = 0;
          pari_err = 0;
          stop_err = 0;
          brkint = 0;
          }
        break;
        }
      case 0x14D:
        {
        if (voie=='8') voie='1';
          else voie++;
        printf("%c",voie);
        delay(200);
        gotoxy(10,2);
        if (!ComExist[voie-0x31]) resul=1; else resul=0;
        if (resul!=0)
          {
          if (voie=='1') voie='8';
            else voie--;
          printf("%c%c",voie,0x07);
          gotoxy(10,2);
          }
        else
          {
          erreur = Close_Port(TRUE);
          CommPort = voie-0x31;
          erreur = Open_Port();
          Voie_active = voie;
          IOStream_WRITE(0,0,0,0,0,0); /* Sets the DEVICE port in use...  */
          IOStream_WRITE(0,0,0,0,0,0); /* Resets the hand-shakings...     */
          resul = Init_Port(longueur,stop_bit,parity,vitesse,
                  &InBuffSz,&OutBuffSz);
          engorge_err = 0;
          pari_err = 0;
          stop_err = 0;
          brkint = 0;
          }
        break;
        }
      case 0x14B:
        {
        if (voie=='1') voie='8';
          else voie--;
        printf("%c",voie);
        delay(200);
        gotoxy(10,2);
        if (!ComExist[voie-0x31]) resul=1; else resul=0;
        if (resul!=0)
          {
          if (voie=='8') voie='1';
            else voie++;
          printf("%c%c",voie,0x07);
          gotoxy(10,2);
          }
        else
          {
          erreur = Close_Port(TRUE);
          CommPort = voie-0x31;
          erreur = Open_Port();
          Voie_active = voie;
          IOStream_WRITE(0,0,0,0,0,0); /* Sets the DEVICE port in use...  */
          IOStream_WRITE(0,0,0,0,0,0); /* Resets the hand-shakings...     */
          resul = Init_Port(longueur,stop_bit,parity,vitesse,
                  &InBuffSz,&OutBuffSz);
          engorge_err = 0;
          pari_err = 0;
          stop_err = 0;
          brkint = 0;
          }
        }
      }
    }
  }


vitesse_setup()
  {
  long vitesse0;

  choix = 0;
  vitesse0 = vitesse;
  /* Buttom menu. */
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(1,25);
  cputs(" To select the transmission speed, use:                then                  ");
  textcolor(RED);
  gotoxy(44,25); cputs("  or  ");
  gotoxy(46,25); printf("%c",16);
  gotoxy(51,25); printf("%c",17);
  gotoxy(61,25); cputs("Carriage return");
  textcolor(BLACK);
  gotoxy(27,2);
  /* Choice */
  while ( (choix!=0x0D) & (!abandon) )
    {
    while ( (choix=get_clav()) == 0 );
    if (choix==0x14D)
      {
      switch (vitesse)
        {
        case  110: vitesse = 150;
                   cputs("   150  ");
                   break;
        case  150: vitesse = 300;
                   cputs("   300  ");
                   break;
        case  300: vitesse = 600;
                   cputs("   600  ");
                   break;
        case  600: vitesse = 1200;
                   cputs("  1200  ");
                   break;
        case 1200: vitesse = 2400;
                   cputs("  2400  ");
                   break;
        case 2400: vitesse = 4800;
                   cputs("  4800  ");
                   break;
        case 4800: vitesse = 9600;
                   cputs("  9600  ");
                   break;
        case 9600: vitesse = 19200;
                   cputs("  19200 ");
                   break;
        case 19200: vitesse = 28800;
                   cputs("  28800 ");
                   break;
        case 28800: vitesse = 38400;
                   cputs("  38400 ");
                   break;
        case 38400: vitesse = 57600;
                   cputs("  57600 ");
                   break;
        case 57600: vitesse = 115200;
                   cputs(" 115200 ");
                   break;
        case 115200: vitesse = 110;
                   cputs("   110  ");
        }
      gotoxy(27,2);
      }
    if (choix==0x14B)
      {
      switch (vitesse)
        {
        case  110: vitesse = 115200;
                   cputs(" 115200 ");
                   break;
        case  150: vitesse = 110;
                   cputs("   110  ");
                   break;
        case  300: vitesse = 150;
                   cputs("   150  ");
                   break;
        case  600: vitesse = 300;
                   cputs("   300  ");
                   break;
        case 1200: vitesse = 600;
                   cputs("   600  ");
                   break;
        case 2400: vitesse = 1200;
                   cputs("  1200  ");
                   break;
        case 4800: vitesse = 2400;
                   cputs("  2400  ");
                   break;
        case 9600: vitesse = 4800;
                   cputs("  4800  ");
                   break;
        case 19200: vitesse = 9600;
                   cputs("  9600  ");
                   break;
        case 28800: vitesse = 19200;
                   cputs("  19200 ");
                   break;
        case 38400: vitesse = 28800;
                   cputs("  28800 ");
                   break;
        case 57600: vitesse = 38400;
                   cputs("  38400 ");
                   break;
        case 115200: vitesse = 57600;
                   cputs("  57600 ");
        }
      gotoxy(27,2);
      }
    }
  /* Setting the new communication speed. */
  resul = Init_Port(longueur,stop_bit,parity,vitesse,&InBuffSz,&OutBuffSz);
  /* If new value is denied, we reset the preceding value. */
  if (resul!=0)
    {
    vitesse = vitesse0;
    gotoxy(27,2);
    cputs("  9600 ");
    Init_Port(longueur,stop_bit,parity,vitesse,&InBuffSz,&OutBuffSz);
    }
  }


structure_octet()
  {
  int  xpos;
  char element;  /* parity, nb-bytes or stop-bit. */

  element = PARITE;
  choix = 0;
  xpos = 57;
  /* Buttom menu. */
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(1,25);
  cputs(" To select the structure of the bytes, use:              then                ");
  textcolor(RED);
  gotoxy(45,25); cputs("Space   | ");
  gotoxy(53,25); printf("%c",16);
  gotoxy(55,25); printf("%c",17);
  gotoxy(63,25); cputs("Carriage return");
  textcolor(BLACK);
  gotoxy(xpos,2);
  /* Choice */
  while ( (choix!=0x0D) & (!abandon) )
    {
    while ( (choix=get_clav()) == 0 );
    switch (choix)
      {
      case 0x14D: switch (element)  /* Right arrow */
                  {
                  case PARITE:
                    switch (parity)
                      {
                      case 'N': parity = 'P';
                                cputs("P");
                                break;
                      case 'P': parity = 'I';
                                cputs("I");
                                break;
                      case 'I': parity = 'T';
                                cputs("T");
                                break;
                      case 'T': parity = 'R';
                                cputs("R");
                                break;
                      case 'R': parity = 'N';
                                cputs("N");
                      }
                    break;
                  case NBOCTETS:
                    switch (longueur)
                      {
                      case '5': longueur = '6';
                                cputs("6");
                                break;
                      case '6': longueur = '7';
                                cputs("7");
                                break;
                      case '7': longueur = '8';
                                cputs("8");
                                break;
                      case '8': longueur = '5';
                                cputs("5");
                      }
                    break;
                  case STOPBIT:
                    switch (stop_bit)
                      {
                      case '2': stop_bit = '1';
                                cputs("1");
                                break;
                      case '1': stop_bit = '2';
                                cputs("2");
                      }
                  }
                break;
      case 0x14B: switch (element)  /* Left arrow */
                  {
                  case PARITE:
                    switch (parity)
                      {
                      case 'N': parity = 'R';
                                cputs("R");
                                break;
                      case 'P': parity = 'N';
                                cputs("N");
                                break;
                      case 'I': parity = 'P';
                                cputs("P");
                                break;
                      case 'T': parity = 'I';
                                cputs("I");
                                break;
                      case 'R': parity = 'T';
                                cputs("T");
                      }
                    break;
                  case NBOCTETS:
                    switch (longueur)
                      {
                      case '5': longueur = '8';
                                cputs("8");
                                break;
                      case '6': longueur = '5';
                                cputs("5");
                                break;
                      case '7': longueur = '6';
                                cputs("6");
                                break;
                      case '8': longueur = '7';
                                cputs("7");
                      }
                    break;
                  case STOPBIT:
                    switch (stop_bit)
                      {
                      case '2': stop_bit = '1';
                                cputs("1");
                                break;
                      case '1': stop_bit = '2';
                                cputs("2");
                      }
                  }
                break;
      case ' ': element++;
                if (element>STOPBIT) element=PARITE;
      }
    switch (element)
      {
      case PARITE:
         xpos = 57;
         break;
      case NBOCTETS:
         xpos = 61;
         break;
       case STOPBIT:
         xpos = 70;
      }
    gotoxy(xpos,2);
    }
  /* Setting the new structure. */
  resul = Init_Port(longueur,stop_bit,parity,vitesse,&InBuffSz,&OutBuffSz);
  /* If the new structure is denied, we reset the preceding value. */
  if (resul!=0)
    {
    parity = 'N';
    longueur = '8';
    stop_bit = '1';
    Init_Port(longueur,stop_bit,parity,vitesse,&InBuffSz,&OutBuffSz);
    gotoxy(57,2); cputs("N");
    gotoxy(61,2); cputs("8");
    gotoxy(70,2); cputs("1");
    }
  }


void set_up()
  {
  int x,y;

  choix = 0;
  /* Buttom menu. */
  x=wherex(); y=wherey();
  window(1,1,80,25);
  set_up_menu();
  /* Choices storing. */
  while ( (choix!=0x1B) & (!abandon) )
    {
    while ( (choix=get_clav()) == 0 );
    switch(choix)
      {
      case 0x13B: /* CopyRight and help: F1 */
             informations(1);
             window(1,1,80,25);
             break;
      case 0x13C: /* Informations: F2 */
             informations(2);
             window(1,1,80,25);
             break;
      case 0x50: /* Serial port */
      case 0x70:
             Port_serie();
             break;
      case 0x56: /* Speed */
      case 0x76:
             vitesse_setup();
             break;
      case 0x53: /* Structure */
      case 0x73:
             structure_octet();
      }
    set_up_menu();
    }
  /* Initial screen status is restored. */
  main_menu();
  textbackground(BLUE);
  if (! terminal)
    {
    if (y<14) window(1,4,80,13);
      else window(1,15,80,24);
    }
  else window(1,3,80,24);
  gotoxy(x,y);
  }


void ModemCmde()
  {
  char StringCmde[MAXStrLen];
  char CarriageRtn[2];

  textcolor(WHITE);
  if (wherex()!=1) scroll_down();
  cputs("Modem command to send: ");
  strcpy(StringCmde,"AT");
  Lit_chaine(StringCmde,wherex(),wherey(),StrLen);
  if ( (StringCmde!="") & (!Saisie_Escape) & (!abandon) )
    {
    CarriageRtn[0] = cr;
    CarriageRtn[1] = EOS;
    strcat(StringCmde,CarriageRtn);
    if (WriteCmde(StringCmde,strlen(StringCmde),TRUE) != 0)
      {
      cputs("An error occured when sending this command.");
      scroll_down();
      }
    }
  }


void traitement_affichage(char caractere)
  {
  char car[1];

  car[0] = caractere;
  car[1] = 0;
  switch (caractere)
    {
    case 0x03: break;
    case 0x0C: {
               if (! terminal) window(1,15,80,24);
               clrscr();
               if (! terminal) window(1,4,80,13);
               break;
               }
    case 0x0A: if (LF_Used) scroll_down();
               break;
    case 0x0D: if (CR_Used) scroll_down();
               break;
    case 0x08: {
               cputs(car);
               cputs(" ");
               cputs(car);
               break;
               }
    case 0x09: cputs("     ");
               break;
    default:   cputs(car);
    }
  }


void traitement_clavier()
  {
  int  code;
  char fox[1] = " ";
  char fox_message[70] =
  "The Quick Brown Fox Jumped Over The Lazy Dog's Back 0123456789 Times !";

  code = get_clav();
  switch (code)
    {
    case 0x110: /* Quit */
                {
                fin = TRUE;
                break;
                }
    case 0x13B: /* CopyRight and Help: F1 */
                {
                informations(1);
                break;
                }
    case 0x13C: /* Informations: F2 */
                {
                informations(2);
                break;
                }
    case 0x13D: /* Modem command: F3 */
                {
                ModemCmde();
                break;
                }
    case 0x119: /* Parameters */
                {
                set_up();
                break;
                }
    case 0x121: /* Fox message */
                {
                textcolor(YELLOW);
                fox[1] = 0;
                IO_err = FALSE;
                erreur = WriteCOMM(&cr,1);
                if ( (erreur==0) & (!IO_err) & echo ) scroll_down();
                n_car=0;
                while ( (erreur==0) & (!IO_err) & (n_car<77) )
                  {
                  if (Lent) delay(T_Delay);
                  erreur = WriteCOMM(&fox_message[n_car],1);
                  if ( (erreur==0) & (!IO_err) & echo )
                    {
                    fox[0] = fox_message[n_car];
                    cputs(fox);
                    }
                  n_car++;
                  }
                break;
                }
    case 0x12E: /* Clearing all the screens (local send */
                /* and remote receipt...).              */
                {
                textcolor(YELLOW);
                IO_err = FALSE;
                erreur = WriteCOMM(&clrscreen,1);
                if ( (!IO_err) & (erreur==0) ) clrscr();
                break;
                }
    default: /* Sending and writting the next keypressed character... */
             {
             IO_err = FALSE;
             erreur = WriteCOMM(&(char)code,1);
             if ( (!IO_err) & (erreur==0) & echo )
               {
               textcolor(YELLOW);
               traitement_affichage((char)code);
               }
             }
    }
  }


/* ===== MAIN PROCEDURE OF THE PROGRAM ===== */

main(int argc, char *argv[])
  {
  byte i,j,k              ;
  char NomPeriph[9]       ;
  char argument[127]      ;
  char beep_error = FALSE ;
  int  *hold_1b           ;
  char carac_recu         ;
  char deb_message[47] = "Your communication partner has just hang off...";
  int OldXpos,OldYpos     ;
  static int Xpos = 1     ;
  static int Ypos = 1     ;
  byte *SendOK = 0        ;
  byte *NbXoff = 0        ;

  erreur = Check_STARCOMM_Present();
  switch (erreur)
    {
    case 0:
    case 1:
      {
      erreur = 200;
      break;
      }
    case 2:
      {
      Version(ver);
      j=0;
      for (i=0;i<8;i++)
        {
        CommPort=i;
        Port_Opened();
        if (ComExist[CommPort])
          {
          ResetCOM_and_TimMAX(RdTimMAX[0],&OldRdTimMAX,
            WrTimMAX[0],&OldWrTimMAX);
          j++;
          Close_Port(TRUE);
          }
        }
      if (j==0)
        erreur = 300;
      else
        {
        CommPort = 0;
        while (!ComExist[CommPort]) CommPort++;
        voie = CommPort+0x31;
        ResetPortDevice();
        erreur = Open_COMM();
        }
      }
    }

  if (erreur==0)
    {
    OldIBreak = getvect(Int1B);
    setvect(Int1B,CtrlBreak);
    OldIError = getvect(Int24);
    setvect(Int24,IError);
    for(i=1;i<argc;i++)
      {
      strcpy(argument,strupr(argv[i]));
      for (j=0;j<=strlen(argument) & argument[j]!=':' & argument[j]!=',';j++)
        commande[j] = argument[j];
      if (argument[j]==':')
        {
        commande[j] = argument[j];
        j++;
        }
      commande[j] = EOS;
      stock_commande_format();
      while (j<strlen(argument) & argument[j]!='/')
        {
        k=0;
        for (j=j;j<=strlen(argument) & argument[j]!=',' & argument[j]!='/';j++)
          {
          commande[k] = argument[j];
          k++;
          }
        if (argument[j]==',') j++;
        commande[k] = EOS;
        stock_commande_format();
        }
      }
    for (i=1;i<argc;i++)
      {
      strcpy(argument,strupr(argv[i]));
      j = 0;
      while (j<=strlen(argument))
        {
        for (j=j;j<=strlen(argument) & argument[j]!='/';j++);
        if (argument[j]=='/')
          {
          j++;
          if (argument[j]=='/') j++;
          k = 0;
          while(j<=strlen(argument) & argument[j]!='/' & argument[j]!=' ')
            {
            commande[k] = argument[j];
            k++;
            j++;
            }
          j--;
          commande[k] = EOS;
          if (strcmp(strupr(commande),"TERMINAL")==0) terminal = TRUE;
          if (strcmp(strupr(commande),"T")==0) terminal = TRUE;
          if (strcmp(strupr(commande),"ALARME")==0) beep_error = TRUE;
          if (strcmp(strupr(commande),"A")==0) beep_error = TRUE;
          if (strcmp(strupr(commande),"RALENTI")==0) Lent = TRUE;
          if (strcmp(strupr(commande),"R")==0) Lent = TRUE;
          }
        }
      }
    Close_Port(TRUE);
    if (!ComExist[voie-0x31])
      {
      CommPort = 0;
      while (!ComExist[CommPort]) CommPort++;
      voie = CommPort+0x31;
      }
    else CommPort=voie-0x31;
    erreur = Open_Port();
    Voie_active = voie;
    IOStream_WRITE(0,0,0,0,0,0);
    resul = Init_Port(longueur,stop_bit,parity,vitesse,&InBuffSz,&OutBuffSz);
    HandShake_Setup(RTS_CTS,FALSE);
    HandShake_Setup(DTR_DSR,FALSE);
    XonoffShaking_Setup(FALSE);
    setup_ecran_inprog();
    page_de_fond();
    IO_err = FALSE;
    erreur = WriteCOMM(&cr,1);
    n_car=0;
    while ( (IO_err==FALSE) & (erreur==0) & (n_car<45) )
      {
      if (Lent) delay(T_Delay);
      erreur = WriteCOMM(&deb_message[n_car],1);
      n_car++;
      }
    if ( (IO_err==FALSE) & (erreur==0) ) erreur = WriteCOMM(&cr,1);
    if ( (IO_err==FALSE) & (erreur==0) ) erreur = WriteCOMM(&cr,1);
    informations(1);

    while ( (!fin) & (!abandon) )
      {
      if (CheckCOMMIn())
        {
        IO_err = FALSE;
        ReadCOMM(&carac_recu,1);
        if (carac_recu==0x1A)
          {
          if (!terminal)
            {
            OldXpos = wherex();
            OldYpos = wherey();
            window(1,15,80,24);
            gotoxy(Xpos,Ypos);
            }
          textcolor(GREEN);
          erreur = Close_COMM();
          erreur = Open_COMM();
          IO_err = TRUE;
          textcolor(LIGHTGRAY);
          scroll_down();
          cputs("EOF received: your partner has probably disconnected !");
          scroll_down();
          if (!terminal)
            {
            Xpos = wherex();
            Ypos = wherey();
            window(1,4,80,13);
            gotoxy(OldXpos,OldYpos);
            }
          }
        if (IO_err==FALSE)
          {
          if (!terminal)
            {
            OldXpos = wherex();
            OldYpos = wherey();
            window(1,15,80,24);
            gotoxy(Xpos,Ypos);
            }
          textcolor(GREEN);
          traitement_affichage(carac_recu);
          if (!terminal)
            {
            Xpos = wherex();
            Ypos = wherey();
            window(1,4,80,13);
            gotoxy(OldXpos,OldYpos);
            }
          }
        }
      if (beep_error==TRUE)
        {
        if (Errors_Report())
          {
          engorge_err = engorge_err + Engorgement;
          pari_err = pari_err + Parite;
          stop_err = stop_err + Stop_bit;
          brkint = brkint + Break_it;
          sound(100);
          delay(50);
          nosound();
          }
        }
      while (kb_hit()) traitement_clavier();
      if (XonoffShaking_Status(SendOK,NbXoff)!=Inactif)
        {
        if ( (!SendOK) & (*NbXoff>50) ) XonoffShaking_Setup(Bilateral);
        }
      }

    window(1,1,80,25);
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
    setup_ecran_outprog();
    printf(">TERMINAL [<Comm format>][<options>]\n");
    printf("  <Comm fmt>=COMi:speed,parity,bits,stp\n");
    printf("  /T = Terminal: full screen emulation.\n");
    printf("  /A = <A>larm if any receipt error.\n");
    printf("  /R = Slow down all transmitting...\n");
    printf("      (when linking to a very slow PC:\n");
    printf("      more and more overrun errors DO\n");
    printf("      occurs on the slowest station !).\n\n");
    erreur = Close_COMM();
    i=0;
    while ( (i<8) & (NomDevice[i]!=' ') )
      {
      NomPeriph[i] = NomDevice[i];
      i++;
      }
    NomPeriph[i] = 0;
    setvect(Int1B,OldIBreak);
    setvect(Int24,OldIError);
    if (!erreur)
      {
      if (Attend_Buff_ems_vide(10)!=0)
        printf("Transmit buffer is NOT empty !\n");
      erreur = Close_Port(TRUE);
      printf("Program has stoped ");
      if (abandon) printf("on a CtrlBreak");
        else
          if (!erreur) printf("normally");
            else printf("(port is open !)");
      printf(".\n%s: file is closed.\n",NomPeriph);
      }
    else printf("Error--> %s: file NOT closed...\n",NomPeriph);
    }
  else
    {
    switch(erreur)
      {
      case 200:
        {
        printf("STARCOMM was not found as a DEVICE!\n");
        printf("Please, use:  DEVICE = STARCOMM.EXE\n");
        printf("in your CONFIG.SYS, then boot-up...\n");
        break;
        }
      case 300:
        {
        printf("Error--> NO USABLE PORT !\n");
        printf("TERMINAL was interrupted.\n");
        break;
        }
      default: printf("DOS error number %i !\n",erreur);
      }
    }
  }
