unit Status;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, MsgStuf, MessCons;

type
  TStatusForm = class(TForm)
    Indicator: TPanel;
  protected
    procedure CMSetStatus(var Msg : TMessage); message CM_SetCmd;
    procedure CMClearStatus(var Msg : TMessage); message CM_ClearCmd;
    procedure CMHello(var Msg : TMessage); message CM_StatusID;
    procedure DefaultHandler(var Message); override;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  StatusForm: TStatusForm;

implementation

{$R *.DFM}

{ Special message event handlers }

procedure TStatusForm.CMSetStatus(var Msg : TMessage);
begin
 Indicator.Color := clRed;
 BroadcastCommand(Self, Msg);
end;

procedure TStatusForm.CMClearStatus(var Msg : TMessage);
begin
 Indicator.Color := clGreen;
 BroadcastCommand(Self, Msg);
end;

procedure TStatusForm.CMHello(var Msg : TMessage);
begin
 Msg.Result := Self.Handle;
end;

procedure TStatusForm.DefaultHandler(var Message);
var
 Cmd : TMessage;
begin
 inherited DefaultHandler(Message);
 Cmd := TMessage(Message);
 if     (Word(Cmd.Msg) >= UserBroadcastMin)
    and (Word(Cmd.Msg) <= UserBroadcastMax)
   then if TMessage(Message).Result = 0
    then TMessage(Message).Result := BroadcastCommand(Self, Cmd)
    else BroadcastCommand(Self, Cmd);
end;

end.
