unit Receiver;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MsgStuf, MessCons;

type
  TReceiverForm = class(TForm)
    DisplayLabel: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  protected
   procedure CMSetLabel(var Msg : TMessage); message CM_SetCmd;
   procedure CMClearLabel(var Msg : TMessage); message CM_ClearCmd;
   procedure CMHello(var Msg : TMessage); message CM_ReceiverID;
   procedure DefaultHandler(var Message); override;
  end;

var
  ReceiverForm: TReceiverForm;

implementation

{$R *.DFM}

{ Special message event handlers }

procedure TReceiverForm.CMSetLabel(var Msg : TMessage);
begin
 DisplayLabel.Color := Msg.WParam;
 DisplayLabel.Caption := StrPas(Pointer(Msg.LParam));
 BroadcastCommand(Self, Msg);
end;

procedure TReceiverForm.CMClearLabel(var Msg : TMessage);
begin
 DisplayLabel.Color := Msg.WParam;
 DisplayLabel.Caption := StrPas(Pointer(Msg.LParam));
 BroadcastCommand(Self, Msg);
end;

procedure TReceiverForm.CMHello(var Msg : TMessage);
begin
 Msg.Result := Self.Handle;
end;

procedure TReceiverForm.DefaultHandler(var Message);
var
 Cmd : TMessage;
begin
 inherited DefaultHandler(Message);
 Cmd := TMessage(Message);
 if     (Word(Cmd.Msg) >= UserBroadcastMin)
    and (Word(Cmd.Msg) <= UserBroadcastMax)
   then if TMessage(Message).Result = 0
    then TMessage(Message).Result := BroadcastCommand(Self, Cmd)
    else BroadcastCommand(Self, Cmd);
end;

end.
