unit Mainunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MsgStuf, MessCons, Sender, Receiver, StdCtrls;

type
  TMainForm = class(TForm)
    QuitBtn: TButton;
    procedure FormActivate(Sender: TObject);
    procedure QuitBtnClick(Sender: TObject);
  protected
    procedure DefaultHandler(var Message); override;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

  implementation

{$R *.DFM}

procedure TMainForm.DefaultHandler(var Message);
var
 Cmd : TMessage;
begin
 inherited DefaultHandler(Message);
 Cmd := TMessage(Message);

 { Translate command as required }
 case Cmd.Msg of
  CM_SetRequest :   Cmd.Msg := CM_SetCmd;
  CM_ClearRequest : Cmd.Msg := CM_ClearCmd;
 end; {case }

 if    (Word(Cmd.Msg) >= UserBroadcastMin)
   and (Word(Cmd.Msg) <= UserBroadcastMax)
  then TMessage(Message).Result := AppBroadcastCommand(Cmd); 
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
 if not SenderForm.Visible then SenderForm.Show;
 if not ReceiverForm.Visible then ReceiverForm.Show;
end;

procedure TMainForm.QuitBtnClick(Sender: TObject);
begin
 Close;
end;

end.
