// pkt95vw.cpp : implementation of the View class
//

#include "stdafx.h"
#include "pkt95.h"

#include "CommDoc.h"
#include "pkt95vw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// View

IMPLEMENT_DYNCREATE(View, CEditView)

BEGIN_MESSAGE_MAP(View, CEditView)
        //{{AFX_MSG_MAP(View)
        ON_WM_CHAR()
        ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
        ON_WM_KEYDOWN()
        //}}AFX_MSG_MAP
        // Standard printing commands
        ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
        ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
        ON_MESSAGE(WM_COMMCHAR,OnCharIn)
        ON_EN_CHANGE(AFX_IDW_PANE_FIRST,OnEditChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// View construction/destruction

View::View()
{
        // TODO: add construction code here

}

View::~View()
{
}

/////////////////////////////////////////////////////////////////////////////
// View drawing

void View::OnDraw(CDC* pDC)
{
        CCommDoc* pDoc = GetDocument();
        ASSERT_VALID(pDoc);

        // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// View printing

BOOL View::OnPreparePrinting(CPrintInfo* pInfo)
{
        // default CEditView preparation
        return CEditView::OnPreparePrinting(pInfo);
}

void View::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
        // Default CEditView begin printing.
        CEditView::OnBeginPrinting(pDC, pInfo);
}

void View::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
        // Default CEditView end printing
        CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// View diagnostics

#ifdef _DEBUG
void View::AssertValid() const
{
        CEditView::AssertValid();
}

void View::Dump(CDumpContext& dc) const
{
        CEditView::Dump(dc);
}

CCommDoc* View::GetDocument() // non-debug version is inline
{
        ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCommDoc)));
        return (CCommDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// View message handlers

void View::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
while (nRepCnt--)
  {
  GetDocument()->Write(nChar);
  }
}


LONG View::OnCharIn(WPARAM wParam,LPARAM lParam)
  {
  DWORD ct=(DWORD)wParam;
  char *ch=(char *)lParam;
  int sel1,sel2,len,wct,newlen;
  CEdit &ectl=GetEditCtrl();
  if (!ct) ct=1;  // echo character
  wct=len=ectl.SendMessage(WM_GETTEXTLENGTH,0,0);
  ectl.GetSel(sel1,sel2);
  // if cursor not at end temporarily move it
  if (sel1!=sel2||sel1!=len)
    ectl.SetSel(len+1,len+1,TRUE);
  ProcChars(ectl,ct,ch,len,sel1,sel2,wct);
  // Trim to about 30K
  while (newlen=ectl.SendMessage(WM_GETTEXTLENGTH,0,0)>30000)
    {
        ectl.SetSel(0,ectl.LineIndex(1),TRUE);
        ectl.Clear();
        }
  sel1-=len-newlen;
  if (sel1<0) sel1=0;
  sel2-=len-newlen;
  if (sel2<0) sel2=0;
  len=newlen;
  // restore selection
  if (sel1!=sel2||sel1!=len)
    ectl.SetSel(sel1,sel2);
  return 0;
  }

BOOL View::ProcChars(CEdit &ectl,unsigned siz,char *ch,int &len,
          int &sel1,int &sel2,int &l1)
  {
  char *nch;
/* Process backspace by processing everything before it,
   backspacing, then processing everything after it */
  if (nch=strchr(ch,'\010'))
    {
        *nch='\0';
        if (ch!=nch) ProcChars(ectl,strlen(ch),ch,len,sel1,sel2,l1);
        ectl.SetSel(l1-1,l1,TRUE);
        ectl.Clear();
        len--;
        if (sel1>len) sel1=len;
        if (sel2>len) sel2=len;
        if (*++nch) ProcChars(ectl,strlen(nch),nch,len,sel1,sel2,l1);
        return TRUE;
        }
  while (nch=strchr(ch,'\007'))
    {
    MessageBeep(0xFFFFFFFF);
    strcpy(nch,nch+1);
    }
  if (*ch)
    {
        ectl.ReplaceSel(ch);
        l1=ectl.SendMessage(WM_GETTEXTLENGTH,0,0);
        }
  return FALSE;
  }

  afx_msg void View::OnEditChange(void)
    {
        return; // don't modify document!
        }

void View::OnInitialUpdate()
{
        SetFont(CFont::FromHandle((HFONT)::GetStockObject(OEM_FIXED_FONT)),FALSE);
        CEditView::OnInitialUpdate();
}

void View::OnEditPaste()
{
        //Replace standard paste so pasted characters are sent to host
        HGLOBAL h;
        LPSTR data;
        if (!OpenClipboard())
          {
          MessageBox("Can't open Clipboard",NULL,MB_OK|MB_ICONSTOP);
          return;
          }
        h=GetClipboardData(CF_OEMTEXT);
        if (h)
          {
          data=(LPSTR)GlobalLock(h);
          while (*data)
            {
            if (*data!='\n') OnChar(*data,1,0);
                data++;
                }
          GlobalUnlock(h);
          }
        CloseClipboard();
}

void View::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
        if (nChar>=VK_F1&&nChar<=VK_F12  &&
          (GetKeyState(VK_CONTROL)&~1)&&
          !(GetKeyState(VK_SHIFT)&~1)&&
          !(GetKeyState(VK_MENU)&~1))
            DoFKey(nChar);
        else
            CEditView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void View::DoFKey(UINT key)
  {
  const char *ini;
  CString sec="FKEYS";
  CString tag;
  char text[128],*bs,*tp=text;
  ini=AfxGetApp()->m_pszProfileName;
  key-=VK_F1-1;
  tag.Format("Key%d",key);
  GetPrivateProfileString(sec,tag,"",text,sizeof(text),ini);
  while (bs=strchr(text,'^'))
    {
        if (isalpha(bs[1]))
          bs[1]=toupper(bs[1])-'A'+1; // control char
        strcpy(bs,bs+1);
        }
  while (*tp) OnChar(*tp++,1,0);
  }
