#ifndef __DEBUG_H__
#define __DEBUG_H__

//---------------------------------------------------------------------------
//
//  File:           DEBUG.H
//  Programmer:     Bob Provencher
//  Create Date:    12/3/94
//  Last Mod Date:	7/15/95
//  Description:    dbugstream class definition
//
//  Copyright (c) 1994, 1995. Aesir Software, Inc.
//  All Rights Reserved.
//
//---------------------------------------------------------------------------

#ifndef __PRECOMP_H__
#include "precomp.h"
#endif

#ifndef __GEN_H__
#include "gen.h"
#endif

#if defined( _MSC_VER )
static const char* crlf = "\r\n";
#else
const char const* crlf = "\r\n";
#endif

class dbugbuf : public streambuf
{

public:

    dbugbuf();
    ~dbugbuf();

	virtual int overflow( int = EOF );
	virtual int underflow( void );
	virtual int sync();

};

inline dbugbuf::~dbugbuf()
{
}

inline int dbugbuf::sync()
{
    return 0;
}

class dbugstream : public ostream
{

public:

     dbugstream();
     ~dbugstream();

    dbugbuf*  rdbuf();     // get the assigned dbugbuf

private:

    dbugbuf buf;

};

inline dbugstream::~dbugstream()
{
}

inline dbugbuf* dbugstream::rdbuf()
{
    return (dbugbuf*)ostream::rdbuf();
}

template<class T1, class T2> class omanip2
{

public:
	omanip2<T1,T2>(ostream& ( *_f)(ostream&, T1, T2 ), T1 _z1, T2 _z2 ) :
		_fn(_f), _ag1(_z1), _ag2(_z2) { }
	friend ostream&  operator<<(ostream& _s, omanip2<T1,T2>& _f)
		{ return(*_f._fn)(_s, _f._ag1, _f._ag2); }

private:
	ostream&  (*_fn)(ostream&, T1, T2);
	T1 _ag1;
	T2 _ag2;
};

extern dbugstream dbug;

#endif
