#ifndef __DDSURF_H__
#define __DDSURF_H__

//---------------------------------------------------------------------------
//
//	File:			DDSURF.H
//	Programmer:		Bob Provencher
//	Create Date:	7/15/95
//	Last Mod Date:	8/8/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "dddiag.h"

extern int  desired_fps;
extern int  move_ball_period;
extern int  numBackBuffs;
extern BOOL page_flip;

#define WM_MOVEBALL		WM_USER + 100

#define TEXT_WIDTH		64		// dword aligned
#define TEXT_HEIGHT		20

extern DDSURFACEDESC	   ddPrimSurfDesc;		// primary surface description
extern LPDIRECTDRAWSURFACE pPrimarySurface;		// primary surface (the screen)
extern DDSURFACEDESC	   ddOffSurfDesc;		// off-screen surface desc
extern LPDIRECTDRAWSURFACE pOffSurface;			// off-screen surface
extern DDSURFACEDESC	   ddCheckerSurfDesc;	// checker surface desc
extern LPDIRECTDRAWSURFACE pCheckerSurface;		// checker surface
extern DDSURFACEDESC	   ddBallSurfDesc;		// ball surface desc
extern LPDIRECTDRAWSURFACE pBallSurface;		// ball surface
extern DDCOLORKEY		   ddck;				// color key
extern POINT			   ptBall;				// where is the ball
extern POINT			   ballSpeed;			// current speed of ball
extern UINT				   uPendingMoves;		// count of pending ball moves

extern DWORD start, end, attempts, frame, misses;

template <class T>
BOOL DDRelease( T& p )
{
	if ( p )
	{

		do
		{
			sCode = p->Release();
            CHECK;
		}
		while ( sCode == DDERR_WASSTILLDRAWING );

		if ( SUCCEEDED( sCode ) )
		{
			p = 0;
			return TRUE;
		}
		else
			return FALSE;

	}
    else
        return TRUE;
}

const DWORD defTimeOut = 2000UL;

BOOL WaitForBltFlagOn(  LPDIRECTDRAWSURFACE lpDDSurf,
					    DWORD dwFlag, 
						DWORD timeout = defTimeOut );

BOOL WaitForBltOk(      LPDIRECTDRAWSURFACE lpDDSurf, 
                        DWORD timeout = defTimeOut );

BOOL WaitForBltDone(    LPDIRECTDRAWSURFACE lpDDSurf, 
                        DWORD timeout = defTimeOut );

BOOL WaitForFlipFlagOn( LPDIRECTDRAWSURFACE lpDDSurf,
						DWORD dwFlag, 
                        DWORD timeout = defTimeOut );

BOOL WaitForFlipOk(     LPDIRECTDRAWSURFACE lpDDSurf, 
                        DWORD timeout = defTimeOut );

BOOL WaitForFlipDone(   LPDIRECTDRAWSURFACE lpDDSurf, 
						DWORD timeout = defTimeOut );

BOOL CreatePrimarySurface( void );
BOOL CreateSurfaces( void );

BOOL CleanUp( void );
BOOL DrawBackground( BYTE back_color, LPDIRECTDRAWSURFACE lpPatSurf,
				const DDSURFACEDESC& ddsd );

BOOL ComposeImage( void );
BOOL ShowImage( void );

BOOL ComposeAndShowImage( void );

BOOL DrawBall( void );
void MoveBall( void );
void AccelBall( void );

BOOL RestoreIfLost( LPDIRECTDRAWSURFACE pDirectDrawSurface );

BOOL CreatePrimarySurface( void );
BOOL CreateCheckerSurface( void ); 
BOOL CreateBallSurface( void ); 
BOOL CreateBackgSurface( void ); 
BOOL CreateTextSurface( void );

BOOL RestoreBallSurface( void );

HRESULT CALLBACK EnumAttachedSurfacesCallback( LPDIRECTDRAWSURFACE lpDDSurface,
											   LPDDSURFACEDESC lpDDSurfDesc,
											   LPVOID );

#endif

