//---------------------------------------------------------------------------
//
//	File:			BALL.CPP
//	Programmer:		Bob Provencher
//	Create Date:	7/16/95
//	Last Mod Date:	7/16/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "dddiag.h"
#include "ddsamp.h"
#include "ddsurf.h"  
#include "ball.h"

int numBalls;
Ball* ball;

Ball::Ball()
{
	DWORD w = ddBallSurfDesc.dwWidth;
	DWORD h = ddBallSurfDesc.dwHeight;
	pos.x = random( uWidth  - w ) + ( w / 2 );
	pos.y = random( uHeight - h ) + ( h / 2 );
	speed.x = random( w / 3 ) - ( w / 6 );
	speed.y = random( h / 3 ) - ( h / 6 );
}

BOOL Ball::Draw() const
{

	//
	//	draw the ball at it's current location
	//

	LONG w = ddBallSurfDesc.dwWidth;
	LONG h = ddBallSurfDesc.dwHeight;

	LONG x = pos.x - ( w / 2 );
	LONG y = pos.y - ( h / 2 );

	RECT rcSrc;

	rcSrc.left   =
	rcSrc.top    = 0;
	rcSrc.right  = w;
	rcSrc.bottom = h;

	if ( x < 0 )
	{
		rcSrc.left = -x;
		x = 0;
	}

	if ( y < 0 )
	{
		rcSrc.top = -y;
		y = 0;
	}

	if ( x + w > (int)uWidth )
		rcSrc.right  = uWidth  - x;

	if ( y + h > (int)uHeight )
		rcSrc.bottom = uHeight - y;

	if ( pBallSurface->IsLost() )
		if ( !RestoreBallSurface() )
			return FALSE;

	DWORD s = timeGetTime();

	sCode = pOffSurface->BltFast( x, y, pBallSurface, &rcSrc, TRUE );

	DDTRACE << ( timeGetTime() - s ) << " ms in DrawBall()\n";

	CHECK;

	return TRUE;

}

void Ball::Accel( void )
{
	if ( ( pos.x < (long)( ddBallSurfDesc.dwWidth / 2 ) && speed.x < 0 ) ||
		 ( pos.x > (long)( uWidth - ddBallSurfDesc.dwWidth / 2 ) && speed.x > 0 ) )
		BounceX();
	if ( ( pos.y < (long)( ddBallSurfDesc.dwHeight / 2 ) && speed.y < 0 ) ||
		 ( pos.y > (long)( uHeight - ddBallSurfDesc.dwHeight / 2 ) && speed.y > 0 ) )
		BounceY();
	else
		speed.y++;
}

