unit Dbuglibf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;

type
  TFrmDebug = class(TForm)
    TxtDebug: TMemo;
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmDebug: TFrmDebug;
  SaveExit : Pointer;

  procedure LibExit; far;
  {The three procedures to be exported}
  procedure DBUGPrint( lpszToPrint : PChar ); export;
  procedure DBUGClear; export;
  procedure DBUGSave( lpszFileName : PChar); export;

implementation
{$R *.DFM}


procedure DBUGSave( lpszFileName : PChar);
var
   FileName : String;
begin
     FileName := StrPas( lpszFileName ); {PChar to Pascal string}
     FrmDebug.TxtDebug.Lines.SaveToFile( FileName );
end;

procedure DBUGPrint( lpszToPrint : PChar );
var
   ToPrint : String;
begin
     ToPrint := StrPas( lpszToPrint );  {PChar to Pascal string}
     FrmDebug.TxtDebug.Lines.Add( ToPrint );
end;

procedure DBUGClear;
begin
     FrmDebug.TxtDebug.Lines.Clear;
end;

procedure LibExit;
begin
     FrmDebug.Free;
end;

procedure TFrmDebug.FormResize(Sender: TObject);
begin
     {Ensure that Memo component resizes with window}
     TxtDebug.Width := FrmDebug.Width - 20;
     TxtDebug.Height := FrmDebug.Height - 40;
end;

begin
     FrmDebug := TFrmDebug.Create( Application );
     FrmDebug.Show;
     SaveExit := ExitProc; {Save old exit procedure}
     ExitProc := @LibExit; {Install LibExit exit procedure}
end.
