unit Dbugcomp;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls;

type
  TNoBugs = class(TComponent)
  private
  {Private declarations }
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
    {There is no need to include a Create procedure
    becuase the loading of the dll is done after
    the component is loaded, and becuase there are
    no variables that would require it. Instead, the
    inherited Create procedure will be called
    automatically.}
    destructor Destroy; override;
    procedure Print( StrToPrint : String );
    procedure Clear;
    procedure Save( FileName : String);
  published
    { Published declarations }
  end;

procedure Register;


{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
implementation

type
    {Defining the function signature as a type
    makes a later typecast easier.}
  TDBUG_W_Params =  procedure( Arg1 : PChar );
  TDBUG_WO_Params=  procedure;
var
  LibPresent      : Boolean; {Flag to indicate presence of dll}
  LibHandle       : THandle; {Instance handle of dll}
  {address of the dll's DBUGPRINT procedure}
  fxnPrintAddress : TDBUG_W_Params;
  {address of the dll's DBUGCLEAR procedure}
  fxnClearAddress : TDBUG_WO_Params;
  {address of the dll's DBUGSAVE procedure}
  fxnSaveAddress  : TDBUG_W_Params;

procedure TNoBugs.Loaded;
const
     {Dll's full path and file name, hardcoded to
     protect source and debug output}
     {Be sure to "personalize" path}
   LibPath : String = 'C:\DELPHI\BIN\DBUGLIB.DLL';
var
   lpszLibName: PChar;  {LibPath as Null-terminated string}
   {procedure names as Null-terminated strings}
   lpszPrintName : PChar;
   lpszClearName : PChar;
   lpszSaveName  : PChar;
begin
     inherited Loaded;
     {Assign values into PChars}
     GetMem( lpszPrintName, 10 );
     {DBUGPrint is the name of the procedure in the DLL}
     StrPCopy( lpszPrintName, 'DBUGPrint');
     GetMem( lpszClearName, 10 );
     {DBUGClear is the name of the procedure in the DLL}
     StrPCopy( lpszClearName, 'DBUGClear');
     GetMem( lpszSaveName, 9 );
     {DBUGSave is the name of the procedure in the DLL}
     StrPCopy( lpszSaveName, 'DBUGSave');
     GetMem( lpszLibName, SizeOf(LibPath) + 1);
     StrPCopy( lpszLibName, LibPath);
     {Assume the library is present}
     LibPresent := TRUE;
     {if it is indeed present then...}
     if FileExists( LibPath ) then
     begin
          {Load the dll into memory}
          LibHandle := LoadLibrary( lpszLibName);
          {if LoadLibrary failed then...}
          if LibHandle < 32 then
          begin
               {Indicate that the dll is not available}
             LibPresent := FALSE;
          end
          {Otherwise, retrieve the addresses of the
          procedures.}
          else
          begin
               {addresses must be typecast to TFarProc.}
               TFarProc( @fxnSaveAddress)  :=
                         GetProcAddress(LibHandle, lpszSaveName);
               TFarProc( @fxnPrintAddress) :=
                         GetProcAddress(LibHandle, lpszPrintName);
               TFarProc( @fxnClearAddress) :=
                         GetProcAddress(LibHandle, lpszClearName);
          end;
     end
     {else, if the dll cannot be found on the drive...}
     else
         LibPresent := FALSE;
     {release the memory used for the PChars}
     FreeMem( lpszPrintName, 10 );
     FreeMem( lpszClearName, 10 );
     FreeMem( lpszSaveName, 9 );
     FreeMem( lpszLibName, 255 );
end;

destructor TNoBugs.Destroy;
begin
     {Unload the library, then call the inherited
     Destroy.}
     if LibHandle > 32 then
        FreeLibrary( LibHandle );
     inherited Destroy;
end;


procedure TNoBugs.Print( StrToPrint : String );
var
   lpszStrToPrint : PChar;{StrToPrint as a Null-terminated string}
begin
     {if the dll is not present, then return to the
     calling procedure immediately!}
     if LibPresent = FALSE then exit;
     {However, if the dll is available, then
     copy StrToPrint into lpszStrToPrint and
     call the dll's DBUGPRINT procedure.}
     GetMem( lpszStrToPrint, SizeOf( StrToPrint) + 1 );
     StrPCopy( lpszStrToPrint, StrToPrint);
     fxnPrintAddress( lpszStrToPrint);
     {Release the memory used by lpszStrToPrint.}
     FreeMem( lpszStrToPrint, SizeOf( StrToPrint) + 1);
end;

procedure TNoBugs.Clear;
begin
     {if the dll is not present, then return to the
     calling procedure immediately!}
     if LibPresent = FALSE then exit;
     {However, if the dll is available, then
     copy StrToPrint into lpszStrToPrint and
     call the dll's DBUGCLEAR procedure.}
     fxnClearAddress;
end;

procedure TNoBugs.Save( FileName : String );
var
   lpszFileName : PChar; {FileName as a Null-terminated string}
begin
     {if the dll is not present, then return to the
     calling procedure immediately!}
     if LibPresent = FALSE then exit;
     {However, if the dll is available, then
     copy StrToPrint into lpszStrToPrint and
     call the dll's DBUGSAVE procedure.}
     GetMem( lpszFileName, SizeOf( FileName) + 1);
     StrPCopy( lpszFileName, FileName);
     fxnSaveAddress( lpszFileName );
     {Release the memory used by lpszFileName.}
     FreeMem( lpszFileName, SizeOf( FileName) + 1);
end;

procedure Register;
begin
  RegisterComponents('Samples', [TNoBugs]);
end;

end.
