//Listing 1. C-based engine for executing machine code

int curr_value;
char *param_block;
char *function_name;

//param_block points to the part of the condensed code
//  buffer following the action code

operation_code = *((int)param_block);
param_block+=sizeof(int);

switch (operation_code)
{
case Literal_number:
  expr_stack.push(atoi((char *)param_block);
  break;
case Variable_value:
  curr_value = symbol_table.get_variable_value((char *)param_block);
  expr_stack.push(curr_value);
  break;
case Add_operation:
  curr_value = expr_stack.pop() + expr_stack.pop();
  expr_stack.push(curr_value);
  break;
case Function_call:
  num_passed_arguments = (int)param_block;
  param_block += sizeof(int);
  symbol_name = (char *)param_block;
  //the execute_function method pops the number of arguments
  //  specified by num_passed_arguments
  curr_value = symbol_table.execute_function(symbol_name,
                                             num_arguments);
  expr_stack.push(curr_value);
  break;
case Assignment:
  curr_value = expr_stack.pop();
  symbol_name = (char *)param_block;
  symbol_table.set_variable_value(symbol_name, curr_value);
  break;
case Display_value:
  curr_value = expr_stack.pop();
  cout << curr_value << endl;
  break:
default:
  //fatal error!
}	
