/* FILEDATE.C - An "External Function" DLL for use with the REXX
*    program XDIR.CMD
*       Written for IBM C Set++ v 2.01 / IBM WarpTlkt (5/13/95)
*       Compiled from command line as a DLL: 
*               icc /Ge- filedate.c filedate.def                */
#pragma comment(copyright, "(C) 1995 by Murray L. Lesser")
#define INCL_NOPMAPI    /* Prevents loading PM API calls */
#define INCL_DOSFILEMGR /* Loads "file manager" API prototypes */
#define INCL_RXFUNC     /* Loads REXX "external function" types */
#include <os2.h>
#include <rexxsaa.h>
#include <stdio.h>
#include <string.h>

RexxFunctionHandler FileDate  ;   /* Type definition in rexxsaa.h */
ULONG FileDate(                     /* REXX External Function */
        CHAR      *name,
        ULONG     Numargs,
        RXSTRING  Args[],
        CHAR      *Queuename,
        RXSTRING  *retstr)         /* Output string goes here */
{
    UCHAR         FileName[256];
    FILEFINDBUF4  InfoBuf;          /* Goes with Info Level 2     */
    HDIR          FileHandle = 1;   /* Required for OS/2 API call */
    ULONG         SearchAttr = 0x37; /* Any, or no, attributes OK */
    ULONG         InfoBufSize = sizeof(InfoBuf);
    ULONG         FileCount = 1;        /* Find only one file */
    ULONG         InfoLevel = 2;   /* Gets length of EAs for file */
    ULONG         EAs = 0;
    APIRET        rc;

    if (Numargs != 1)   /* Error check: If taken, will produce    */
        return 40;      /*    REXX "improper function call" error */
    strcpy(FileName,Args[0].strptr);
    rc = DosFindFirst(FileName,&FileHandle,SearchAttr,&InfoBuf,
             InfoBufSize,&FileCount,InfoLevel);
  /* If API error, call will return "" */
    if (rc != 0)  {
        retstr->strptr[0] = '\n';
        retstr->strlength = 0;
        return 0;
        }
    DosFindClose(FileHandle);           /* Leakage preventer */
  /* Correct cbList return for actual EA length: */
    if (InfoBuf.cbList != 4) EAs = InfoBuf.cbList/2;
  /* Normal output:  File date, EA length, name of File found */
    sprintf(retstr->strptr,"%d/%02d/%d %d %s",
        InfoBuf.fdateLastWrite.month,
        InfoBuf.fdateLastWrite.day,
        InfoBuf.fdateLastWrite.year + 1980,
        EAs,                             /* Length of EAs  */
        InfoBuf.achName);                /* File found */
    retstr->strlength = strlen(retstr->strptr);
    return 0;
}
