unit Userstat;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     ExtCtrls,
     NWLib, 
     NWTools, 
     NWServer; 

type
  TwinUserStats = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    netName: TEdit;
    fullUserName: TEdit;
    netAddrs: TComboBox;
    stationAddrs: TComboBox;
    StatTimer: TTimer;
    bPause: TBitBtn;
    NWLib1: TNWLib;
    NWTools1: TNWTools;
    NWServer1: TNWServer;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    loginTime: TEdit;
    bytesRead: TEdit;
    bytesWritten: TEdit;
    Requests: TEdit;
    recordLocks: TEdit;
    fileLocks: TEdit;
    procedure bPauseClick(Sender: TObject);
    procedure StatTimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure statsUpdate ;
  end;

var
  winUserStats: TwinUserStats;

implementation

{$R *.DFM}

procedure TwinUserStats.FormShow(Sender: TObject);
  var
    connectInfo : TNWConnectInfo ;    { our interface structure }
    connList    : TConnList      ;
    nConns      : word           ;
    nLoop       : word           ;
  begin
    {Get User's Login Connection List, then look at on each one }
    nConns := 0 ;
    GetUserConnList(GetPrimaryServerID,netName.text,nConns,connList) ;
    for nloop := 1 to nConns do begin
      if GetConnectInfo(GetPrimaryServerID, 
                        connList[nloop-1],connectInfo) then
        begin
          fullUserName.text := fullName(netname.text) + ' @ ' +
                               connectInfo.serverName ;
          { Add Items to ComboBoxes }
          netAddrs.items.Add(connectInfo.internet) ;
          stationAddrs.items.Add(intToStr(connList[nloop-1])) ;
        end;
    end;
    netAddrs.text := netaddrs.items[0] ;
    stationAddrs.text := stationAddrs.items[0] ;
    { if only one item, change combobox style }
    if (netAddrs.items.count < 2) then
      netAddrs.style := csSimple ;
    if (stationAddrs.items.count < 2) then
      stationAddrs.style := csSimple ;

    { initial timer event }
    statsUpdate ;
  end;

procedure TwinUserStats.bPauseClick(Sender: TObject);
  begin
    statTimer.enabled := (not statTimer.enabled) ;
    if not statTimer.enabled then
      bPause.caption := '&Resume' 
    else
      bPause.caption := '&Pause' ; 
  end;

procedure TwinUserStats.StatTimerTimer(Sender: TObject);
  begin
    statsUpdate ;
  end;

procedure TWinUserStats.statsUpdate ;
  var
    connStats : TNWConnStats ;      { public netware struct. }
  begin
    if getUserStats(GetPrimaryServerID,
                    strToIntDef(stationAddrs.items[maxLong(stationAddrs.itemIndex,0)],0),
                    connStats) then 
      begin
        loginTime.text    := formTime(connStats.loginTime)  ;
        bytesRead.text    := intToStr(connStats.bytesRead)     ;
        bytesWritten.text := intToStr(connStats.bytesWritten)  ;
        requests.text     := intToStr(connStats.totalRequests) ;
        recordLocks.text  := intToStr(connStats.recordLocks)   ;
        fileLocks.text    := intToStr(connStats.fileLocks)     ;
      end                              
    else
      begin
        loginTime.text    := '0' ;
        bytesRead.text    := '0' ;
        bytesWritten.text := '0' ;
        requests.text     := '0' ;
        recordLocks.text  := '0' ;
        fileLocks.text    := '0' ;
      end;                   
  end;

end.
