unit Printcap;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     Spin, 
     ExtCtrls, 
     nwPrint, 
     Nwtools, 
     Nwlib, 
     NWServer;

type
  TwinCapture = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Panel1: TPanel;
    Header1: THeader;
    ServerList: TListBox;
    Panel2: TPanel;
    Header2: THeader;
    QueueList: TListBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cBanner: TEdit;
    nCopies: TSpinEdit;
    nTimeOut: TSpinEdit;
    nTabs: TSpinEdit;
    lAutoEndCap: TCheckBox;
    bEndCap: TButton;
    nForm: TSpinEdit;
    Label5: TLabel;
    lFormFeeds: TCheckBox;
    NWLib1: TNWLib;
    NWTools1: TNWTools;
    NWPrint1: TNWPrint;
    NWServer1: TNWServer;
    Panel3: TPanel;
    Header3: THeader;
    qUserList: TListBox;
    Panel4: TPanel;
    Header4: THeader;
    qOperatorList: TListBox;
    Panel5: TPanel;
    Header5: THeader;
    qServerList: TListBox;
    procedure FormShow(Sender: TObject);
    procedure ServerListDblClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure bEndCapClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure QueueListDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winCapture: TwinCapture;

implementation

{$R *.DFM}

{ Store Capture Options }
var
  captureFlags : TNWCaptureFlags ; 



procedure TwinCapture.FormCreate(Sender: TObject);
  begin
    { Initialize Default Capture Environment Flags }
    if not GetCaptureFlags(1,captureFlags) then 
      AlertBox('LPT1:;Could Not Retrieve Capture Flags on Port') ;
  end;

procedure TwinCapture.FormShow(Sender: TObject);
  begin
    { Populate Listboxes }
    serverList.items.AddStrings(
                      GetConnectedServerList) ;
    queueList.items.AddStrings(
                      GetBinderyList(GetPrimaryServerID,nw_printq)) ;
    qServerList.items.AddStrings(
                      getQueueServers(getPrimaryServerID,captureFlags.qname)) ;
    qUserList.items.AddStrings(
                      getQueueUsers(getPrimaryServerID,captureFlags.qname)) ;
    qOperatorList.items.AddStrings(
                      getQueueOperators(getPrimaryServerID,captureFlags.qname)) ;
    bEndCap.enabled := IsCaptured(1) ; { LPT1: }                               
    { Read Capture Flags }
    nCopies.value  := captureFlags.Copies ;
    nTabs.value    := captureFlags.tabSize ;
    nTimeOut.value := captureFlags.timeout ;
    cBanner.text   := captureFlags.banner ;
    nForm.Value    := captureFlags.formType ;
    lAutoEndCap.checked := captureFlags.autoEndCap ;
    lFormFeeds.checked  := captureFlags.FormFeed ;

    { Set Listbox indexes }
    serverlist.itemindex := 
         serverList.items.indexOf(GetServerName(captureFlags.nServer));
    queuelist.itemindex := 
         queuelist.items.indexOf(captureFlags.qname) ;
  end;

procedure TwinCapture.ServerListDblClick(Sender: TObject);
  var
    nconn : TNWConnHandle ;
    ctemp : string ;
  begin
    { Select New Server and Build New Queue List}
    if serverList.items.count > 0 then
      begin
        ctemp := serverList.items[serverList.itemindex] ;
        nConn := GetServerHandle(ctemp) ;
        if nConn > 0 then
          begin
            queueList.clear ;
            queueList.items.AddStrings(GetBinderyList(nConn,nw_printq));
          end
      end;
  end;

procedure TwinCapture.OKBtnClick(Sender: TObject);
  var
    cserver  : string ;
    cqueue   : string ;
  begin     
    cserver := ServerList.items[MaxLong(ServerList.itemindex,0)] ;
    cqueue  := queueList.items[MaxLong(queueList.itemindex,0)] ;
    { Store CaptureFlags Options }
    with captureFlags do begin
      copies     := nCopies.value ;
      banner     := cbanner.text ;
      tabSize    := nTabs.value ;
      timeOut    := nTimeOut.value ;
      formType   := nform.value ;
      autoEndCap := lAutoEndCap.checked;
      formFeed   := lFormFeeds.checked ;
    end;
    if Capture(GetServerHandle(cserver),cQueue,1,CaptureFlags) then
      begin
        bEndCap.enabled := True ;
        okBox(cserver +'/' + cqueue + ';Captured Successfully!') ;
      end
    else
      AlertBox('Error Capturing LPT1: to Device ' +
               queueList.items[MaxLong(queuelist.itemIndex,0)]) ;
  end;

procedure TwinCapture.bEndCapClick(Sender: TObject);
  begin
    bEndCap.enabled := (not EndCap(1)) ;
  end;

procedure TwinCapture.QueueListDblClick(Sender: TObject);
  begin
    if queueList.items.count > 0 then
      begin
        qUserList.items.clear ;
        qUserList.items.AddStrings(
            getQueueUsers(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;

        qOperatorList.items.clear ;
        qOperatorList.items.AddStrings(
            getQueueOperators(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;

        qServerList.items.clear ;
        qServerList.items.AddStrings(
            getQueueServers(getPrimaryServerID,queueList.items[queueList.itemIndex])) ;
      end;  
  end;

end.
