If(0)
    This module generates the code for the Valuation and Property Type
    description files.

    This data is stored in the UNIV file

    code is the property type code or valuation type code

    ptyp_code^[code]  = description for property type
    vtyp_code^[code]  = description for valuation type

Endif
Define DescSearchCode(Desc, desc)
/*
    Desc is Vtyp or Ptyp etc
    desc is vtyp or ptyp etc

    This will generate the formatting routine for the combo box
*/
{
    Print(`
Define `><Desc><`SearchCode(key, type) {
	Explode(key, "^", &code);
	if (type != "s")
		return code;
	return StrCat(code, "\t", univ^`><desc><`_code^[code]);
}`);
}
Define DescMaintScr(Desc, desc, nameLong, nameAbrv)
/*
    This will generate the code that defines the Screen Dialogue
*/
{
    Print(`
Define `><Desc><`MaintScr() {
	scr = SdCreate(, -1, -1, 18, 72, "`><nameLong><` Maintenance");

	SdPrompt(scr, 1,  1, "`><nameAbrv><` Code  :");
	SdCombo(scr, "code",  0,  1, 19, 12, 10, "", "univ^`><desc><`_code^", 133, 
										   "`><Desc><`SearchCode", 62, , 134);
	SdFieldCols(scr, "code", 10);
	SdPrompt(scr, 3,  1, "`><nameAbrv><` Name  :");
	SdString(scr, "desc", 0,  3, 19, 50);

	SdButton(scr, "ok",   0, 16, 29, 10, "Maint", "m", 1);
	SdButton(scr, "del",  0, 16, 42, 10, "Delete", "d", 114);
	SdButton(scr, "can",  1, 16, 55, 10, "Cancel", "", 2);
	return scr;
}`);
}
Define DescDelete(Desc, desc)
/*
    This will generate the code that deletes one of the descriptions
*/
{
    Print(`
Define `><Desc><`Delete(code) {
	while(field = NextField("univ", "`><desc><`", code, field))
		univ^`><desc><`^[code]^[field] = "";
	univ^`><desc><`_code^[code] = "";
}`);
}
Define DescMaint(Desc, desc, nameLong)
/*
    This will generate the code that maintains a description
*/
{
    Print(`
Define `><Desc><`Maint() {
	scr = `><Desc><`MaintScr();
	mode = 1;
	cursor = "";
	while (1) {
	    if (!cursor) {
			if (mode) {
				SdModeSet(scr, 0);
				SdModeSet(scr, 1, "code", "del", "can");
				SdButton(scr, "ok",   1, 16, 29, 10, "Maint", "m", 1);
			}
			else {
				SdModeSet(scr, 1);
				SdModeSet(scr, 0, "code", "del");
				if (univ^`><desc><`_code^[code])
					SdButton(scr, "ok",   1, 16, 29, 10, "Modify", "m", 1);
				else
					SdButton(scr, "ok",   1, 16, 29, 10, "Add", "a", 1);
			}
			SdFieldVar(scr, "code", 	code,
							"desc",		&univ^`><desc><`_code^[code]);
		}
		cmd = SdEdit(scr, cursor);
		if (mode) {
			Explode(SdFieldGet(scr, "code"), "^", &code);
			if (cmd == 133)				/* action on the combo box */
				continue;
			else if (cmd == 2 || cmd == 3)
				break;
			else if (cmd != 1 && cmd != 134) {
				if (!univ^`><desc><`_code^[code]) {
					MsgWait("", "`><nameLong><` Code does not exist.");
					continue;
				}
				if (cmd == 114) {		/* delete */
					if ((cmd = MsgYesNoCancel("", "Delete " . code . ", are you sure ?")) && cmd == 2) {		/* yes hit ? */
						`><Desc><`Delete(code);
					}
				}
				continue;
			}
			mode = 0;					/* means change details */
		}
		else {
			if (cmd == 1) {
				if (!SdFieldGet(scr, "desc")) {
					MsgWait("", "`><nameLong><` Name must be entered.");
					cursor = "desc";
					continue;
				}
				SdUpdate(scr);
			}
			else if (cmd == 3) 
				break;
			mode = 1;					/* means do next selection */
		}
		cursor = "";
	}
	SdDestroy(scr);
}`);
}
Define DescGenerate(Desc, desc, nameLong, nameAbrv)
{
    DescSearchCode(Desc, desc);
    DescMaintScr(Desc, desc, nameLong, nameAbrv);
    DescDelete(Desc, desc);
    DescMaint(Desc, desc, nameLong);
}
Eval {
/*
    When this is evaluated, the code for the Property Type Maintenance
    program, and the Valuation Type Maintenance program is output
    using the macros that we have just defined.
*/
    DescGenerate("Ptyp", "ptyp", "Property Type", "Prop Type");
    DescGenerate("Vtyp", "vtyp", "Valuation Type", "Valn Type");
}
