Define MtceSelFmt(key) {
    if (suf = parm^mtce^suf) {
        if (!StrMatch(suf, key)) {
            return "";
        }
    }
    return key;
}
Define MtceScrCreate()
{
    showVal = parm^mtce^showVal;
    width = parm^mtce^width;
    table = glob^mtce^table;
    selHt = parm^mtce^selHt;
    valHt = parm^mtce^valHt;

    if (selHt < 5)          selHt = 5;
    else if (selHt > 16)    selHt = 16;

    if (valHt < 5)          valHt = 5;
    else if (valHt > 16)    valHt = 16;

    if (width < 42)         width = 42;
    else if (width > 78)    width = 78;

    title = "Table Maintenance - " . table;
    if (match = parm^mtce^match)
        title .= ", match " . match;

    scr = SdCreate(, -1, -1, 1 + selHt + (showVal ? valHt : 0), width, title);

    SdSelect(scr, "sel",  1, 0, 1, width - 2, selHt, ,
                    table . "^" . match, 131,
                    , 130, showVal ? 131 : "");

    row = selHt;
    if (showVal) {
        SdMultiLine(scr, "val", 0, row, 1, width - 2, valHt, , 2048, "Literal");
        code = MtceSelCode(scr);
        SdFieldSet(scr, "val", [table]^[parm^mtce^pre][code]);
        row += valHt;
    }

    btnLen = (width - 2) / 4;
    col = 1;
    SdButton(scr, "mod",   1, row, col, btnLen, "Modify",  "m", 122);
    col += btnLen;
    SdButton(scr, "add",   1, row, col, btnLen, "Add",     "a", 123);
    col += btnLen;
    SdButton(scr, "del",   1, row, col, btnLen, "Delete",  "d", 124);
    col += btnLen;
    SdButton(scr, "opt",   1, row, col, btnLen, "Options", "o", 120);
    return scr;
}
Define MtceSelCode(scr)
{
    return SdFieldGet(scr, "sel");
}
Define MtceSelFieldSet(scr, code)
{
    SdFieldSet(scr, "sel", code);
    if (parm^mtce^showVal)
        SdFieldSet(scr, "val", [glob^mtce^table]^[parm^mtce^pre][code]);
}
Define MtceSelNext(code)
{
    if (nxt = next([glob^mtce^table]^[parm^mtce^pre][code]))
        return nxt;
    return prev([glob^mtce^table]^[parm^mtce^pre][code]);
}
Define Mtce(table)
{
    if (!table)
        table = "univ";
    glob^mtce^table = table;

    scr = MtceScrCreate();


    while (action != 2 && action != 3) {
        switch(action = SdEdit(scr)) {
        case 120:                       // pressed options button
            code = MtceSelCode(scr);
            if (MtceOpt() == 1) {
                SdDestroy(scr);
                scr = MtceScrCreate();
                MtceSelFieldSet(scr, code);
            }
            break;

        case 130:                       // double click select box
        case 122:                       // pressed modify button
            if (MtceMod(code = MtceSelCode(scr)) == 1)
                MtceSelFieldSet(scr, code);
            break;

        case 131:                       // moved to or selected in select box
            code = MtceSelCode(scr);
            SdFieldSet(scr, "val", [glob^mtce^table]^[parm^mtce^pre][code]);
            break;

        case 123:                       // pressed add button
            if (MtceAdd(&code) == 1)
                MtceSelFieldSet(scr, code);
            break;

        case 124:                       // pressed delete button
            code = MtceSelCode(scr);
            if (MsgYesNo("", 
                         "Delete ". code. ", are you sure ?") == 1) {
                nextCode = MtceSelNext(code);
                [glob^mtce^table]^[parm^mtce^pre][code] = "";
                MtceSelFieldSet(scr, nextCode);
            }
            break;
        }
    }
    SdDestroy(scr);    
}
Define MtceOptWidthValn(scr, value, name) {
    if (!value)             /* may be blank */
        return "";
    if (value < 42 || value > 78) {
        MsgWait("", "Width must be between 42 and 78 inclusive");
        return 1;
    }
}
Define MtceOptSelHtValn(scr, value, name) {
    if (!value)             /* may be blank */
        return "";
    if (value < 5 || value > 16) {
        MsgWait("", "Select height must be between 5 and 16 inclusive");
        return 1;
    }
    if (value + SdFieldGet(scr, "valht") > 20) {
        MsgWait("", "Sum of select and value height must less than 21");
        return 1;

    }
}
Define MtceOptValHtValn(scr, value, name) {
    if (!value)             /* may be blank */
        return "";
    if (value < 5 || value > 16) {
        MsgWait("", "Value height must be between 5 and 16 inclusive");
        return 1;
    }
    if (value + SdFieldGet(scr, "selht") > 20) {
        MsgWait("", "Sum of select and value height must less than 21");
        return 1;

    }
}
Define MtceOpt()
{
    scr = SdCreate("", -2, -2, 10, 60, "Options");
    SdPrompt(scr, 1,  1, "Match Pattern:");
    SdString(scr, "mch",    1, 1, 16, 32, &parm^mtce^match, 128, "Caret");

    SdPrompt(scr, 2,  1, "Screen Width:");
    SdInt   (scr, "wid",    1, 2, 16, 3, &parm^mtce^width, "MtceOptWidthValn");
    SdPrompt(scr, 3,  1, "Select Height:");
    SdInt   (scr, "selht",  1, 3, 16, 3, &parm^mtce^selHt, "MtceOptSelHtValn");
    SdPrompt(scr, 4,  1, "Value Height:");
    SdInt   (scr, "valht",  1, 4, 16, 3, &parm^mtce^valHt, "MtceOptValHtValn");

    SdCheck (scr, "c0",   1, 6, 1, 32, &parm^mtce^showVal, 
                            "Show value with select", "s");
    SdButton(scr, "ok",   1, 8, 15, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 8, 30, 10, "Cancel", "", 2);
    if ((action = SdEdit(scr)) == 1) {
        SdUpdate(scr);
        StrPatternParts(parm^mtce^match, &parm^mtce^pre, &parm^mtce^suf);
    }
    SdDestroy(scr);    
    return action;
}
Define MtceModScrCreate(title)
{
    scr = SdCreate(, -1, -1, 14, 72, title . " - " . glob^mtce^table . "^"
                                           . parm^mtce^pre);

    SdPrompt(scr, 1,  1, "Name:");
    SdString(scr, "code",  0,  1, 7, 64, , 128, "Caret");
    SdPrompt(scr, 2,  1, "Value(literal):");
    SdMultiLine(scr, "val", 1, 3, 1, 70, 8, "", 2048, "Caret, Literal");

    SdButton(scr, "ok",   1, 12, 21, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 12, 36, 10, "Cancel", "", 2);
    return scr;
}
Define MtceMod(code)
{
    scr = MtceModScrCreate("Modify Symbol");
    SdModeSet(scr, 0, "code");
    SdFieldVar(scr, "code", code);
    SdFieldVar(scr, "val", &[glob^mtce^table]^[parm^mtce^pre][code]);
    if ((action = SdEdit(scr)) == 1) {
        SdUpdate(scr);
    }
    SdDestroy(scr);    
    return action;
}
Define MtceAdd(code)
{
    scr = MtceModScrCreate("Add Symbol");
    SdModeSet(scr, 1, "code");
    while ((action = SdEdit(scr)) == 1) {
        code = SdFieldGet(scr, "code");
        if (!code) {
            MsgWait( , "Symbol Name must be specified");
            continue;
        }
        if ([glob^mtce^table]^[parm^mtce^pre][code]) {
            MsgWait( , "Symbol Name already exists");
            continue;
        }
        SdFieldVarChg(scr, "val", &[glob^mtce^table]^[parm^mtce^pre][code]);
        SdUpdate(scr);
        break;
    }
    SdDestroy(scr);    
    return action;
}
If(0)
0----+----1----+----2----+----3----+----4----+----5---
                                                        0
  [ ] univ     [ ] mdat     [ ] parm     [ ] data       1
                                                        2
  Data Filename: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx    3
                                                        4
             [   OK   ]       [ Cancel ]                5
                                                        6

Endif
Define MtceTableSelect(title, table, tableName)
{
    glob^table^letter^["univ"] = "u";
    glob^table^letter^["mdat"] = "m";
    glob^table^letter^["parm"] = "p";
    glob^table^letter^["data"] = "d";

    glob^table^name^["u"] = "univ";
    glob^table^name^["m"] = "mdat";
    glob^table^name^["p"] = "parm";
    glob^table^name^["d"] = "data";

    if (!(tableLetter = glob^table^letter^[table]))
        tableLetter = "u";

    scr = SdCreate(, -1, -1, 7, 54, title);
    SdRadio (scr, "rad", 1, 1, 2, 12, &tableLetter, "Univ", "u", 131);
    SdRadio (scr, "", 1, 1, 15, 12, &tableLetter, "Mdat", "m", 131);
    SdRadio (scr, "", 1, 1, 28, 12, &tableLetter, "Parm", "p", 131);
    SdRadio (scr, "", 1, 1, 41, 12, &tableLetter, "Data", "d", 132);
    SdPrompt(scr, 3, 2, "Data Filename:");
    SdString(scr, "inf",  tableLetter == "d",  3, 17, 33, &tableName, 64);

    SdButton(scr, "", 1,    5, 13, 10, "OK",     "", 1);
    SdButton(scr, "", 1,    5, 30, 10, "Cancel", "", 2);

    do {
        cmd = SdEdit(scr, cursor);

        switch (cmd) {
        case 1:
            SdUpdate(scr);
            if (!tableLetter) {
                MsgWait(title, "Must choose source Symbol Table");
                cursor = "sym";
                continue;
            }
            else if (tableLetter == "d") {
                if (!tableName) {
                    MsgWait(title, "For Data, must specify a Data Filename");
                    cursor = "inf";
                    continue;
                }
                if (SymOpen("data", tableName)) {
                    MsgWait(title, "Could not open Data Filename");
                    cursor = "inf";
                    continue;
                }
            }
            table = glob^table^name^[tableLetter];

        case 2:
        case 3:
            end = "y";
            break;

        case 131:
            SdModeSet(scr, 0, "inf");
            cursor = "rad";
            continue;

        case 132:
            SdModeSet(scr, 1, cursor = "inf");
            continue;
        }
    } while (!end);

    SdDestroy(scr);
    return cmd;
}
Define MtceSelect()
{
    while (MtceTableSelect("Select Table to Maintain", 
                           &table, &tableName) == 1) {
        if (table == "data")
            doneData = "y";
        Mtce(table);
    }
    if (doneData)
        Signal("");                     // to restart system
}
