
//***************************************************************************
//
// Class:					CFileSystem
//
// Purpose:				To encapsulate access to the file system.
//
// Copyright:			Copyright 1993, 1994, 1995 Scott P. Leslie
//								All Rights Reserved.
//
// Version:				Version 1.4NT for MS Windows NT 3.5 and MSVC 2.x.
//
// Important:			Read the README.WRI file included with this distribution
//								before using this class.
//
// Shareware:			This class is ShareWare.  If you use it, you should register
//								it with the author.  If you do not register it after 14 days
//								of use, you must discontinue using it.
//
//								Contact the author at sleslie@webcom.com for more info.
//
// Distribution:	You may not distribute the source code for this class.
//								Object code generated from this class (or any derivation of
//								this class) can only be distributed by registered users.
//
// Disclaimer:		This class is provided as is with no implied or express
//								warranties.  You should test this class for your particular
//								use on non-critical data before using it in a production
//								system.
//
//***************************************************************************

#ifndef _CFileSystem_h_
#define _CFileSystem_h_

#include <direct.h>
// winbase.h defines this to be (0x100000L) for some reason.
#ifdef GetFreeSpace
#undef GetFreeSpace
#endif

#include "stdafx.h"


//***************************************************************************
// Definitions
//***************************************************************************
#define DRIVE_UNDETERMINED 0


class CFileSystem : public CObject
{
public:
	CFileSystem();				// Constructor
	~CFileSystem();				// Destructor

	// File/Directory Attributes

	enum Attribute {
		normal		= FILE_ATTRIBUTE_NORMAL,	// Normal Files (Win32 API version 0x80)
		readOnly	= CFile::readOnly,		// Read-Only Files
		hidden		= CFile::hidden,			// Hidden Files
		system		= CFile::system,			// System Files
		volume		= CFile::volume,			// Volume Label
		directory	= CFile::directory,		// Subdirectory Entry
		archive		= CFile::archive,			// Archive File

		allfiles	= CFileSystem::normal		|		// All "files"
								CFileSystem::readOnly	|		// Used to determine "size" of directory.
								CFileSystem::hidden		|
								CFileSystem::system		|
								CFileSystem::archive,
	}; // Attribute


	// Directory Functions

	CString				GetCurrentDirectory(const CString& FileSystem = "");
	BOOL					ChangeDirectory(const CString& NewDirectory);
	BOOL					RenameDirectory(const CString& OldName, const CString& NewName);
	BOOL					MakeDirectory(const CString& NewDirectory);
	BOOL					MakePath(const CString& NewDirectory);
	BOOL					DeleteDirectory(const CString& Directory, const BOOL bDeleteFilesAndDirs = FALSE);

	LONG					GetDirectorySize(const CString& Directory = "", const CString& WildCard = "*.*", const BOOL bRecurseSubdirs = FALSE);

	// FileSystem Functions

	CString				GetCurrentFileSystem();
	BOOL					ChangeFileSystem(const CString& FileSystem);
	CStringList *	GetFileSystemList();
	CString				GetVolumeLabel(const CString& FileSystem);
	LONG					GetFileSystemType(const CString& FileSystem);
	BOOL					IsReadOnlyFileSystem(const CString& FileSystem);
	LONG					GetFreeSpace(const CString& FileSystem);
	LONG					GetTotalSpace(const CString& FileSystem);

	// File Functions

	BOOL					GetFileStatus(const CString& FileName, CFileStatus& FileStatus);
	BOOL					GetFileCreateTime(const CString& FileName, CTime& time);
	BOOL					GetFileModifyTime(const CString& FileName, CTime& time);
	BOOL					GetFileAccessTime(const CString& FileName, CTime& time);
	BOOL					GetFileSize(const CString& FileName, unsigned long& lSize);
	BOOL					GetFileAttribute(const CString& FileName, BYTE& Attribute);

	BOOL					RenameFile(const CString& OldFileName, const CString& NewFileName);
	BOOL					DeleteFile(const CString& FileName);
	BOOL					DeleteFiles(const CString& FileSpec, const unsigned long eFileAttrib = normal);

	BOOL					CopyFile(const CString& SourceFileName, const CString& DestFileName, const unsigned long lBuffSize = 10240);
	BOOL					CopyFiles(const CString& FileSpec, const CString& DestPath, const BOOL bIgnoreErrors = FALSE, const unsigned long eFileAttrib = normal);

	// Comparison Functions

	BOOL					CompareFiles(const CString& FileName1, const CString& FileName2, const unsigned long lBuffSize = 10240);
	BOOL					CompareDirectories(const CString& PathName1, const CString& PathName2, const BOOL bRecurseSubdirs = FALSE, const BOOL bCompareFileContents = FALSE, const unsigned long eFileAttrib = normal);

	// Existance Functions
	
	BOOL					FileExists(const CString& PathAndFileName);
	BOOL					FileSystemExists(const CString& FileSystemName);
	BOOL					DirectoryExists(const CString& Path);

	// File/Path Name Functions

	CString				GetFullPathName(const CString& PathAndFileName);
	CString				GetFileName(const CString& PathAndFileName);
	CString				GetPath(const CString& PathAndFileName, const BOOL bIncludeFileSystem = TRUE);
	CString				GetExtension(const CString& PathAndFileName);
	CString				GetFileSystem(const CString& PathAndFileName);
	CString				GetBaseFileName(const CString& PathAndFileName);

	CString				AppendWildcard(const CString& Path, const CString& Wildcard);

	// Directory Listing Functions

	CStringList	*	GetDirectory(const CString& SearchString, const unsigned long eFileAttrib, const BOOL bRecurseSubDirs=FALSE, CStringList *pStringList = NULL);

	CStringList *	GetSubdirList(const CString& SearchDir, const BOOL bPathInName = TRUE);
	CStringList *	GetFileList(const CString& SearchString, const unsigned long eFileAttrib);

	CString *			GetDirectoryEntry(const CString& Wildcard = "", const unsigned long eFileAttrib = normal);


	// MFC CStringList Functions

	static void		Sort(CStringList *pStringList);

	// MFC GUI Functions

	static void		LoadListBox(CListBox *pListBox, const CStringList * pStringList);
	static void		LoadComboBox(CComboBox *pComboBox, const CStringList * pStringList);


protected:
	BOOL					ChangeFileSystem(const char cFileSystem);
	BOOL					CloseFile(CFile *pFile) const;

	int						MaxFileNameLength;


protected:
	BOOL					GetADirectoryEntry(CString &fileName, const CString& Wildcard = "", const unsigned long eFileAttrib = normal);

private:
	WIN32_FIND_DATA	m_FileInfo;
	HANDLE					m_hFind;

}; // CFileSystem

#endif // _CFileSystem_h_

