/*
   DataBase ++ 2.02.

   The following example creates a database and fills it with 10 records.
   It creates two index tag and then seeks a name in the file. It reports
   what record it was found at along with some file inormation.
   
   Borland compile ( c4fox.lib == your codebase lib for FoxPro files ):

      bcc -ml -DS4FOX example3 dbpp202.lib c4fox.lib emu.lib mathl.lib cl.lib
*/

#include "dbppdata.h"             // DataBase++
#include <iostream.h>

#define MAX_NAMES    30
#define FNAME        "people.dbf"

void main()
{
   int i;
   
   // Create the DBDatabase object with the file name.
   DBDatabase db( FNAME );

   // Create a DBStructure object and add fields to it.
   DBStructure dbs;
   dbs.addField( "name", 'C', 20 );
   dbs.addField( "age", 'N', 3 );

   // Create a DBIndexTag object and fill it with tag info.
   DBIndexTag idx;
   idx.addTag( "people", "name" );
   idx.addTag( "age", "age" );

   // Create the database and open it.
   if ( ! db.create( dbs, idx ) )
   {
      cout << "Error creating file\n";
      exit( 1 );
   }
   
   // Create some names.
   char *names[ MAX_NAMES ] = {
      "Jeff", "Wendy", "Kyle", "Nicole", "Scott",
      "Andy", "Dave", "Bruce", "Done", "Henry"
   };

   // Open index files.  Only needed if NOT using FoxPro .CDX files.
//   db.openIndex( "people.ndx" );
//   db.openIndex( "age.ndx" );
   
   // Add some records.
   for ( i = 0; i < MAX_NAMES; i++ )
   {
      // Append a blank record.
      db.append();

      // Replace a field with a string.
      db.replace( "name", names[ i ] );

      // Replace a field with an int.
      db.replace( "age", i * 10 );
   }

   // Display some info.
   cout << "Data File Name:  " << db.fileName() << endl;
   cout << "Records in File: " << db.reccount() << endl;
   cout << "Current Record:  " << db.recno() << endl;
   cout << "Current Index:   " << db.indexTag() << endl;

   cout << endl;

   // Set the current index.
   db.setIndexTag( "people" );
   
   // Seek a name.
   cout << "Performing seek()\n";
   if ( db.seek( "Nicole" ) )
      cout << "Nicole found at record " << db.recno() << endl;
   else
      cout << "Nicole not found.\n";

   // Seek on an age. Even though the age field is numeric, we can seek
   // by using a string.
   db.setIndexTag( "age" );
   if ( db.seek( "70" ) )
      cout << "Age 70 found at record " << db.recno() << " and belongs to "
           << db.getString( "name" ) << endl;
   else
      cout << "Age 70 not found." << endl;
   
   // Close file.
   db.close();
}

