/*
   Library: DataBase++ Ver. 2.02.
   File:    DBPPSTRU.HPP
   Purpose: Declarations for class DBStructure. Code in dbppstru.cpp
   Notice:  Copyright (C), 1992 - 1995, Jeff Stapleton. All rights reserved.
*/

#ifndef __DBPPSTRU_H
#define __DBPPSTRU_H

#include "dbppobjt.h"  
#include "dbpparay.h"    // DBArray class.

const int nameSize = 20;

/* struct to hold a field definition.
*/
struct DBField : public DBObject 
{
   char name[nameSize];
   char type;
   int  len;
   int  dec;
};

/* DataBase structure class.
*/
class DBStructure : public DBObject 
{
   public:

      /* Constructor/destructor.
      */
      DLLAPI DBStructure() : fields( 30, 5 ) {}    // Constructor.
      virtual DLLAPI ~DBStructure() {}             // Destructor.

      /* Methods/operators.                                                   
      */
      VOID      DLLAPI   addField( char *fldName, char type, int len, int dec = 0 ); // Add a field definition.   
      int       DLLAPI   numFields() { return fields.itemsInArray(); }               // Return number fields in this.
      DBField * DLLAPI   operator [] ( int idx );                                    // Access to an individual DBField struct.
      DBArray & DLLAPI   fieldArray() { return fields; }                             // Return the fields array.
      
   private:

      DBArray fields;
};

#endif   // __DBPPSTRU_H


