/*
   Library: DataBase++ Ver. 2.02.
   File:    DBPPDATA.HPP
   Purpose: Declarations for class DBDatabase. Code in DBPPDATA.cpp
   Notice:  Copyright (C), 1992 - 1995, Jeff Stapleton. All rights reserved.
*/

/* Declaratons for the DBDatabase class.
*/

#ifndef __DBPPDATA_H
#define __DBPPDATA_H

#include "dbppobjt.h"    // DBObject class.
#include "dbppstru.h"    // DBStructure class.
#include "dbppindx.h"    // DBIndex class.
#include "dbpparay.h"    // DBArray class.
#include <stdio.h>

extern "C" {
#include <d4all.h>         // CodeBase
}

class DBDatabase;

typedef BOOL ( * FilterFunc ) ( DBDatabase &dbf );      // Filter function pointer.

/* DBDatabase class using the CodeBase 5.0 library.
*/
class DBDatabase : public DBObject
{
   public:

      /* Constructors and Destructor.
      */
      DLLAPI DBDatabase();                                        // Make a new DBDatabase.
      DLLAPI DBDatabase( char * fName );                          // Make a new DBDatabase, with it's file name.
      virtual DLLAPI ~DBDatabase();                               // Destroy it.
      
      /* Class methods.
      */
      static CODE4 * DLLAPI  CodeBase() { return &codeBase; }   // Return a pointer to the CODE4 struct.
      static char *  DLLAPI  GetCentury() { return century; }   // Return the century.
      static int     DLLAPI  Instances() { return instances; }  // Number of instances of self.
      static VOID    DLLAPI  Initialize();
      static VOID    DLLAPI  Shutdown();
      static int     DLLAPI  OpenFiles() { return openFiles; }  // Number of open files.
      static VOID    DLLAPI  SetCentury( char *aCentury ) { strcpy( century, aCentury ); }      // Set century.
      static VOID    DLLAPI  SetMultiUser( BOOL state );        // set multi user.
      static BOOL    DLLAPI  SetSafety( BOOL flag );            // Set safety.
      static VOID    DLLAPI  CloseAll();                        // Close all open files.

      /* Instance methods.
      */
      BOOL    DLLAPI     append();                                 // Append a blank record.
      BOOL    DLLAPI     appendBlank() { return append(); }        // Append a blank record.
      BOOL    DLLAPI     bof() { return d4bof( Data4 ); }         // TRUE if bof.
      BOOL    DLLAPI     close();                                  // Close the opened file.
      BOOL    DLLAPI     create( DBStructure& dbs );                 // Create a database.
      BOOL    DLLAPI     create( DBStructure& dbs, DBIndexTag& idx );  // Create a database and index.
      BOOL    DLLAPI     createIndex( DBIndexTag& idx );             // Create an index file.
      VOID    DLLAPI     deleteRec() { d4delete( Data4 ); }       // Delete a record.
      BOOL    DLLAPI     deleted() { return d4deleted( Data4 ); } // Return's TRUE if deleted.
      BOOL    DLLAPI     eof() { return d4eof( Data4 ); }         // TRUE if eof.
      int     DLLAPI     fieldNum( char *fldName ) { return( d4field_number( Data4, fldName ) ); }                // Return position of the field fldName.
      int     DLLAPI     fieldType( char *fldName );               // Return the field type.
      BOOL    DLLAPI     fileLock() { return( ( d4lock_file( Data4 ) ) == 0 ); }                              // Lock file. Return's 1 if successful.
      char *  DLLAPI     fileName() { return FileName; }           // Return the file name.
      DATA4 * DLLAPI     getDATA4() const { return Data4; }      // Return pointer to Data4.
      char *  DLLAPI     getDate( char *fldName );                 // Return a date field.
      double  DLLAPI     getDouble( char *fldName );               // Return a double field.
      int     DLLAPI     getInt( char *fldName );                  // Return an int.
      int     DLLAPI     getLogical( char *fldName );              // Return TRUE if true. 
      long    DLLAPI     getLong( char *fldName );                 // Return a long field.
      char *  DLLAPI     getMemo( char *fldName );                 // Return a memo.
      char *  DLLAPI     getString( char *fldName );               // Return a string field.
      VOID    DLLAPI     go( long nRecno );                        // Go to a record number.
      VOID    DLLAPI     goBottom();                               // Go to eof.
      VOID    DLLAPI     goTop();                                  // Go to bof.
      char *  DLLAPI     indexTag();                               // Return's name of current index tag.
      BOOL    DLLAPI     isOpen() { return openState; }            // TRUE if open.
      VOID    DLLAPI     memoPack();                               // Pack the memo file.
      int     DLLAPI     numFields() { return( d4num_fields( Data4 ) ); }                              // Return's number of fields in DBDatabase.
      BOOL    DLLAPI     open();                                   // Open the file.
      #if !defined( S4FOX ) && !defined( INDEX_GROUPS )
      BOOL    DLLAPI     openIndex( char * indexFile );            // Open an index file.
      #endif
      VOID    DLLAPI     pack( int mPack = 0 );                    // Pack the file. If mPack is TRUE, the associated memo file is also packed.
      long    DLLAPI     reccount() { return d4reccount( Data4 ); }                               // Return number of records.
      VOID    DLLAPI     recall() { d4recall( Data4 ); }          // Recall a deleted record.
      VOID    DLLAPI     reindex();                                // Reindex the file.
      BOOL    DLLAPI     recLock() { return( ( d4lock( Data4, recno() ) ) == 0 ); }                                // Lock current record. Return's 1 if successful.
      long    DLLAPI     recno() { return d4recno( Data4 ); }                                  // Return record number.
      VOID    DLLAPI     replace( char *fldName, char *str );      // Character, memo and date.
      VOID    DLLAPI     replace( char *fldName, double d );       // double
      VOID    DLLAPI     replace( char *fldName, int i );          // int's and logical
      VOID    DLLAPI     replace( char *fldName, long l );         // long.
      int     DLLAPI     seek( char *seekExpr );                   // Seek an index for seekExpr.
      VOID    DLLAPI     setFileName( char * fName );              // Set the FileName.
      VOID    DLLAPI     setFilter( FilterFunc ff ) { pFilterFunc = ff; }   // Set a filter function.
      BOOL    DLLAPI     setIndexTag( char *aTagName = NULL );     // Select an index tag.
      VOID    DLLAPI     skip( int nRecs = 1 );                    // Skip record(s) nRecs.
      VOID    DLLAPI     unlock() { d4unlock( Data4 ); }             // Release all locks.
      int     DLLAPI     unlockIndex();                            // Unlock current index if any.
      VOID    DLLAPI     zap( int mPack = 0 );                     // Zap the file. If mPack is TRUE, the associated memo file is also packed.
       
   private:

      /* Class variables.
      */
      static CODE4   codeBase;                              // Code Base struct.
      static int     openFiles;                             // Number of open files.
      static int     instances;                             // Number of DBDatabase objects.
      static char    century[ 3 ];                          // Hold's century chars.
      static BOOL    safety;                                // FALSE if create overwrites, TRUE if warning. Set to FALSE.
      static BOOL    multiUser;                             // TRUE if multi user, otherwise FALSE;
         
      /* Instance vars.                                     
      */                                                    
      char        FileName [ 80 ];                          // Name of the file.
      DATA4 *     Data4;                                    // Pointer to data structure.
      BOOL        openState;                                // TRUE if open; FALSE if closed.
      FilterFunc  pFilterFunc;                              // Pointer to a user supplied filter function.
         
      /* Private methods                                    
      */                                                    
      VOID        init();                                   // Initialize this.
      VOID        removeFromArray();                        // Remove this from array.
};

#endif // _DBPPDATA_H
