
/*		TAB.C
 * Program to display a file assuming tab stops are at 3 character
 * Intervals. By redirecting the output from this program to a file,
 *	it may be printed using the DOS print command.
 *
 */

#include	<stdio.h>
#include	<dos.h>

#define	TAB_SIZE	3			/* tab spacing */
/*#define	FF*/						/* insert form feeds */

FILE	*fp;
char	bfr[256];

main(int argc, char *argv[])
{
	int	i, j, chr, lines;

	if(argc < 2)
	{
		printf("\nUsage: tab <filename> [>file.out]\n");
		exit(1);
	}
	lines = 0;
	if (fp = fopen(argv[1], "r"))
	{
		j = 0;
		while (fgets(bfr, 255, fp))
		{
			for (i=0; bfr[i]; i++)
			{
				chr = bfr[i];
				if(chr == '\t')						/* tab */
				{
					do
						putchar(' ');
					while(++j % TAB_SIZE);
				}
				else										/* not a tab */
				{
					j = (chr != '\n') ? j+1 : 0;
					if (j < 78)
						putchar(chr);
				}
			}
			lines++;

#ifdef	FF
			if (lines > 59)
			{
				putchar(0x0c);							/* form feed to next page */
				lines = 0;
			}
#endif

		}
	}
	else
	{
		printf("Can't open '%s'\n", argv[1]);
		exit(1);
	}
	fclose(fp);
}

/* end of tab.c */

