{***************************************************************************}
unit Algerr;

interface

Uses SysUtils;

Const
	ErrEmptyXpr			= 1;
	ErrNoText			= 2;
	ErrBadChar			= 3;
	ErrNoVarTable		= 4;
	ErrOperator			= 5;
	ErrLParen			= 6;
	ErrRParen			= 7;
	ErrFuncParen		= 8;
	ErrFuncParms		= 9;
	ErrSyntax			= 10;
	ErrToken				= 11;
	ErrParmCount		= 12;
	ErrETX				= 13;
	ErrAssign			= 14;
	ErrVarTbl			= 15;
	ErrString			= 16;
	ErrNoFunc			= 17;
	ErrUnknownOprnd	= 18;
	ErrInvalidOprnd	= 19;
	ErrUnknownOprtn	= 20;
	ErrNoParms			= 21;
	ErrParmMatch		= 22;
	ErrNoSuchVar		= 23;

	MaxAlgErrNmbr		= 23;

Type

{***************************************************************************}
EAlgXpr = class(Exception);

Procedure AlgXprErr(ErrNmbr: Integer);
Procedure SetAlgErrBase(Err0: Integer);
Function  GetAlgErrBase: Integer;

{***************************************************************************}
{***************************************************************************}
implementation

Var	AlgErrBase: Integer;

{***************************************************************************}
Procedure AlgXprErr(ErrNmbr: Integer);
Begin
	If (ErrNmbr < 1) or (ErrNmbr > MaxAlgErrNmbr)
		Then raise EAlgXpr.CreateRes(AlgErrBase)
		Else raise EAlgXpr.CreateRes(AlgErrBase+ErrNmbr)
End;

{***************************************************************************}
Procedure SetAlgErrBase(Err0: Integer);
Begin
	AlgErrBase := Err0;
End;

{***************************************************************************}
Function  GetAlgErrBase: Integer;
Begin
	Result := AlgErrBase
End;

{***************************************************************************}
Initialization
	AlgErrBase := 3000;
End.

