VERSION 2.00
Begin Form frmREQFIL 
   AutoRedraw      =   -1  'True
   Caption         =   "ReqFil Server"
   ClientHeight    =   0
   ClientLeft      =   2580
   ClientTop       =   2745
   ClientWidth     =   2070
   ControlBox      =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   12
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   435
   Left            =   2505
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   0
   ScaleWidth      =   2070
   Top             =   2385
   Width           =   2220
   Begin Timer Timer1 
      Enabled         =   0   'False
      Left            =   420
      Top             =   0
   End
End
Option Explicit
Const GET_PATH = 0
Const GET_FULLFILENAME = 1
Const GET_FILENAME = 2
Const GET_FILEEXT = 3
Const MAX_SIZE = 4500&

Declare Function GetPrivateProfileString Lib "Kernel" (ByVal section As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Function CalcParts (fname As String, sizes() As Integer) As Integer
'aim for parts of even size, but no larger than MAX_SIZE chars.
Dim fl As Long
Dim parts As Integer
Dim s As Integer
Dim i As Integer

fl = FileLen(fname)
parts = (fl + MAX_SIZE - 1) \ MAX_SIZE  'not integer division - '\'
s = fl / parts

For i = 1 To parts
    ReDim Preserve sizes(i)
    If i <> parts Then
        sizes(i) = s
    Else
        'a silly big one at the end - just to make sure it all
        'gets sent!
        sizes(i) = MAX_SIZE + 500
    End If
Next i

CalcParts = parts

End Function

Function ExtractArg (a As String) As String
'Extract the next argument from a command$.
'NB, in worst VB style, the callers 'a' is altered by this function.
Dim i As Integer

If a = "" Then Exit Function

i = InStr(a, " ")
If i = 0 Then
    ExtractArg = a
    a = ""
Else
    ExtractArg = Left(a, i - 1)
    a = Mid(a, i + 1)
End If

End Function

Sub Form_Activate ()
'Static in_here As Integer

'If in_here = True Then Exit Sub
'in_here = True

'ServerAction
'Unload Me

End Sub

Sub Form_Load ()

Move 0, screen.Height - Height
Show
DoEvents

'You don't have to use a timer to call ServerAction. However you can't do it
'from within Form_Load because when the function exits you need to
'"Unload me" which you can't do from here.
'An alternative is to do it from the Activate event - sample code is in
'there but commented out. If you use that then remove the timer. I prefer to
'use the timer so that the form does at least appear on the screen for long
'enough to see it!
'Another alternative is to put all the code from the (general) section of
'this form into a code module, and add a Main() function with two statements:
'
'ServerAction
'End
'
'You can then completely get rid of the form.
'The choice is yours!
'
timer1.Interval = 500
timer1.Enabled = True

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

End

End Sub

Function Get_Ini_String (section As String, KeyName As String, KeyDefault As String, Filename As String)
Dim x As Integer
Dim tmp As String

tmp = Space$(100)

x = GetPrivateProfileString(section, KeyName, KeyDefault, tmp, Len(tmp), Filename)
Get_Ini_String = Left$(tmp, x)

End Function

Function GetPathBits (ByVal TempPath As String, action As Integer) As String
'Hacked out of Microsoft Knowledge Base Article ID: Q113897.
'The programming style is that of the author!
'I simply added the ability to return different parts of the path according
'to the action argument.
Dim DriveLetter As String
Dim DirPath As String
Dim Filename As String
Dim Extension As String
Dim PathLength As Integer
Dim OffSet As Integer
Dim ThisLength As Integer
Dim FileNameFound As Integer

If Mid(TempPath$, 2, 1) = ":" Then     ' Find the drive letter.
    DriveLetter = Left(TempPath$, 2)
    TempPath$ = Mid(TempPath$, 3)
End If

PathLength% = Len(TempPath$)
For OffSet% = PathLength% To 1 Step -1  ' Find the next delimiter.
    Select Case Mid(TempPath$, OffSet%, 1)

    Case ".": ' This indicates either an extension or a . or a ..
    ThisLength% = Len(TempPath$) - OffSet%

    If ThisLength% >= 1 And ThisLength% <= 3 Then ' Extension
        Extension = Mid$(TempPath$, OffSet%, ThisLength% + 1)
    End If
    TempPath$ = Left(TempPath$, OffSet% - 1)

    Case "\": ' This indicates a path delimiter.
    ThisLength% = Len(TempPath$) - OffSet%
    If ThisLength% >= 1 And ThisLength% <= 8 Then ' Filename
        Filename = Mid$(TempPath$, OffSet% + 1, ThisLength%)
        TempPath$ = Left(TempPath$, OffSet%)

        FileNameFound% = True
        Exit For
    End If

    Case Else
    End Select
Next OffSet%

If FileNameFound% = False Then
    Filename = TempPath$
Else
    DirPath = TempPath$
End If

Select Case action
    Case GET_PATH
        GetPathBits = DriveLetter & DirPath
    Case GET_FULLFILENAME
        GetPathBits = Filename & Extension
    Case GET_FILENAME
        GetPathBits = Filename
    Case GET_FILEEXT
        GetPathBits = Extension
End Select

End Function

Function GetPubPath ()
Dim winpath As String
Dim a As String
Dim ini_name As String

On Error GoTo getpub_err

'make a default path.
a = App.Path
'it ends "SERVERS", so remove "SERVERS"
winpath = Left(a, Len(a) - 7)
'and put on "PUB\"
GetPubPath = winpath & "PUB\"

'PACKET.INI is in the directory above - try and read the
'[TERMINAL], PUB_DIR entry.
ini_name = winpath & "PACKET.INI"
a = Get_Ini_String("TERMINAL", "PUB_DIR", "", ini_name)

If a <> "" Then
    If Right(a, 1) <> "\" Then a = a & "\"
    GetPubPath = a
End If

getpub_err:
Exit Function

End Function

Function MakeBID (next_bid As String) As String
Dim num As Integer

'return next_bid and bump next_bid - ok??
'the format of the BID is MMNNNNCCCCCC
'MM = two magic chars - either leave them as they are or replace them
'with something else.
'NNNN = an incrementing number - 1 to 9999 and wrap back to 1.
'CCCCCC = the system callsign (might on be 4 or 5 chars)

MakeBID = "RF" & Mid(next_bid, 3)
num = Val(Mid(next_bid, 3, 4))
num = num + 1
If num > 9999 Then num = 1
next_bid = "RF" & Format(num, "0000") & Mid(next_bid, 7)

End Function

Function MakeMailName (Path As String, ext As String, day_offset As Integer) As String
Dim t As Variant
Dim ot As Variant
Dim secs As Long
Dim fname As String

ot = CVDate("Jan 01 1980")
Do
    t = Now + day_offset
    t = t - ot
    secs = t * 60 * 60 * 24
    fname = Hex$(secs)
    fname = Path & fname & ext
Loop While Dir$(fname) <> ""

MakeMailName = fname

End Function

Sub ProcessRequest (to_s As String, from_s As String, ByVal from_bbs As String, next_bid As String, ln As String, sent_count As Integer, sys_message As String, is_title As Integer, proc_count As Integer, pub_path As String)
Dim f As String
Dim rep As String
Dim err_title As String
Dim fd As Integer
Dim crlf As String
Dim sizes() As Integer
Dim a As String
Dim b As String
Dim i As Integer
Dim fname As String
Dim fn As String
Dim parts As Integer
Dim count As Integer

On Error GoTo procreq_err

ReDim sizes(0)
crlf = Chr$(13) & Chr$(10)

rep = "Your REQFIL request: """ & ln & """" & crlf
rep = rep & "could not be successfully processed." & crlf
rep = rep & "The failure reason was: "

err_title = "Report from " & to_s & "'s REQFIL"

'the requested file comes after the first ' ' in the title.
a = Trim(Mid(ln, 2))
i = InStr(a, " ")
If i = 0 Then
    'if it's the title line and there have been some content lines,
    'don't send a warning.
    If is_title = False Or (is_title = True And proc_count = 0) Then
        a = rep & "No file was requested." & crlf
        Call SendSenderMessage(from_s, from_bbs, to_s, err_title, next_bid, a)
        sent_count = sent_count + 1
        sys_message = sys_message & ln & ":-" & crlf
        sys_message = sys_message & "Error: no file was requested." & crlf & crlf
    End If
    Exit Sub
End If

sys_message = sys_message & ln & ":-" & crlf

'look for any more separating ' 's.
a = Mid(a, i + 1)
i = InStr(a, " ")
If i <> 0 Then
    fname = Left(a, i - 1)
    a = Trim(Mid(a, i + 1))
Else
    fname = a
    a = ""
End If

'look for a BBS.
i = InStr(a, "@")
If i <> 0 And i <> Len(a) Then
    from_bbs = Trim(Mid(a, i + 1))
End If

'trim off any drive from the file name.
If Len(fname) > 2 Then
    If Mid(fname, 2, 1) = ":" Then fname = Mid(fname, 3)
End If

'remove any leading '\'
If Left(fname, 1) = "\" And Len(fname) > 1 Then fname = Mid(fname, 2)

fname = pub_path & fname
If Dir$(fname) = "" Then
    a = rep & "The requested file does not exist." & crlf
    Call SendSenderMessage(from_s, from_bbs, to_s, err_title, next_bid, a)
    sent_count = sent_count + 1
    sys_message = sys_message & "Error: the requested file does not exist." & crlf & crlf
    Exit Sub
End If

fn = GetPathBits(fname, GET_FULLFILENAME)

parts = CalcParts(fname, sizes())

fd = FreeFile
Open fname For Input As fd

For i = 1 To parts
    If EOF(fd) Then Exit For
    b = ""
    Do While Len(b) < sizes(i) And Not EOF(fd)
        Line Input #fd, a
        b = b & a & crlf
    Loop
    a = fn
    If parts > 1 Then a = a & " (" & Format(i) & " of " & Format(parts) & ")"
    Call SendSenderMessage(from_s, from_bbs, to_s, a, next_bid, b)
    count = count + 1
Next i

Close fd
fd = 0

sent_count = sent_count + count

sys_message = sys_message & Format(count) & " parts were sent." & crlf & crlf

procreq_err:
If fd <> 0 Then Close fd

Exit Sub

End Sub

Sub SendSenderMessage (from_s As String, from_bbs As String, to_s As String, title As String, next_bid As String, message As String)
Dim a As String
Dim fd As Integer
Dim fname As String
Dim bid As String

'get our path.
a = App.Path
'take "servers" off the end and put on "mail\send\"
a = Left(a, Len(a) - 7) & "MAIL\SEND\"
'make a file name in the correct format.
fname = MakeMailName(a, ".SRV", 0)

'send a message to the user.
fd = FreeFile
Open fname For Output As fd
Print #fd, "P"
Print #fd, from_s
Print #fd, from_bbs
Print #fd, title
bid = MakeBID(next_bid)
Print #fd, bid
Print #fd, message
Close fd
fd = 0

End Sub

Sub SendSysopMessage (to_s As String, message As String)
Dim a As String
Dim fd As Integer
Dim fname As String

'get our path.
a = App.Path
'take "servers" off the end and put on "mail\receive\"
a = Left(a, Len(a) - 7) & "MAIL\RECEIVE\"
'make a file name in the correct format.
fname = MakeMailName(a, ".TXT", 0)

'send a message to the user.
fd = FreeFile
Open fname For Output As fd
Print #fd, "N"
Print #fd, to_s
Print #fd, "SYSTEM"
Print #fd, ""
Print #fd, "REQFIL report"
Print #fd, message
Close fd
fd = 0

End Sub

Sub ServerAction ()
'*** BASIC PRICIPLES (for WinPack SERVER writers) ***
'
'If what the code does seems to differ from what these comments say, believe
'the code!
'
'WinPack 'servers' work rather like FBB servers.
'The server must run quickly and terminate after each call.
'
'*** SERVER INPUT ***
'The server receives its input as command line arguments. There are two:-
'1. The full path name of the file containing the message text.
'2. The next BID that WinPack would use.
'
'***Except*** if the first argument is /info. In that case the server should
'create a file called <server>.txt that contains a description of the server,
'including how to use it. This file must be created in the same directory as
'the server. Having written the file, the server must then terminate. (The
'sysop's callsign is passed as a second arg, for use in the info if needed).
'
'Format of the message file:-
'If the server is processing incoming messages (the normal case).
'Line 1 - 'N'
'Line 2 - the message 'To' callsign. At the moment this can only be the
'         callsign of the WinPack operator (sysop).
'Line 3 - the sender's callsign.
'Line 4 - the sender's BBS.
'Line 5 - the message title.
'
'If the message is a SERVER\SEND special server and therefore processing
'outgoing messages.
'Line 1 - the type - 'P' or 'B'
'Line 2 - the recipients callsign.
'Line 3 - the recipients BBS.
'Line 4 - the message title.
'Line 5 - the BID.
'
'The rest of the file contains the message text. BUT it may have "To",
'"From", etc. header lines as if it was being read on the BBS. So make no
'assumptions as to the position of any text in the file. If your server
'allows commands to be placed in the file then make the lines containing
'the commands identifiable. The most obvious thing to do is to use lines
'starting with '/' and a keyword.
'
'*** SERVER OUTPUT ***
'Return a status by creating <server>.REP in the same directory as your
'program. <server> being the name of your server. At the moment this file
'should contain two lines each containing a numeric value. The first line
'is the number of messages sent to the sysop, the second is the number of
'messages sent to the sender of the message. If this file is not created,
'WinPack regards the server as having failed.
'
'You can send a message to the WinPack sysop by creating a file with the
'following format in the MAIL\RECEIVE directory. (Your server will be running
'in a WinPack subdirectory called SERVERS. The path to MAIL\RECEIVE will
'always be ..\MAIL\RECEIVE):-
'N
'sysop's callsign (see above)
'SYSTEM
'
'Your message title.
'Some message text.
'
'Note that there is a blank line between SYSTEM and the title.
'
'You can send messages back to the sender by creating a file with the
'following format in the MAIL\SEND directory. (Your server will be running
'in a WinPack subdirectory called SERVERS. The path to MAIL\SEND will always
'be ..\MAIL\SEND):-
'P
'sender's callsign
'sender's home BBS
'message title
'message BID
'message contents
'
'*** WINPACK BID's ***
'WinPack passes you the next available BID as a command line argument (see
'above). The format of the BID is MMNNNNCCCCCC:-
'MM = two 'magic' chars - either leave them as they are or replace them
'with something else.
'NNNN = an incrementing number - 1 to 9999 and wrap back to 1.
'CCCCCC = the system callsign (might on be 4 or 5 chars)
'The 'magic' chars are two random hex characters. They are to try and ensure
'that even if people delete the next BID file or reinstall the software, they
'are very unlikely to generate the same BID twice.
'
'You can use as many BIDs as you want - simply increment the numeric part
'and make sure that the REP file correctly states how many messages you have
'sent - WinPack adjusts the BID file to allow for how ever many BIDs you use.
'You many wish to change the two magic chars to identify the server being
'used, e.g. this REQFIL changes them to "RF".
'
'*** WINPACK MAIL FILE NAME FORMAT ***
'A WinPack mail file name consists of the number of seconds that have elapsed
'since 01 Jan 1980 in hexadecimal. This allows for files to be sorted in
'chronological order. It also allows for the release of files to be delayed:-
'Before WinPack forwards a message to the BBS, it checks to see if the
'current time is equal to or greater than the time encoded in the file name.
'If it is not then the file is held. This allows for the release of things
'like multiple 7+ parts to be controlled - you simply create a file name that
'is in advance of the current time.
'
'Messages created by a server should normally have an extension of .SRV. If
'you create them with an extension of .TXT then the line length will be
'adjusted before they are sent, according to whatever length the user has set
'in the WinPack setup screen. This is not truncation, extra CR/LFs are
'inserted in lines that are too long.

Dim a As String
Dim rep_fname As String
Dim fd As Integer
Dim to_s As String
Dim from_s As String
Dim from_bbs As String
Dim title_s As String
Dim fname As String
Dim next_bid As String
Dim sent_count As Integer
Dim crlf As String
Dim sys_message As String
Dim proc_count As Integer
Dim pub_path As String

crlf = Chr$(13) & Chr$(10)

'Make status file name based on our EXE name.
a = GetPathBits(App.EXEName, GET_FILENAME)
a = App.Path & "\" & a
rep_fname = a & ".REP"

On Error GoTo server_err

'Kill the reply file if it exists. If Winpack can't find a reply file then
'it regards the session as having failed.
If Dir$(rep_fname) <> "" Then Kill rep_fname

'parse the args.
a = UCase(Command$)
If a = "" Then GoTo server_err
'the message file name.
fname = ExtractArg(a)
If a = "" Then GoTo server_err
'the next BID to use.
next_bid = a

If fname = "/INFO" Then
    'next_bid in this case is the sysop's callsign.
    WriteInfo (next_bid)
    Exit Sub
End If

'get the path to the public files root directory.
pub_path = GetPubPath()

'read the headers from the incoming file.
fd = FreeFile
Open fname For Input As fd
Line Input #fd, a
Line Input #fd, to_s
Line Input #fd, from_s
Line Input #fd, from_bbs
Line Input #fd, title_s

sys_message = "A REQFIL from " & from_s & " has been processed:-" & crlf & crlf

'read the file line by line looking for /REQFIL commands. They may be in the
'body of the file besides being in the title.
Do While Not EOF(fd)
    Line Input #fd, a
    a = UCase(a)
    If Len(a) > 7 Then
        If Left(a, 7) = "/REQFIL" Then
            Call ProcessRequest(to_s, from_s, from_bbs, next_bid, a, sent_count, sys_message, False, proc_count, pub_path)
            proc_count = proc_count + 1
        End If
    End If
Loop
Close fd
fd = 0

'process the title line.
Call ProcessRequest(to_s, from_s, from_bbs, next_bid, title_s, sent_count, sys_message, True, proc_count, pub_path)

'change the file type to 'S' for server to show we've processed it.
fd = FreeFile
Open fname For Binary As fd
a = "S"
Put #fd, , a
Close fd
fd = 0

Call SendSysopMessage(to_s, sys_message)

Call WriteStatus(rep_fname, 1, sent_count)

server_err:
'If an error occurred while a file was open, close it.
If fd <> 0 Then Close fd
Exit Sub

End Sub

Sub Timer1_Timer ()

timer1.Enabled = False

Call ServerAction
Unload Me

End Sub

Sub WriteInfo (to_s As String)
Dim a As String
Dim fd As Integer

a = GetPathBits(App.EXEName, GET_FILENAME)
a = App.Path & "\" & a & ".TXT"

fd = FreeFile
Open a For Output As fd

Print #fd, "REQFIL Server for WinPack - V1.0"
Print #fd, "--------------------------------"
Print #fd, "Written by Roger Barker, G4IDE. October 1995."
Print #fd, "This WinPack server is freeware."
Print #fd, ""
Print #fd, "To use the server you must send a message to " & to_s & ". The title of"
Print #fd, "the message must start with /REQFIL. For example the title:-"
Print #fd, "/REQFIL SAMPLE.TXT @ GB7IDE"
Print #fd, "requests that the file SAMPLE.TXT be sent to the sender of the"
Print #fd, "message. The file should be sent to him @ GB7IDE."
Print #fd, "(The BBS need only be included if it is not the BBS from which the"
Print #fd, "request was sent)."
Print #fd, ""
Print #fd, "Additional request lines, in *exactly* the same format as the title"
Print #fd, "line, including the /REQFIL, may be included in the body of the"
Print #fd, "message. Therefore several files can be requested with one message."
Print #fd, ""
Print #fd, "It is not obligatory for the title line to include a file request,"
Print #fd, "It can simply be /REQFIL with no additional text and all the requests"
Print #fd, "can be put in the body of the message. This is useful if the file"
Print #fd, "name cannot be fitted into the nominal 30 characters that are"
Print #fd, "available for a message title."
Print #fd, ""
Print #fd, "If necessary, files are broken into parts before they are sent,"
Print #fd, "so that no part is larger than " & Format(MAX_SIZE) & " characters."

Close fd
fd = 0

info_err:
If fd <> 0 Then Close fd
Exit Sub

End Sub

Sub WriteStatus (fname As String, status_count As Integer, sender_count As Integer)
Dim fd As Integer

fd = FreeFile
Open fname For Output As fd
Print #fd, Format(status_count)
Print #fd, Format(sender_count)
Close fd

End Sub

