//DRAW.CPP
#include <draw.h>
#include <defin.h>
#include <pgextern.h>
#include <dos.h>
#include <math.h>
#include <mem.h>
DRAW::DRAW()
{
  vram=(BYTE *)MK_FP(VIDEOSEGM,VIDEOOFFS);
}
//***Pixel setzen*******************************************************
void DRAW::SetPix(int x,int y,BYTE color,BYTE page)
{
  xpos=x;
  ypos=y;
  col=color;
  writeto=page;
  WriteTo();
}
//*********************************************************************
//Farbe eines Pixels auslesen
BYTE DRAW::GetPix(int x,int y,BYTE page)
{
  offset=320*y+x;
  switch(page)
  {
   case SWAP:
     return swap[offset];
   case PIC:
     return pic[offset];
   case VRAM:
     return peekb(VIDEOSEGM,offset);
  }
}
//***Linie zeichnen*****************************************************
void DRAW::Line(int x1,int y1,int x2,int y2,BYTE color,BYTE page)
{
 int tempx,x,y,dx,dy,abw,xk,yk;
 WORD offs,length;
 if(y1==y2)
  {
    if(x1>x2)   //Werte vertauschen
     {
	tempx=x1;
	x1=x2;
	x2=tempx;
     }
     length=(x2-x1)+1;
     offs=320*y1+x1;
       switch(page)
       {
	case SWAP:
	  setmem(swap+offs,length,color);
	  break;
	case PIC:
	  setmem(pic+offs,length,color);
	  break;
	case VRAM:
	  setmem(vram+offs,length,color);
       }
  }
 else
  {
     x=x1;
     y=y1;
     dy=abs(y2-y1);
     dx=abs(x2-x1);
     abw=dx-dy;
       writeto=page;
       col=color;
       xpos=x;
       ypos=y;
       WriteTo();
      if(x2>x1)
	xk=1;
      else
	xk=-1;
      if(y2>y1)
	yk=1;
      else
	yk=-1;
    while((x!=x2)||(y!=y2))
     {
       if(abw>=0)
	 {
	   x+=xk;
	   abw-=dy;
	 }
       if(abw<0)
	 {
	   y+=yk;
	   abw+=dx;
	 }
	xpos=x;
	ypos=y;
	WriteTo();
     }
  }
}
//***Rechteck zeichnen**************************************************
void DRAW::Rectangle(int x1,int y1,int x2,int y2,BYTE color,BYTE page)
{
   int tempx,tempy;
   WORD offs1,offs2,length;
    if(x1>x2)   //Werte vertauschen
     {
	tempx=x1;
	x1=x2;
	x2=tempx;
     }
    if(y1>y2)
     {
       tempy=y1;
       y1=y2;
       y2=tempy;
     }
   writeto=page;
   col=color;
   length=(x2-x1)+1;
   offs1=320*y1+x1;
   offs2=320*y2+x1;
       switch(page)
       {
	case SWAP:
	  setmem(swap+offs1,length,color);
	  setmem(swap+offs2,length,color);
	  break;
	case PIC:
	  setmem(pic+offs1,length,color);
	  setmem(pic+offs2,length,color);
	  break;
	case VRAM:
	  setmem(vram+offs1,length,color);
	  setmem(vram+offs2,length,color);
       }
  for(y1=y1;y1<=y2;y1++)
   {
	  xpos=x1;
	  ypos=y1;
	  WriteTo();
	  xpos=x2;
	  ypos=y1;
	  WriteTo();
   }
}
//***Rechteckige Flche zeichnen****************************************
void DRAW::Bar(int x1,int y1,int x2,int y2,BYTE color,BYTE page)
{
 int tempx,tempy;
 WORD offs,length;
 if(x1<0)
   x1=0;
 else if(x1>319)
   x1=319;
 if(x2<0)
   x2=0;
 else if(x2>319)
   x2=319;

 if(y1<0)
   y1=0;
 else if(y1>199)
   y1=199;
 if(y2<0)
   y2=0;
 else if(y2>199)
   y2=199;

    if(x1>x2)   //Werte vertauschen
     {
	tempx=x1;
	x1=x2;
	x2=tempx;
     }
    if(y1>y2)
     {
	tempy=y1;
	y1=y2;
	y2=tempy;
     }
   length=(x2-x1)+1;
   for(y1=y1;y1<=y2;y1++)
    {
       offs=320*y1+x1;
       switch(page)
       {
	case SWAP:
	  setmem(swap+offs,length,color);
	  break;
	case PIC:
	  setmem(pic+offs,length,color);
	  break;
	case VRAM:
	  setmem(vram+offs,length,color);
       }
    }
}
//***Kreis oder Ellipse zeichnen****************************************
//Die Kreis-/Ellipsenfunktion nicht im Spiel verwenden, da zu langsam!
void DRAW::Circle(float xm,float ym,float hm,float bm,float radius,BYTE color,BYTE page)
{
  WORD i2;
  DWORD y,x;
  float xk,yk,xk2,yk2,i;
  writeto=page;
  col=color;
  for(i=0.;i<=360.;i+=.1)
  {
    xk=xm+((radius+bm) * cos(i));
    yk=ym+((radius+hm) * sin(i));
      xk2=floor(xk);
      yk2=floor(yk);
      xk2=xk2+0.5;
      yk2=yk2+0.5;
       if(xk<xk2)
	 x=floor(xk);
       else
	 x=ceil(xk);
       if(yk<yk2)
	 y=floor(yk);
       else
	 y=ceil(yk);

     if(x>319 || y>199)
	continue;
    xpos=x;
    ypos=y;
    WriteTo();
  }
}
//***Ausgefllten Kreis oder Ellipse zeichnen***************************
void DRAW::FillCircle(float xm,float ym,float hm,float bm,float radius,BYTE color,BYTE page)
{
  long x,y,i3;
  float xk,yk,xk2,yk2,i2,i,yy;
  writeto=page;
  col=color;
  for(i=0.;i<=360.;i+=.1)
  {
    xk=xm+((radius+bm) * cos(i));
    yk=ym+((radius+hm) * sin(i));
      xk2=floor(xk);
      yk2=floor(yk);
      xk2=xk2+0.5;
      yk2=yk2+0.5;
       if(xk<xk2)
	 x=floor(xk);
       else
	 x=ceil(xk);
       if(yk<yk2)
	 y=floor(yk);
       else
	 y=ceil(yk);
   if(x<=319 && y<=199 && x>=0 && y>=0)
    {
      xpos=x;
      ypos=y;
      WriteTo();
    }
       yy=ym-yk;
	 for(i2=y;i2<=(ym+yy);i2+=1)
	  {
	    i3=floor(i2);
	    if(i3<200 && i3>=0 && x<320 && x>=0)
	    {
	      xpos=x;
	      ypos=i3;
	      WriteTo();
	    }
	  }
  }
}
//*** Rahmen setzen*****************************************************
void DRAW::Chassis(BYTE color)
{
  union REGS r;
   r.h.ah=0x10;
   r.h.al=0x1;
   r.h.bh=color;
   int86(0x10,&r,&r);
}
//***Pixel in welche Seite schreiben?***********************************
void DRAW::WriteTo(void)
{
 if(xpos>319)
    xpos=319;
 else if(xpos<0)
    xpos=0;
 if(ypos>199)
    ypos=199;
 else if(ypos<0)
    ypos=0;
 offset=320*ypos+xpos;
  switch(writeto)
  {
   case SWAP:
     swap[offset]=col;
     break;
   case PIC:
     pic[offset]=col;
     break;
   case VRAM:
     pokeb(VIDEOSEGM,offset,col);
     break;
  }
}

