; Hi!
;
; AT FIRST : WHAT IS THIS / COPYRIGHT
;
; This is the version 1.1 of "Graphics Board support for games",
; featuring the EGS Boards. The code is very similar to the
; functions that are needed to do a sublibrary for rtg.library.
; In fact, that is, what i am currently doing with that stuff, making
; a sublibrary for rtg.library out of this. But if some coders
; want to RELEASE things, they probably NEED something, and
; rtg.library still is not there. So they can use this code,
; and it will be very easy later, to change their code from
; this "short hack with big documentation" to the better
; solution : rtg.library of John Hendrikx.
; Up to now this is only EGS stuff, but this will change in the future
; (but before i add support for other boards, i first will convert
; this source to a rtg.library sublibrary, probably...
; If someone has code for other Boards that he wants to include...
; send it to me... (MagicSN on irc, haeuser@tick.informatik.uni-stuttgart.de
; on the net)

; As to the speed : I do not know. In writing pixels, it had about
; the same speed as CyberGFX, but i do not know how this code will
; do in a running game of course...

; As to the COPYRIGHT : The Copyright of this code is *MINE*,
; and the least thing i want from you, if you want to use this code,
; is, that you write something to the documentation of your
; game/demo like "The graphics board code for EGS was written
; by MagicSN". If you want to do more (send me a free copy
; of your game or some money or some Beta versions to test them
; for my Texturemapping FAQ :) ), i of course will be pleased,
; but you do not have to... If you have problems with the
; way this code is written, contact me, and we will talk by email
; about these problems, and i maybe will do some new code :)))
; And of course, you have to know... i *WILL* give that code
; to everyone who wants it, and i *WILL* include this code
; to rtg.library... not only to one game...
;
; _______________________________________________________________

; The following file are the EGS support routines.
; I did not include documentation to every single routine,
; but i supported some documentation that helps to include
; the code to the own source (Parameter, what the routine
; does, what it returns and that stuff).
;
; This code supports writing directly to video RAM. In fact,
; i am not 100% sure, if there is not a little driver between
; this code and video RAM, but it is the lowest you can go with
; EGS (i had to test out a lot of things myself, as Viona
; does not seem to be interested in someone using EGS a low level
; way...) But as a pixel appears on screen as soon as you
; move.b or move.l it to the memory, i suppose this code
; writes directly to video RAM :) If someone knows for sure,
; mail me :)))
;
; In the meanwhile there is a working version of rtgEGS.library,
; by the way, and a soon working version of rtgAMI.library (ECS/AGA),
; so rtgmaster.library should soon be available (hopefully soon
; for Picasso and CyberGFX too...) If you are interested in
; rtgmaster.library, please mail me too... we currently have some
; problems with our Screenmode Requester, that is the only thing,
; why we did not release it on Aminet up to now...

; It may be needed to change some include paths. By the way, ONLY
; use the EGS Include Files provided in this document. Those are
; changed include files, as the assembly language include files
; that are available from Viona Developpement do not support
; EGS Version 6 (and we need Version 6, Version 5 is old rubbish,
; that no one uses...)

; Table of contents :

; 1. OpenEGS : Opens the egs.library and gets sure, that EGS is surely active
     (an EGS Board correctly installed)
; 2. GetScreenmodes : Gets a list of the names of all EGS Screenmodes available
     (this code does not need ModeIDs, only Screenmode NAMES...)
; 3. FlipBuffers : Double-/Triplebuffering
; 4. GetBufAdr : Get Base Address of Video RAM for a Buffer
; 5. LockRtgScreen : Does the Screenlocking
; 6. UnlockRtgScreen : Does the Screenunlocking
; 7. LoadRtgRGB : Sets the color table
; 8. OpenRtgScreen : Opens the screen
; 9. CloseRtgScreen : Closes the screen
; 10. ScreenAtFront : Finds out if a specific Screen is in front or not
; 11. GetRtgScreenData : Gets some data about open screens
; 12. Some stuff about keyboard events (for people that use IDCMP
;     in their ECS/AGA code, to make the EGS version easy for them)
; 13. CloseEGS : Closes the egs.library
; 14. Some things about Frequencies ...
; 15. Some Include-Files...

; NOTE : This routines need the Library-Base-Addresses UtilityBase
; and DosBase valid in order to work. This routines work with
; Workbench 2.0 and upwards.
; With the exception of 12. and 14. all functions are tested.
; I did not include high level constructs as WritePixel or RectFill,
; but if someone needs them, i could support him with the needed
; functions.

; Why i did no Library ? There will be a library... the rtgmaster.library
; of John Hendrikx. And this code will be part of it :) (Or a a bit
; modified version of this code). This routines are for people
; who are near release, and it will be quite easy to adapt code done
; with this routines to rtgmaster.library later...

    incdir "include:"
    include "sc:Asm-include/egs/lvo/lvo_egs.i"
    include "sc:Asm-include/egs/egs.i"

; Some definitions...

_LVOOpenLibrary EQU -552
_LVOCloseLibrary EQU -414
_LVOAllocMem EQU -198
_LVOFreeMem EQU -210

CALLSYS MACRO
      jsr _LVO\1(a6)
     ENDM

XLIB MACRO
        XREF _LVO\1
        ENDM

; The first function opens egs.library and looks if there really
; is an EGS Board appended to the system. (So this code won't get
; activated, if you use EGS with AGA or ECS, or if you have only
; the libraries installed and you for example use CyberGFX...)
; If this function found a correctly installed EGS, it returns 1,
; else it returns 0 (in a longword).

; The function needs :
; - Exec.library :)
; - Egs.library V6.0 or higher
; (EGS V6.0 is the lowest version of EGS still supported, named EGS II
; often...)
; The function does not take any parameters.

; This function (and so the whole function collection) works on :
; - EGS Spectrum
; - EGS Piccolo
; - EGS Piccolo SD64
; - EGS Rainbow 3
; - EGS G110

; Maybe on : EGS Rainbow 2, EGS Graffity (do not confuse with the Graffiti
; graphics board, that is another one...) and A2410 of Commodore.
; About EGS Graffity i am not sure, if it was ever built (but there
; exists a Shapeshifter driver for the board), and about A2410 i probably
; soon will get information if my code worked on it... About Rainbow 2
; i am not sure, if there exists EGS for the board...
; There does not exist any other EGS (only the ECS/AGA ... but it would
; be silly to use this drivers on a pure AGA system i think... use
; some hardware hacks there... :) )
; Maybe one should try RB2a/RB2b on Rainbow 2 like RB3a/RB3b on Rainbow 3 ? :)

OpenEGS:
      movem.l a0-a6/d0-d7,-(sp)
      move.l #0,EgsBase
      lea EgsName,a1
      moveq #6,d0
      move.l $4,a6
      CALLSYS OpenLibrary
      cmp.l #0,d0
      beq .Exit
      move.l d0,EgsBase
      move.l EgsBase,a6
      CALLSYS E_LockEGSVideo
      CALLSYS E_GetHardInfo
      move.l d0,a3
      CALLSYS E_UnlockEGSVideo
      move.l #1,d0
      move.l ehi_Drivers(a3),a0
      lea edd_Node(a0),a0
      move.l LN_SUCC(a0),a0
      cmp.l #0,LN_SUCC(a0)
      beq .Exit
      cmp.l #1,d0
      bne.s .LookRB3a
      move.l LN_NAME(a0),a1
      cmp.l #'PICO',(a1)
      bne.s .LookRB3a
      bsr .Found
.LookRB3a:
      cmp.l #1,d0
      bne.s .LookRB3b
      move.l LN_NAME(a0),a1
      cmp.l #'RB3a',(a1)
      bne.s .LookRB3b
      bsr .Found
.LookRB3b:
      cmp.l #1,d0
      bne.s .LookG110
      move.l LN_NAME(a0),a1
      cmp.l #'RB3b',(a1)
      bne.s .LookG110
      bsr .Found
.LookG110:
      cmp.l #1,d0
      bne.s .LookGVP
      move.l LN_NAME(a0),a1
      cmp.l #'G110',(a1)
      bne.s .LookGVP
      bsr .Found
.LookGVP:
      cmp.l #1,d0
      bne.s .LookLoop
      move.l LN_NAME(a0),a1
      cmp.l #'LEGS',(a1)
      bne.s .LookLoop
      bsr .Found
.LookLoop:
      cmp.l #0,LN_SUCC(a0)
      beq .Exit
      cmp.l #0,d0
      beq .QuitLoop
      lea edd_Node(a0),a0
      move.l LN_SUCC(a0),a0
      cmp.l #1,d0
      bne.s .SearchRB3a
      move.l LN_NAME(a0),a1
      cmp.l #'PICO',(a1)
      bne.s .SearchRB3a
      bsr.s .Found
.SearchRB3a:
      cmp.l #1,d0
      bne.s .SearchRB3b
      move.l LN_NAME(a0),a1
      cmp.l #'RB3a',(a1)
      bne.s .SearchRB3b
      bsr.s .Found
.SearchRB3b:
      cmp.l #1,d0
      bne.s .SearchG110
      move.l LN_NAME(a0),a1
      cmp.l #'RB3b',(a1)
      bne.s .SearchG110
      bsr.s .Found
.SearchG110:
      cmp.l #1,d0
      bne.s .SearchGVP
      move.l LN_NAME(a0),a1
      cmp.l #'G110',(a1)
      bne.s .SearchGVP
      bsr.s .Found
.SearchGVP:
      cmp.l #1,d0
      bne.s .LookLoop
      move.l LN_NAME(a0),a1
      cmp.l #'LEGS',(a1)
      bne .LookLoop
      bsr.s .Found
      bra .LookLoop
.Found:
      move.l #0,d0
      rts
.QuitLoop:
      movem.l (sp)+,a0-a6/d0-d7
      move.l #1,d0
      rts
.Exit:
      movem.l (sp)+,a0-a6/d0-d7
.CloseEGS:
      move.l $4,a6
      move.l EgsBase,a1
      CALLSYS CloseLibrary
      move.l #0,d0
      rts
EgsBase: dc.l 0
EgsName: dc.b 'egs.library',0


; To get the ModeID of an EGS Screenmode is a bit difficult.
; But it is EASY to get its name. So this code works completely
; with Screenmode Names, even the OpenScreen code.
; And if you got the name, you simply could scan the screenmode
; list of the system after the screenmode and look THERE for
; his ModeID (by the way, all EGS Screenmode names start with
; LEGS, PICO, RB3, A2410 or G110).
; This function returns a list of EGS Screenmodes (in fact,
; the EGS Screenmode list). Ignore a screenmode called
; EGS-DEFAULT !!! And be sure to walk the list till
; esm_Node.ln_Next *REALLY* is 0.

; If you URGENTLY need the ModeID : Go through the Screenmode
; system list. As to supported depths you can be sure, 1,8 and 24
; bit are supported. Be careful as to horizontal, vertical,...
; frequencies... as far as i know, for EGS Modes the values are
; not correct in the system list (i did not check this out myself,
; but with the source code of somebody else, there were wrong
; values...)

; And this is the structure :

;  STRUCTURE  E_ScreenMode,0
;         STRUCT  esm_Node,LN_SIZE ; in esmNode.ln_Name steht der Screenmode-Name !!!
;         UWORD   esm_Horiz ; Die Horizontalauflsung !!!
;         UWORD   esm_Vert ; Die Vertikalauflsung !!!
;         UWORD   esm_Pad
;         ULONG   esm_Depths ; Die Farbtiefe (diese Routinen hier untersttzen allerdings
;                            ; nur die Farbtiefen 1,8 und 24)
;         APTR    esm_Driver ; Weitere Infos, die man normalerweise nicht braucht
;         STRUCT  esm_Specs,24*4 ; Weitere Infos, die man normalerweise nicht braucht
;         LABEL   esm_SIZEOF


; You should be careful, not to change the data in this list, as this
; is REALLY the EGS System list, not a copy of it !!! So if you change
; the screenmode name for example, the EGS Screenmode name in the SYSTEM
; changes too... nice effect :)

GetScreenmodes:
      movem.l a3/a6,-(sp)
      move.l EgsBase,a6
      CALLSYS E_LockEGSVideo
      CALLSYS E_GetHardInfo
      move.l d0,a3
      CALLSYS E_UnlockEGSVideo
      move.l ehi_Modes(a3),d0
      movem.l (sp)+,a3/a6
      rts


; The following function serves for doing Double- or Triple-Buffering.
; The function wants a pointer to a RtgScreen-structure (this structure
; will be explained below) in a0, in d0 a buffer number between 0 and 2,
; where 0 is the Buffer that is open shortly after the screen opened for
; the first time. If a not-existing buffer number will be choosen or
; the buffer that is CURRENTLY displayed, this function simply does
; *NOTHING*.
; NOTE : This function DOES NOT WAIT. So it is possible that the correction
; of the display will be after the next VBI. But therefor, the function
; does *NOT* consume *ANY* calculation time. The function returns at once.
; It destroys a0,a1,d0 and d1.

FlipBuffers:
      ; IN: a0.l = RtgScreen
      ; IN: d0.l = Buffer
      ; COM: a0,a1,d0,d1 will be destroyed

      movem.l a2/a3/a6/d7,-(sp)
      cmp.l rs_ActiveMap(a0),d0
      beq .Exit
      move.l rs_NumBuf(a0),d1
      cmp.l d1,d0
      bge .Exit
      cmp.l #0,d0
      beq.s .BufferOK
      cmp.l #1,d0
      beq.s .BufferOK
      cmp.l #2,d0
      bne .Exit
.BufferOK:
      move.l a0,a3
      move.l EgsBase,a6
      move.l rs_MyScreen(a3),a0
      cmp.l #0,d0
      bne.s .NotA
      move.l rs_MapA(a3),a1
      bra .NotC
.NotA:
      cmp.l #1,d0
      bne.s .NotB
      move.l rs_MapB(a3),a1
      bra .NotC
.NotB:
      move.l rs_MapC(a3),a1
.NotC:
      move.l d0,d7
      move.l a1,rs_FrontMap(a3)
      CALLSYS E_FlipMap
      move.l d7,rs_ActiveMap(a3)
.Exit:
      movem.l (sp)+,a2/a3/a6/d7
      rts

; GetBufAdr is to find out the Video RAM base address of
; a certain Buffer of a certain RtgScreen. The Buffer Number
; should be between 0 and 2, or this function will do strange
; things. Parameter : Address of a RtgScreen in a0, Buffernumber
; in d0. The base address will come back in d0. This routine
; destroys the contents of d0 and a0.

GetBufAdr:

      ;IN: a0.l = RtgScreen
      ;IN: d0.l = Buffer
      ;OUT: d0.l = RtgBuffer
      ;COM: d0 and a0 will be destroyed

      cmp.l #0,d0
      beq.s .MapA
      cmp.l #1,d0
      beq.s .MapB
      move.l rs_MapC(a0),a0
      bra .FindPlane
.MapA:
      move.l rs_MapA(a0),a0
      bra .FindPlane
.MapB:
      move.l rs_MapB(a0),a0
.FindPlane:
      move.l ebm_Plane(a0),d0
      rts


; The next function is for locking the video memory for private use.
; Sadly, it is not possible to REALLY lock video memory under EGS.
; This function only gets sure, that the system may not crash, if
; two applications access the same memory. You will still get
; ghost images. (Like for example if you use the Shapeshifter
; Mac emulation and the WB-Emu on the same EGS graphics board.)
; You will get the first ever displayed buffer on this screen
; back in d0 (its video memory base address).
; The function destroys the contents of a0,a1,d0 and d1. The function
; takes about 0.1 seconds. Do not try to *REMOVE* this delay in
; the code. You will take a trip to india then :)
; NOTE : This function should be called *AT ONCE* after you opened
; a screen !!! You may nest LockRtgScreen/UnlockRtgScreen, but do
; not nest deepere than 255 times... this will confuse EVERYTHING!
; (But, normaly, ONE call should be enough, i think...)

; Parameter : Address of RtgScreen in a0.

LockRtgScreen:

      ;IN: a0.l = RtgScreen
      ;OUT: d0.l = RtgBitmap
      ;COM: a0,a1,d0,d1 will be destroyed

      movem.l a4/a6,-(sp)
      move.l rs_MapA(a0),a1
      add.b #1,ebm_Lock(a1)
      add.b #1,rs_Locks(a0)
      move.l rs_MapB(a0),a1
      cmp.l #0,a1
      beq.s .NoB
      add.b #1,ebm_Lock(a1)
.NoB:
      move.l rs_MapC(a0),a1
      cmp.l #0,a1
      beq.s .NoC
      add.b #1,ebm_Lock(a1)
.NoC:
      move.l a0,a4
      move.l DosBase,a6
      move.l #5,d1
      jsr -198(a6)
      move.l a4,a0
      movem.l (sp)+,a4/a6
      move.l rs_MapA(a0),a0
      move.l ebm_Plane(a0),d0
      rts

; The next function unlocks the screen again. This function should be called
; shortly before you close the screen again. It destroys the contents
; of d0,d1,a0 and a1. You will need a pointer to a RtgScreen in a0.
; Contrary to LockRtgScreen, this function returns at *ONCE*.

UnlockRtgScreen:

      ;IN: a0.l = RtgScreen
      ;COM: a0,a1,d0,d1 will be destroyed

      cmp.b #0,rs_Locks(a0)
      beq.s .Exit
      move.l rs_MapA(a0),a1
      sub.b #1,ebm_Lock(a1)
      move.l rs_MapB(a0),a1
      cmp.l #0,a1
      beq .NoB
      sub.b #1,ebm_Lock(a1)
.NoB:
      move.l rs_MapC(a0),a1
      cmp.l #0,a1
      beq .NoC
      sub.b #1,ebm_Lock(a1)
.NoC:
      sub.b #1,rs_Locks(a0)
.Exit:
      rts

; Now we need (for 1 or 8 Bit colordepth) the color table.
; For 24 Bit colordepth of course no color table is used. In a0
; is a pointer to the appropriate RtgScreen. In a1 is a pointer to
; the color table, with a longwords indicating the number of
; color values to be changed at the beginning, then a longword
; indicating the "startcolorregister", after that the color values
; in longwords, for example :

; dc.l 5,3 ; 5 values starting with color register 3
; dc.l 0,0,0 ; Then the color values ...
; dc.l 200,0,3
; dc.l 0,50,103
; dc.l 20,50,0
; dc.l 0,0,10

; The routine destroys a0,a1,d0 and d1.
; Of course you may use E_SetRGB8 directly, but i found
; such a table function quite nice...

LoadRtgRGB:

      ;IN: a0.l = RtgScreen
      ;IN: a1.l = Table
      ;COM: a0,a1,d0,d1 will be destroyed

    movem.l d3-d7/a2-a6,-(sp)
    cmp.l #4,rsEGS_Bytes(a0)
    beq .Exit
    cmp.l #0,a1
    beq .Exit
    move.l rs_MyScreen(a0),a3
    move.l rs_Bytes(a0),d0
    cmp.l #0,d0
    beq .OneBit
    cmp.l #1,d0
    beq .OneByte
    bra .Exit
.OneBit:
    move.l (a1)+,d3
    move.l (a1)+,d4
    cmp.l #0,d3
    beq .Exit
    cmp.l #3,d3
    bge .Exit
    cmp.l #0,d4
    beq .StartZero
    cmp.l #1,d4
    beq .StartOne
    bra .Exit
.StartZero:
    move.l a3,a0
    move.l #0,d0
    move.l (a1)+,d1
    move.l (a1)+,d2
    move.l (a1)+,d3
    move.l a1,d7
    move.l EgsBase,a6
    CALLSYS E_SetRGB8
    move.l d7,a1
    cmp.l #1,d3
    beq .Exit
.StartOne:
    move.l a3,a0
    move.l #1,d0
    move.l (a1)+,d1
    move.l (a1)+,d2
    move.l (a1)+,d3
    CALLSYS E_SetRGB8
    bra .Exit
.OneByte:
    move.l a1,a4
    move.l (a4)+,d1
    cmp.l #0,d1
    beq .Exit
    cmp.l #257,d1
    bge .Exit
    move.l (a4)+,d0
    cmp.l #256,d0
    bge .Exit
    move.l d1,d2
    sub.l #1,d1
    move.l d1,d6
    move.l d0,d5
    move.l EgsBase,a6
.Loop:
    move.l (a4)+,d1
    move.l (a4)+,d2
    move.l (a4)+,d3
    move.l d5,d0
    move.l a3,a0
    CALLSYS E_SetRGB8
    add.l #1,d5
    dbra d6,.Loop
.Exit:
    move.l #0,d0
    movem.l (sp)+,d3-d7/a2-a6
    rts


; The next function opens a new RtgScreen, so it is the function on which
; all the other functions base. It destroys a0,a1, d0 and d1.

; Inputs Parameter is the ScreenQuery structure in a2 (more details about
; this structure will come later in this file). Do not disturb, if this function
; looks a bit strange, the source changed a *LOT* since the first version.
; But it works ... :)

; The function will give you back the pointer to the RtgScreen structure
; in d0, or 0, if it failed to open the Screen. It will only work, if
; OpenEGS was called before.

; NOTE : This "Screen" is no real screen. It is a chunky display with
; a MessagePort attached, to be exact :)

OpenRtgScreen:

      ; IN: a2 = ScreenQuery structure
      ; OUT: d0 = RtgScreen handle
      ; COM: d0-d1,a0-a1 may be destroyed

      movem.l d2-d7/a2-a6,-(sp)
      cmp.l #0,EgsBase
      beq .Exit
      move.l a2,a4
      move.l sq_Buffers(a4),d4
      cmp.l #0,d4
      beq .Exit
      move.l #3,d0
      cmp.l d0,d4
      bgt .Exit
.BufferDone:
      move.w sq_Depth(a4),d0
      move.w sq_Width,-(sp)
      move.w sq_Height,-(sp)
      cmp.l #24,d0
      beq .TrueColor
      cmp.l #8,d0
      beq .Chunky
      bra .Mask
.TrueColor:
      move.l #E_PIXELMAP,d5
      move.w #24,d6
      bra.s .Continue
.Chunky:
      move.l #E_PIXELMAP,d5
      move.w #8,d6
      bra.s .Continue
.Mask:
      move.l #E_BITPLANEMAP,d5
      move.w #1,d6
.Continue:
      move.l #rs_SIZEOF,d0
      move.l #MEMF_CLEAR,d1
      move.l $4,a6
      CALLSYS AllocMem
      cmp.l #0,d0
      beq .Error1
      move.l d0,a3
      move.l EgsBase,a6
      move.l #ens_SIZEOF,d0
      move.l #MEMF_CLEAR,d1
      move.l $4,a6
      CALLSYS AllocMem
      cmp.l #0,d0
      beq .Error3
      move.l d0,a0
      move.l sq_ScreenMode(a4),a1
      move.l a1,ens_Mode(a0)
      move.w d6,ens_Depth(a0)
      move.w #0,ens_Pad_1(a0)
      move.l #0,ens_Colors(a0)
      move.l #0,ens_Map(a0)
      move.l #0,ens_Flags(a0)
      move.l #0,ens_Flags(a0)
      move.l #0,ens_Mouse(a0)
      move.l sq_EdcmpFlags(a4),ens_EdcmpFlags(a0)
      move.l sq_Port(a4),ens_Port(a0)
      move.l EgsBase,a6
      move.l a0,d7
      CALLSYS E_OpenScreen
      cmp.l #0,d0
      beq .Error4
      move.l d0,rs_MyScreen(a3)
      move.l d7,a1
      move.l #ens_SIZEOF,d0
      move.l $4,a6
      CALLSYS FreeMem
      move.l #0,rs_ActiveMap(a3)
      cmp.l #2,d4
      bge.s .DBuff
      move.l #0,rs_MapB(a3)
      move.l #0,rs_MapC(a3)
      tst.l (sp)+
      bra .NoDBuff
.AnotherLabel:
      sub.l d0,d0
      sub.l d1,d1
      move.w (sp)+,d1
      move.w (sp)+,d0
      sub.l d2,d2
      move.w d6,d2
      move.l d5,d3
      move.l #0,d4
      add.l #E_EB_DISPLAYABLE,d4
      add.l #E_EB_BLITABLE,d4
      add.l #E_EB_SWAPABLE,d4
      add.l #E_EB_CLEARMAP,d4
      move.l rs_MyScreen(a3),a0
      move.l esc_Map(a0),a0
      move.l EgsBase,a6
      CALLSYS E_AllocBitMap
      cmp.l #0,d0
      beq .Error5
      move.l d0,rs_MapC(a3)
      move.l d0,a0
      CALLSYS E_ClearBitMap
      bra .NoDBuff
.DBuff:
      move.w (sp)+,d1
      move.w (sp)+,d0
      sub.l d2,d2
      move.w d6,d2
      move.l d5,d3
      move.l d4,-(sp)
      move.l #0,d4
      add.l #E_EB_DISPLAYABLE,d4
      add.l #E_EB_BLITABLE,d4
      add.l #E_EB_SWAPABLE,d4
      add.l #E_EB_CLEARMAP,d4
      move.l rs_MyScreen(a3),a0
      move.l esc_Map(a0),a0
      move.l EgsBase,a6
      move.w d0,-(sp)
      move.w d1,-(sp)
      CALLSYS E_AllocBitMap
      move.w (sp)+,d3
      move.w (sp)+,d2
      move.l (sp)+,d4
      cmp.l #0,d0
      beq .Error5
      move.w d2,-(sp)
      move.w d3,-(sp)
      move.l d0,rs_MapB(a3)
      move.l d0,a0
      CALLSYS E_ClearBitMap
      cmp.l #3,d4
      beq .AnotherLabel
      move.l #0,rs_MapC(a3)
      tst.l (sp)+
.NoDBuff:
      move.l EgsBase,a6
      move.l rs_MyScreen(a3),a0
      move.l esc_Map(a0),a0
      move.l a0,rs_MapA(a3)
      move.l a0,rs_FrontMap(a3)
      CALLSYS E_ClearBitMap
      move.l rs_MapA(a3),a0
      move.w ebm_Width(a0),d0
      ext.l d0
      move.l d0,rs_Width(a3)
      move.b ebm_Depth(a0),d0
      move.l d5,rs_Type(a3)
      cmp.b #8,d0
      beq.s .OneByte
      cmp.b #1,d0
      beq.s .OneBit
      move.l #4,rs_Bytes(a3)
      bra.s .ALabel
.OneBit:
      move.l #0,rs_Bytes(a3)
      bra .ALabel
.NoB:
      move.l rs_MapC(a3),d0
      cmp.l #0,d0
      bne .NoC
      move.l #2,rs_NumBuf(a3)
      bra .SetLock
.NoC:
      move.l #3,rs_NumBuf(a3)
      bra .SetLock
.OneByte:
      move.l #1,rs_Bytes(a3)
.ALabel:
      move.l rs_MapB(a3),d0
      cmp.l #0,d0
      bne .NoB
      move.l #1,rs_NumBuf(a3)
.SetLock:
      move.w #0,rs_Locks(a3)
      move.l a3,d0
      movem.l (sp)+,d2-d7/a2-a6
      rts
.Exit:
      move.l #0,d0
      movem.l (sp)+,d2-d7/a2-a6
      rts
.Error1:
      tst.l (sp)+
.Raus:
      movem.l (sp)+,d2-d7/a2-a6
      move.l #0,d0
      rts
.Error3:
      tst.l (sp)+
      move.l a3,a1
      move.l #rs_SIZEOF,d0
      CALLSYS FreeMem
      move.l (sp)+,a0
      move.l EgsBase,a6
      CALLSYS E_DisposeBitMap
      movem.l (sp)+,d2-d7/a2-a6
      move.l #0,d0
      rts

.Error4:
      tst.l (sp)+
      move.l ens_Map(a4),a0
      move.l EgsBase,a6
      CALLSYS E_DisposeBitMap
      move.l a4,a1
      move.l #ens_SIZEOF,d0
      move.l $4,a6
      CALLSYS FreeMem
      move.l a3,a1
      move.l #rs_SIZEOF,d0
      CALLSYS FreeMem
      movem.l (sp)+,d2-d7/a2-a6
      move.l #0,d0
      rts

.Error5:
      move.l rs_MyScreen(a3),a0
      CALLSYS E_CloseScreen
      move.l rs_MapC(a3),a0
      cmp.l #0,a0
      beq .Error6
      CALLSYS E_DisposeBitMap
.Error6:
      move.l a3,a1
      move.l #rs_SIZEOF,d0
      move.l $4,a6
      CALLSYS FreeMem
      movem.l (sp)+,d2-d7/a2-a6
      move.l #0,d0
      rts
.Error2:
      tst.l (sp)+
      tst.l (sp)+
      move.l a3,a1
      move.l #rs_SIZEOF,d0
      CALLSYS FreeMem
      movem.l (sp)+,d2-d7/a2-a6
      move.l #0,d0
      rts

; The next function serves to close a RtgScreen.
; It destroys d0,d1,a0 and a1. If the "wrong" Double-/Triple-Buffere
; is currently displayed, this function will correct this, before
; closing the screen.


CloseRtgScreen:
      ; IN: a0.l = RtgScreen
      ; COM: a0,a1,d0,d1 will be destroyed

      movem.l a2/a3/a6,-(sp)
      move.l a0,a3
      move.l rs_ActiveMap(a0),d0
      cmp.l #0,d0
      beq.s .NoFlip
      move.l rs_MyScreen(a0),a0
      move.l EgsBase,a6
      CALLSYS E_WaitTOF
      move.l a3,a0
      move.l rs_MapA(a0),a1
      move.l rs_MyScreen(a0),a0
      CALLSYS E_FlipMap
.NoFlip:
      move.l EgsBase,a6
      move.l rs_MyScreen(a3),a0
      CALLSYS E_CloseScreen
      move.l rs_MapB(a3),a0
      cmp.l #0,a0
      beq.s .NoB
      CALLSYS E_DisposeBitMap
.NoB:
      move.l rs_MapC(a3),a0
      cmp.l #0,a0
      beq.s .NoC
      CALLSYS E_DisposeBitMap
.NoC:
      move.l $4,a6
      move.l a3,a1
      move.l #rs_SIZEOF,d0
      CALLSYS FreeMem
      movem.l (sp)+,a2/a3/a6
      rts

; RtgScreenAtFront tests, if the RtgScreen, which address
; was given in a0, is in front, or if this is another screen.
; d0, d1, a0 and a1 will be destroyed. A return value of 0
; indicates, another screen being in the front. A return value
; of $FFFFFFFF (-1) indicates, this screen was *IN FACT* the
; one in front. This function is useful for coding a
; multitasking-friendly game. This function was not tested
; up to now. It destroys d0,d1, a0 and a1.

; In version 1.0 of this code, there was a *bug* causing
; this function to crash (as i first tested this function
; some days ago... but now all functions are tested (unless
; this eDCMP and this frequency stuff...)

RtgScreenAtFront:
; IN  : RtgScreen (a0.l)
; OUT : 0/-1 (d0.l)

    movem.l a4-a6,-(sp)
    move.l EgsBase,a6
    move.l rs_MyScreen(a0),a0 ; That was missing in 1.0 !!!
    move.l a0,a4
    CALLSYS E_WhichMonitor
    move.l d0,a0
    CALLSYS E_WhichScreen
    move.l #0,d1
    cmp.l a4,d0
    bne .Not
    move.l #$ffffffff,d1
.Not:
    move.l d1,d0
    move.l (sp)+,a4-a6
    rts

; GetRtgScreenData serves to get some information about an already
; open screen. You give the address of some Tags to a1, and the
; function fills the appropriate values to ti_Data of these Tags.
; These Tags are : grd_Buffers, to get the number of Buffers of
; a screen, grd_Width for the width, grd_Height for the height,
; grd_Depth for the depth (z.B. 8 for 256 colors). In a0 there
; is the address of the RtgScreen (will be explained below).
; The function destroys the contents of d0,d1, a0 and a1.

GetRtgScreenData:

    ;IN: a0.l = RtgScreen
    ;IN: a1.l = RtgTags
    ;COM: a0,a1,d0,d1 will be destroyed

    movem.l a2-a6,-(sp)
    move.l a1,a4
    cmp.l #0,a0
    beq .Exit
    cmp.l #0,a1
    beq .Exit
    move.l a0,a3
    move.l a1,a0
    move.l #grd_Buffers,d0
    move.l UtilityBase,a6
    CALLSYS FindTagItem
    cmp.l #0,d0
    beq .NoBuffers
    move.l rs_MapB(a3),d1
    cmp.l #0,d1
    beq .NoB
    move.l rs_MapC(a3),d1
    cmp.l #0,d1
    beq .NoC
    move.l d0,a0
    move.l #3,ti_Data(a0)
    bra .NoBuffers
.NoC:
    move.l d0,a0
    move.l #2,ti_Data(a0)
    bra .NoBuffers
.NoB:
    move.l d0,a0
    move.l #1,ti_Data(a0)
.NoBuffers:
    move.l a4,a0
    move.l #grd_Width,d0
    CALLSYS FindTagItem
    cmp.l #0,d0
    beq .BranchMinWidth
    move.l rs_MyScreen(a3),a0
    move.l esc_Map(a0),a0
    move.l d0,a1
    sub.l d0,d0
    move.w ebm_Width(a0),d0
    ext.l d0
    move.l d0,ti_Data(a1)
.BranchMinWidth:
    move.l a4,a0
    move.l #grd_Height,d0
    CALLSYS FindTagItem
    cmp.l #0,d0
    beq .BranchMinHeight
    move.l rs_MyScreen(a3),a0
    move.l esc_Map(a0),a0
    move.l d0,a1
    move.w ebm_Height(a0),d0
    ext.l d0
    move.l d0,ti_Data(a1)
.BranchMinHeight:
    move.l a4,a0
    move.l #grd_Depth,d0
    CALLSYS FindTagItem
    cmp.l #0,d0
    beq .BranchChunky
    move.l rs_MyScreen(a3),a0
    move.l esc_Map(a0),a0
    sub.l d1,d1
    move.b ebm_Depth(a0),d1
    ext.w d1
    ext.l d1
    move.l d0,a0
    move.l d1,ti_Data(a0)
.Exit:
    move.l a4,a1
    movem.l (sp)+,a2-a6
    rts
    END

; The RtgScreen structure :


;  STRUCTURE RtgScreenEGS,0
;   APTR   rs_MyScreen
;   ULONG  rs_ActiveMap
;   APTR   rs_MapA
;   APTR   rs_MapB
;  APTR   rs_MapC
;  APTR   rs_FrontMap
;  ULONG  rs_Bytes
;  ULONG  rs_Width
;  ULONG  rs_NumBuf
;  UWORD  rs_Locks
;  LABEL rsEGS_SIZEOF

; This structure is a modified version of the RtgScreen structure of rtg.library.
: Some comments :

; * rs_MyScreen is the address of the E_EScreen of the Screen (an  E_EScreen
;   of EGS is a sort of display with an eDCMP-Messageport, which is nearly
;   the same of an IDCMP Port of Intuition, attached).

; * rs_ActiveMap is the *NUMBER* of the currently active buffer (between
;   0 and 2, DO NOT CONFUSE WITH rs_FrontMap !!!)


; * rs_MapA to rs_MapC are the Video RAM base addresses of the three buffers.


; * rs_FrontMap is the video RAM base address of the currently activated
;   buffer. DO NOT CONFUSE WITH rs_ActiveMap !!!)

; * rs_Bytes is the number of Bytes for *ONE* Pixel, this is 1 for 8 Bit
;   (256 colors, chunky, colormap), 4 for 24 Bit, where the data are
;   arranged as RGBx : One Byte Red-Value, one Byte Green-Value, one
;   Byte Blue-Value, one Byte Alpha-Channel (do not use it, if you do not
;   know what you do...). For 1 Bit 0 is here found.

; * rs_Width is the Width of the screen (so the appropiate functions can
;   get to the Width more easy than to look in the E_EScreen structure,
;   but this are all interna of my code, so do not bother about it :) )

; * rs_NumBuf is the number of available Buffers on this screen (between
;   1 and 3).


; * rs_Locks is the number of Locks on a Screen (they are nestable until
;   255 locks... do not lock more, this will confuse my code, but usually
;   one lock should be enough :) )

; STRUCTURE ScreenQuery,0
;   ULONG sq_ScreenMode ; Pointer to the *NAME* of the wanted Screenmode
;   ULONG sq_Width      ; The Width
;   ULONG sq_Height     ; The Height
;   UWORD sq_Depth      ; The color depth
;   ULONG sq_Buffers    ; How many Buffers...
;   ULONG sq_Port       ; An eDCMP Messageport
;   ULONG sq_EdcmpFlags ; The used Edcmp-Flags of the Screen
; LABEL sq_SIZEOF

; Some NOTES :

; * sq_Width and sq_Height have to be *TESTED*, if they contain valid values,
;   using the data structure you get using GetScreenmodes (they are not allowed
;   to contain higher values than in esm_Horiz and esm_Vert).


; * sq_Depth *has to be* 1,8 or 24.

; * sq_Buffers has to be between 1 and 3. A wrong value will cause OpenRtgScreen to fail.

; * sq_Screenmode contains the *ADDRESS* of a string. This string has to be the
:   name of the wished Screenmode (for example 'PICOa:VGA 640x480'). These
;   addresses you can find in the return value of GetScreenmodes. ModeIDs
;   are not needed.
; * As to information about sq_Port and sq_EdcmpFlags, more detailed information
;   will be explained later. At this point only : sq_Port is only a
;   usual pointer to a MessagePort from Exec.library (like the UserPort
;   of a window, but here directly connected to the Screen). If someone
;   does not use IDCMP for the keyboard code in his game, he of course
;   does not need this MessagePort and may specify these two values as 0.
;   If he uses them, he has to provide a correctly initialized MessagePort.

; Some things about keyboard and EGS :

; 1. How do i get the Message Port ?

; You have to provide your own MessagePort to OpenRtgScreen (struct MessagePort of
; exec.library, or a pointer to it, to be exact) using the ScreenQuery structure.
; Following is the data for sq_EdcmpFlags :

; * Corresponding EDCMPFlagSet has 32 bits !
; E_eMOUSEBUTTONS         EQU     1
; E_eMOUSEMOVE            EQU     2
; E_eRAWKEY               EQU     4
; E_eTIMETICK             EQU     8
; E_eDISKINSERTED         EQU     16
; E_eDISKREMOVED          EQU     32
; E_eNEWPREFS             EQU     64

; (like that defined in egs.i. There is *NO* VanillaKey, so all has be done using RAWKEY !!!)

; 2. Getting the Messages from the Port

; A. A usual Wait/WaitPort with the appropriate Parameters
; B. A usual GetMsg that returns a pointer to a
;    E_EGSMessage.

;  STRUCTURE  E_EGSMessage,0
;         STRUCT  ems_Msg,MN_SIZE ; has long word size
;         ULONG   ems_Class
;         UWORD   ems_Code
;         UWORD   ems_Qualifier
;         APTR    ems_IAddress
;         WORD    ems_MouseX
;         WORD    ems_MouseY
;         ULONG   ems_Seconds
;         ULONG   ems_Micros
;         APTR    ems_EdcmpScreen
;         LABEL   ems_SIZEOF

; ( looks well-known, doesn't it ? :) )

; The rest should be no problem...


Now some code to close the egs.library after you are finished...

CloseEGS:
      cmp.l #0,EgsBase
      beq .Exit
      move.l $4,a6
.CloseEGS:
      move.l $4,a6
      move.l EgsBase,a1
      CALLSYS CloseLibrary
.Exit:
      move.l #0,d0
      rts

14. About the different frequencies the following :

(NOTE: Even if you provide *NO* code checking the frequencies needed for a
screenmode, EGS checks itself, if the Screenmode fits on the monitor... of course,
if someone *accepted* wrong values as Screenmodes in spite of the System
warning him, or if he switched the monitor for another monitor, a check
still makes sense...)

NOTE : It is also possible to check the frequencies using the normal Amiga
System, as the EGS Screenmodes appear there too (only 8 Bit Depths of course,
but theay appear...) I am not sure, if the frequencies are correct in the
normal systemlist (i think NOT...), as i never did it this way before...
the normal way is the EGS native method explained below...

But now the "EGS native method" of checking the frequencies ...

A. Find the EGS Screenmode structure in the stuff that GetScreenmodes returns
B. If the structure is (for example) in a0, look at the Array esm_Specs
   (24 ScreenParamPtr of EGS). Look for *THE* pointer that is for the
   color depth for that you want to know the frequencies (the frequencies
   are color depth dependent for EGS). Therefor, the first pointer is
   at the one for color depth 1, the 8th for 256 colors, the 24th for
   24 Bit.
C. Get the values out of the following structure :

struct E_ScreenParam {

       struct  MinNode MinNode;   /* internal chaining, the list is found
                                   * in the associated screen param struct.
                                   */
       WORD            PixFreq;   /* pixel frequency in units of 1/100 MHz */
       WORD            LineFreq;  /* line  frequency in units of 1/100 KHz */
       WORD            FrameFreq; /* frame frequency in units of 1/100  Hz */
       WORD            Pad0;

       ULONG           Flags;     /* ScreenParamFlagSet                    */

       WORD            Hfront;    /* horizontal front porch in ns          */
       WORD            Hsync;     /* horizontal sync in ns                 */
       WORD            Hback;     /* horizontal back porch in ns           */

       WORD            Vfront;    /* vertical front porch in s            */
       WORD            Vsync;     /* vertical sync in s                   */
       WORD            Vback;     /* vertical back porch in s             */
       WORD            Vpre;      /* vertical preequalisation in s        */
       WORD            Vpost;     /* vertical postequalisation in s       */

       E_ScreenSpecPtr Screen;    /* the ruling screen param               */
};

(Sorry, i do not have ASM-Includes for that, but should be easy to convert...)

As to what each value is, i snapped the following out of the EGS includes :

/*
 * Some notes about display and syncing...
 *
 *
 *
 *  +------------------------------------------------+
 *  |###################################     HH      |\
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | \ active vertical
 *  |###################################     HH      | /
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      | |
 *  |###################################     HH      |/
 *  |                                        HH      |\_ vertical \
 *  |                                        HH      | | front     |
 *  |                                        HH      |/  porch     |
 *  |VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV|\_ vertical  | vertical
 *  |VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV|/  sync      \ blank
 *  |                                        HH      |\            /
 *  |                                        HH      | |           |
 *  |                                        HH      | | vertical  |
 *  |                                        HH      | \ back      |
 *  |                                        HH      | / porch     |
 *  |                                        HH      | |           |
 *  |                                        HH      |/           /
 *  +------------------------------------------------+
 *   \____________  ___________________/\  _/\/\_  _/
 *                \/                     \/  |   \/
 *            active horizontal          |   |  horizontal back porch
 *                                       |   |
 *                                       |   \ horizontal sync
 *                                       |
 *                                       \ horizontal front porch
 *
 *                                      \_  ________/
 *                                        \/
 *                                       horizontal blank
 *
 * Pixel timing diagramm:
 *
 *            .   .   .   .   .   .   .   .   .   .   .   .   .   .
 *            ._  ._  ._  ._  ._  ._  ._  ._  ._  ._  ._  ._  ._  ._
 * PClock  :  | | | | | | | | | | | | | | | | | | | | | | | | | | |
 *           _|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.|_|.
 *            .   .   .   .   .   .   .   .__________     .   .   .
 * RGB     :  .   .   .   .   .   .   .___/   .   .  \    .   .   .
 *            .   .   .   .   .   .___/   .   .   .   |   .   ._____
 *            .   .   .___.   .   /   .   .   .   .   |   .   /   .
 *            .   .___/   \   .   |   .   .   .   .   |   .   |   .
 *     black ...../........\_____/.....................\_____/......
 *            .   |   .   .   .   .   .   .   .   .   .   .   .   .
 *     blank ____/.   .   .   .   .   .   .   .   .   .   .   .   .
 *            .   ._________________________________________________
 * DispEn  :  .   |   .   .   .   .   .   .   .   .   .   .   .   .
 *           _____|.................................................
 *            .   .   .   .   .   .   .   .   .   .   .   .   .   .
 *
 * PClock or pixel frequency determines the speed at which pixels are sampled
 * and sent to the DACs.
 *
 *
 *
 *
 * Horizontal timinig diagram:
 *
 *                .                              .    . .     .
 * RGB     :      ##############   ##############.    . .     ######
 *           _____##############...##############_____________######
 *                .______________________________.    . .     ._____
 * DispEn:        |                              |    . .     |
 *           _____|..............................|____________|.....
 *                .                              .    ._.     .
 * HSync   :      .                              .    | |     .
 *           _________________________________________|.|___________
 *                .                              .    . .     .
 * Sync on :      ##############   ##############.    . .     ######
 * green     _____##############...##############_____..._____######
 *                .                              .    |_|     .
 *                .                              .    . .     .
 *
 *                | - active video ------------- | hf | | hb  |
 *                |                              |    hs      |
 *                |                              |            |
 *                |                              | - hblank - |
 *                |                                           |
 *                | - linetime ------------------------------ |
 *
 *   hf      : Horizontal front porch, the time between the end of the
 *             active display to the start of the horizontal sync pulse.
 *             This value controls the size of the right border of a display.
 *
 *   hs      : Horizontal sync, this signal starts the horizontal flyback.
 *
 *   hb      : Horizontal back porch, the time between the and of the
 *             horizontal sync pulse to the start of the next display line.
 *             This value contorls the size of the left border of a display.
 *
 *   hblank  : The full blanking period, from the end of line n to the start
 *             of line n+1. This value controlls the width of the display.
 *             If hf and hb are changed, but hblank kept the same, the display
 *             can be moved to the left or right.
 *
 *   hfreq   : The horizontal line frequency equals 1/linetime
 *
 * Vertical timing diagramm:
 *
 *               .     .     .     .     .     .     .     .     .
 * RGB     : ####. ####. ####.     .     .     .     .     .     . #
 *           ####._####__####______________________________________#
 *           ___ . ___ . ___ . ___ .     .     .     .     .     . _
 * DispEn  :    |.|   |.|   |.|   |.     .     .     .     .     .|
 *           ...|_|...|_|...|_|...|_______________________________|.
 *               .     .     .     .     .     .     .     .     .
 * HSync   :     |     |     |     |  |  |  |  |  |  |     |     |
 *           ____|_____|_____|_____|__|__|__|__|__|__|_____|_____|__
 *               .     .     .     .     ._____.     .     .     .
 * VSync   :     .     .     .     .     |     |     .     .     .
 *           ____________________________|.....|____________________
 *               .     .     .     .     ._____.     .     .     .
 * CSync   :     |     |     |     |     |     |     .     .     |
 *           ____|_____|_____|_____|_____|.....|_________________|__
 *               .     .     .     .     .__ __.     .     .     .
 * CSync   :     |     |     |     |  |  |  |  |  |  |     |     |
 * tesselated____|_____|_____|_____|__|__|..|..|__|__|_____|_____|__
 *               .     .     .     .     .     .     .     .     .
 * CSync on: ####. ####. ####.     .     .     .     .     .     . #
 * green     ####._####._####._____.__ __.......__ __._____._____._#
 *               |     |     |     |  |  |__|__|  |  |     |     |
 *               .     .     .     .     .     .     .     .     .
 *
 *                          |      |vpre |    |vpost|             |
 *                          |                                     |
 *                          | --- vf --- | vs | ----- vb -------- |
 *                          |                                     |
 *           <-- active --- | - vertical blanking period vblank - |->
 *                          |
 *           <------------- | - frametime -------------------------->
 *
 *   vf      : Vertical front porch, the time from the end of the last
 *             active line to the start of the sync signal, controls the
 *             the size of the bottom border of the display
 *
 *   vs      : Vertical sync pulse, start the vertical flyback
 *
 *   vb      : Vertical back porch, the time from the end of the vertical
 *             sync to the start of the next display frame. This value
 *             controls the size of the top border
 *
 *   vpre,
 *   vpost   : Vertical ??serration?? pulses, needed in interlace mode to
 *             sync on a half line
 *
 *   vblank  : The full vertical blanking period this value controls
 *             the vertical size of the display
 *
 *   vfreq   : The vertical frame frequency equals 1/frametime
 *
 *
 */

D. You are able to do the frequency check automatically :

- Get the display driver address out of the EGS Screenmode address (which
  you get using GetScreenmodes)

  struct E_DisplayDriver {

      /* E_EGSObject         Object; */
                                        /* it's an object !!!          */
         struct  Node        Node;      /* internal chaining, the list
                                         * is found in the hardinfo
                                         * structure
                                         */
         WORD                Pad0;

         char               *Prefix;    /* the prefix name of all the
                                         * drivers screenmodes like
                                         * "LEGSa:" or "RB3a:"
                                         */
         ULONG               Depths;    /* supported colordepths, each
                                         * bit represents one depth, so
                                         * 1<<8 stands for eight biz
                                         */
         struct  E_MinMax    Freqs[24]; /* supported pixel frequency
                                         * intervalls for specific color
                                         * depths. (as C does not support
                                         * array starting at one, the
                                         * index is colordepth minus one)
                                         */
         struct MinList      Monitors;  /* supported specs of the attached
                                         * monitor
                                         */
         ULONG               Flags;     /* DisplayDriverFlagSet; */
         char               *Default;   /* the name of the drivers defaults
                                         * file
                                                                            */
         ULONG                  MaxPixel[24];   /* The maxmimum number of pixels
                                         * the graphics device can
                                         * in a given color depth. (As C
                                         * does not support arrays
                                         * starting at one, the index is
                                         * colordepth minus one)
                                         */
         ULONG               MemSize;   /* The size of the onboard memory in
                                         * bytes
                                         */
         UWORD              MouseSize;  /* The maximum mouse size, may be
                                                                         * less for some screenmodes
                                                                     */
         UWORD                      Pad1;
                char                        *description; /* A small text describing the
                                                                             * graphics device
                                                                             */
};

- get the address of the Monitor there (struct MinList Monitors).

struct E_MonitorSpec {

        struct  Node  Node;     /* internal chaining, the list is found in
                                 * the hard info "monitors", the lh_name
                                 * field contains the monitor name
                                 */
        WORD          Pad0;
        struct  List  Screens;  /* list of the supported screenmodes; the
                                 * nodes are of type "E_ScreenSpec"
                                 */
        WORD          Pad1;
        ULONG         Sync;     /* Syncing flags                           */

        WORD          MinHoriz; /* minimum horizontal frequency * 1/100KHz */
        WORD          MaxHoriz; /* maximum horizontal frequency * 1/100KHz */
        WORD          MinVerti; /* minimum vertical frequency  * 1/100Hz  */
        WORD          MaxVerti; /* maximum vertical frequency   * 1/100Hz  */
};

- And now you are able to compare, if the frequencies for the selected Screenmode
  are okay for the connected monitor :)


Includes :

egs.i

      IFND            EGS_EGS_I
EGS_EGS_I       SET     1
*\
*
*  $
*  $ FILE     : egs.i
*  $ VERSION  : 1
*  $ REVISION : 37
*  $ DATE     : 21-Mar-95 18:36
*  $
*  $ Author   : mvk
*  $
*
*
* (c) Copyright 1990/93 VIONA Development
*     All Rights Reserved
* Revision 36 modified by S.P. Huser
* Modified : E_EBitmap, E_EScreen, E_HardInfo,E_ScreenMode
* New      : E_EMinMax, E_EMouseImg, E_MonitorSpec, E_DisplayDriver
* ... because Viona seemed not to be capable to do this themselves...
* The modified structures SHOULD now be V.6 compatible, i really HOPE
* they do not CHANGE anything in this structures in future releases ...
*
*\
        IFND    EXEC_TYPES_I
        INCLUDE "exec/types.i"
        ENDC
        IFND    EXEC_PORTS_I
        INCLUDE "exec/ports.i"
        ENDC

*
*  This library is the basic interface to high resolution graphics cards.
*  The hardware is almost completely encapsulated by this module. It is
*  not allowed to access hardware registers directly.
*
*  The library is designed for full multitasking support. Thus several
*  programs can use the graphics card simultaneously.  Screens can be
*  switched like Intuition screens by pressing the left Amiga key and "S".
*
*  Moreover, a separate mouse pointer is supported.  The Amiga mouse and
*  EGS mouse can be exchanged by pressing the left Amiga key and "A".
*  If the mouse pointer is on the EGS screen, all key codes are redirected
*  to the screen, too.
*
*  EGS screens have a message system on their own so that applications with
*  input processing can lack any window without losing multitasking
*  capabilities.
*

*
*  EMemNode, EMemPtr
*
*  Graphics memory on the card is allocated by the procedure AllocEMem.
*  The memory segments are held in EMemNode list structures.  As graphics
*  cards use almost only big consecutive segments, the EGS libraries possess
*  memory management that can move memory in its address location.  To
*  inhibit memory running away while being used, the EMemNode must be locked
*  by incrementing "lock", e.g. when loading "dest" into any address register.
*  "lock" must be decremented after memory access.  The address of the
*  allocated graphics memory is located in the "dest" field.
*  Only the fields "dest" and "lock" are public, all other fields are
*  strictly private.  Example:
*
*  EMemNode mem;
*  ...
*  mem.lock++;               now mem.dest may be used
*  mem.dest = $AA;
*  ...(further memory accesses)...
*  mem.lock--;               now mem.dest may not be used any longer
*

* To access the "lock" component, you would have to use
*   "mynode.lock.false.lock", which is simply disgusting !
*
* struct E_EMemNode {
*                        APTR Dest;
*                        union {
*                               struct {
*                                       BYTE Lock;
*                                       UBYTE Display;
*                                       } false;
*                               struct {
*                                       UWORD Moveable;
*                                       } true;
*                               } Lock;
*
*                       UWORD Pad_1;
*                       LONG Size;
*                       APTR Next, Prev;
*                  };
*
*   But as "moveable" is private to the EGS library, I just ignore the
*   memory variation.  If you want to test for moveable then test both
*   "lock" and "display".
*
 STRUCTURE  E_EMemNode,0
        APTR    emn_Dest
        BYTE    emn_Lock
        UBYTE   emn_Display
        UWORD   emn_Pad_1
        LONG    emn_Size
        APTR    emn_Next
        APTR    emn_Prev
        LABEL   emn_SIZEOF

*
*  EViewPtr
*
*  Opaque access to a view mode which contains only internal data that is
*  not exported for reasons of compatibility.
*

*
*  CLUEntry, CLU, CLUPtr
*
*  The colour lookup table.  The range of a colour component red, green or
*  blue is 0 to 255, which means all 8 bits are used.  The number of necessary
*  table entries depends on the selected screen depth.  If the CLUT is too
*  short, the missing colours are selected by random.  If no CLUT is
*  specified, a standard CLUT is generated.
*
 STRUCTURE  E_CLUEntry,0
        UBYTE   ece_Red
        UBYTE   ece_Green
        UBYTE   ece_Blue
        UBYTE   ece_Dummy
        LABEL   ece_SIZEOF

*
*  EBitMapPtr, EBitMap
*
*  Basic structure for management of graphics memory.
*
*  As different graphic boards exist which have different memory organisations
*  the egs libraries offer several different bitmap types.
*
*  These are the fields that have the same meaning in any bitmap:
*
*   .Width       : Pixel Width.
*   .Height      : Pixel Height.
*   .BytesPerRow : Number of bytes per row.
*   .Depth       : Number of bits for one pixel; though in 24 bit mode (real)
*                  the number 24 is contained herein, always 32 bits (one
*                  long word) are used.
*
*   .Type        : type of bitmap.
*
*  The different types are:
*
*   E_PIXELMAP      : The memory format is chunky which means that the bits that
*                     build up one pixel lay in adjacent memory locations.
*                     E.g. 2 bits : aabbccdd eeffgghh iijjkkll ...
*                     The organisation in 24 bit is RGBx. This is the native egs
*                     bitmap type. You can allways get an map of these type in
*                     24 bits. The functions in egsblit are allways able to work
*                     with this bitmap and convert from and to other 24 bit
*                     formats, or to other bit depths.
*                     The real location in memory is
*
*                             ..->Typekey.PixelMap.Planes.Dest
*
*                     The memory has to be locked before it is accessed or the
*                     pointer to it, as the libraries are able to move parts
*                     of the graphicsmemory to gain longer fragments.
*                     To lock increment the lock field, to unlock decrement it
*                     again. This lock does not guarantee exclusive access, it
*                     only guarantees, that the bitmap ist not moved.
*
*   E_PIXLACEMAP    : Some graphicsboards have in interlaced an splitted memory
*                     which means that the odd and the even field of the display
*                     reside in different memory locations. The format is the
*                     same as E_pixelMap, with one exception. The even lines
*                     are in one block and the odd lines are in one block. The
*                     starting location of the odd field is
*
*                       ..->Typekey.PixelMap.Planes.Dest+
*                        ..->Typekey.PixelMap.IntDisp
*
*   E_BITPLANEMAP   : The bits that build each pixel are spread over several
*                     bitplanes.
*
*   E_USERMAP       : Nothing is known about the structure of the frame store.
*
*   E_PIXELMAP_xRGB : Same as E_PIXELMAP, exept that the format in 24 bit is
*                     xRGB and not RGBx.
*
*  Your programms should be able to handle at least the E_PIXELMAP format. If
*  it can't handle the format it is given, use the routines of the
*  egsblit.library.
*  If you need a bitmap for double buffering you should use the bitmap from
*  your screen as friend bitmap and the flag E_EB_DISPLAYABLE.
*
*

*
*
*  Enumeration type for access to union fields
*
*
E_PIXELMAP              EQU     0
E_PIXLACEMAP            EQU     1
E_BITPLANEMAP           EQU     2
E_USERMAP               EQU     3
E_PIXELMAP_xRGB         EQU     4
E_EB_DISPLAYABLE        EQU     1
E_EB_BLITABLE           EQU     2
E_EB_SWAPABLE           EQU     4
E_EB_NOTSWAPABLE        EQU     8
E_EB_CLEARMAP           EQU     16

 STRUCTURE  E_EBitMap,0
        WORD    ebm_Width
        WORD    ebm_Height
        UWORD   ebm_BytesPerRow
        BYTE    ebm_Depth
        UBYTE   ebm_Type

* Enumeration type descriptor for access to union fields

        APTR    ebm_Plane
        BYTE    ebm_Lock
        UBYTE   ebm_Display
        UWORD   ebm_Pad0
        ULONG   ebm_Pad1

        STRUCT  ebm_BitPlanes,24*4  ; because Ptr size is 4 Bytes
                                    ; in C BitPlanes[24]
        APTR    ebm_Colors
        ULONG   ebm_Flags
        APTR    ebm_Class
        LABEL   ebm_SIZEOF

*
*               union {
*
*                       struct {
*                               struct   E_EMemNode Planes;
*                                ULONG             IntDisp;
*                              } PixelMap;
*
*                       struct {
*                               APTR   BitPlanes [24];
*                              } BitPlaneMap;
*
*                       struct {
*                               APTR   Action;
*                               } UserMap;
*
*                       } Typekey;
*                 };
*

* Access example:
*
*    E_EBitMapPtr Ptr;
*    APTR Plane, Otherplane;
*
*    if (Ptr->Type == E_BITPLANEMAP)
*      {
*      Plane = Ptr->Typekey.BitPlaneMap.BitPlanes[someindex];
*      }
*    if (Ptr-Type == E_PIXELMAP)
*      {
*      Otherplane = Ptr->Typekey.PixelMap.Planes.Dest;
*      }
*
*

*
*  SoftMousePtr, SoftMouse, HardMousePtr, HardMouse
*
*  Data block for the mouse pointer. Three colours can be used. The bits of
*  a pixel are consecutive as usually, the combination %00 represents a
*  transparent pixel.
*
*  The maximum size of a software mouse pointer is 32 by 32 pixels.  A hard-
*  ware mouse pointer can have up to 64 by 64 pixels but that would exceed
*  the processor capabilities during emulation.
*
*
*  EMouse, EMousePtr
*
*  Definition structure for a mouse pointer.  Each screen can have only one
*  mouse pointer at any moment.  When switching screens, the pointer is
*  changed adequately.  A screen's mouse pointer can be altered by a function
*  at any time.
*
*  For graphics cards without a hardware pointer a pointer is emulated by
*  software.  Specified HardMouse structures are used only if a hardware
*  pointer was implemented, too.  If .soft = NIL then the HardMouse structure
*  is converted into a SoftMouse structure automatically.
*
*   .Color1       : Colour for %01
*   .Color2       : Colour for %10
*   .Color3       : Colour for %11.
*                   These colours are supported only for 4 bit mode and higher.
*   .XSpot,
*   .YSpot        : Displacement of the mouse pointer's click pixel.
*   .Width,
*   .Height       : Width and Height of the SoftMouse.
*   .Soft         : Pointer to SoftMouse structure, should always be initia-
*                   lized for reasons of compatibility.
*   .Hard         : Pointer to HardMouse structure; if you always want to use
*                   the small mouse pointer this field should be NIL.
*
*  Example: The standard mouse pointer.
*
*    StdMouse= EMouse:(Color1=$00000001,Color2=$FF0000FF,Color3=$80000080,
*                      XSpot=1,YSpot=1,Width=25,Height=31,
*                      Soft=SoftMouse:(
*   (%01010101000000000000000000000000,%00000000000000000000000000000000),
*   (%01111111010101010000000000000000,%00000000000000000000000000000000),
*   (%01111010111111110101010100000000,%00000000000000000000000000000000),
*   (%01111111101010101111111101010101,%00000000000000000000000000000000),
*   (%00011111111110101010101011110100,%00000000000000000000000000000000),
*   (%00011111111111111110101011010000,%00000000000000000000000000000000),
*   (%00011111111111111111111101000000,%00000000000000000000000000000000),
*   (%00011111111111111111110100000000,%00000000000000000000000000000000),
*   (%00010111111111111111101101000000,%00000000000000000000000000000000),
*   (%00000111111111111111111011010100,%00000000000000000000000000000000),
*   (%00000111111111111111111110111101,%00000000000000000000000000000000),
*   (%00000111111111011111111111101111,%01000000000000000000000000000000),
*   (%00000101111101010111111111111011,%11010100000000000000000000000000),
*   (%00000001110101010101111111111110,%10111101000000000000000000000000),
*   (%00000001010101010101111111111111,%11101011010000000000000000000000),
*   (%00000001010101010101011111111111,%11111010110101000000000000000000),
*   (%00000001010101010101010111111111,%11111111101111010000000000000000),
*   (%00000001010101010101010101111111,%11111111111101000000000000000000),
*   (%00000001010101010101010101111111,%11111111010100000000000000000000),
*   (%00000000010101010001010101011111,%11111101000000000000000000000000),
*   (%00000000010101000000010101010111,%11110101010000000000000000000000),
*   (%00000000010100000000010101010101,%11110101010100000000000000000000),
*   (%00000000010000000000000101010101,%11010101010101010000000000000000),
*   (%00000000000000000000000001010101,%01010101010101010100000000000000),
*   (%00000000000000000000000000010101,%01010101010101010000000000000000),
*   (%00000000000000000000000000010101,%01010101010101000000000000000000),
*   (%00000000000000000000000000000101,%01010101010000000000000000000000),
*   (%00000000000000000000000000000001,%01010101000000000000000000000000),
*   (%00000000000000000000000000000000,%01010101000000000000000000000000),
*   (%00000000000000000000000000000000,%01010100000000000000000000000000),
*   (%00000000000000000000000000000000,%00010000000000000000000000000000),
*   (%00000000000000000000000000000000,%00000000000000000000000000000000))'PTR);
*

 STRUCTURE E_ClipRect,0
        APTR    ecr_Next
        WORD    ecr_Left
        WORD    ecr_Top
        WORD    ecr_Right
        WORD    ecr_Bottom
        LABEL   ecr_SIZEOF

 STRUCTURE E_EMouseImg,0
        BYTE    emi_width
        BYTE    emi_height
        BYTE    emi_xSpot
        BYTE    emi_ySpot
        LABEL   emi_SIZEOF

 STRUCTURE  E_EMouse,0
        LONG    emo_Color1
        LONG    emo_Color2
        LONG    emo_Color3
        WORD    emo_XSpot
        WORD    emo_YSpot
        WORD    emo_Width
        WORD    emo_Height
        APTR    emo_Soft
        APTR    emo_Hard
        LABEL   emo_SIZEOF

*
*  EScrFlags, EScrFlagSet, EScreen, EScreenPtr, NewEScreen...
*
*  EScreens are structures with capabilities as follows:
*   - Management of resolution mode (EViewPtr)
*   - Management of graphics memory (EBitMap)
*   - Message system for user input
*  Please note that an EScreen is different from the EGSIntui screens, i.e.
*  NO window can be opened on any EScreen; for that purpose an EGSIntui screen
*  must be created.
*
*  EScrFlags
*     SCREENBEHIND : The new screen is opened behind all other screens.
*     OWNBITMAP    : The screen has a user defined BitMap.
*     LACESCREEN   : The screen is to be opened as interlaced to decrease
*                    video line frequency in spite of knowing the flicker
*                    (currently without meaning).
*
*  NewEScreen
*   .Mode          : Name of the selected video mode ending with a null byte.
*   .Depth         : Required bit depth (1, 2, 4, 6, 8, 12, 16 or 24).
*                    Allowed pixel depths depend on the underlying hardware,
*                    and may vary for different screen modes. The suggested
*                    way to retrieve data for supported modes and depths is
*                    by the use of 'E_GetHardInfo'.
*   .Colors        : An own CLUT if required; if NIL the standard CLUT is used.
*   .Map           : Possibly a user BitMap which has to be allocated
*                    previously.
*   .Flags         : Flags for the new screen (only "SCREENBEHIND").
*   .Mouse         : Possibly a user mouse pointer.
*   .EdcmpFlags    : Messages to be sent.
*   .Port          : Possibly an application message port; must be removed
*                    before closing the screen (or crash).
*

* Corresponding EScrFlagSet has 32 bits !
E_SCREENBEHIND          EQU     1
E_OWN_BITMAP            EQU     2
E_LACESCREEN            EQU     4

 STRUCTURE  E_NewEScreen,0
        APTR    ens_Mode
        UWORD   ens_Depth
        UWORD   ens_Pad_1
        APTR    ens_Colors
        APTR    ens_Map
        ULONG   ens_Flags
        APTR    ens_Mouse
        ULONG   ens_EdcmpFlags
        APTR    ens_Port
        LABEL   ens_SIZEOF

*
*  EScreen
*   .Prev,
*   .Next          : Internal chaining.
*   .View          : !!!! PRIVATE !!!!
*   .Map           : Pointer to the screen's BitMap structure.
*   .Colors        : !!!! PRIVATE !!!!
*   .Mouse         : EMouse structure (READ ONLY !!!!).
*   .MouseOn       : !!!! PRIVATE !!!!
*   .EdcmpFlags    : Message flags (READ ONLY !!!).
*   .Port          : Screen's message port.
*   .BackLink      : Link field for users, e.g. used by EGSIntui.
*   .MouseX,
*   .MouseY        : Always the current mouse position on the screen.
*
 STRUCTURE  E_EScreen,0

        STRUCT  esc_Node,MLN_SIZE
        APTR    esc_View
        APTR    esc_Map
        APTR    esc_Colors
        APTR    esc_Mouse
        ULONG   esc_Flags
        UBYTE   esc_MouseOn
        UBYTE   esc_Pad_1
        UBYTE   esc_Pad_2
        UBYTE   esc_Pad_3
        ULONG   esc_EdcmpFlags
        APTR    esc_Port
        APTR    esc_BackLink
        WORD    esc_MouseX
        WORD    esc_MouseY
        APTR    esc_EIScreen
        STRUCT  esc_Off,ecr_SIZEOF
        APTR    esc_ModeName
        STRUCT  esc_MouseImg,emi_SIZEOF
        LABEL   esc_SIZEOF

*
*  EDCMPFlags, EDCMPFlagSet, EGSMsgPtr, EGSMessage
*
*  Structures for the message system working on the EScreen level.  Thus
*  mouse and character input can be gained without opening a window.
*
*  EDCMPFlags:
*    eMOUSEBUTTONS  : Mouse buttons were pressed
*    eMOUSEMOVE     : Mouse was moved
*    eRAWKEY        : Key code from the keyboard
*    eINTUITICK     : Timer is calling
*    eDISKINSERTED  : Disk was inserted
*    eDISKREMOVED   : Disk was removed
*    eNEWPREFS      : Preferences have been changed
*
*   .Class          : Type of the message
*   .Code           : Message code (refer to  "InputEvents")
*   .Qualifier      : Message code (refer to  "InputEvents")
*   .IAddress       : (For E_eRAWKEY: Pointer to deadkey array )
*   .MouseX,
*   .MouseY         : Mouse position
*   .Second,
*   .Micros         : Event time
*   .EdcmpScreen    : Screen sending the message
*

* Corresponding EDCMPFlagSet has 32 bits !
E_eMOUSEBUTTONS         EQU     1
E_eMOUSEMOVE            EQU     2
E_eRAWKEY               EQU     4
E_eTIMETICK             EQU     8
E_eDISKINSERTED         EQU     16
E_eDISKREMOVED          EQU     32
E_eNEWPREFS             EQU     64

 STRUCTURE  E_EGSMessage,0
        STRUCT  ems_Msg,MN_SIZE
                                ; has long word size
        ULONG   ems_Class
        UWORD   ems_Code
        UWORD   ems_Qualifier
        APTR    ems_IAddress
        WORD    ems_MouseX
        WORD    ems_MouseY
        ULONG   ems_Seconds
        ULONG   ems_Micros
        APTR    ems_EdcmpScreen
        LABEL   ems_SIZEOF

*
*  ScreenMode, ScreenModePtr
*
*  Information on supported screen modes and depths. The list including
*  these modes is found by 'GetHardInfo'.
*
*   .ln_Name : The name of the mode, for use in 'E_OpenScreen' ...
*   .Horiz     : The horizontal resolution
*   .Vert      : The vertical resolution
*   .Depths    : The supported pixel depths in this mode. Each depth is
*                represented in one bit. E.g. (1<<24) & mode->depths for
*                24 bit.
*
 STRUCTURE  E_ScreenMode,0
        STRUCT  esm_Node,LN_SIZE
        UWORD   esm_Horiz
        UWORD   esm_Vert
        UWORD   esm_Pad
        ULONG   esm_Depths
        APTR    esm_Driver
        STRUCT  esm_Specs,24*4
        LABEL   esm_SIZEOF

*
*  To realize the highest possible compatibility between different graphics
*  cards, the library must offer a function giving information about the
*  current card plugged in.  Among these information items are the resolutions
*  that the card implements.
*  That task is carried out by the HardInfo structure and the procedure
*  "GetHardInfo".
*

* Corresponding HardInfoFlagSet has 32 bits !

E_HARD_BLITTER                  EQU     1
E_HARD_BOOTROM                  EQU     2
E_HARD_VBLANK                   EQU     4
E_HARD_REALMODE                 EQU     8
E_HARD_GAMMACORRECT             EQU     16
E_HARD_PLANES                   EQU     32

 STRUCTURE E_MonitorSpec,0
        STRUCT emss_Node,LN_SIZE
        WORD   emss_Pad0
        STRUCT emss_Screens,LH_SIZE
        WORD   emss_Pad1
        ULONG  emss_Sync
        WORD   emss_MinHoriz
        WORD   emss_MaxHoriz
        WORD   emss_MinVerti
        WORD   emss_MaxVerti
        LABEL  emss_SIZEOF

 STRUCTURE E_MinMax,0
        WORD   emm_min
        WORD   emm_max
        LABEL  emm_SIZEOF

 STRUCTURE E_DisplayDriver,0
        STRUCT edd_Node,LN_SIZE
        WORD   edd_Pad0
        APTR   edd_Prefix
        ULONG  edd_Depths
        STRUCT edd_Freqs,24*emm_SIZEOF
        STRUCT edd_Monitors,MLN_SIZE
        ULONG  edd_Flags
        APTR   edd_Default
        STRUCT edd_MaxPixel,24*4
        ULONG  edd_MemSize
        UWORD  edd_MouseSize
        UWORD  edd_Pad1
        APTR   edd_description
        LABEL  edd_SIZEOF

 STRUCTURE  E_HardInfo,0
        APTR    ehi_Product
        APTR    ehi_Manufact
        APTR    ehi_Name
        WORD    ehi_Version
        WORD    ehi_MaxFreq
        ULONG   ehi_Flags
        APTR    ehi_Modes
        WORD    ehi_ActPixClock
        WORD    ehi_frameTime
        APTR    ehi_MemBase
        LONG    ehi_MemSize
        APTR    ehi_LibDate
        APTR    ehi_Drivers
        APTR    ehi_Monitors
        APTR    ehi_VideoNodes
        APTR    ehi_Screen
        LABEL   ehi_SIZEOF

        ENDC  ; EGS_EGS_H

lvo/lvo_egs.i :


       IFND            LVO_EGS_I
LVO_EGS_I       SET     1
*
*  $
*  $ FILE     : lvo_egs.i
*  $ VERSION  : 1
*  $ REVISION : 2
*  $ DATE     : 21-Mar-95 20:46
*  $
*  $ Author   : mvk
*  $
*
*
* (c) Copyright 1990/93 VIONA Development
*     All Rights Reserved
* Modified Revision 1 by S.P. Huser
* Because Viona was not capable to do this themselves...
*
*

_LVOE_OpenScreen                EQU     -30
_LVOE_CloseScreen               EQU     -36
_LVOE_MouseOn                   EQU     -42
_LVOE_MouseOff                  EQU     -48
_LVOE_ModifyMouse               EQU     -54
_LVOE_ScreenToFront             EQU     -60
_LVOE_ScreenToBack              EQU     -66
_LVOE_ActivateEGSScreen         EQU     -72
_LVOE_ActivateAmigaScreen       EQU     -78
_LVOE_SetRGB8                   EQU     -84
_LVOE_ModifyEDCMP               EQU     -90
_LVOE_Private0                  EQU     -96
_LVOE_Private1                  EQU     -102
_LVOE_Private2                  EQU     -108
_LVOE_Private3                  EQU     -114
_LVOE_Private4                  EQU     -120
_LVOE_Private5                  EQU     -126
_LVOE_DisposeBitMap             EQU     -132
_LVOE_ClearBitMap               EQU     -138
_LVOE_SetMouseExcept            EQU     -144
_LVOE_ResetMouseExcept          EQU     -150
_LVOE_GetRGB8                   EQU     -156
_LVOE_Private6                  EQU     -162
_LVOE_FlipMap                   EQU     -168
_LVOE_SetRGB8CM                 EQU     -174
_LVOE_GetHardInfo               EQU     -180
_LVOE_GetRGB8CM                 EQU     -186
_LVOE_OldWaitTOF                EQU     -192
_LVOE_AllocBitMap               EQU     -198
_LVOE_CreateEMemPool            EQU     -204
_LVOE_DeleteEMemPool            EQU     -210
_LVOE_AllocEMemPool             EQU     -216
_LVOE_FreeEMemPool              EQU     -222
_LVOE_ObtainPublicClass         EQU     -228
_LVOE_AddPublicClass            EQU     -234
_LVOE_GetSymbol                 EQU     -240
_LVOE_AddMethod                 EQU     -246
_LVOE_CreateSubClass            EQU     -252
_LVOE_Dispatch                  EQU     -258
_LVOE_isSubClass                EQU     -264
_LVOE_SendEGSMsg                EQU     -270
_LVOE_AllocBitMapFrame          EQU     -276
_LVOE_DisposeBitMapFrame        EQU     -282
_LVOE_AllocBitMapClass          EQU     -288
_LVOE_MoveMouse                 EQU     -294
_LVOE_AddPublicVideoNode        EQU     -300
_LVOE_AddVideoLink              EQU     -306
_LVOE_RemVideoLink              EQU     -312
_LVOE_LockEGSVideo              EQU     -318
_LVOE_UnlockEGSVideo            EQU     -324
_LVOE_SetUserFocus              EQU     -330
_LVOE_CrossMouseBorder          EQU     -336
_LVOE_AddScreenMode             EQU     -342
_LVOE_WaitTOF                   EQU     -348
_LVOE_WhichScreen               EQU     -354
_LVOE_WhichMonitor              EQU     -360
_LVOE_CanDisplayOnMonitor       EQU     -366
_LVOE_CreateObject              EQU     -372
_LVOE_DeleteObject              EQU     -378
_LVOE_FindPublicVideoNode       EQU     -384
_LVOE_NewMapType                EQU     -390
_LVOE_Private7                  EQU     -396
_LVOE_MouseOffRect              EQU     -402
_LVOE_ObtainClass               EQU     -408
_LVOE_ReleaseClass              EQU     -414
_LVOE_ObtainObjectClass         EQU     -420
_LVOE_GetSymName                EQU     -426
_LVOE_AddClassMethod            EQU     -432
_LVOE_DispatchClass             EQU     -438
_LVOE_GetClassMethod            EQU     -444
_LVOE_isSubType                 EQU     -450
_LVOE_CreateMonitorSpecTagList  EQU     -456
_LVOE_ChangeMonitorSpecTagList  EQU     -462
_LVOE_SaveMonitorSpec           EQU     -468
_LVOE_ObtainMonitorSpec         EQU     -474
_LVOE_ReleaseMonitorSpec        EQU     -480
_LVOE_DeleteMonitorSpec         EQU     -486
_LVOE_RenameMonitorSpec         EQU     -492
_LVOE_CreateScreenSpecTagList   EQU     -498
_LVOE_DeleteScreenSpec          EQU     -504
_LVOE_ChangeScreenSpecTagList   EQU     -510
_LVOE_ObtainScreenSpec          EQU     -516
_LVOE_ReleaseScreenSpec         EQU     -522
_LVOE_CreateScreenParamTagList  EQU     -528
_LVOE_DeleteScreenParam         EQU     -534
_LVOE_ChangeScreenParamTagList  EQU     -540
_LVOE_GetRealTimings            EQU     -546
_LVOE_AddMonitorSpec            EQU     -552
_LVOE_RemMonitorSpec            EQU     -558
_LVOE_SaveMonitorPrefs          EQU     -564
_LVOE_LoadMonitorPrefs          EQU     -570
_LVOE_OpenScreenTagList         EQU     -576
_LVOE_DefinePublicObject        EQU     -582
_LVOE_ObtainPublicObject        EQU     -588
_LVOE_LoadDriver                EQU     -594
_LVOE_ReloadPrefs               EQU     -600
_LVOE_ReleasePublicObject       EQU     -606
_LVOE_ObtainObject              EQU     -612
_LVOE_CreateObjectMsg           EQU     -618
ENDC  * LVO_EGS_I

