@ECHO OFF
REM =========================================================================
REM Batch file installer for Printer Settings Program
REM For English (US)
REM Copyright(c) Hewlett-Packard Company, 1995
REM =========================================================================
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM          Must check the existence of the files before continuing
REM      if install.bat is not run from the installer disk, report error
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
IF NOT EXIST install.bat  GOTO INSTERROR
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM check the existence of files which are not country dependent
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
IF NOT EXIST pcp\djpmenu.ex_  GOTO FILEMISSING
IF NOT EXIST pcp\expand.exe   GOTO FILEMISSING
IF NOT EXIST pcp\font1.da_    GOTO FILEMISSING
IF NOT EXIST pcp\font2.da_    GOTO FILEMISSING
IF NOT EXIST pcp\hplogo.bat   GOTO FILEMISSING
IF NOT EXIST pcp\hpask.com    GOTO FILEMISSING
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM check the existence of other files
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
IF NOT EXIST pcp\djptxt.us_   GOTO FILEMISSING
IF NOT EXIST pcp\resource.us_ GOTO FILEMISSING
IF NOT EXIST pcp\usa          GOTO FILEMISSING
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM start the installation process
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
:NOPORT
CALL PCP\HPLOGO.BAT
ECHO     Ŀ
ECHO           The DJPMenu configuration utility allows you to change       
ECHO           or define the settings on your HP DeskJet Portable           
ECHO           printers.                                                    
ECHO                                                                        
ECHO           Before installing DJPMenu, ensure that the printer           
ECHO           is connected to the parallel port of your computer           
ECHO           and POWERED on.                                              
ECHO     
ECHO 
ECHO            Which parallel port is the printer connected to?
ECHO 
ECHO            [1]  LPT1:             [2]  LPT2:             [3]  LPT3:
ECHO 
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Ask the user which port is the printer connected to.
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PCP\HPASK "           Enter Printer Port Choice (1-3):"
IF ERRORLEVEL 52 GOTO NOPORT
IF ERRORLEVEL 51 GOTO PORT3
IF ERRORLEVEL 50 GOTO PORT2
IF ERRORLEVEL 49 GOTO PORT1
GOTO NOPORT
:PORT3
SET PORT=LPT3:
GOTO NEXT1
:PORT2
SET PORT=LPT2:
GOTO NEXT1
:PORT1
SET PORT=LPT1:
:NEXT1
CALL PCP\HPLOGO.BAT
ECHO     Ŀ
ECHO            The files will be copied to C:\DESKJET. The required        
ECHO            disk space is less than 100 Kbytes.                         
ECHO     
ECHO 
ECHO             You have chosen %PORT% as the parallel port.
ECHO             If the port selection is wrong, you can quit the
ECHO             installation by pressing Ctrl-C.
ECHO 
ECHO Ctrl-C to quit, or
PAUSE
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Inform user that the files will be expanded in C:\DESKJET directory.
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
CALL PCP\HPLOGO.BAT
ECHO Installing ...

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM If c:\deskjet directory does not exist, create it.
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
IF NOT EXIST c:\deskjet\nul GOTO NODIR
GOTO DIROK
:NODIR
ECHO Creating directory C:\DESKJET
MKDIR c:\deskjet
:DIROK

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Copy resource string over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ECHO Exploding RESOURCE in C:\DESKJET
IF EXIST c:\deskjet\resource DEL c:\deskjet\resource
pcp\expand pcp\resource.us_ c:\deskjet\resource > nul

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Copy font?.dat over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ECHO Exploding FONT?.DAT in C:\DESKJET
IF EXIST c:\deskjet\font1.dat DEL c:\deskjet\font1.dat
pcp\expand -r pcp\font1.da_ c:\deskjet > nul
IF EXIST c:\deskjet\font2.dat DEL c:\deskjet\font2.dat
pcp\expand -r pcp\font2.da_ c:\deskjet > nul
 
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Copy djpmenu.txt over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ECHO Exploding DJPMENU.TXT in C:\DESKJET
IF EXIST c:\deskjet\djpmenu.txt DEL c:\deskjet\djpmenu.txt
pcp\expand pcp\djptxt.us_ c:\deskjet\djpmenu.txt > nul

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Copy djpmenu.exe over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ECHO Exploding DJPMENU.EXE in C:\DESKJET
IF EXIST c:\deskjet\djpmenu.exe DEL c:\deskjet\djpmenu.exe
pcp\expand -r pcp\djpmenu.ex_ c:\deskjet > nul

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Copy country defaults over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ECHO Configuring the Country Default Settings of the printer
copy pcp\usa %PORT% /b > nul
set PORT=
PAUSE

REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Check all the necessary files have been copied over to C:\DESKJET
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
IF NOT EXIST c:\deskjet\djpmenu.exe  GOTO NOTCOMPLETE
IF NOT EXIST c:\deskjet\djpmenu.txt  GOTO NOTCOMPLETE
IF NOT EXIST c:\deskjet\resource     GOTO NOTCOMPLETE
IF NOT EXIST c:\deskjet\font1.dat    GOTO NOTCOMPLETE
IF NOT EXIST c:\deskjet\font2.dat    GOTO NOTCOMPLETE
CALL PCP\HPLOGO.BAT
ECHO     Ŀ
ECHO         The installation is completed.                                 
ECHO                                                                        
ECHO         Refer to the DJPMENU.TXT file in the directory C:\DESKJET      
ECHO         for information on using DJPMenu and its functions.            
ECHO         To run DJPMenu, type DJPMENU at the prompt C:\DESKJET.         
ECHO         You can also alter your AUTOEXEC.BAT to include C:\DESKJET     
ECHO         in the path.                                                   
ECHO                                                                        
ECHO         Also, check that the country default setting in the            
ECHO         Advanced Settings menu of DJPMenu is set to United States.     
ECHO         For HP DeskJet Portable, HP DeskJet 310 and HP DeskJet 320     
ECHO         the country default selected will only be activated after       
ECHO         the printer is reset (press the Online and Setup keys while     
ECHO         powering up the printer).                                      
ECHO     
ECHO 
GOTO END
:NOTCOMPLETE
CALL PCP\HPLOGO.BAT
ECHO     Ŀ
ECHO           One or more files was not copied properly. This may be       
ECHO           due to insufficient disk space on drive C. Clear             
ECHO           some disk space on drive C and run the installation          
ECHO           program again.                                               
ECHO     
ECHO 
GOTO END
:INSTERROR
CLS
ECHO     Ŀ
ECHO                                 ** ERROR **                            
ECHO                                                                        
ECHO             You must run INSTALL from the installation disk.           
ECHO             Insert the disk in drive A:, change to drive A:              
ECHO             and type INSTALL.                                          
ECHO     
ECHO 
GOTO END
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
REM Error message to inform the user that he/she might accientally delete
REM file(s) from the installer disk which is/are important.
REM =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
:FILEMISSING
ECHO     Ŀ
ECHO                                 ** ERROR **                            
ECHO                                                                        
ECHO              Some files are missing from your installation disk.       
ECHO              Contact your nearest HP support center for a              
ECHO              replacement disk.                                         
ECHO     
ECHO 
:END
