<html>
<head>
<title>WAIS Document Retrieval</title>
</head>
<body>
<pre>
[Federal Register: December 15, 1995 (Volume 60, Number 241)]
[Proposed Rules ]               
[Page 64475-64524]
From the Federal Register Online via GPO Access [wais.access.gpo.gov]



[[Page 64475]]

_______________________________________________________________________

Part II





Department of Education





_______________________________________________________________________



34 CFR Part 361



The State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program; Proposed Rule


[[Page 64476]]


DEPARTMENT OF EDUCATION

34 CFR Part 361

RIN 1820-AB12

 
The State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program

AGENCY: Department of Education.

ACTION: Notice of proposed rulemaking.

-----------------------------------------------------------------------

SUMMARY: The Secretary proposes to amend the regulations governing The 
State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program. These amendments are 
needed to implement changes to the <strong>Rehabilitation</strong> Act of 1973 (Act) 
made by the <strong>Rehabilitation</strong> Act Amendments of 1992, enacted on October 
29, 1992, as amended by the 1993 technical amendments (hereinafter 
collectively referred to as the 1992 Amendments).

DATES: Comments must be received on or before February 23, 1996.

ADDRESSES: All comments concerning these proposed regulations should be 
addressed to Fredric K. Schroeder, U.S. Department of Education, 600 
Independence Avenue SW., Room 3028, Mary E. Switzer Building, 
Washington, D.C. 20202-2531. Comments transmitted by facsimile should 
be sent to (202) 205-9772. Comments can be transmitted in an electronic 
format either through the electronic bulletin board system (BBS) of the 
<strong>Rehabilitation</strong> Services Administration (RSA) or through internet. The 
internet address is ``State__VR@ed.gov''. The access number for the RSA 
BBS is (202) 205-5574 for low speed (2400 BPS or lower) modems and 
(202) 205-6174 for high speed (9600 BPS and higher) modems. Comments 
can also be transmitted to the RSA BBS through Fedworld via internet 
using the telnet command. Telnet to: ``Fedworld.gov''. All comments 
transmitted in an electronic format should be sent to the following RSA 
BBS mailbox: ``RSADPPES''. To facilitate the analysis of comments, 
electronic transmission of comments is preferred. Also, comments should 
be specific and identified by proposed regulatory citation. Comments 
received by RSA after the due date for comments will not be considered.
    A copy of any comments that concern information collection 
requirements should also be sent to the Office of Management and Budget 
at the address listed in the Paperwork Reduction Act section of this 
preamble.

FOR FURTHER INFORMATION CONTACT: Beverlee Stafford, U.S. Department of 
Education, 600 Independence Avenue SW., Room 3014, Mary E. Switzer 
Building, Washington, D.C. 20202-2531. Telephone (202) 205-8831. 
Individuals who use a telecommunications device for the deaf (TDD) may 
call (202) 205-5538.

SUPPLEMENTARY INFORMATION: The State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services 
Program (program) is authorized by Title I of the Act (29 U.S.C. 701-
744). This program provides support to each State to assist it in 
operating a comprehensive, coordinated, effective, efficient, and 
accountable State program to assess, plan, develop, and provide 
<strong>vocational</strong> <strong>rehabilitation</strong> (VR) services to individuals with 
disabilities so that those individuals may prepare for and engage in 
gainful employment, consistent with their strengths, resources, 
priorities, concerns, abilities, capabilities, and informed choice. The 
program supports the National Education Goal that, by the year 2000, 
every adult American, including individuals with disabilities, will 
possess the knowledge and skills necessary to compete in a global 
economy and exercise the rights and responsibilities of citizenship.
    Regulations for this program were last published in their entirety 
on May 12, 1988 (53 FR 16978) to implement the 1986 amendments to the 
Act and are codified in 34 CFR Part 361. In addition, a notice of 
proposed rulemaking (NPRM) for this program was published on July 3, 
1991 (56 FR 30620) (1991 NPRM), but it was never finalized.
    In the 1991 NPRM, the Secretary proposed amendments to the 
regulations for this program that were designed to reduce regulatory 
burden on States and to place greater administrative discretion at the 
State level. More specifically, the 1991 NPRM proposed to remove or 
reduce certain State plan, paperwork, and reporting requirements not 
mandated by statute, to clarify the regulations through more precise 
definitions, and generally to simplify and condense the regulations. At 
the request of the Congress, the proposed regulations in the 1991 NPRM 
were not finalized because the <strong>Rehabilitation</strong> Act Amendments of 1992 
were being developed at that time.
    The 1992 Amendments made extensive changes to Title I of the Act 
that have far-reaching implications for the program. One of the major 
themes of the 1992 Amendments is the empowerment of individuals with 
disabilities in terms of influence on the State plan and State 
<strong>vocational</strong> <strong>rehabilitation</strong> policy through membership on the State 
<strong>Rehabilitation</strong> Advisory Council or an independent commission and 
increased participation in the development, implementation, and 
evaluation of their individualized written <strong>rehabilitation</strong> programs 
through informed choice. The statute also requires that designated 
State units (DSUs) provide for the use of appropriate modes of 
communication and accessible formats to ensure equal access for 
individuals with disabilities who need this assistance.
    A related theme is the integration of individuals with disabilities 
into the full spectrum of American life. The 1992 Amendments requires 
both that <strong>vocational</strong> <strong>rehabilitation</strong> services be provided in the most 
integrated settings possible and that employment outcomes be in the 
most integrated settings possible.
    Another key theme of the 1992 Amendments is to improve access to 
the <strong>vocational</strong> <strong>rehabilitation</strong> system. The amendments streamline the 
process for making eligibility determinations by requiring the use of 
existing information to the extent possible, by adding a presumption of 
benefit from services, and by providing a 60-day time limit for making 
eligibility determinations.
    The 1992 Amendments also focuses on expanding and improving the 
quality of services by requiring States to develop a strategic plan, by 
requiring States to develop a comprehensive system of personnel 
development to ensure that DSU personnel are adequately trained and 
meet the State's highest standards, and by requiring the development of 
standards and indicators to evaluate the performance of State programs. 
The evaluation standards and performance indicators are being developed 
separately and are not addressed in this NPRM.
    Finally, the 1992 Amendments focuses on expanding and improving 
services to certain groups of individuals with disabilities. The 
amendments include new order of selection and eligibility provisions 
that are designed to increase and improve services for individuals with 
severe disabilities, particularly individuals with the most severe 
disabilities. The amendments also contain new outreach requirements 
that are designed to increase services to individuals with disabilities 
who are members of groups that are currently unserved and underserved, 
including members of minority groups. In addition, the amendments 
contain provisions that are designed to increase coordination between 
education agencies and DSUs to better serve individuals with 
disabilities who are transitioning students.
    This NPRM proposes changes to implement the 1992 Amendments to 
Title I Parts A, B, and C of the Act (with the exception of the 
strengthened order 

[[Page 64477]]
of selection requirements in sections 12(d) and 101(a)(5)(A) of the 
Act, the evaluation standards and performance indicator requirements in 
section 106 of the Act, and the client assistance program requirements 
in section 112 of the Act, which are being implemented in separate 
rulemaking documents) and proposes to incorporate some of the changes 
that were previously proposed in the 1991 NPRM to reduce the 
administrative burden on States. This NPRM also proposes other changes 
that the Secretary believes are important to update, consolidate, 
clarify, and in other ways improve the regulations for this program.
    Executive Order 12866 encourages Federal agencies to facilitate 
meaningful participation in the regulatory development process. 
Accordingly, prior to drafting this NPRM, RSA, on March 31, 1994, made 
draft proposed regulations (draft regulations) available in accessible 
formats, including an electronic format, to a broad spectrum of parties 
for informal review and comment. Over 600 letters of comments on the 
draft regulations were analyzed. RSA also gathered public input on the 
draft regulations through public meetings held in Washington, D.C. on 
April 19, May 12, and May 17, 1994; Chicago on April 26, 1994; and 
Oakland, California on May 4 and May 5, 1994; and through public 
teleconferences on April 20, May 13, May 18, and June 8, 1994. In 
addition, three separate focus groups were convened in June 1994 to 
allow for further discussion of three discrete issues: eligibility 
under the program, informed choice in the selection of services and 
service providers, and the standards related to the achievement and 
maintenance of an employment outcome.
    The following is a section-by-section summary of the regulations 
proposed in this NPRM, including an explanation of the major 
provisions, how they differ from the existing and the draft 
regulations, and the reasons the Secretary is proposing them. In 
addition, in order to clarify proposed organizational changes, the 
summary identifies the sections of the current regulations, as well as 
the sections of the statute, on which every section of the proposed 
regulations is based.
    Changes to the draft regulations that appear in this NPRM were made 
in response to public comments received by RSA and input provided 
during the public meetings, teleconferences, and focus groups. 
Significant changes to the draft regulations are discussed in the 
section-by-section summary. However, minor technical and structural 
changes that do not significantly alter the provisions of the draft 
regulations are not discussed.
    In response to public commenters who viewed some of the paperwork 
requirements in the draft regulations as unduly burdensome, the 
Secretary has proposed in the NPRM eliminating or consolidating 
documentation requirements wherever feasible. Those requirements that 
would remain in the proposed regulations are considered essential to 
the proper administration of the program. Paperwork requirements in the 
following sections of the draft regulations have been removed or 
reduced: Secs. 361.13(c), 361.19, 361.20(b), 361.21 (a) and (b), 
361.22(a)(1), 361.29 (a)(2) and (a)(4), 361.33(b), 361.46, 361.47, 
361.52, and 361.53(a)(3).
    In addition, the draft regulations have been reviewed and revised 
in accordance with the Department's principles for regulating, which 
were developed as part of the Administration's regulatory reinvention 
initiative under the National Performance Review II. The principles are 
designed to ensure that the Department regulates in the most flexible, 
most equitable, and least burdensome way possible. As a result of that 
review, additional non-statutory requirements in the draft regulations 
have been eliminated or modified to reduce paperwork or process 
requirements on States and to increase State flexibility in meeting 
statutory requirements. These proposed changes are identified in the 
section-by-section summary.
    The proposed regulations, like the draft regulations, provide 
guidance through examples in the following three areas: permissible 
expenses under the definition of ``maintenance''; permissible expenses 
under the definition of ``transportation''; and meeting the final 
eligibility criterion (an individual with a disability must require VR 
services) under Sec. 361.42. Some public commenters on the draft 
regulations opposed the use of examples on the grounds that they would 
interfere with individual counselor judgment, whereas other commenters 
supported their use as an effective means of ensuring that counselors 
had ready access to information typically found in guidance materials. 
By including the examples in the regulations, the Secretary intends to 
make the regulations more comprehensive and useful. The Secretary 
emphasizes, both here and throughout the section-by-section summary, 
that the examples are provided solely for the purposes of illustration, 
do not address all situations that a <strong>rehabilitation</strong> counselor may face, 
and are not intended to preclude individual counselor judgment on a 
case-by-case basis. The examples are merely guidance material to which 
<strong>rehabilitation</strong> professionals can quickly refer.
    References in the section-by-section summary to the ``proposed 
regulations,'' as opposed to the ``draft regulations,'' refer to 
regulatory provisions included in this NPRM.

Section-by-Section Summary

Section 361.1--Purpose

    This proposed new section of the regulations would incorporate the 
language in section 100(a)(2) of the statute, which emphasizes the goal 
of gainful employment for individuals with disabilities and the 
responsibility of States to operate comprehensive, coordinated, 
effective, efficient, and accountable programs that are designed to 
assess, plan, develop, and provide <strong>vocational</strong> <strong>rehabilitation</strong> services. 
The Secretary interprets the statutory term ``gainful employment'' to 
have the same meaning as the term ``employment outcome,'' as it is 
defined in the proposed regulations.

Section 361.2--Eligibility for a Grant

    This new section is proposed for clarification. A similar section 
was proposed in the 1991 NPRM.

Section 361.3--Authorized Activities

    This new section is proposed to clarify how the funds under this 
program can be used. A similar section was proposed in the 1991 NPRM. 
It also incorporates the new statutory provision in section 111(a)(1) 
of the Act that funds may be used to develop and implement the 
strategic plan.

Section 361.4--Applicable Regulations

    This proposed section would revise Sec. 361.1(b)(1) of the existing 
regulations to clarify that the reference to 34 CFR Part 74 
(Administration of Grants to Institutions of Higher Education, 
Hospitals, and Nonprofit Organizations) applies only to the award of 
subgrants by <strong>vocational</strong> <strong>rehabilitation</strong> agencies to entities that are 
not State or local governments or Indian tribal organizations and to 
remove the reference to 34 CFR Part 78 (The Education Appeal Board) 
because it has been deleted from the Education Department General 
Administrative Regulations (EDGAR). In addition, the proposed section 
would add references to 34 CFR Parts 80, 81, 82, 85, and 86 because 
those parts have been added to EDGAR since the regulations for this 
program were last revised, and they are applicable to this program. 

[[Page 64478]]


Section 361.5--Applicable Definitions

    This proposed section is taken from Sec. 361.1(c) of the existing 
regulations. It has been revised to incorporate changes in the 
definitions in section 7 of the Act that were made by the 1992 
Amendments. The definitions are organized alphabetically and are 
numbered for purposes of quick identification.
    The following definitions from the current regulations are not 
included in the proposed regulations since the terms have been removed 
or replaced in the Act: ``employability,'' ``evaluation of <strong>vocational</strong> 
<strong>rehabilitation</strong> potential,'' ``initial expenditure,'' ``<strong>rehabilitation</strong> 
facility,'' and ``time-limited services.'' In addition, the term 
``workshop'' is not used or defined in the proposed regulations. 
Statutory definitions of the following terms have been added to the 
proposed regulations without substantive change: ``assistive technology 
device,'' ``assistive technology service,'' ``extended services,'' 
``impartial hearing officer,'' ``ongoing support services,'' ``personal 
assistance services,'' ``<strong>rehabilitation</strong> technology,'' ``supported 
employment,'' ``supported employment services,'' and ``transition 
services. In addition, definitions of ``American Indian'' and ``State'' 
have been revised to reflect statutory changes made by the 1992 
Amendments.
    Definitions of the terms ``community <strong>rehabilitation</strong> program'' and 
``employment outcome,'' which are defined in the Act, have been revised 
to clarify or elaborate on the statutory definitions. The proposed 
definition of ``community <strong>rehabilitation</strong> program'' incorporates the 
definition in section 7(25) of the Act, but would add a definition of 
the word ``program'' to clarify that community <strong>rehabilitation</strong> programs 
do not include individual practitioners, such as physicians or physical 
therapists, who provide VR services but are not affiliated with an 
agency, organization, or institution that provides VR services as one 
of its major functions. This clarification is based on the Secretary's 
view that Congress did not intend for the assessment of the capacity 
and effectiveness of community <strong>rehabilitation</strong> programs and related 
requirements to include every individual person who provides VR 
services. However, the Secretary interprets the term community 
<strong>rehabilitation</strong> program and the associated requirements to apply to a 
<strong>vocational</strong> <strong>rehabilitation</strong> services unit of a hospital. In addition, in 
response to public comment on the draft regulations, the Secretary 
proposes to broaden the meaning of the term ``program'' from an entity 
that provides or facilitates the provision of VR services as its 
primary function to an entity that provides or facilitates the 
provision of VR services as one of its major functions. This change 
would enable, for example, a local affiliate of the United Cerebral 
Policy Foundation that provides VR services, in addition to 
disseminating information and providing educational services, to be 
considered a ``community <strong>rehabilitation</strong> program'' under the definition.
    The proposed definition of ``employment outcome'' elaborates on the 
definition in section 7(5) of the Act by incorporating into the 
definition the concept in the Act that an employment outcome must be 
consistent with an individual's strengths, resources, priorities, 
concerns, abilities, capabilities, interests, and informed choice. The 
proposed definition would replace the definition of ``employability'' 
in Sec. 361.1 of the existing regulations. In response to the draft 
regulations, several commenters expressed concern about the scope of 
permissible employment outcomes under the definition. Although the 
proposed definition, unlike the current regulatory definition of 
``employability,'' does not identify a full range of permissible 
employment outcomes under the <strong>vocational</strong> <strong>rehabilitation</strong> services 
program, the Secretary does not intend the proposed definition to 
exclude any employment outcome that has been permitted in the past. 
Thus, for example, homemaker, extended employment, and self-employment 
remain acceptable employment outcomes. The proposed definition does, 
however, recognize competitive employment as the optimal employment 
outcome under the program, and language emphasizing this has been added 
to the definition.
    The Secretary proposes new definitions or revisions to the 
definitions in the existing regulations for the following terms that 
are not defined in the Act: ``administrative costs,'' ``applicant,'' 
``appropriate modes of communication,'' ``comparable services and 
benefits,'' ``competitive employment,'' ``construction of a facility 
for a public or nonprofit community <strong>rehabilitation</strong> program,'' 
``establishment, development, or improvement of a public or nonprofit 
community <strong>rehabilitation</strong> program,'' ``establishment of a facility for a 
public or nonprofit community <strong>rehabilitation</strong> program,'' ``extended 
employment,'' ``family member,'' ``individual's representative,'' 
``integrated setting,'' ``maintenance,'' ``post-employment services,'' 
``transitioning student,'' and ``transportation.''
    The proposed definition of ``administrative costs'' is based on 
existing RSA subregulatory guidance and definitions of the term that 
are used in other RSA programs. The definition, which is substantially 
the same as the definition of ``administrative costs'' in the draft 
regulations, lists, as examples, certain types of expenses that would 
constitute administrative costs. Several commenters on the draft 
regulations suggested adding other items to the definition. In 
response, the Secretary has amended the definition of ``administrative 
costs'' to clarify that the types of expenses listed in the definition 
are intended only as examples and that other expenditures would be 
considered administrative costs as long as those expenditures relate to 
program planning, development, monitoring, and evaluation.
    The Secretary proposes to define ``applicant'' for clarification by 
referencing the requirements for submitting an application in 
Sec. 361.41(b)(2) of the proposed regulations.
    In response to public comment on the draft regulations, the 
Secretary proposes to change the term ``special modes of 
communication'' to ``appropriate modes of communication'' to ensure 
consistency with the Americans with Disabilities Act (ADA). In 
addition, the Secretary proposes to eliminate references in the 
definition to individuals who are blind, deaf, or hearing-impaired to 
clarify that the proposed definition is not limited by type of 
disability and that it includes all appropriate modes of communication 
necessary to enable any individual with a disability to comprehend 
information being communicated.
    Finally, the Secretary has expanded the list of examples of 
communication services and materials in the proposed definition. 
However, the Secretary does not consider the list to be all-inclusive 
and emphasizes that other appropriate modes of communication not 
specified in the proposed definition are also available.
    The proposed definition of ``comparable services and benefits'' is 
based on a definition of that term that was proposed in the 1991 NPRM. 
It is intended to support the statutory purpose of conserving 
<strong>rehabilitation</strong> funds, while ensuring the provision of appropriate and 
timely services in lieu of those provided by the DSU. The proposed 
definition revises the definition proposed in the 1991 NPRM to remove 
private agencies (i.e., community, philanthropic, and other 

[[Page 64479]]
private entities that are not VR service providers but do provide 
financial or other assistance to individuals with disabilities to help 
meet VR needs, such as scholarship assistance from a local Lions Club) 
as one of the sources of comparable services and benefits because the 
Secretary interprets the reference in the statute to ``other programs'' 
to mean other public programs. In addition, the Secretary believes it 
would be too burdensome to require State agencies to determine the 
availability of comparable services and benefits from private agencies 
prior to providing services and benefits under this program. The 
Secretary would, however, continue to encourage State agencies to use 
services and benefits that are available from private agencies to the 
extent they are known. In response to public comment on the draft 
regulations, the Secretary has further amended the term by clarifying 
that comparable services and benefits must be available ``within a 
reasonable period of time'' and must be commensurate with the services 
that the individual would otherwise receive from the VR agency.
    In response to public comment on the draft regulations, the 
Secretary has consolidated the definitions of ``competitive 
employment'' and ``competitive work'' from the draft regulations into a 
single proposed definition of ``competitive employment.'' The 
consolidated definition recognizes that integration (i.e., an 
employment outcome in an integrated job setting) is an element of 
competitive employment, rather than a separate concept. It would 
establish a general requirement that individuals must receive 
compensation that is at or above the minimum wage, but not less than 
the prevailing community wage for non-disabled individuals performing 
the same or similar work.
    The consolidated definition would apply to supported employment as 
well as to other kinds of competitive employment outcomes. Under the 
proposed definition, however, an employment outcome in a supported 
employment setting in which an individual receives wages below the 
minimum wage in accordance with section 14(c) of the Fair Labor 
Standards Act (FLSA) (i.e., wages based on individual productivity) 
would no longer be considered competitive employment. Although this 
proposed change would represent a significant departure from 
longstanding RSA regulatory policy, the Secretary agrees with those 
public commenters who suggested that competitive employment outcomes 
should be limited to those in which individuals are compensated at or 
above the minimum wage. In addition, this proposed change is consistent 
with section 101(a)(16) of the Act, which requires DSUs annually to 
review and reevaluate the status of each individual in an employment 
setting under section 14(c) of the FLSA in order to determine the 
individual's readiness for competitive employment. This statutory 
requirement indicates that supported employment settings in which 
individuals are compensated below minimum wage in accordance with the 
FLSA do not constitute competitive employment. The Secretary also notes 
that the proposed change would have the effect of requiring individuals 
in supported employment to earn at least the minimum wage in order to 
receive services under Title VI, Part C of the Act. Finally, so that 
the impact of this proposed change can be appropriately evaluated, the 
Secretary requests public comment on the extent to which individuals 
currently in supported employment earn less than the minimum wage.
    The proposed definition of the term ``construction of a facility 
for a public or nonprofit community <strong>rehabilitation</strong> program'' is based 
on the definition of the term ``construction of a <strong>rehabilitation</strong> 
facility'' in Sec. 361.1(c) of the existing regulations and the 
definition of the term ``construction'' in section 7(1) of the Act. The 
proposed regulations also incorporate the 1992 Amendments, which 
replaced the concept of <strong>rehabilitation</strong> facilities with ``community 
<strong>rehabilitation</strong> programs.'' The word ``facility'' is used in the 
proposed regulations only to refer to a ``building'' or ``structure.'' 
In addition, the Secretary proposes to fold into this definition all 
authorized construction expenditures under this program, which are 
currently contained in Sec. 361.74(a) of the existing regulations.
    The Secretary proposes to define the term ``eligible individual'' 
for clarification throughout the regulations by referencing the basic 
eligibility criteria in proposed Sec. 361.42(a).
    The proposed definition of the term ``establishment, development, 
or improvement of a public or nonprofit community <strong>rehabilitation</strong> 
program'' elaborates on the statutory definition of the term 
``establishment of a community <strong>rehabilitation</strong> program'' by 
incorporating all of the types of expenditures for which a State unit 
can receive Federal financial participation. These provisions are taken 
from Sec. 361.73(a) of the existing regulations and include the 
limitations on staffing costs initially proposed in the 1991 NPRM.
    The Secretary proposes to define separately the term 
``establishment of a facility for a public or nonprofit community 
<strong>rehabilitation</strong> program'' for purposes of clarification. The proposed 
definition covers only those authorized activities contained in the 
definition of ``establishment, development, or improvement of a public 
or nonprofit community <strong>rehabilitation</strong> program'' that involve 
facilities. In response to public comment about these three terms, the 
Secretary wishes to emphasize that funds under this program cannot be 
used to support community <strong>rehabilitation</strong> programs that are profitmaking 
organizations.
    In response to public comment on the draft regulations, the 
Secretary has amended the proposed definition of the term ``extended 
employment'' to clarify that it means work in a non-integrated or 
sheltered setting for a public or private nonprofit agency or 
organization that provides compensation in accordance with the Fair 
Labor Standards Act as well as any on-the-job support services the 
individual might require. In response to several commenters who 
expressed concern with language in the draft definition that stated 
that some individuals in extended employment ``are not ready for 
competitive employment,'' the Secretary has modified the proposed 
definition to clarify that the purpose of extended employment is to 
enable individuals to continue to train or otherwise prepare for 
competitive employment, unless the individual makes an informed choice 
to remain in extended employment.
    In response to public comment, the definition of the term ``family 
member'' has been revised to mean any individual (1) who is a relative 
or guardian, or who lives in the same household as an applicant or 
eligible individual regardless of their interpersonal relationship; (2) 
who has a substantial interest in the well-being of that individual; 
and (3) who needs <strong>vocational</strong> <strong>rehabilitation</strong> services to enable the 
applicant or eligible individual to achieve an employment outcome.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend the definition of the term ``impartial 
hearing officer'' to clarify that a member of the DSU's <strong>rehabilitation</strong> 
advisory council may not serve as an impartial hearing officer for that 
same DSU. Under the proposed definition, however, a member of the State 
<strong>Rehabilitation</strong> Advisory Council could serve as an impartial hearing 
officer in cases involving another DSU within the same State. For 
example, a member of the State <strong>Rehabilitation</strong> 

[[Page 64480]]
Advisory Council for a State unit serving individuals who are blind 
would not be precluded, solely on the basis of that membership, from 
serving as an impartial hearing officer in cases involving the State 
unit that serves individuals other than individuals with visual 
disabilities.
    The Secretary proposes to include the term ``individual with a most 
severe disability'' in the definitions to clarify that States are 
required to define the term as a subset of and consistent with the 
definition of the statutory term ``individual with a severe 
disability.''
    The Secretary proposes to define the term ``individual's 
representative,'' consistent with the list of potential representatives 
in the Act, so that the defined term, rather than the long list of 
potential representatives, can be referenced throughout the 
regulations. In response to public comment on the draft regulations, 
the Secretary proposes to amend the definition to clarify that it means 
any representative chosen by an applicant or eligible individual, 
including a parent, guardian, other family member, or advocate, unless 
a representative has been appointed by a court to represent the 
interests of the individual, in which case the court-appointed 
representative is the individual's representative.
    The proposed definition of the term ``integrated setting'' is 
designed to implement the intent of the statute that individuals 
receive VR services and achieve employment outcomes in the most 
integrated settings possible, consistent with the individual's informed 
choice. In the draft regulations the term was defined broadly to mean a 
setting in which the majority of individuals with whom individuals with 
disabilities interact meaningfully, excluding service providers, are 
non-disabled individuals. In response to public comment on the draft 
regulations, the Secretary proposes to amend the term by requiring that 
applicants or eligible individuals need only be given the opportunity 
to interact with non-disabled individuals, excluding service providers, 
on a regular basis for a setting to be considered integrated. This 
proposed change would permit employment at a center for independent 
living, for example, to be considered integrated as long as the 
employee has the opportunity to regularly interact with non-disabled 
persons, even though the Act requires that a majority of a center's 
employees be disabled. The proposed definition also applies to 
supported employment placements. A separate definition of 
``integration'' for supported employment placements is, therefore, no 
longer needed and is not included in the proposed regulations.
    ``Maintenance'' would be defined to clarify that it includes living 
expenses (e.g., food, shelter, and clothing) only to the extent that 
they are in excess of an individual's normal expenses and that it is 
available only for eligible individuals and individuals receiving 
extended evaluation services. The proposed definition reflects 
statutory language in section 103(a)(5) of the Act that limits the 
provision of maintenance to ``additional costs while participating in 
<strong>rehabilitation</strong>.'' The Secretary considers an individual to be 
participating in <strong>rehabilitation</strong> if the individual is receiving services 
under an individualized written <strong>rehabilitation</strong> program (IWRP) or under 
a written plan for providing extended evaluation services. The 
provision of maintenance must be tied to other needed services. 
Maintenance, however, cannot be used to pay the expenses of all 
applicants receiving assessment services, as several commenters urged. 
As discussed later in the definitions section of the preamble, the 
Secretary believes, however, that the short-term costs of food and 
shelter of applicants who are required to travel to receive assessment 
services, and who are not receiving extended evaluation services, could 
be covered as a transportation expense. In addition, the Secretary 
proposes a note following the proposed definition of maintenance that 
provides examples of permissible maintenance expenses. The last example 
was added in response to public comment and indicates that maintenance 
can be used to cover the costs of food, shelter, and clothing of 
homeless or recently deinstitutionalized individuals until other 
financial assistance can be secured for those costs. The Secretary 
emphasizes that the examples are provided solely for the purposes of 
illustration and do not preclude designated State units from providing 
maintenance in other appropriate situations.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend the definition of the term ``ongoing 
support services'' by removing the requirement that the assessment of 
an individual's employment stability include one monthly contact with 
the individual's employer whenever the IWRP of an individual in 
supported employment provides for off-site monitoring. The Secretary 
emphasizes, however, that contacts with employers are authorized as 
follow-up services under paragraph (iii)(F) of the proposed definition 
and could be provided as often as necessary to reinforce a supported 
employment placement.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend the definition of the term ``physical and 
mental restoration service'' by deleting from the proposed definition 
certain services that are not specifically identified in the statute. 
For example, ``convalescent or nursing home care'' has been deleted 
since it is not specified in section 103(a)(4) of the Act and is viewed 
as a type of long-term care rather than a restoration service.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend the definition of the term ``physical or 
mental impairment'' to mean an injury, disease, or other condition that 
materially limits, or if not treated will result in materially 
limiting, mental or physical functioning.
    The Secretary proposes to define ``post-employment services'' based 
on existing subregulatory guidance. In response to public comment on 
the draft regulations, the Secretary has amended the proposed 
definition to clarify that post-employment services are any <strong>vocational</strong> 
<strong>rehabilitation</strong> services for individuals that are provided subsequent to 
the achievement of an employment outcome and that are necessary to 
enable the individual to maintain, regain, or advance in employment 
consistent with the individual's strengths, resources, priorities, 
concerns, abilities, capabilities, and interests. In addition, the 
Secretary proposes to amend the note following the proposed definition 
in order to further explain the circumstances under which post-
employment services may be provided.
    In response to public comment on the draft regulations, the 
Secretary has amended the definition of the term ``substantial 
impediment to employment,'' as used in the criteria for determining 
eligibility under Sec. 361.42(a)(1), to mean a physical or mental 
impairment that hinders (rather than ``prevents'') an individual from 
preparing for, entering into, engaging in, or retaining employment 
consistent with the individual's abilities and capabilities. The 
Secretary proposes to delete the provision in the draft regulations 
that the impairment hinder the individual from employment that is 
consistent with the individual's interests. The purpose of this change 
is to clarify that an individual with an impairment who is not 
interested in his or her current employment does not, based on that 
lack of interest alone, have a substantial impediment to employment.
    In response to public comment on the draft regulations and 
consistent with section 103(a)(14) of the Act, the 

[[Page 64481]]
Secretary proposes to amend the definition of the term ``transition 
services'' to clarify that transition services must promote or 
facilitate the accomplishment of long-term <strong>rehabilitation</strong> goals and 
intermediate <strong>rehabilitation</strong> objectives identified in the transitioning 
student's IWRP.
    In response to public commenters who sought further clarification 
of the term ``transitioning student'' in the draft regulations, the 
Secretary proposes to define the term to mean a student who is eligible 
to receive <strong>vocational</strong> <strong>rehabilitation</strong> services and is receiving 
``transition services'' as defined in the regulations.
    The Secretary proposes to define the term ``transportation'' on the 
basis of existing subregulatory guidance. In addition, the Secretary 
has included a note following the proposed definition that provides 
examples of permissible transportation expenses. One of these examples 
covers the short-term, travel-related expenses (i.e., food and shelter) 
of applicants receiving assessment services. These expenses, as 
discussed previously, cannot be provided under the maintenance 
authority. The Secretary also emphasizes that these examples are 
provided solely for the purposes of illustration and do not preclude 
DSUs from providing transportation costs in other appropriate 
situations.
    Finally, the following nomenclature changes from the Act have been 
incorporated into the definitions and throughout the regulations: 
references to all forms of the word ``handicap'' have been changed to 
the corresponding form of the word ``disability;'' certain references 
to the word ``disability'' have been replaced by the word 
``impairment'' (e.g., physical or mental impairment); and the word 
``client'' has been removed and replaced with other appropriate terms, 
including ``applicant,'' ``eligible individual,'' ``individual,'' or 
``individual with a disability.''
    The Secretary also notes that proposed changes to supported 
employment definitions included in this NPRM would also affect those 
definitions in 34 CFR Parts 363, 376, and 380.

Section 361.10--Submission, Approval, and Disapproval of the State Plan

    Proposed Sec. 361.10 contains certain requirements from Secs. 361.2 
and 361.3 of the existing regulations relating to the purpose, 
duration, development, submission, and approval of the State plan. Many 
of the other requirements in Secs. 361.2 and 361.3 of the existing 
regulations have been relocated to other sections of the proposed 
regulations because they deal with the substance and administration of 
the State plan. Proposed Sec. 361.10 also incorporates the new 
statutory provision that authorizes the Secretary to approve the 
submission of a State plan for a period other than three years if it 
corresponds to the period required for another plan required under 
Federal law. Proposed paragraph (j) of this section provides the 
procedures for disapproval of the State plan. The procedural 
protections would be the same as those that are currently provided when 
the Secretary withholds funds.
    Paragraphs (e) and (f) of Sec. 361.2 of the existing regulations, 
which contain provisions regarding the designation of and transition to 
a new State agency or State unit, would be removed from the proposed 
regulations. The 1991 NPRM proposed removal of these requirements 
because of the paperwork burden, and they have been omitted in this 
NPRM for the same reason.

Section 361.11--Withholding of Funds

    Proposed Sec. 361.11 revises Sec. 361.4 of the existing regulations 
to make withholding hearings under this program subject to the 
jurisdiction of and the procedural requirements governing the 
Department's Office of Administrative Law Judges in EDGAR, 34 CFR Part 
81, rather than program specific hearing procedures in current 
Secs. 361.170 through 361.186, which would be repealed. This is 
consistent with the changes proposed in the 1991 NPRM.

Section 361.12--Methods of Administration

    This proposed section is taken from Sec. 361.10 of the existing 
regulations. The proposed regulations add a clause to clarify that 
proper and efficient administration of the State plan includes 
procedures to ensure accurate data collection and financial 
accountability.

Section 361.13--State Agency for Administration

    This proposed section consolidates information contained in 
Secs. 361.5, 361.6, and 361.8 of the existing regulations regarding the 
designation of the State agency, the organizational level and status of 
the State unit, and the full-time director requirement.
    In an effort to reduce the regulatory burden and increase State 
flexibility in accordance with the Department's principles for 
regulating, the Secretary proposes to delete the requirement in 
Sec. 361.13(a)(1)(i) of the draft regulations and Sec. 361.5(b)(1) of 
the current regulations that a designated State agency that has as its 
major function <strong>vocational</strong> <strong>rehabilitation</strong> or <strong>vocational</strong> and other 
<strong>rehabilitation</strong> of individuals with disabilities also ``have the 
authority, subject to the supervision of the Governor, if appropriate, 
to define the scope of the program within the provisions of State and 
Federal law and to direct its administration without external 
administrative controls.'' Elimination of this non-statutory 
requirement, which applies currently to only one of the three sole 
State agency options identified in the regulations, is intended to 
increase State flexibility in locating and administering its <strong>vocational</strong> 
<strong>rehabilitation</strong> program.
    Several commenters on the draft regulations requested clarification 
of the requirement in Sec. 361.13(b)(1)(iii) that at least 90 percent 
of the State unit staff work full-time on the <strong>rehabilitation</strong> work of 
the organizational unit, which must be primarily concerned with 
<strong>vocational</strong> <strong>rehabilitation</strong> or <strong>vocational</strong> <strong>rehabilitation</strong> and other 
<strong>rehabilitation</strong>. This requirement means that if the organizational unit 
provides other <strong>rehabilitation</strong> services, in addition to <strong>vocational</strong> 
<strong>rehabilitation</strong>, the 90 percent staffing requirement applies to all unit 
staff providing <strong>rehabilitation</strong> services, not to just the <strong>vocational</strong> 
<strong>rehabilitation</strong> staff. ``Other <strong>rehabilitation</strong>'' includes, but is not 
limited to, other programs that provide medical, psychological, 
educational, or social services to individuals with disabilities. For 
example, a State unit with 90 percent of its staff working on 
independent living services, programs for the developmentally disabled, 
disabled children's services, services for individuals who are deaf or 
hearing-impaired, services for individuals who are blind or visually 
impaired, Social Security disability determinations, or some other type 
of program related to individuals with disabilities, in addition to 
<strong>vocational</strong> <strong>rehabilitation</strong>, would satisfy the 90 percent requirement. 
The Secretary also notes that Federal funds under this program may be 
used only to pay the salaries of the State unit staff that are working 
full-time or part-time on <strong>vocational</strong> <strong>rehabilitation</strong>.
    In accordance with the Department's principles for regulating, the 
Secretary also proposes to delete the requirement in Sec. 361.13(c) of 
the draft regulations and Sec. 361.6(a) of the current regulations that 
the State plan describe the organizational structure of the State 
agency and its organizational units. The Secretary instead would rely 
on an assurance, required by statute, that a State agency that is 
required to have a <strong>vocational</strong> <strong>rehabilitation</strong> unit locate that 

[[Page 64482]]
unit at an organizational level comparable to other organizational 
units within the State agency. This proposed change is intended to 
reduce paperwork burdens on State agencies in developing their State 
plans.
    The Secretary is not proposing any substantive changes in paragraph 
(d) of this section to the requirements in current Sec. 361.5(e) with 
regard to the responsibility of the designated State unit for 
administration of the <strong>vocational</strong> <strong>rehabilitation</strong> program, but is 
soliciting public comment on the need for changes.
    The current regulations specify certain program functions or 
activities (determinations of eligibility, development of IWRPs, and 
decisions regarding the provision of services) that must be the 
responsibility of the DSU and that cannot be delegated to any other 
agency or individual. This non-delegation provision has been 
interpreted by RSA to mean that the DSU must carry out these functions 
or activities using its own staff. The draft proposed regulations, 
consistent with RSA subregulatory policy, specified additional program 
functions that must be carried out by the DSU: determinations that 
service recipients have achieved appropriate employment outcomes, the 
formulation and implementation of program policy, and the allocation 
and expenditure of program funds. The draft proposed regulations also 
would have strengthened the role of the State unit by requiring that 
the unit have a substantial role in all decisions affecting the 
administration of the VR program whenever management functions within 
the State agency are centralized.
    Public comment on these draft proposed changes was neither 
extensive nor consistent. Some State VR directors supported a 
strengthening of the role and authority of the DSU but thought the 
draft proposed regulations were not strong enough, while other 
commenters thought the regulations were too prescriptive and believed 
that the only program function that must be carried out directly by DSU 
staff is eligibility determinations.
    In light of the mixed public comment received thus far and the 
Administration's regulatory reinvention initiative, which is intended 
to increase State flexibility in administering Federally funded 
programs whenever permitted by statute, the Department is soliciting 
additional public comment on the following questions: Should the 
regulations expand or otherwise clarify essential program functions for 
which the DSU must be responsible in order to meet the statutory 
requirement in section 101(a)(2)(A) that it be responsible for the VR 
program? Must these essential program functions be carried out by DSU 
staff or should the regulations provide States as much flexibility as 
possible to determine how to carry out these functions as long as the 
DSU retains administrative oversight in these areas? Any changes made 
to provide increased flexibility to States would not require DSUs to 
change their current administrative practices but would provide States 
additional flexibility to restructure, consolidate, or contract out 
program operations as long as the DSU retains ultimate responsibility.

Section 361.14--Substitute State Agency

    This proposed section revises certain requirements regarding the 
selection of a substitute State agency (Sec. 361.7 of the existing 
regulations) in order to simplify the process and reduce the paperwork 
burden. The existing regulations permit applications from a potentially 
unlimited number of substitute State agency applicants, from which the 
Secretary selects the substitute State agency based on detailed 
criteria in the existing regulations. The proposed regulations place 
the authority and responsibility for the selection of a substitute 
State agency on the State so that the Secretary would need only to 
review and approve a State plan from one substitute State agency prior 
to providing funds.

Section 361.15--Local Administration

    This proposed section simplifies Sec. 361.9 of the current 
regulations by removing the requirements related to a written agreement 
between a sole local agency and the State unit in order to reduce the 
paperwork burden on States. It proposes to replace the written 
agreement requirements with assurances from the State unit in the State 
plan relating to the administration and supervision of a sole local 
agency.

Section 361.16--Establishment of an Independent Commission or a State 
<strong>Rehabilitation</strong> Advisory Council

    This proposed new section implements the new requirements related 
to the State <strong>Rehabilitation</strong> Advisory Council (Council) in section 
101(a)(36) of the Act. The proposed section clarifies that a State does 
not need to establish a Council or meet the requirements related to a 
Council if the State agency is a consumer-controlled independent 
commission. The proposed section also clarifies that if the State has a 
separate State agency for individuals who are blind, four options 
regarding the possible combinations of the two State agencies exist. 
Although only three options are identified in the Act, the section-by-
section analysis of the Act in the Conference Report clarifies that the 
fourth option, a mirror image of the third combination identified in 
the Act, is also acceptable. This option is contained in proposed 
paragraph (b)(4) of this section.

Section 361.17--Requirements for a State <strong>Rehabilitation</strong> Advisory 
Council

    This proposed new section incorporates the new statutory 
requirements in section 105 of the Act with the clarification that the 
director of the DSU is a nonvoting member of the State <strong>Rehabilitation</strong> 
Advisory Council. Since the purpose of the Council is to advise the 
State unit, and the statute is clear that the director is an ex-officio 
member of the Council, the Secretary does not believe that Congress 
intended that the director of the State unit provide advice to herself 
or himself by voting on Council decisions. Similarly, the Secretary has 
clarified the regulations to state that any employee of the designated 
State agency may serve only as a nonvoting member of the Council.
    Several commenters on the draft regulation sought clarification 
with respect to the appointment of Council representatives from the 
Client Assistance Program (CAP) and the Statewide Independent Living 
Council (SILC). In response, the Secretary proposes to amend the 
regulations to clarify that the role of the CAP and SILC is to 
recommend to the Governor, or other appropriate appointment authority 
designated by State law, Council representatives for their respective 
organizations. Based on these recommendations, the Governor or other 
State-designated authority determines who will be the Council 
appointees, since the statute clearly vests appointment authority in 
those entities. The Secretary also notes that those individuals 
recommended for Council membership by the CAP or SILC need not be CAP 
or SILC members.
    In addition, in response to public comment on the draft 
regulations, the Secretary emphasizes that, although the Council must 
be composed of at least 13 members (unless the State qualifies for an 
exception under paragraph (b)(4) of this section), a State is not 
precluded from having more than 13 individuals serve on its Council.
    The Secretary also encourages States to consider appointing Council 
members from minority backgrounds consistent with the 1992 Amendments 
to the Act, which emphasizes outreach 

[[Page 64483]]
to individuals from minority backgrounds and the need for 
<strong>rehabilitation</strong> programs to better reflect the culturally diverse 
population of the United States.
    Finally, in response to public comment on the draft regulations, 
the Secretary proposes to amend the annual reporting requirements of 
the Council by requiring the Council to submit to the Governor, or 
other appropriate State entity, and to the Secretary an annual report 
of the status of the State's <strong>vocational</strong> <strong>rehabilitation</strong> programs within 
90, rather than 60, days from the end of the fiscal year and by 
requiring that the report be available through appropriate modes of 
communication.

Section 361.18--Comprehensive System of Personnel Development

    This proposed new section incorporates the new statutory 
requirements in sections 101(a)(7) and 101(a)(35) of the Act. The 
requirements in section 101(a)(7) of the Act are virtually identical to 
requirements for a comprehensive system of personnel development under 
the Individuals with Disabilities Education Act (IDEA). For this 
reason, this section of the proposed regulations closely tracks the 
regulations implementing the IDEA requirements (34 CFR 300.380 through 
300.383), with modifications to better reflect the context of the State 
<strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program.
    Some commenters on the draft regulations questioned the basis for 
requiring the involvement of the State <strong>Rehabilitation</strong> Advisory Council 
in the development of personnel standards. The Act requires that the 
Council generally advise the State unit in connection with the carrying 
out of its programmatic responsibilities. In addition, the State agency 
is required to consult, and seek advice from, the Council on issues 
affecting the development of the State plan. Because an effective 
system of personnel development is an essential part of the State plan 
and a critical element to the success of the State <strong>Vocational</strong> 
<strong>Rehabilitation</strong> Services Program, the Secretary considers it necessary 
for the Council to participate in the development of State personnel 
standards.
    Paragraph (a) of this section requires that the State plan include, 
on an annual basis, a description of a system for collecting and 
analyzing personnel data. Several commenters on the draft regulations 
expressed concern about the amount of data that must be provided to the 
Secretary under this provision. In response, the Secretary emphasizes 
that, although annual data collection and analysis requirements are 
statutorily imposed, the proposed regulations require only that the 
State plan include a description of the system used to collect the data 
on personnel needs and personnel development and do not require the 
State to submit the actual data to the Secretary.
    In response to public comment on the draft regulations, the 
Secretary proposes to broaden the definition of the term ``highest 
requirements in the State applicable to that profession or 
discipline,'' as used in the development and maintenance of personnel 
standards by the State, to mean the highest entry-level academic degree 
or equivalent experience needed to meet any national- or State-
recognized certification, licensing, registration, or other comparable 
requirements that apply to a profession or discipline. The purpose of 
this change is to recognize that some States base their personnel 
standards, in part, on relevant work experience by substituting 
equivalent work experience for certain academic credentials. State 
standards of this type would meet this definition. This change, 
however, would not allow work experience to substitute for academic 
requirements if the existing State standard is based only on academic 
credentials.
    The Secretary also believes that permitting States to base highest 
personnel standards in the State on equivalent experience, as well as 
on academic degrees, stresses the significance of relevant work 
experience and will diversify further the pool from which qualified 
personnel can be selected.
    Several commenters on the draft regulations suggested areas of 
training in addition to <strong>rehabilitation</strong> technology that should be 
required in the regulations as part of the State's program of staff 
development. The Secretary believes that the specific training areas 
for staff development adopted by a State unit must be based on the 
particular needs of that State unit. The Secretary recognizes, however, 
that staff development may include, but is not limited to, training 
with respect to the requirements of the Americans with Disabilities 
Act, IDEA, and Social Security incentive programs, training to 
facilitate informed choice under this program, and training to improve 
the provision of services to culturally diverse populations. A 
provision to this effect has been added to the proposed regulations.
    In response to public comment on the draft regulations, the 
Secretary proposes to change the reference in paragraph (e) of this 
section from ``special communication needs personnel'' to ``personnel 
to address individual communication needs'' and has clarified this 
provision by requiring the State unit to describe in the State plan how 
it includes among its personnel, or obtains the services of, 
individuals able to communicate in the native languages of applicants 
and eligible individuals who have limited English speaking ability. 
That personnel may include State agency staff, family members of an 
applicant or eligible individual, community volunteers, and other 
individuals able to communicate in the appropriate native language. The 
State unit also must describe how it ensures that appropriate modes of 
communication are used for all applicants and eligible individuals.
    In response to public comment on the draft regulations, the 
Secretary wishes to stress the importance of requiring in the State 
plan a description of the State's personnel performance evaluation 
system that facilitates, and does not impede, the purposes and policies 
of the <strong>vocational</strong> <strong>rehabilitation</strong> services program outlined in the Act. 
More precisely, the proposed regulations require that the evaluation 
system further the statutory policy of serving individuals with the 
most severe disabilities. In support of this requirement, the Senate 
Committee on Labor and Human Resources states in its report that it 
``is concerned that in some States, procedures used for evaluating 
performance of counselors may have the unintended consequence of 
providing a disincentive to serve individuals with the most severe 
disabilities and those clients requiring complex services.'' The 
performance evaluation system required under the Act and included in 
the proposed regulations is designed to address these disincentives.
    The Secretary proposes to modify paragraph (g) of this section to 
track section 101(a)(7)(A)(ii) of the Act, which requires the State 
agency to describe the activities it will undertake to coordinate its 
comprehensive system of personnel development with personnel 
development under IDEA. This proposed change is intended to increase 
the flexibility of State agencies to implement the most effective 
procedures for coordinating the development of personnel under both 
statutes. An example of how a State may address this coordination 
requirement would be to establish a joint continuing education program 
for both DSU personnel and personnel under IDEA that deals with the 
provision of VR services, including transition services, to 
transitioning students. 

[[Page 64484]]


Section 361.19--Affirmative Action for Individuals With Disabilities

    This proposed section, which is based on section 101(a)(6)(A) of 
the Act and Sec. 361.15 of the existing regulations, requires the State 
agency to take affirmative action to employ and advance in employment 
qualified individuals with disabilities. In accordance with the 
Department's principles for regulating, the Secretary proposes to 
delete the non-statutory requirement in the draft regulations and the 
current regulations that the State unit develop an affirmative action 
plan that provides for specific goals, action steps, timetables, 
evaluation criteria for measuring progress, and complaint and 
enforcement procedures. By not requiring a formal affirmative action 
plan or specifying the minimum requirements a State must incorporate 
into that plan, the proposed provision would give State agencies 
greater flexibility to take those steps it considers most appropriate 
for increasing the number of qualified individuals with disabilities 
that it employs or advances in employment. The proposed changes also 
would reduce State paperwork burdens.

Section 361.20--State Plan Development

    This proposed section revises Sec. 361.18 of the existing 
regulations to implement new requirements in section 101(a)(23) of the 
Act.
    Consistent with section 101(a)(23) of the Act, paragraph (a)(1) of 
this section of the regulations would require the State unit to conduct 
public meetings throughout the State to provide all segments of the 
public, including interested groups, organizations, and individuals, an 
opportunity to comment on the State plan prior to its development and 
to comment on any revisions to the State plan. In accordance with the 
Department's principles for regulating, the Secretary believes that 
States should have the latitude to develop their own procedures for 
ensuring that interested parties are afforded a meaningful opportunity 
to comment on the State plan before it is developed and when it is 
revised. Additionally, in order to satisfy the statutory requirement 
that the State unit, prior to conducting public meetings throughout the 
State, provide appropriate and sufficient notice of the public 
meetings, the proposed regulations would require the State unit to 
follow notice requirements established under State law or, in the 
absence of those requirements, to consult with the State <strong>Rehabilitation</strong> 
Advisory Council to develop notice procedures. The proposed regulations 
would not impose any specific minimum Federal requirements for what 
constitutes ``appropriate and sufficient notice.''
    In response to those commenters who sought regulatory clarification 
of the public participation and notice requirements of this section, 
the Secretary provides the following examples as suggested ways a DSU 
might meet these requirements. A State unit could satisfy the public 
participation requirement, for example, by soliciting input from the 
public before developing a preliminary draft State plan and making the 
preliminary draft plan available to the public 30 days prior to the 
public meetings. An example of ``appropriate and sufficient notice'' of 
public meetings would be notice that is provided at least 30 days prior 
to a public meeting through various media available to the general 
public, such as newspapers and public service announcements, and 
through specific contacts with appropriate constituency groups and 
organizations identified by the State unit, in consultation with the 
State <strong>Rehabilitation</strong> Advisory Council. An example of how a State unit 
could meet the statutory requirement that it ``conduct public meetings 
throughout the State,'' would be to hold public meetings in at least 
two different geographic locations that are among the State's most 
densely populated areas and at sites that are accessible to individuals 
with disabilities.
    Some commenters on the draft regulations suggested that larger 
States be required to hold a greater number of public meetings than 
smaller States, while other commenters suggested that States make use 
of emerging technologies that enable individuals to participate in 
public meetings without having to be in attendance. The Secretary 
encourages each State to hold as many public meetings as are necessary 
to ensure meaningful participation of all interested persons and 
organizations in that State. The Secretary also urges States to 
consider using alternative or emerging technologies that allow for 
wider public participation. The proposed regulations are intended to 
provide each State with the flexibility to choose the manner in which 
it conducts public meetings (e.g., in person, satellite broadcasts, 
teleconferences, or a combination thereof) as long as the meetings are 
truly interactive and are designed to maximize the opportunity for 
meaningful participation.
    The proposed section also would implement the new statutory 
provision in section 105(c)(2) of the Act that requires the State 
<strong>Rehabilitation</strong> Advisory Council to advise the State unit on the 
preparation of the State plan by requiring the State unit to consult 
with the Council in the development of the State plan. Finally, the 
proposed section implements the new statutory requirement in section 
101 (a)(32) of the Act that the State plan describe the manner in which 
it will modify State policy and procedures in response to consumer 
satisfaction surveys.

Section 361.21--Consultations Regarding the Administration of the State 
Plan

    This proposed section is also taken from Sec. 361.18 of the 
existing regulations. It incorporates section 101(a)(18) of the Act, 
including the new statutory requirement regarding consultation with the 
director of the CAP. It would also require consultation with the State 
<strong>Rehabilitation</strong> Advisory Council, consistent with the Council functions 
in new section 105(c) of the Act. It proposes to remove provisions in 
the existing regulations that list examples of matters of general 
policy development and implementation. Finally, this proposed section, 
as well as the previous section, would implement new section 101(a)(32) 
of the Act, which requires the State plan to describe the manner in 
which the State will modify State policy and procedures in response to 
consumer satisfaction surveys.

Section 361.22--Cooperation With Agencies Responsible for Transitioning 
Students

    This proposed new section combines Sec. 361.19(b) of the existing 
regulations, which requires the State plan to provide for the 
coordination of services for individuals who are eligible both for 
<strong>vocational</strong> <strong>rehabilitation</strong> services and for services under IDEA, with 
the new statutory provisions in sections 101(a)(11) and (a)(24) of the 
Act. The new statutory provisions require formal interagency agreements 
to facilitate the transfer of responsibilities for transitioning 
students who are receiving special education services from the agency 
responsible for providing a free appropriate public education to the 
State unit responsible for providing <strong>vocational</strong> <strong>rehabilitation</strong> 
services. In addition, proposed paragraph (b) of this section 
implements the new requirement in section 101(a)(30) of the Act 
regarding the availability of <strong>vocational</strong> <strong>rehabilitation</strong> services to 
students who are individuals with 

[[Page 64485]]
disabilities and who are not in special education programs.
    Some commenters on the draft regulations viewed the required 
content of formal interagency agreements between State units and State 
educational agencies as unduly burdensome. In response, the Secretary 
proposes to amend the regulations to require that formal interagency 
agreements need only identify provisions for determining State lead 
agencies and qualified personnel responsible for transition services, 
in addition to identifying those policies and practices that can be 
coordinated between the agencies, including eligibility standards, 
referral policies, outreach procedures, and evaluation procedures. The 
formal interagency agreement may, as appropriate, identify available 
resources, the financial responsibilities of each agency, dispute 
resolution procedures, and other cooperative policies.
    Other commenters expressed concern that the draft regulations 
required State agencies to shoulder more of the responsibility for 
transitioning students than is contemplated under the Act. In response, 
the Secretary proposes to add a note in the regulations to clarify the 
roles of the <strong>rehabilitation</strong> and educational agencies in facilitating 
the transition of students who are eligible for VR services. As stated 
by the Senate Committee on Labor and Human Resources, the role of the 
State agency is primarily one of planning for the student's years after 
leaving school.

Section 361.23--Cooperation With Other Public Agencies

    This proposed section is taken from paragraphs (a), (c), and (d) of 
Sec. 361.19 of the existing regulations and has been revised to 
incorporate the new requirements in section 101(a)(11) of the Act 
regarding the content of formal interagency cooperative agreements. The 
proposed section is also reorganized to clarify that the long list of 
programs under existing Sec. 361.19(a) refers to Federal, State, and 
local public programs and agencies providing services related to the 
<strong>rehabilitation</strong> of individuals with disabilities.

Section 361.24--Coordination With the Statewide Independent Living 
Council

    This proposed new section incorporates the new requirement in 
section 101(a)(33) of the Act that the State unit coordinate and 
establish working relationships with the Statewide Independent Living 
Council and independent living centers within the State.

Section 361.25--Statewideness

    This proposed new section contains the requirement in Sec. 361.2(a) 
of the existing regulations that the State plan be in effect in all 
political subdivisions of the State.

Section 361.26--Waiver of Statewideness

    This proposed section revises Sec. 361.12 of the existing 
regulations to clarify that a waiver of statewideness is necessary if 
the State unit wants to provide through local financing increased 
services or an expanded scope of services that is different from the 
services available statewide. The procedural requirements relating to a 
request for a waiver would remain substantially the same.

Section 361.27--Shared Funding and Administration of Joint Programs

    This proposed section revises Sec. 361.11 of the existing 
regulations to clarify that these programs involve shared funding and 
administrative responsibility, that a request for the Secretary's 
approval must be included in the State plan, and that a request for 
waiver of statewideness also must be included in the State plan, if 
necessary. The proposed regulations would also remove the specific 
requirements relating to a written agreement that are in the existing 
regulations. The 1991 NPRM proposed to remove the written agreement 
requirements as part of the effort to reduce paperwork burden, and the 
requirements are omitted in this NPRM for the same reason.

Section 361.28--Third-Party Cooperative Arrangements Involving Funds 
From Other Agencies

    This proposed section revises Sec. 361.13 of the existing 
regulations to reduce the requirements related to third-party 
cooperative arrangements, including the requirements for a written 
agreement, an annual program budget, and an annual review of program 
operations. The proposed regulations would also clarify that 
applicants, as well as eligible individuals, can receive services under 
these cooperative arrangements. This section would be placed 
organizationally in the regulations next to the proposed section on 
shared funding and administration to emphasize the differences between 
joint programs and third-party cooperative arrangements.
    Some commenters on the draft regulations suggested that third-party 
cooperative arrangements be jointly administered by the State unit and 
the cooperating agency, i.e., administered in the same way as joint 
programs under proposed Sec. 361.27. In response, the Secretary notes 
that section 101(a)(2) of the Act requires the designated State unit to 
be responsible for the <strong>vocational</strong> <strong>rehabilitation</strong> program. Third-party 
cooperative arrangements provide a framework for cooperating agencies 
to provide <strong>vocational</strong> <strong>rehabilitation</strong> services and contribute to the 
State's non-Federal financial share under the program. Thus, third-
party arrangements are considered part of the <strong>vocational</strong> <strong>rehabilitation</strong> 
program for which the State unit must retain administrative 
responsibility. In contrast, State units that are parties to joint 
programs share funding and administrative responsibility with other 
agencies.
    In response to public comment on the draft regulations, the 
Secretary has clarified that services provided by the cooperating 
agency under a cooperative arrangement must either be new services that 
have a <strong>vocational</strong> <strong>rehabilitation</strong> focus or existing services that have 
been modified, adapted, expanded, or reconfigured to have a VR focus. 
These requirements are consistent with longstanding RSA subregulatory 
guidance.

Section 361.29--Statewide Studies and Evaluations

    This proposed section revises and expands Sec. 361.17 of the 
existing regulations to identify and clarify the timelines for all of 
the study and evaluation requirements, some of which are currently 
contained in other sections. It also expands the requirement in 
Sec. 361.2(a)(2)(i) of existing regulations that the State plan 
describe changes in policy resulting from the statewide studies and the 
annual evaluation to also require a description of activities 
undertaken and changes in the State plan, the strategic plan, and plan 
amendments that result from the studies and evaluations. Proposed 
paragraph (d) of this section incorporates the new requirement in 
section 105(c)(2) of the Act regarding the role of the State 
<strong>Rehabilitation</strong> Advisory Council in the preparation of the statewide 
studies and evaluation.

Section 361.30--Services to Special Groups of Individuals With 
Disabilities

    This proposed section combines Secs. 361.37 and 361.38 of the 
existing regulations regarding special services for civil employees of 
the United States and for American Indians, along with paragraph (c) of 
Sec. 361.36 of the existing regulations, which provides for special 
consideration for public safety officers. In addition, the Secretary 
proposes to clarify in this section that special consideration means 
that a public safety 

[[Page 64486]]
officer would receive priority for services over other individuals in 
the same priority category of an order of selection. The proposed 
section would also incorporate the statutory definitions of ``criminal 
act'' and ``public safety officer'' from section 7 of the Act.

Section 361.31--Utilization of Community Resources

    This proposed section is substantially the same as Sec. 361.56 of 
the existing regulations. It has been relocated to group it with other 
utilization sections in the part of the regulations that contains 
general administration requirements, rather than in the part of the 
regulations that addresses provision of services requirements.

Section 361.32--Utilization of Profitmaking Organizations for On-The-
Job Training in Connection With Selected Projects

    This proposed section revises Sec. 361.57 of the existing 
regulations to increase State unit flexibility by authorizing, rather 
than requiring, a State unit to use profitmaking organizations if it 
determines that those organizations are better qualified to provide 
needed services than nonprofit agencies, organizations, or facilities 
in the State.

Section 361.33--Utilization of Community <strong>Rehabilitation</strong> Programs

    This proposed section revises Secs. 361.21 and 361.22 of the 
existing regulations and replaces the term ``<strong>rehabilitation</strong> 
facilities'' with the term ``community <strong>rehabilitation</strong> programs,'' 
consistent with the 1992 Amendments. It also incorporates changes in 
the State plan requirements in sections 101(a)(5) and 101(a)(15) of the 
Act and new requirements in sections 101(a)(27) and 101(a)(28) of the 
Act.
    In accordance with the Department's principles for regulating, the 
Secretary proposes to eliminate current non-statutory requirements for 
a <strong>rehabilitation</strong> facilities plan and for an inventory of community 
<strong>rehabilitation</strong> programs and requirements in the draft regulations for a 
justification in the State plan for using funds for the support of 
community <strong>rehabilitation</strong> programs, including the construction of 
facilities, and for a prioritized list in the State plan of proposed 
activities. The removal of these provisions would substantially reduce 
paperwork burdens on designated State units.

Section 361.34--Supported Employment Plan

    This proposed new section incorporates sections 101(a)(25) and 
635(a) of the Act, which require a State to assure that it has an 
acceptable plan for providing supported employment services and to 
submit that plan as a State plan supplement.

Section 361.35--Strategic Plan

    This proposed new section would require that the strategic plan to 
expand and improve <strong>vocational</strong> <strong>rehabilitation</strong> services be provided as a 
supplement to the State plan. Section 101(a)(34)(A) of the Act requires 
the State plan to include an assurance that the State has a strategic 
plan to expand <strong>vocational</strong> <strong>rehabilitation</strong> services in accordance with 
Part C of Title I. In addition, section 120 of the Act requires States 
to submit their strategic plans to the Secretary prior to receiving 
funding under Part B of the Act, which includes the allotment for this 
program. The Secretary believes that requiring the strategic plan as a 
supplement to the State plan is the simplest and least burdensome 
approach.

Section 361.36--Reserved

    This section is reserved for the order of selection regulations, 
which are being implemented in a separate rulemaking document.

Section 361.37--Establishment and Maintenance of Information and 
Referral Resources

    The provision proposed in the draft regulations was substantially 
the same as Sec. 361.20 of the existing regulations. However, 
commenters on both the draft regulations and the July 16, 1993 NPRM on 
order of selection have requested that State units operating under an 
order of selection be permitted to provide non-purchased services 
(e.g., information and referral) to eligible individuals who do not 
qualify for services under the State unit's priority categories. An 
order of selection is required under section 101(a)(5)(A) of the Act if 
a State unit determines that it is unable to provide services to all 
eligible individuals who apply for services. In response to public 
comment, the Secretary proposes to address this concern by amending the 
regulations to authorize any State unit that has implemented an order 
of selection to establish an expanded information and referral program 
that includes the provision of job referral services to eligible 
individuals who are not being served under a State unit's order of 
selection, provided that certain State plan requirements are met. These 
requirements include a description in the State plan of the level of 
commitment of staff and other resources for this purpose and an 
assurance that in carrying out this program, the State unit will not 
use case services funds that are needed to provide VR services to 
eligible individuals who are able to be served under the State unit's 
order of selection.

Section 361.38--Protection, Use, and Release of Personal Information

    This proposed section is substantially the same as Sec. 361.49 of 
the existing regulations with the clarification in proposed paragraph 
(e)(3) that a State unit is required to release personal information if 
required by Federal regulations or Federal law.
    In addition, some commenters on the draft regulations expressed 
concern that the State unit could release harmful personal information 
to a representative not chosen by the applicant or eligible individual. 
In response, the Secretary has clarified that the State unit may 
release information that it determines to be harmful to the individual 
only to a third party chosen by the individual, which may include, 
among others, an advocate, a family member, or a qualified medical or 
mental health professional.
    In response to public comment on the draft regulations, the 
Secretary also proposes to amend the regulations by clarifying that 
State units shall release personal information in response to an 
``order issued by a judicial officer.'' The Secretary believes that the 
use of the term ``judicial order'' in both the current and draft 
regulations is confusing and that the clarification is necessary to 
ensure that a judge, magistrate, or other authorized judicial officer 
appropriately weighs the factors necessitating release of personal 
information against the individual's rights to privacy and protection 
from unauthorized use before ordering a State unit to release the 
information.
    In addition, the proposed section has been relocated to group it 
with other sections of the regulations that contain the administrative 
requirements since it does not relate to the provision and scope of 
services.
    While the confidentiality of personal information from applicants 
and eligible individuals under this program is considered essential to 
protect individual privacy, the Secretary specifically requests public 
comment on whether the provisions of this section are unduly burdensome 
or inconsistent with State laws governing the protection, use, or 
release of personal information.

Section 361.39--State-Imposed Requirements

    This proposed section is taken from Sec. 361.25 of the existing 
regulations. The 

[[Page 64487]]
draft regulations would have required State units to identify State-
imposed requirements at the public meetings to develop and revise the 
State plan. In response to public comment, the Secretary proposes to 
clarify this section of the regulations by requiring State units to 
identify upon request those regulations and policies relating to the 
administration or operation of the <strong>vocational</strong> <strong>rehabilitation</strong> program 
that are State-imposed. In making these changes the Secretary 
recognizes that the scope of State-imposed requirements is broader than 
those included in the State plan and that the Act requires the 
application of any State rule or policy relating to the administration 
or operation of the <strong>vocational</strong> <strong>rehabilitation</strong> program to be identified 
as a State-imposed requirement. The proposed section would require 
State units to identify those requirements upon request, including, but 
not limited to, requests made at public meetings.

Section 361.40--Reports

    This proposed section is substantially the same as Sec. 361.23 of 
the current regulations, except that it would add cross-references to 
sections 13, 14, and 101(a)(10) of the Act to distinguish the reporting 
requirements under this section from the reporting requirements related 
to statewide studies and evaluations under proposed Sec. 361.29.

Section 361.41--Processing Referrals and Applications

    This section expands Sec. 361.30 of the current regulations to 
incorporate the new statutory requirement in section 102(a)(5)(A) of 
the Act that an eligibility determination be made within 60 days of the 
date on which an application is submitted, with limited exceptions. The 
Secretary proposes to require the State unit to establish timelines for 
making good faith efforts to contact individuals who have been referred 
for services to minimize delay at the pre-application stage.
    Under the draft regulations, an individual was considered to have 
``submitted an application'' if the individual, or the individual's 
representative, as appropriate, had submitted a completed agency 
application or a signed written request for services. In an effort to 
ensure that agencies are provided with all information necessary to 
make eligibility determinations, some commenters on the draft 
regulations stated that completion of an agency application should be 
the sole method for requesting services. In contrast, other commenters 
supported the use of alternative methods for requesting services as a 
means of avoiding unnecessary delays if a particular application form 
was not used. In response, the Secretary proposes to clarify the 
regulations by interpreting the term ``submitted an application'' to 
include any request for services as long as the individual has provided 
information necessary for the DSU to initiate an assessment to 
determine eligibility and priority for services. Once an individual or 
the individual's representative, as appropriate, requests services, it 
is expected that State units will make good faith efforts to obtain 
this information as quickly as possible. For example, if a potential 
applicant has requested services in writing, the State unit may need to 
telephone the individual in order to obtain the necessary information 
in a timely manner. In addition, the proposed regulations require State 
units to make application forms readily available throughout the State.

Section 361.42--Assessment for Determining Eligibility and Priority for 
Services

    This section combines Secs. 361.31 and 361.32 of the existing 
regulations, which are the sections on eligibility and preliminary 
diagnostic study. The 1992 Amendments combined in the statute all of 
the evaluation steps that are currently required by those sections and 
by Secs. 361.33 and 361.40 of the existing regulations into one 
assessment for determining eligibility and <strong>vocational</strong> <strong>rehabilitation</strong> 
needs, which is defined in section 7(22) of the Act. The Secretary 
proposes to divide that assessment into two steps in the regulations--
an assessment for determining eligibility and priority for services, 
addressed in this section, and an assessment for determining <strong>vocational</strong> 
<strong>rehabilitation</strong> needs through the development of the IWRP, addressed by 
proposed Sec. 361.45.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend this section by requiring that the 
assessment for determining eligibility and priority for services be 
conducted in the most integrated setting possible, consistent with the 
individual's needs and informed choice.
    Proposed paragraph (a) of this section incorporates the changes in 
the eligibility criteria that were made by the 1992 Amendments, 
including the presumption that an individual with an impairment that 
constitutes a substantial impediment to employment can benefit from 
<strong>vocational</strong> <strong>rehabilitation</strong> services, the presumption that Social 
Security beneficiaries meet the first two eligibility criteria, and the 
new requirement that an individual with a disability require <strong>vocational</strong> 
<strong>rehabilitation</strong> services in order to achieve an employment outcome 
consistent with the individual's strengths, resources, priorities, 
concerns, abilities, capabilities, and informed choice.
    Some commenters questioned the absence of a regulatory provision 
identifying who is qualified to determine the existence of a physical 
or mental impairment. Section 361.32 of the existing regulations 
requires that the preliminary diagnostic study, for purposes of 
determining an individual's eligibility for services, must include 
medical information and, in the case of individuals with mental and 
emotional disorders, an examination by a physician or by a licensed or 
certified psychologist. Proposed paragraph (a)(1)(i) of this section is 
based on amendments to section 103(a) of the Act, which substituted the 
standard that ``qualified personnel in accordance with State licensure 
laws'' make these determinations in lieu of particular medical 
professionals. The proposed regulatory provision broadens this concept 
to also encompass individuals who are certified under State law and 
individuals licensed or certified under State regulations. The 
Secretary believes that this broader interpretation is necessary to 
ensure that existing data and determinations made by other agencies, 
particularly education agencies, are used by DSUs in determining 
whether an individual is an individual with a disability under section 
7(8)(A) of the Act or an individual with a severe disability under 
section 7(15)(A) of the Act. Under the proposed regulations, the 
determination of who is qualified to determine the existence of an 
impairment will vary from State to State depending on State licensure 
and certification requirements. Although the proposed regulations do 
not require a medical diagnosis for a DSU to determine that an 
impairment exists, the Secretary anticipates that in most instances 
those determinations will be supported by medical documentation.
    Paragraph (a)(2) of Sec. 361.42 in the draft regulations required a 
DSU to presume that an applicant can benefit in terms of an employment 
outcome unless it determines, based on clear and convincing evidence, 
that the applicant is incapable of benefitting from VR services as a 
result of the severity of his or her disability. In response to public 
comment, the Secretary proposes to delete the phrase ``as a result of 
the severity of his or her disability'' from the NPRM in order to 
clarify that individuals may be found incapable of 

[[Page 64488]]
benefitting from VR services for reasons other than severity of 
disability. This change is consistent with section 102(a)(4)(A) of the 
Act. Nevertheless, the Secretary expects that the overwhelming majority 
of determinations under this requirement will be based on the severity 
of the individual's disability and specifically requests public 
commenters to identify reasons other than severity of disability that 
would support a determination that an individual is incapable of 
benefitting from VR services. If a determination that an individual 
cannot benefit from VR services is based on the severity of the 
individual's disability, section 102(a)(4)(B) of the Act and proposed 
paragraph (d)(1) of this section would also require the DSU to conduct 
an extended evaluation before reaching this conclusion. Finally, the 
Secretary proposes to further amend paragraph (a)(2) of this section to 
clarify that the presumption of benefit applies only to those 
applicants who meet the first two eligibility criteria.
    In response to public comment on paragraph (b)(1) of this section 
of the draft regulations, the Secretary proposes to amend the 
regulations to prohibit States from imposing any duration of residence 
requirement for the receipt of services on any applicant who is 
present, rather than resides, in the State. The amended provision 
closely tracks the statutory language of section 101(a)(14) of the Act.
    Paragraph (c) of this section incorporates the new statutory 
provisions that require the State unit to use existing data, to the 
extent possible, to determine eligibility and <strong>vocational</strong> <strong>rehabilitation</strong> 
needs.
    Some public commenters on the draft regulations inquired as to the 
scope of <strong>vocational</strong> <strong>rehabilitation</strong> services that DSUs must provide 
during an extended evaluation. In response, the Secretary proposes to 
amend the regulations to require the State unit to develop a written 
plan during the extended evaluation period for determining eligibility 
and for determining the nature and scope of services required to 
achieve an employment outcome. The provision of services under the plan 
must be limited to those services needed to make these two 
determinations. It should be noted that this change represents a 
departure from the current regulations, which required DSUs to develop 
an IWRP for individuals in extended evaluation. The Act, however, 
requires only that IWRPs be developed for eligible individuals. The 
written plan requirements of this section are, therefore, intended to 
lessen the burden on State units of developing IWRPS for individuals in 
an extended evaluation, while ensuring that the specific services to be 
provided during an extended evaluation are clearly identified.
    The proposed regulations also contain a note on clear and 
convincing evidence that is based on legislative history from the 
Senate Committee Report. In response to public comment, the Secretary 
proposes to amend the note to clarify that determinations under the 
``clear and convincing evidence'' standard must be made on a case-by-
case basis.
    Finally, the Secretary views the new eligibility criterion that an 
individual must require <strong>vocational</strong> <strong>rehabilitation</strong> services in order to 
achieve or retain an employment outcome as a limiting factor that is 
intended to screen out individuals who can prepare for, enter into, 
engage in, or retain gainful employment consistent with their 
strengths, resources, priorities, concerns, abilities, and capabilities 
without assistance from the <strong>vocational</strong> <strong>rehabilitation</strong> program. The 
proposed regulations contain a second note that provides several 
examples for guidance to State agencies regarding situations in which 
an individual may or may not require <strong>vocational</strong> <strong>rehabilitation</strong> 
services. The Secretary emphasizes that the examples are provided 
solely for the purposes of illustration, do not address all situations 
under which an individual may be eligible or ineligible for services, 
and are not intended to substitute for individual counselor judgment on 
a case-by-case basis.

Section 361.43--Procedures for Ineligibility Determination

    The Secretary proposes this new section to consolidate overlapping 
provisions relating to procedures for ineligibility determinations that 
are currently contained in several different sections of the 
regulations. Specifically, it would consolidate paragraph (e) of 
current Sec. 361.34, which contains termination provisions for an 
extended evaluation to determine <strong>rehabilitation</strong> potential, paragraph 
(c) of current Sec. 361.35, which contains the requirements for a 
certification of ineligibility, and paragraph (d) of current 
Sec. 361.40, which contains the requirements regarding review of 
ineligibility determinations.
    The Secretary proposes to require DSUs to review all ineligibility 
determinations once within 12 months unless exceptions apply. In 
response to public comment on the draft regulations, the Secretary also 
proposes to amend paragraph (d) of this section to clarify that each 
year after the initial review, DSUs must, upon request, review any 
ineligibility determination that is based on the inability of the 
individual to achieve an employment outcome.

Section 361.44--Closure Without Eligibility Determination

    The Secretary proposes to create this new section from the 
provisions contained in paragraph (e) of Sec. 361.35 of the current 
regulations, which is the section that contains the certification 
requirements. Although the certification requirements have been removed 
from the proposed regulations because they overlap with the 
documentation requirements in the case record (referred to as record of 
services in proposed Sec. 361.47), the substantive requirements related 
to closure without an eligibility determination are substantially the 
same as they are in existing Sec. 361.35(e).
    In response to public comment on the draft regulations, the 
Secretary has clarified the regulations to authorize the State unit to 
close an applicant's case if the applicant declines to participate in, 
or is unavailable to complete, an assessment for determining 
eligibility and priority for services. In either situation, the State 
unit is required to make a reasonable number of attempts to contact the 
individual or, if appropriate, the individual's representative prior to 
closing the applicant's case.

Sec. 361.45--Development of the Individualized Written <strong>Rehabilitation</strong> 
Program

    In response to public comment, this section, entitled ``Assessment 
for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs'' in the draft 
regulations, has been renamed for purposes of clarification. The 
Secretary believes this proposed retitling better reflects the full 
scope of requirements under the IWRP development process, of which the 
assessment represents an essential part. The Secretary also proposes to 
clarify the purpose clause under paragraph (a) of this section for the 
same reason.
    This proposed section would combine the provisions in Secs. 361.33 
and 361.40 of the current regulations regarding thorough diagnostic 
study and IWRP procedures. It incorporates new statutory requirements 
created by the 1992 Amendments, including requirements regarding 
informed choice, integrated settings, and the use of existing data.
    Some public commenters suggested that the term ``counseling and 
guidance'' be defined in the proposed regulations. The Secretary 
declines to define the term, but proposes to revise paragraph (b)(1) of 
this section to 

[[Page 64489]]
emphasize the development of a counseling and guidance relationship 
between the <strong>vocational</strong> <strong>rehabilitation</strong> counselor and the individual 
during assessment. That relationship is intended as a means of 
fostering collaboration between the counselor and the individual in 
identifying, preparing for, and achieving meaningful <strong>vocational</strong> 
outcomes for the individual. The Secretary envisions that the 
counselor, based on his or her expertise, will provide the individual 
with comprehensive information relevant to the individual needs of the 
individual and that the counselor and individual will jointly discuss 
the values, needs, desires, and realities facing both individuals. It 
also should be noted that, in response to public comment, the Secretary 
has deleted the requirement in the draft regulations that counseling 
and guidance be provided throughout the development and implementation 
of the IWRP. As discussed in the following paragraph, IWRPs are 
developed on an individual basis, and while some individuals may 
request or require counseling and guidance services throughout the 
development and implementation of their IWRPs, others may not. By 
making this change, the Secretary emphasizes that the provision of 
counseling and guidance during the development and implementation of 
the IWRP is dependent on the particular circumstances affecting each 
individual.
    Several commenters on the draft regulations were concerned that 
this section required State units to impose strict timelines for 
developing IWRPs without considering the particular needs of the 
individual. In response, the Secretary proposes to amend the 
regulations to require State units to establish and implement standards 
for the prompt development of IWRPs, including timelines that take 
individual needs into consideration. The Secretary agrees that the 
development of the IWRP is a highly individualized process and must be 
conducted in a manner consistent with the individual's strengths, 
priorities, concerns, abilities, capabilities, and career interests. 
Nevertheless, the Secretary believes that these timelines, which are 
not absolute and operate as guidelines, are consistent with the 
legislative intent that individuals with disabilities receive services 
as quickly as possible and, therefore, are necessary to guard against 
delays in the development of the IWRP once an individual is determined 
eligible for VR services.

Section 361.46--Content of the IWRP

    This proposed section contains the IWRP content requirements, which 
are in Sec. 361.41 of the existing regulations.
    Several commenters on the draft regulations viewed certain 
requirements under this section and Sec. 361.47 (Record of services) as 
duplicative of one another and, therefore, unduly burdensome. In 
response, the Secretary proposes to reduce the paperwork requirements 
in each section of the regulations by eliminating certain requirements 
that are non-statutory or redundant. The Secretary emphasizes, however, 
that the elimination of certain documentation requirements in these 
sections is intended solely as a means of reducing paperwork burdens on 
the State unit and does not diminish the responsibility of the State 
unit to fully develop the IWRP and to be able to document or otherwise 
support its determinations affecting each individual should those 
determinations be questioned within the context of a compliance review 
or audit. Each IWRP content or record of services requirement 
eliminated from the draft regulations is, the Secretary believes, 
sufficiently addressed elsewhere in the regulations.
    For example, the Secretary proposes to delete the requirement that 
the IWRP include statements supporting the basis on which individuals 
are determined eligible or ineligible for services. The Secretary 
agrees that those statements are burdensome given comparable case 
record requirements in proposed Sec. 361.47 (a) and (b) that the State 
unit maintain documentation supporting determinations of eligibility 
and ineligibility.
    In paragraph (c) of this section, the Secretary proposes to clarify 
the regulations by consolidating the IWRP content requirements that 
relate to post-employment services.
    Some public commenters on the draft regulations suggested that the 
State unit attach the Individualized Education Plan (IEP) to the IWRP, 
rather than summarize the IEP, when coordinating with education 
agencies to serve transitioning students. In response, the Secretary 
emphasizes that the Secretary does not consider coordination between 
the IWRP and IEP to represent a documentation requirement. Rather, the 
requirement in the draft regulations that the IWRP include a summary of 
the transitioning student's IEP was intended to ensure that the State 
unit review the <strong>vocational</strong> goals, <strong>rehabilitation</strong> objectives, and nature 
and scope of services identified in the transitioning student's IEP 
during the course of developing the IWRP. Requiring that review is 
consistent with the legislative intent that State units coordinate with 
education agencies to serve transitioning students in the most 
effective and efficient manner possible. In an effort to clarify the 
regulations, however, the Secretary proposes to amend this section to 
require the State unit to ensure that the transitioning student's IWRP 
is consistent with the student's IEP in terms of goals, objectives, and 
services. Although the IWRP need not include a summary or an attached 
copy of the IEP, it is expected that, for transitioning students, State 
units will closely review the IEP in the course of IWRP development. In 
addition, the Secretary proposes to amend Sec. 361.47(f) to require the 
State unit to maintain documentation from the needs assessment to 
support the goals, objectives, and services identified in the IWRP and 
in the IEP of transitioning students.
    Finally, in response to public comment, the Secretary proposes to 
add paragraph (e) to this section to require State units to ensure that 
a determination that an individual is ineligible for services after an 
IWRP has been developed is made in accordance with the procedures in 
proposed Sec. 361.43 and is included as an amendment to the IWRP.

Section 361.47--Record of Services

    This proposed section revises Sec. 361.39 of the existing 
regulations. References to the ``case record'' would be replaced with 
the term ``record of services'' to discourage characterizing 
individuals with disabilities as ``cases.'' The proposed section would 
incorporate the choice and integration requirements in the 1992 
Amendments.
    As previously discussed, the Secretary has significantly revised 
this section to reduce paperwork requirements in response to commenters 
on the draft regulations who viewed many of the record of services 
requirements as unduly burdensome or duplicative of other requirements 
in the regulations.
    In response to public comment, the Secretary proposes to simplify 
paragraphs (a) and (b) of this section to require State units to 
maintain documentation to support determinations of eligibility or non-
eligibility made in accordance with proposed Sec. 361.42 or 
Sec. 361.43. The Secretary also proposes to require State units to 
include, as part of an individual's record, documentation supporting 
the determination that an individual has a severe or most severe 
disability. This requirement is 

[[Page 64490]]
particularly important to support an individual's receipt of services 
from a State unit operating under an order of selection or to support 
the individual's placement in a supported employment setting. In 
addition, this requirement is consistent with the intent of the Act to 
expand and improve services to individuals with the most severe 
disabilities.
    In paragraph (d) of this section, the Secretary proposes to 
simplify the requirements relating to extended evaluations by requiring 
State units to maintain documentation to support the need for an 
extended evaluation and to support the periodic assessments conducted 
during the extended evaluation. Documentation maintained under this 
paragraph would also include the written plan developed during the 
extended evaluation in accordance with Sec. 361.42(d)(3).
    In an effort to better coordinate <strong>rehabilitation</strong> services for 
transitioning students, the Secretary also proposes to amend paragraph 
(f) of this section to specify that the State unit must document the 
development of the individual's long-term <strong>vocational</strong> goal, intermediate 
<strong>rehabilitation</strong> objectives, and nature and scope of services, as 
identified in the transitioning student's IWRP and IEP.
    Finally, the Secretary proposes to delete a number of requirements 
from the draft regulations on the basis that the requirements are 
unduly burdensome or unnecessarily duplicative of other provisions in 
the regulations. For example, because the IWRP is included as part of 
the individual's record of services that must be maintained under this 
section, requirements that are duplicative of IWRP content requirements 
in proposed Sec. 361.46 have been deleted from the record of services. 
For each record of services requirement that the Secretary considers 
duplicative of other requirements in the regulations, specific 
references to those other requirements are provided.
    Accordingly, the Secretary proposes to delete the following 
documentation requirements from this section of the draft regulations: 
(1) Documentation of the manner in which the individual was provided 
information necessary to make informed choices as to <strong>vocational</strong> goals, 
<strong>rehabilitation</strong> services, and service providers (addressed by 
Sec. 361.46(a)(6) and Sec. 361.52). (2) Documentation of the manner in 
which the individual was provided information regarding the level of 
integration of service provision and job placement options (addressed 
by Sec. 361.46(a)(7)(iii) and Sec. 361.52). (3) Documentation 
supporting the determination that the clinical status of the individual 
is stable or slowly progressive if physical and mental restoration 
services are provided (addressed by Sec. 361.46(a)(3)). (4) 
Documentation to support any decision to provide services to family 
members (addressed by Sec. 361.46(a)(3)). (5) Documentation relating to 
the individual's participation in the cost of any <strong>vocational</strong> 
<strong>rehabilitation</strong> services, the eligibility of the individual for any 
comparable services and benefits, and the availability and use of those 
comparable service and benefits (addressed by Sec. 361.46(a)(7)). (6) 
Documentation that the individual has been advised of the 
confidentiality of all information pertaining to the individual and 
that any information about the individual has been released with the 
individual's informed written consent (addressed by Sec. 361.46(a)(7) 
and Sec. 361.38). (7) Documentation of any plans to provide post-
employment services after the employment outcome has been achieved 
(addressed by Sec. 361.46(c)). (8) Documentation of any review of the 
determination that an individual is no longer capable of achieving an 
employment outcome after services under an IWRP have already been 
provided (addressed by Sec. 361.43(d)).
    The Secretary is particularly interested in public comment on 
whether the proposed provisions cover all key decision points in the 
<strong>rehabilitation</strong> process for which documentation is needed.

Section 361.48--Scope of <strong>Vocational</strong> <strong>Rehabilitation</strong> Services for 
Individuals With Disabilities

    This proposed section revises Sec. 361.42 of the existing 
regulations.
    The phrase ``counseling and guidance'' in the current regulations 
has been changed in proposed Sec. 361.48(a)(3) to ``<strong>vocational</strong> 
counseling and guidance'' in order to clarify that counseling and 
guidance services that are provided as discrete <strong>vocational</strong> 
<strong>rehabilitation</strong> services are <strong>vocational</strong> in nature and specifically 
designed to assist the individual in reaching an employment outcome. 
<strong>Vocational</strong> counseling and guidance is, therefore, distinguishable from 
the more generalized counseling and guidance that an individual may 
need at any point during the <strong>rehabilitation</strong> process in connection with 
the provision of services.
    A number of paragraphs from the current regulatory section have 
been revised to remove definitional text, and definitions for those 
services have been added to proposed Sec. 361.5. For example, proposed 
Sec. 361.48(a)(5), providing for physical and mental restoration 
services, has been revised to remove all definitional material, which 
is now in proposed Sec. 361.5(b)(35). Proposed paragraph (a)(7) of this 
section, providing for maintenance, has been modified to remove the 
current regulatory provisions that describe maintenance in terms of 
subsistence or basic living expenses, and a proposed definition of 
maintenance has been included in proposed Sec. 361.5(b)(31) to clarify 
that maintenance costs are those expenses that are in excess of normal 
living expenses and that are necessitated by participation in a 
<strong>vocational</strong> <strong>rehabilitation</strong> program. Similarly, proposed paragraph (a)(8) 
of this section provides for transportation in connection with the 
rendering of any <strong>vocational</strong> <strong>rehabilitation</strong> service, and a definition of 
transportation has been added to proposed Sec. 361.5(b)(49), which 
clarifies that transportation must be necessary to enable an applicant 
or eligible individual to participate in a program of <strong>vocational</strong> 
<strong>rehabilitation</strong> services. This change was proposed in the 1991 NPRM.
    Proposed paragraph (a)(9) of this section clarifies that the 
services available to family members are <strong>vocational</strong> <strong>rehabilitation</strong> 
services necessary to enable the applicant or eligible individual to 
achieve an employment outcome.
    Some commenters on the draft regulations requested that the 
provision of ``note-taking services'' not be limited to individuals who 
are deaf or blind. In response, the Secretary agrees that note-taking 
services should be available to any eligible individual in need of 
those services to achieve an employment outcome. Therefore, the 
Secretary proposes to delete ``note-taking'' from proposed paragraphs 
(a)(10) and (a)(11) of this section and emphasizes that these services 
are available under proposed paragraph (a)(20) of this section as 
``other services'' whenever necessary for an eligible individual to 
achieve an employment outcome.
    Proposed paragraph (a)(13) of this section, which provides for job 
search, placement assistance, and job retention services, clarifies the 
scope of services currently available under existing paragraph (a)(12) 
of Sec. 361.42, which provides for placement in suitable employment. 
Proposed paragraphs (a)(14) and (a)(15) of this section incorporate new 
requirements in the statute for supported employment and personal 
assistance services. Proposed paragraph (a)(16) of this section revises 
the paragraph in the existing regulations on post-employment services 
by 

[[Page 64491]]
referring to the proposed definition of post-employment services in 
Sec. 361.5(b)(37). That definition incorporates the language in the 
1992 Amendments regarding advancement in employment and individual 
choice. Finally, proposed paragraph (a)(18) of this section revises the 
paragraph in the existing regulations on <strong>rehabilitation</strong> engineering 
services, consistent with the 1992 Amendments, to provide for 
<strong>rehabilitation</strong> technology services.

Section 361.49--Scope of <strong>Vocational</strong> <strong>Rehabilitation</strong> Services for Groups 
of Individuals With Disabilities

    This proposed section would consolidate provisions from several 
sections of the existing regulations, including the definition of 
<strong>vocational</strong> <strong>rehabilitation</strong> services for the benefit of groups of 
individuals in Sec. 361.1(c) of the existing regulations and 
Secs. 361.50, 361.51, 361.52, and 361.53 of the existing regulations. 
In addition, it would incorporate new requirements imposed by the 1992 
Amendments, such as replacing the concept of the ``establishment of a 
<strong>rehabilitation</strong> facility'' with the concept of the ``establishment, 
development, or improvement of a public or other nonprofit community 
<strong>rehabilitation</strong> program,'' restricting the construction of a 
<strong>rehabilitation</strong> facility to special circumstances, and adding the newly 
authorized service of technical assistance and support services for 
businesses that are not subject to the Americans with Disabilities Act 
and are seeking to employ individuals with disabilities.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend paragraph (a)(5) of this section to clarify 
that the establishment of small business enterprises operated by 
individuals with the most severe disabilities under the State unit's 
supervision includes vending facilities established under the Randolph-
Sheppard program. In addition, the Secretary proposes to amend this 
paragraph to clarify that management services and supervision in 
support of a small business enterprise may be provided by the State 
unit beyond the initial establishment period of six months. The 
Secretary also proposes to clarify the draft regulations to state that 
initial stock and supplies and operational costs for small business 
enterprises may be provided only during the initial six-month 
establishment period. These changes are consistent with section 
103(b)(1) of the Act, as well as with the Randolph-Sheppard Act and its 
implementing regulations in 34 CFR Part 395.

Section 361.50--Written Policies Governing the Provision of Services

    This section contains material from paragraph (b) of Sec. 361.42 of 
the existing regulations, which requires written State policies on the 
scope of <strong>vocational</strong> <strong>rehabilitation</strong> services for individuals, and 
Sec. 361.44 of the existing regulations, which is the section on 
authorization of services. The Secretary proposes to require that a 
State unit have policies regarding the provision of services for groups 
of individuals with disabilities, as well as the availability of 
services for individuals with disabilities.
    In the draft regulations, this proposed section incorporated new 
provisions, based on existing policy and subregulatory guidance, to 
clarify that no absolute caps or limits, in terms of location, cost, or 
duration, could be placed on the availability of services that would 
effectively deny an individual a necessary service. Although these 
provisions are maintained in the proposed regulations, some public 
commenters were concerned that insufficient emphasis was placed on the 
requirement that policies governing the provision of services must be 
designed to meet the <strong>rehabilitation</strong> needs of each individual served by 
the State unit. In response, the Secretary proposes to amend the 
regulations to specify that the policies required to be developed under 
this section must ensure that the provision of services is based on the 
individual's <strong>rehabilitation</strong> needs as identified in the IWRP. As in the 
draft regulations, the proposed section would also prohibit State units 
from arbitrarily limiting the nature or scope of <strong>vocational</strong> 
<strong>rehabilitation</strong> services needed by any eligible individual to achieve an 
employment outcome.
    Some commenters on the draft regulations opposed the ability of 
State units to establish preferences for in-State services on the basis 
that those preferences are inconsistent with principles of individual 
choice. In response, the Secretary proposes to amend the regulations to 
permit individuals to choose out-of-State services over in-State 
services. However, if an individual selects an out-of-State service at 
a higher cost than an in-State service, if either service would meet 
the individual's <strong>rehabilitation</strong> needs, the designated State unit would 
be required to pay only an amount equal to the cost of the in-State 
service.
    The draft regulations would have required State units to provide 
written authorization of services either before or at the same time as 
the purchase of services, except in emergency situations when oral 
authorization, followed by prompt written confirmation, was permitted. 
In response to those commenters on the draft regulations who believed 
that the State unit should have greater flexibility in developing 
policies governing the authorization of services to individuals, the 
Secretary proposes to simplify the regulations to require State units 
to establish policies related to the timely authorization of services, 
including conditions under which verbal authorization can be given.

Section 361.51--Written Standards for Facilities and Providers of 
Services

    This proposed section would incorporate Sec. 361.45 of the existing 
regulations, would expand the requirement for standards to ensure 
accessibility of facilities, and would require new standards regarding 
qualified personnel and fraud, waste, and abuse, consistent with the 
1992 Amendments.
    In response to public comment on the draft regulations, the 
Secretary interprets the accessibility of facilities requirement 
broadly so as not to prevent any individual with a disability, 
including the multi-chemically disabled, from receiving services at a 
facility. In response to public comment, the Secretary also proposes to 
amend the qualified personnel requirements in paragraph (b)(1) of this 
section to reflect the personnel standards included in the State 
agency's comprehensive system of personnel development under section 
361.18(c).

Section 361.52--Opportunity To Make Informed Choices Regarding the 
Selection of Services and Providers

    This proposed new section would implement section 12(e)(1) of the 
Act, which was added by the 1992 Amendments and requires the Secretary 
to promulgate regulations establishing criteria pertaining to the 
selection of <strong>vocational</strong> <strong>rehabilitation</strong> services and providers by an 
individual with a disability.
    In response to public comment on the draft regulations, the 
Secretary proposes to amend this section of the regulations to clarify 
that the concept of informed choice applies to all aspects of the 
<strong>vocational</strong> <strong>rehabilitation</strong> process, including the selection of 
<strong>vocational</strong> goals, intermediate objectives, VR services, and service 
providers. This provision is closely related to the requirement in 
proposed Sec. 361.46(a)(6) that the IWRP include a statement from the 
individual describing the manner in which the individual exercised 
informed choice in selecting among 

[[Page 64492]]
alternative goals, objectives, services, providers, and methods used to 
procure or provide services. The proposed regulations also would 
require that the State unit consult with its State <strong>Rehabilitation</strong> 
Advisory Council, if it has one, when developing its policies for 
facilitating informed choice.
    Several commenters opposed the requirement in the draft regulations 
that State units develop indicators regarding the quality of service 
providers on the basis that such a requirement is overly burdensome and 
likely to lead to disputes, and potentially litigation, between State 
units and providers of VR services. In response, the Secretary proposes 
to amend the regulations to require State units to provide individuals, 
or assist individuals in acquiring, information necessary to make an 
informed choice about the specific services, including the providers of 
those services, that are needed to achieve the individual's <strong>vocational</strong> 
goal. Thus, it is expected that State units will provide, or facilitate 
access to, information concerning cost and accessibility of services, 
level of consumer satisfaction with services, qualifications of service 
providers, and other information necessary to enable the individual to 
make an informed choice among alternative services and providers.
    It should also be noted that in response to public comment and in 
the interest of reducing the burden on State units, the proposed 
regulations would not require DSUs to provide a list of available 
services and the potential providers of those services to each 
individual. Lists of this type, as well as resource materials such as 
consumer satisfaction surveys, are, however, included in the 
regulations as examples of possible sources of information that may be 
used by DSUs to satisfy the information requirements of this section.

Section 361.53--Availability of Comparable Services and Benefits

    This proposed section revises Sec. 361.47(b) of the existing 
regulations.
    As provided for in the draft regulations, the availability of 
comparable services and benefits is based on whether services and 
benefits exist under another program for the individual and whether the 
individual is eligible for those services or benefits. However, the use 
of comparable services and benefits under the draft regulations was 
dependent upon whether the comparable services and benefits were 
``currently available'' to the individual. In response to public 
commenters who expressed confusion as to the meaning of this phrase, 
the Secretary proposes to delete the word ``currently'' from this 
section and to amend the regulations to require DSUs to use comparable 
services and benefits if available to the eligible individual within a 
reasonable period of time that is appropriate for the achievement of 
the intermediate <strong>rehabilitation</strong> objectives identified in the 
individual's IWRP. What constitutes a reasonable period of time would 
vary according to the services identified in each individual's IWRP. By 
making this change, the Secretary emphasizes that the use of comparable 
services and benefits should not unreasonably delay the individual in 
meeting his or her <strong>rehabilitation</strong> objectives.
    In the event comparable services and benefits exist but are not 
available to the individual within a reasonable period of time, the 
proposed regulations would require the State unit to provide VR 
services during the interim period until they become available. In an 
effort to respond to public comment and reduce the burden on DSUs, the 
Secretary proposes to delete the requirement in the draft regulations 
that State units obtain reimbursement for any overlap in benefits once 
the comparable services and benefits become available.
    In response to public comment on the draft regulations, the 
Secretary also proposes to revise the regulations to clarify that a 
determination as to the availability of comparable services and 
benefits is not required in connection with the provision of those 
services listed under paragraph (b) of this section. Although DSUs are 
free to provide these services without pursuing the availability of 
comparable services and benefits, the Secretary encourages State units 
to use known comparable services and benefits whenever possible in 
order to maximize the use of funds provided under this program.
    In response to public comment on the draft regulations, the 
Secretary also proposes to amend paragraph (b) of this section by 
including taped texts and computer accessible formats (sometimes 
referred to as E-text) among those services for which comparable 
services and benefits do not need to be sought. This addition is 
consistent with the Act's legislative history, specifically Conference 
Report No. 102-973.

Section 361.54--Participation of Individuals in Cost of Services Based 
on Financial Need

    This proposed section is taken from Sec. 361.47(a) of the existing 
regulations. It would clarify the requirements that a State unit must 
meet if it chooses to consider the financial need of individuals to 
determine the extent of their participation in the cost of <strong>vocational</strong> 
<strong>rehabilitation</strong> services. The Secretary proposes to clarify the draft 
regulations to require State units to ensure that its policies 
governing financial need be applied uniformly to all individuals in 
similar circumstances. The Secretary interprets this provision, which 
is modeled after existing regulations, to require a State unit to apply 
its financial needs test to each individual in need of a service 
covered by the test without regard to the type of the individual's 
disability. The proposed regulations would also clarify that this 
uniform application requirement does not prohibit setting different 
levels of need for different geographic regions in the State, but 
requires uniform application of the standard to all individuals within 
each geographic region or to all individuals within the State if the 
State unit does not establish geographical differentials. Finally, the 
proposed regulations would clarify that the level of an individual's 
financial participation in the cost of VR services must be reasonable, 
based on the individual's financial need and ability to pay, and must 
not be so high as to effectively deny the individual a necessary 
service.

Section 361.55--Review of Extended Employment in Community 
<strong>Rehabilitation</strong> Programs or Other Employment Under Section 14(c) of the 
Fair Labor Standards Act

    This proposed section is taken, in part, from Sec. 361.58 of the 
existing regulations. In addition to the review of extended employment 
outcomes, the 1992 Amendments require the review of employment outcomes 
in which the individual is compensated in accordance with section 14(c) 
of the Fair Labor Standards Act to determine the individual's needs and 
interests related to competitive employment. This section would also 
incorporate the emphasis in the 1992 Amendments on employment and 
training in integrated settings and would elaborate on the meaning of 
the ``maximum effort'' required of State units in the existing 
regulations to clarify that State units are required to provide 
services to promote movement from extended employment to integrated 
employment.

Section 361.56--Individuals Determined To Have Achieved an Employment 
Outcome

    This proposed section, which has been renamed to conform to the 
changes discussed in the following paragraphs, is taken from 
Sec. 361.43 of the existing regulations. It has been revised to make 
the requirements in the current 

[[Page 64493]]
regulations more outcome-oriented, rather than process-oriented, and to 
incorporate the new statutory emphases on choice and integrated 
settings.
    In an effort to better reflect whether an individual has 
successfully achieved an employment outcome, the draft regulations 
would have extended the period for which an employment outcome must be 
maintained from 60 to 180 days. Several commenters, however, opposed 
the 180-day standard as unduly burdensome and inconsistent with 
individual choice. Some commenters believed that the standard for 
closing an individual's case should be based on the particular 
circumstances of the individual's employment situation, while others 
indicated that the determination as to whether the individual is 
successfully employed should be made jointly by the individual, the 
<strong>rehabilitation</strong> counselor or coordinator, and, in some cases, the 
employer. In response to these comments and to the views expressed by 
members of the focus group that discussed this issue, the Secretary 
proposes to delete the draft requirement that an employment outcome 
must be maintained for 180 days. In its place, the Secretary proposes a 
standard under which the individual must maintain the employment 
outcome for the duration of any probationary period that the employer 
has established for its employees, or, if the employer does not have an 
established probationary period, for a period of at least 90 days. In 
addition, the individual and the <strong>rehabilitation</strong> counselor or 
coordinator must agree that the employment outcome is satisfactory and 
that the individual is performing well on the job. Like the draft 
regulations, this section would also require the State unit to assure 
that the employment outcome is in the most integrated setting possible 
and is consistent with the individual's abilities, capabilities, 
interests, and informed choice. Finally, in response to public comment, 
the Secretary proposes to amend this section to require that the 
provision of services under the individual's IWRP contribute to, rather 
than result in, the achievement of the employment outcome.
    The proposed standard, like that in the draft regulations, is 
intended to strengthen the current minimum 60-day standard for 
maintaining a job placement in an effort to better reflect whether an 
individual has, in fact, successfully achieved an employment outcome. 
The Secretary agrees with those commenters who suggested that 
achievement of an employment outcome should be based, in part, on the 
stability of the individual's employment. In addition, the proposed 
changes from the current regulations are also intended to condition the 
achievement of an employment outcome on the satisfaction of the 
individual, the counselor, and the employer. The Secretary believes 
that the best measure of an employer's satisfaction with an 
individual's job performance is whether the individual has met the 
employer's probationary period. For those individuals whose employers 
have not established a customary probationary period, the Secretary 
views the 90-day minimum as an adequate safeguard to ensure that the 
individual is performing well and is likely to maintain the employment 
outcome. Consistent with the Act's emphasis on informed choice, the 
proposed regulations would also base the decision that an individual 
has achieved an employment outcome on the individual's, as well as the 
counselor's or coordinator's, satisfaction with the employment outcome. 
The Secretary emphasizes that a satisfactory employment outcome, at a 
minimum, must meet the provisions of this section, and the Secretary is 
particularly interested in public comment concerning whether further 
standards for defining ``satisfactory'' should be developed at the 
Federal level.
    The Secretary is continuing to consider issues concerning outcome 
measures for the <strong>vocational</strong> <strong>rehabilitation</strong> program, including the 
proposed time standard in these regulations for maintaining a job 
placement in order to achieve an employment outcome (the duration of 
the employer's probationary period or, in the absence of an employer 
policy in this area, at least 90 days). The Secretary believes that the 
high level of Federal funding for this program--over 78 percent--
warrants close attention to accountability measures to ensure that 
employment outcomes are maintained over time. The Secretary is 
particularly interested in receiving comments on whether the proposed 
job retention standard is strong enough to achieve this result.
    The Secretary is also interested in receiving comments about the 
relationship between closure requirements for the <strong>vocational</strong> 
<strong>rehabilitation</strong> program and other programs, including those under the 
Job Training Partnership Act (13 weeks), the Social Security 
beneficiary <strong>rehabilitation</strong> program (9 months of substantial gainful 
activity), and other State manpower development and job training 
programs. Finally, the Secretary is interested in comments on the 
impact of the proposed new employment outcome standard and whether, in 
comparison to the current standard, it would likely increase or 
decrease the number of individuals with disabilities achieving long-
term employment outcomes.

Section 361.57--Review of <strong>Rehabilitation</strong> Counselor and Coordinator 
Determinations

    This proposed section is taken from Sec. 361.48 of the existing 
regulations.
    In accordance with the Department's principles for regulating, the 
Secretary proposes to delete all non-statutory timelines from this 
section of the draft regulations. In place of specific time limits, the 
proposed regulations would require each DSU, in consultation with its 
State <strong>Rehabilitation</strong> Advisory Council, if it has one, to develop 
reasonable timelines for key stages of the appeal process to ensure 
that appeals are handled promptly. Specifically, DSU's would be 
required to develop timelines to ensure that hearings are held within a 
reasonable time after an individual's request for review, that the 
initial decision of the impartial hearing officer is rendered within a 
reasonable time after the hearing is completed, and that the final 
decision of the DSU director is rendered within a reasonable time after 
notifying the individual of the director's intent to review the initial 
decision. These changes are intended to provide DSU's with increased 
flexibility to develop appropriate timelines, while protecting 
individuals against unreasonable delays in the review process. Like the 
current regulations, this proposed provision also would permit a DSU to 
establish an informal process to resolve a request for review without 
conducting a formal hearing, but would require the DSU to conduct a 
hearing within the relevant State-developed timeline if informal 
resolution is unsuccessful. The Secretary particularly requests public 
comment on whether a specific overall time limit for completing the 
entire formal review process (e.g., 125 days) should be required under 
the regulations.
    This section would incorporate the requirement in the 1992 
Amendments that prohibits the State unit from instituting a suspension, 
reduction, or termination of services pending a final State hearing 
determination unless the agency has evidence that the services were 
obtained through fraud, misrepresentation, collusion, or criminal 
conduct on the part of the individual, or the individual so requests. 
The Secretary interprets this provision to mean that services may be 
suspended, reduced, or terminated 

[[Page 64494]]
pending a final determination if there is ``substantial evidence'' of 
that conduct.
    This proposed section also incorporates the requirement in the 1992 
Amendments that the director not overturn or modify the decision of an 
impartial hearing officer unless the director concludes, based on clear 
and convincing evidence, that the decision of the impartial hearing 
officer is clearly erroneous because it is ``contrary to Federal or 
State law, including policy.'' The Secretary interprets this statutory 
language to include a decision that is contrary to the approved State 
plan, the Act, or Federal or State <strong>vocational</strong> <strong>rehabilitation</strong> 
regulations or policy.
    It should be noted that the Secretary has changed the term 
``calendar day'' from the draft regulations to ``day'' in the proposed 
regulations in response to public commenters who inquired as to the 
difference in meaning between the two terms. Procedural time limits in 
this section and throughout the regulations are, therefore, measured in 
terms of ``days,'' which the Secretary intends to mean ``calendar 
days'' rather than ``working days.''
    Finally, in response to public comment on the draft regulations, 
the Secretary proposes to add to paragraph (f) of this section a 
requirement that the DSU inform applicants and eligible individuals of 
the manner in which it selects impartial hearing officers.

Section 361.60--Matching Requirements

    This proposed new section would clarify the matching requirements 
by consolidating all of the Federal and non-Federal share provisions. 
Proposed paragraph (a) of this section contains the general Federal 
share provision, which is in Sec. 361.86(a) of the existing regulations 
and was revised by the 1992 Amendments to be 78.7 percent. Proposed 
paragraph (a) of this section also contains the 50 percent Federal 
share provision for construction projects, which is in Sec. 361.74(b) 
of the existing regulations, and the 90 percent Federal share provision 
for innovation and expansion grant activities, which is addressed in 
Sec. 361.153 of the existing regulations.
    In accordance with the Department's principles for regulating, the 
Secretary proposes to simplify the requirements relating to the non-
Federal share in the draft regulations by removing from the regulations 
a list of permissible sources of expenditures to meet the non-Federal 
share and instead cross-referencing the applicability of the matching 
or cost sharing requirements in 34 CFR 80.24 of EDGAR with certain 
exceptions. The proposed regulations would specify that third party in-
kind contributions, which are a permissible source of matching funds 
under EDGAR, may not be used as part of the non-Federal share under the 
VR program. In addition, the proposed regulations would continue, but 
clarify, existing regulatory requirements that prohibit earmarked 
donations that benefit the donor from being used to meet the non-
Federal share. The Secretary wishes to emphasize that the changes 
proposed with regard to meeting the non-Federal share would not 
prohibit the use of any funding sources that are currently allowable.

Section 361.61--Limitation on Use of Funds for Construction 
Expenditures

    This proposed new section sets out in a separate section the 
requirement in paragraph (d) of Sec. 361.85 of the existing regulations 
that no more than 10 percent of a State's allotment may be used for 
construction.

Section 361.62--Maintenance of Effort Requirements

    This proposed section is taken from Sec. 361.86 of the existing 
regulations. It incorporates provisions in the 1992 Amendments, which 
changed the standard on which the maintenance of effort level is based 
from the average of the three prior fiscal years to the second prior 
fiscal year. It also folds into the same section a separate maintenance 
of effort requirement relating to the construction of facilities that 
is contained in both Sec. 361.52(e) and Sec. 361.85(d) of the existing 
regulations. This proposed section clarifies the procedures the 
Secretary follows for determining whether maintenance of effort 
requirements have been met and for reducing the amount payable in the 
case of a maintenance of effort deficit if there is a separate State 
agency for <strong>vocational</strong> <strong>rehabilitation</strong> services for individuals who are 
blind.

Section 361.63--Program Income

    This proposed new section consolidates in one place all of the 
provisions related to program income. Proposed paragraph (a) of this 
section incorporates the definition of program income from EDGAR (34 
CFR 80.25(b)). Proposed paragraph (b) of this section incorporates 
existing subregulatory guidance regarding the sources of program 
income. Proposed paragraph (c)(1) of this section incorporates the 
general EDGAR requirement that program income must be used in the 
program in which it is earned, but makes an exception for Social 
Security reimbursements as provided in section 108 of the Act. Proposed 
paragraph (c)(1) of this section would clarify that program income is 
considered earned when it is received.
    In response to public comment on the draft regulations, the 
Secretary proposes to delete from proposed paragraph (c)(3)(ii) of this 
section the requirement that the State notify the Secretary prior to 
using the deduction method for accounting for program income. By 
removing this condition, the Secretary emphasizes that the State is 
free either to use program income to expand its <strong>vocational</strong> 
<strong>rehabilitation</strong> program or to deduct it from its total allowable costs, 
without seeking prior Federal approval.
    Proposed paragraph (c)(4) of this section would clarify that 
program income may not be used to meet the non-Federal share 
requirement.

Section 361.64--Obligation of Federal Funds and Program Income

    This proposed new section incorporates the amendment to section 19 
of the Act, which clarifies that both Federal funds, including 
reallotted funds, and program income from all sources may be carried 
over for obligation from the year in which the funds are received until 
the end of the following year.
    In response to public comments on the draft regulations, the 
Secretary proposes to amend paragraph (b) of this section to clarify 
that the State unit may carry over any portion of unobligated Federal 
funds that it has matched by obligating non-Federal funds during the 
fiscal year for which the Federal funds were appropriated. This 
clarification is consistent with section 19 of the Act, which allows 
for carryover of Federal funds ``to the extent'' that recipients comply 
with Federal share requirements.

Section 361.65--Allotment and Payment of Federal Funds for <strong>Vocational</strong> 
<strong>Rehabilitation</strong> Services

    This proposed section is taken from Secs. 361.85 and 361.87 of the 
existing regulations.

Section 361.70--Purpose of the Strategic Plan

    This proposed section implements new section 120 of the Act, which 
makes grants under Part B of the Act, as well as innovation and 
expansion grants under Part C of the Act, contingent on the preparation 
and submission of a statewide strategic plan.

Section 361.71--Procedures for Developing the Strategic Plan

    This proposed new section implements new section 122 of the Act, 
which requires the State to hold public forums and meet with members of 
the 

[[Page 64495]]
State <strong>Rehabilitation</strong> Advisory Council and the Statewide Independent 
Living Council prior to developing the strategic plan. The Secretary 
interprets the public forum requirement in the statute to require the 
same procedures for public input on the strategic plan that are 
required for the development of the State plan under Sec. 361.20 of the 
proposed regulations.

Section 361.72--Content of the Strategic Plan

    This proposed new section incorporates the new requirements in 
section 121 of the Act with no substantive changes.

Section 361.73--Use of Funds

    This proposed new section incorporates the requirements in new 
sections 101(a)(34)(B) and 123 of the Act. The Secretary interprets 
101(a)(34)(B) to require that at least 1.5 percent of the funds 
received under Part B of the Act be used for the activities identified 
in section 123. The Secretary has clarified that all funds received 
under Part C of the Act must be used for activities identified in a 
State's strategic plan, which may include, but are not limited to, the 
activities identified in section 123 of the Act.

Section 361.74--Allotment of Federal Funds

    This proposed new section incorporates by reference the 
requirements of new section 124 of the Act without substantive change.

Executive Order 12866

1. Assessment of Costs and Benefits

    These proposed regulations have been reviewed in accordance with 
Executive Order 12866. Under the terms of the order the Secretary has 
assessed the potential costs and benefits of this regulatory action.
    The potential costs associated with the proposed regulations are 
those resulting from statutory requirements and those determined by the 
Secretary to be necessary for administering this program effectively 
and efficiently. Burdens specifically associated with information 
collection requirements, if any, are identified and explained elsewhere 
in this preamble under the heading Paperwork Reduction Act of 1995.
    In assessing the potential costs and benefits--both quantitative 
and qualitative--of these proposed regulations, the Secretary has 
determined that the benefits of the proposed regulations justify the 
costs. A further discussion of the potential costs and benefits of 
these proposed regulations is contained in the summary at the end of 
this section of the preamble.
    The Secretary has also determined that this regulatory action does 
not unduly interfere with State, local, and tribal governments in the 
exercise of their governmental functions.
    To assist the Department in complying with the specific 
requirements of Executive Order 12866, the Secretary invites comment on 
whether there may be further opportunities to reduce any potential 
costs or increase potential benefits resulting from these proposed 
regulations without impeding the effective and efficient administration 
of the program.
    Summary of potential benefits relative to potential costs of the 
regulatory provisions discussed previously in this preamble:
    The Secretary believes that the NPRM would substantially improve 
The State VR Services Program and would yield substantial benefits in 
terms of program management, efficiency, and effectiveness. The 
Secretary also believes that the proposed regulations represent the 
least burdensome way to implement the 1992 Amendments to Title I of the 
Act and fulfill important policy objectives that the Secretary 
considers essential to the success of the program. As stated previously 
in this preamble, the NPRM has been revised consistent with the 
Department's principles for regulating, which were developed during the 
Administration's regulatory reinvention initiative, to further reduce 
paperwork or process requirements and to enhance the flexibility of 
DSUs to meet non-statutory requirements. Increased flexibility of DSUs 
and other benefits resulting from the proposed regulations are 
discussed in the following paragraphs of this section and throughout 
the section-by-section summary of the preamble.
Improved Organization of Regulations
    The NPRM would substantially reorganize and clarify the current 
program regulations in order to make the regulations easier to 
understand and more useful. In response to requests from members of the 
<strong>vocational</strong> <strong>rehabilitation</strong> community, the proposed regulations also 
would include definitions of a number of previously undefined terms, 
including ``comparable services and benefits,'' ``maintenance,'' and 
``post-employment services.''
Notes and Examples
    The Secretary has provided additional clarifying information in the 
proposed regulations through the use of notes and examples. Many 
commenters to the draft regulations stated that they find this 
information more accessible and more useful when it is included in the 
regulations rather than issued separately by RSA as subregulatory 
guidance. As stated previously throughout this preamble, the Secretary 
emphasizes that the limited notes and examples in the proposed 
regulations are purely illustrative and are not intended to restrict 
State flexibility.
Reduction of Grantee Burden
    Non-statutory paperwork requirements have been eliminated or 
consolidated throughout the NPRM in an effort to reduce the regulatory 
burden on States. For example, previously duplicative requirements 
under Sec. 361.46 (Content of the IWRP) and Sec. 361.47 (Record of 
services) have been consolidated to reduce the paperwork burden on 
States and to ensure efficient administration of the program. A list of 
other sections in which paperwork burden on grantees has been removed 
or reduced in response to public comment on the draft regulations 
precedes the section-by-section summary in this preamble. Also, 
additional burden-reducing steps taken by the Secretary in accordance 
with the Department's principles for regulating are explained 
throughout the section-by-section summary in the preamble. For example, 
the proposed deletion of the requirement that the State plan describe 
the organizational structure of the State agency and its organizational 
units is discussed under Sec. 361.13 (State agency for administration) 
in the section-by-section summary. Those paperwork requirements that 
would remain in the proposed regulations are considered essential to 
the proper administration of the program.
Enhanced Protections for Individuals With Disabilities
    The proposed regulations include provisions intended to ensure that 
individuals with disabilities are not improperly denied necessary VR 
services. In particular, Sec. 361.50 (Written policies governing the 
provision of services) would require DSUs to ensure that the provision 
of VR services for an eligible individual is based on the individual's 
particular <strong>rehabilitation</strong> needs and would prevent DSUs from arbitrarily 
limiting the nature or scope of <strong>vocational</strong> <strong>rehabilitation</strong> services 
needed by any eligible individual to achieve an employment outcome. In 
addition, Sec. 361.54 (Participation of individuals in cost of services 
based on financial need) would require DSUs to 

[[Page 64496]]
apply a State financial needs test to each individual in need of a 
service covered by the test without regard to type of disability. This 
section would also require DSUs to ensure that the level of an 
individual's financial participation in the cost of VR services is 
reasonable, based on the individual's ability to pay, and not so high 
as to effectively deny the individual a necessary service.
Increased Flexibility of Grantees to Satisfy Statutory Requirements
    A number of provisions in the proposed regulations have been 
revised in an effort to enhance the flexibility of States in meeting 
specific statutory requirements. For example, proposed Sec. 361.20 
(State plan development) would allow States to determine what 
constitutes appropriate and sufficient notice under the Act for 
purposes of providing notice of public meetings on State plan 
development. Although the proposed regulations would not impose any 
specific minimum Federal requirements for what constitutes 
``appropriate and sufficient notice,'' the section-by-section summary 
of this proposed section identifies suggested ways a DSU might meet 
these requirements. Similarly, Sec. 361.52 (Opportunity to make 
informed choices regarding the selection of services and providers) of 
the proposed regulations identifies possible methods a DSU may follow 
or sources of information a DSU may maintain to ensure that each 
eligible individual is afforded an opportunity, as required under the 
Act, to make an informed choice in selecting <strong>vocational</strong> <strong>rehabilitation</strong> 
services and providers. Finally, proposed Sec. 361.57 (Review of 
<strong>rehabilitation</strong> counselor and coordinator determinations) would allow 
States to establish their own timelines for key stages of the 
statutorily-mandated fair hearing process.
Additional Benefits
    The proposed regulations reflect the policy in the 1992 Amendments 
of ensuring that individuals are provided necessary information through 
appropriate modes of communication to enable them to participate in a 
<strong>rehabilitation</strong> program or to influence DSU <strong>rehabilitation</strong> policy 
development. For example, proposed Sec. 361.20(d) requires a DSU, in 
developing its State plan, to provide, through appropriate modes of 
communication, the notices of the public meetings, any materials 
furnished prior to or during the public meetings, and the approved 
State plan.

2. Clarity of the Regulations

    Executive Order 12866 requires each agency to write regulations 
that are easy to understand.
    The Secretary invites comments on how to make these proposed 
regulations easier to understand, including answers to questions such 
as the following: (1) Are the requirements in the proposed regulations 
clearly stated? (2) Do the regulations contain technical terms or other 
wording that interferes with their clarity? (3) Does the format of the 
regulations (grouping and order of sections, use of headings, 
paragraphing, etc.) aid or reduce their clarity? Would the regulations 
be easier to understand if they were divided into more (but shorter) 
sections? (A ``section'' is preceded by the symbol ``Sec. '' and a 
numbered heading; for example, Sec. 361.5 Applicable definitions.) (4) 
Is the description of the regulations in the ``Supplementary 
Information'' section of this preamble helpful in understanding the 
regulations? How could this description be more helpful in making the 
regulations easier to understand? (5) What else could the Department do 
to make the regulations easier to understand?
    A copy of any comments that concern how the Department could make 
these proposed regulations easier to understand should be sent to 
Stanley M. Cohen, Regulations Quality Officer, U.S. Department of 
Education, 600 Independence Avenue, S.W. (Room 5100, FB-10B), 
Washington, D.C. 20202-2241.

Regulatory Flexibility Act Certification

    The Secretary certifies that these proposed regulations would not 
have a significant economic impact on a substantial number of small 
entities.
    Because these proposed regulations would affect only States and 
State agencies, the regulations would not have an impact on small 
entities. States and State agencies are not defined as ``small 
entities'' in the Regulatory Flexibility Act.

Paperwork Reduction Act of 1995

    Sections 361.10, 361.13, 361.14, 361.15, 361.16, 361.17, 361.18, 
361.19, 361.20, 361.21, 361.22, 361.26, 361.27, 361.29, 361.33, 361.34, 
361.35, 361.37, 361.40, 361.46, 361.48, 361.49, 361.50, 361.51, 361.52, 
361.54, 361.57, 361.71, and 361.72 contain information collection 
requirements. As required by the Paperwork Reduction Act of 1995 (44 
U.S.C. 3507(d)), the Department of Education has submitted a copy of 
these sections to the Office of Management and Budget (OMB) for its 
review.
Collection of Information: The State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services 
Program
    States are eligible to apply for grants under these regulations. 
The information to be collected includes State plan assurances and 
descriptions to meet statutory requirements. The Department needs and 
uses the information to review State plans to determine whether they 
can be approved. Approval of a State plan is necessary to receive a 
grant under this program.
    All information is to be collected and reported once every three 
years, with the exception of the following information, which is 
required annually: advice provided by the State <strong>Rehabilitation</strong> Advisory 
Council under Sec. 361.16; collection and analysis of data on qualified 
personnel needs and personnel development under Sec. 361.18; analysis 
of characteristics of individuals determined to be ineligible for 
services and reasons for their ineligibility, evaluation of the 
effectiveness of the State's <strong>vocational</strong> <strong>rehabilitation</strong> program, any 
changes adopted in State policy or in the State plan as a result of 
statewide studies and the annual program evaluation, and the methods 
used to expand and improve <strong>vocational</strong> <strong>rehabilitation</strong> services to 
individuals with the most severe disabilities under Sec. 361.29; 
revisions to the supported employment plan under Sec. 361.34; a 
description of the manner in which <strong>rehabilitation</strong> technology services 
will be provided throughout the <strong>rehabilitation</strong> process, the personnel 
training that will be provided to facilitate the provision of 
<strong>rehabilitation</strong> technology services, and the manner in which personal 
assistance services will be provided to individuals with disabilities 
under Sec. 361.48. Annual reporting and recordkeeping burden for this 
collection of information is estimated to average 221.2 hours per 
response for 82 respondents, including the time for reviewing 
instructions, searching existing data sources, gathering and 
maintaining the data needed, and completing and reviewing the 
collection of information. Thus, the total annual reporting and 
recordkeeping burden for this collection is estimated to be 18,138.4 
hours.
    Organizations and individuals desiring to submit comments on the 
information collection requirements should direct them to the Office of 
Information and Regulatory Affairs, OMB, Room 10235, New Executive 
Office Building, Washington, D.C. 20503; Attention: Laura Oliven. 

[[Page 64497]]

    The Department considers comments by the public on these proposed 
collections of information in--
    &lt;bullet&gt; Evaluating whether the proposed collections of information 
are necessary for the proper performance of the functions of the 
Department, including whether the information will have practical 
utility;
    &lt;bullet&gt; Evaluating the accuracy of the Department's estimate of 
the burden of the proposed collections of information, including the 
validity of the methodology and assumptions used;
    &lt;bullet&gt; Enhancing the quality, usefulness, and clarity of the 
information to be collected; and
    &lt;bullet&gt; Minimizing the burden of the collection of information on 
those who are to respond, including through the use of appropriate 
automated, electronic, mechanical, or other technological collection 
techniques or other forms of information technology; e.g., permitting 
electronic submission of responses.
    OMB is required to make a decision concerning the collections of 
information contained in these proposed regulations between 30 and 60 
days after publication of this document in the Federal Register. 
Therefore, a comment to OMB is best assured of having its full effect 
if OMB receives it within 30 days of publication. This does not affect 
the deadline for the public to comment to the Department on the 
proposed regulations.

Intergovernmental Review

    This program is subject to the requirements of Executive Order 
12372 and the regulations in 34 CFR part 79. The objective of the 
Executive order is to foster an intergovernmental partnership and a 
strengthened federalism by relying on processes developed by State and 
local governments for coordination and review of proposed Federal 
financial assistance.
    In accordance with the order, this document is intended to provide 
early notification of the Department's specific plans and actions for 
this program.
    Invitation to Comment: Interested persons are invited to submit 
comments and recommendations regarding these proposed regulations.
    All comments submitted in response to these proposed regulations 
will be available for public inspection, during and after the comment 
period, in Room 3214, 330 C Street SW., Washington, D.C., between the 
hours of 8:30 a.m. and 4:00 p.m., Monday through Friday of each week 
except Federal holidays.

Assessment of Educational Impact

    The Secretary particularly requests comments on whether the 
proposed regulations in this document would require transmission of 
information that is being gathered by or is available from any other 
agency or authority of the United States.

List of Subjects in 34 CFR Part 361

    Reporting and recordkeeping requirements, State-administered grant 
program--education, <strong>Vocational</strong> <strong>rehabilitation</strong>.

    Dated: August 28, 1995.
Richard W. Riley,
Secretary of Education.

(Catalog of Federal Domestic Assistance Number 84.126--The State 
<strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program)

    The Secretary proposes to amend Title 34 of the Code of Federal 
Regulations by revising Part 361 to read as follows:

PART 361--THE STATE <strong>VOCATIONAL</strong> <strong>REHABILITATION</strong> SERVICES PROGRAM

Subpart A--General

Sec.
361.1  Purpose.
361.2  Eligibility for a grant.
361.3  Authorized activities.
361.4  Applicable regulations.
361.5  Applicable definitions.
Subpart B--State Plan for <strong>Vocational</strong> <strong>Rehabilitation</strong> Services
361.10  Submission, approval, and disapproval of the State plan.
361.11  Withholding of funds.

State Plan Content: Administration

361.12  Methods of administration.
361.13  State agency for administration.
361.14  Substitute State agency.
361.15  Local administration.
361.16  Establishment of an independent commission or a State 
<strong>Rehabilitation</strong> Advisory Council.
361.17  Requirements for a State <strong>Rehabilitation</strong> Advisory Council.
361.18  Comprehensive system of personnel development.
361.19  Affirmative action for individuals with disabilities.
361.20  State plan development.
361.21  Consultations regarding the administration of the State 
plan.
361.22  Cooperation with agencies responsible for transitioning 
students.
361.23  Cooperation with other public agencies.
361.24  Coordination with the Statewide Independent Living Council.
361.25  Statewideness.
361.26  Waiver of statewideness.
361.27  Shared funding and administration of joint programs.
361.28  Third-party cooperative arrangements involving funds from 
other public agencies.
361.29  Statewide studies and evaluations.
361.30  Services to special groups of individuals with disabilities.
361.31  Utilization of community resources.
361.32  Utilization of profitmaking organizations for on-the-job 
training in connection with selected projects.
361.33  Utilization of community <strong>rehabilitation</strong> programs.
361.34  Supported employment plan.
361.35  Strategic plan.
361.36  [Reserved].
361.37  Establishment and maintenance of information and referral 
resources.
361.38  Protection, use, and release of personal information.
361.39  State-imposed requirements.
361.40  Reports.

State Plan Content: Provision and Scope of Services

361.41  Processing referrals and applications.
361.42  Assessment for determining eligibility and priority for 
services.
361.43  Procedures for ineligibility determination.
361.44  Closure without eligibility determination.
361.45  Development of the individualized written <strong>rehabilitation</strong> 
program.
361.46  Content of the individualized written <strong>rehabilitation</strong> 
program.
361.47  Record of services.
361.48  Scope of <strong>vocational</strong> <strong>rehabilitation</strong> services for individuals 
with disabilities.
361.49  Scope of <strong>vocational</strong> <strong>rehabilitation</strong> services for groups of 
individuals with disabilities.
361.50  Written policies governing the provision of services.
361.51  Written standards for facilities and providers of services.
361.52  Opportunity to make informed choices regarding the selection 
of services and providers.
361.53  Availability of comparable services and benefits.
361.54  Participation of individuals in cost of services based on 
financial need.
361.55  Review of extended employment in community <strong>rehabilitation</strong> 
programs or other employment under section 14(c) of the Fair Labor 
Standards Act.
361.56  Individuals determined to have achieved an employment 
outcome.
361.57  Review of <strong>rehabilitation</strong> counselor or coordinator 
determinations.
Subpart C--Financing of State <strong>Vocational</strong> <strong>Rehabilitation</strong> Programs
361.60  Matching requirements.
361.61  Limitation on use of funds for construction expenditures.
361.62  Maintenance of effort requirements.
361.63  Program income.
361.64  Obligation of Federal funds and program income.
361.65  Allotment and payment of Federal funds for <strong>vocational</strong> 
<strong>rehabilitation</strong> services. 

[[Page 64498]]

Subpart D--Strategic Plan for Innovation and Expansion of <strong>Vocational</strong> 
<strong>Rehabilitation</strong> Services
361.70  Purpose of the strategic plan.
361.71  Procedures for developing the strategic plan.
361.72  Content of the strategic plan.
361.73  Use of funds.
361.74  Allotment of Federal funds.
    Authority: 29 U.S.C. 711(c), unless otherwise noted.

Subpart A--General


Sec. 361.1  Purpose.

    Under the State <strong>Vocational</strong> <strong>Rehabilitation</strong> Services Program 
(program), the Secretary provides grants to assist States in operating 
a comprehensive, coordinated, effective, efficient, and accountable 
program that is designed to assess, plan, develop, and provide 
<strong>vocational</strong> <strong>rehabilitation</strong> services for individuals with disabilities, 
consistent with their strengths, resources, priorities, concerns, 
abilities, capabilities, and informed choice, so that they may prepare 
for and engage in gainful employment.

(Authority: Sections 12(c) and 100(a)(2) of the Act; 29 U.S.C. 
711(c) and 720(a)(2))


Sec. 361.2  Eligibility for a grant.

    Any State that submits to the Secretary a State plan that meets the 
requirements of section 101(a) of the Act and this part is eligible for 
a grant under this program.

(Authority: Section 101(a) of the Act; 29 U.S.C. 721(a))


Sec. 361.3  Authorized activities.

    The Secretary makes payments to a State to assist in--
    (a) The costs of providing <strong>vocational</strong> <strong>rehabilitation</strong> services under 
the State plan;
    (b) Administrative costs under the State plan; and
    (c) The costs of developing and implementing the strategic plan.

(Authority: Section 111(a)(1) of the Act; 29 U.S.C. 731(a)(1))


Sec. 361.4  Applicable regulations.

    The following regulations apply to this program:
    (a) The Education Department General Administrative Regulations 
(EDGAR) as follows:
    (1) 34 CFR Part 74 (Administration of Grants to Institutions of 
Higher Education, Hospitals, and Nonprofit Organizations), with respect 
to subgrants to entities that are not State or local governments or 
Indian tribal organizations.
    (2) 34 CFR Part 76 (State-Administered Programs).
    (3) 34 CFR Part 77 (Definitions that Apply to Department 
Regulations).
    (4) 34 CFR Part 79 (Intergovernmental Review of Department of 
Education Programs and Activities).
    (5) 34 CFR Part 80 (Uniform Administrative Requirements for Grants 
and Cooperative Agreements to State and Local Governments), except for 
Sec. 80.24(a)(2).
    (6) 34 CFR Part 81 (General Education Provisions Act-Enforcement).
    (7) 34 CFR Part 82 (New Restrictions on Lobbying).
    (8) 34 CFR Part 85 (Governmentwide Debarment and Suspension 
(Nonprocurement) and Governmentwide Requirements for Drug-Free 
Workplace (Grants)).
    (9) 34 CFR Part 86 (Drug-Free Schools and Campuses).
    (b) The regulations in this part 361.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))


Sec. 361.5  Applicable definitions.

    (a) Definitions in EDGAR. The following terms used in this part are 
defined in 34 CFR 77.1:

Department
EDGAR
Fiscal year
Nonprofit
Private
Public
Secretary

    (b) Other definitions. The following definitions also apply to this 
part:
    (1) Act means the <strong>Rehabilitation</strong> Act of 1973 (29 U.S.C. 701 et 
seq.), as amended.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))
    (2) Administrative costs under the State plan means expenses 
related to program planning, development, monitoring, and evaluation, 
including, but not limited to, quality assurance; budgeting, 
accounting, financial management, statistical systems, and related data 
processing; providing information about the program to the public; 
technical assistance to other State agencies, private nonprofit 
organizations, and businesses and industries; the State <strong>Rehabilitation</strong> 
Advisory Council and other advisory committees; professional 
organization membership dues for State unit employees; the removal of 
architectural barriers in State agency offices and facilities; 
operating and maintaining State unit facilities, equipment, and 
grounds; supplies; administration of the comprehensive system of 
personnel development, including personnel administration, 
administration of affirmative action plans, and training and staff 
development; administrative salaries, including clerical and other 
support staff salaries, in support of these functions; travel costs 
related to carrying out the program, other than travel costs related to 
the provision of services; and legal expenses required in the 
administration of the program.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (3) American Indian means an individual who is a member of an 
Indian tribe.

(Authority: Section 7(20) of the Act; 29 U.S.C. 706(20))

    (4) Applicant means an individual who submits an application for 
<strong>vocational</strong> <strong>rehabilitation</strong> services in accordance with 
Sec. 361.41(b)(2).

(Authority: Section 12(c) of the Act; 29 U.S.C.711 (c))

    (5) Appropriate modes of communication means specialized media 
systems and devices for individuals with disabilities that enable an 
individual to comprehend and respond to information that is being 
communicated. Appropriate modes of communication include, but are not 
limited to, the use of interpreters, open and closed captioned videos, 
specialized telecommunications services and audio recordings, Brailled 
and large print materials, materials in electronic formats, and 
augmentative communication devices.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (6) Assistive technology device means any item, piece of equipment, 
or product system, whether acquired commercially off the shelf, 
modified, or customized, that is used to increase, maintain, or improve 
the functional capabilities of an individual with a disability.

(Authority: Section 7(23) of the Act; 29 U.S.C. 706(23))

    (7) Assistive technology service means any service that directly 
assists an individual with a disability in the selection, acquisition, 
or use of an assistive technology device, including--
    (i) The evaluation of the needs of an individual with a disability, 
including a functional evaluation of the individual in his or her 
customary environment;
    (ii) Purchasing, leasing, or otherwise providing for the 
acquisition by an individual with a disability of an assistive 
technology device;
    (iii) Selecting, designing, fitting, customizing, adapting, 
applying, maintaining, repairing, or replacing assistive technology 
devices; 

[[Page 64499]]

    (iv) Coordinating and using other therapies, interventions, or 
services with assistive technology devices, such as those associated 
with existing education and <strong>rehabilitation</strong> plans and programs;
    (v) Training or technical assistance for an individual with a 
disability or, if appropriate, the family members, guardians, 
advocates, or authorized representatives of the individual; and
    (vi) Training or technical assistance for professionals (including 
individuals providing education and <strong>rehabilitation</strong> services), 
employers, or others who provide services to, employ, or are otherwise 
substantially involved in the major life functions of individuals with 
disabilities, to the extent that training or technical assistance is 
necessary to the achievement of an employment outcome by an individual 
with a disability.

(Authority: Sections 7(24) and 12(c) of the Act; 29 U.S.C. 706(24) 
and 711(c))

    (8) Community <strong>rehabilitation</strong> program.
    (i) Community <strong>rehabilitation</strong> program means a program that provides 
directly or facilitates the provision of one or more of the following 
<strong>vocational</strong> <strong>rehabilitation</strong> services to individuals with disabilities to 
enable those individuals to maximize their opportunities for 
employment, including career advancement:
    (A) Medical, psychiatric, psychological, social, and <strong>vocational</strong> 
services that are provided under one management.
    (B) Testing, fitting, or training in the use of prosthetic and 
orthotic devices.
    (C) Recreational therapy.
    (D) Physical and occupational therapy.
    (E) Speech, language, and hearing therapy.
    (F) Psychiatric, psychological, and social services, including 
positive behavior management.
    (G) Assessment for determining eligibility and <strong>vocational</strong> 
<strong>rehabilitation</strong> needs.
    (H) <strong>Rehabilitation</strong> technology.
    (I) Job development, placement, and retention services.
    (J) Evaluation or control of specific disabilities.
    (K) Orientation and mobility services for individuals who are 
blind.
    (L) Extended employment.
    (M) Psychosocial <strong>rehabilitation</strong> services.
    (N) Supported employment services and extended services.
    (O) Services to family members if necessary to enable the applicant 
or eligible individual to achieve an employment outcome.
    (P) Personal assistance services.
    (Q) Services similar to the services described in paragraphs (A) 
through (P) of this definition.
    (ii) For the purposes of this definition, the word program means an 
agency, organization, or institution, or unit of an agency, 
organization, or institution, that provides directly or facilitates the 
provision of <strong>vocational</strong> <strong>rehabilitation</strong> services as one of its major 
functions.

(Authority: Sections 7(25) and 12(c) of the Act; 29 U.S.C. 706(25) 
and 711(c))

    (9) Comparable services and benefits means services and benefits 
that are--
    (i) Provided or paid for, in whole or in part, by other Federal, 
State, or local public agencies, by health insurance, or by employee 
benefits;
    (ii) Available to the individual within a reasonable period of time 
in accordance with Sec. 361.53; and
    (iii) Commensurate to the services that the individual would 
otherwise receive from the <strong>vocational</strong> <strong>rehabilitation</strong> agency.

(Authority: Sections 12(c) and 101(a)(8) of the Act; 29 U.S.C. 
711(c) and 721(a)(8))

    (10) Competitive employment means work--
    (i) In the competitive labor market that is performed on a full-
time or part-time basis in an integrated setting; and
    (ii) For which an individual is compensated at or above the minimum 
wage, but not less than the prevailing wage for the same or similar 
work in the local community performed by individuals who are not 
disabled.

(Authority: Sections 7(5), 7(18), and 12(c) of the Act; 29 U.S.C. 
706(5), 706(18), and 711(c))

    (11) Construction of a facility for a public or nonprofit community 
<strong>rehabilitation</strong> program means--
    (i) The acquisition of land in connection with the construction of 
a new building for a community <strong>rehabilitation</strong> program;
    (ii) The acquisition of existing buildings;
    (iii) The remodeling, alteration, or renovation of existing 
buildings;
    (iv) The construction of new buildings and expansion of existing 
buildings;
    (v) Architect's fees, site surveys, and soil investigation, if 
necessary, in connection with the construction project;
    (vi) The acquisition of initial fixed or movable equipment of any 
new, newly acquired, newly expanded, newly remodeled, newly altered, or 
newly renovated buildings that are to be used for community 
<strong>rehabilitation</strong> program purposes; and
    (vii) Other direct expenditures appropriate to the construction 
project, except costs of off-site improvements.

(Authority: Sections 7(1) and 12(c) of the Act; 29 U.S.C. 706(1) and 
711(c))

    (12) Designated State agency or State agency means the sole State 
agency, designated in accordance with Sec. 361.13(a), to administer, or 
supervise local administration of, the State plan for <strong>vocational</strong> 
<strong>rehabilitation</strong> services. The term includes the State agency for 
individuals who are blind, if designated as the sole State agency with 
respect to that part of the plan relating to the <strong>vocational</strong> 
<strong>rehabilitation</strong> of individuals who are blind.

(Authority: Sections 7(3)(A) and 101(a)(1)(A) of the Act; 29 U.S.C. 
706(3)(A) and 721(a)(1)(A))

    (13) Designated State unit or State unit means either--
    (i) The State agency <strong>vocational</strong> <strong>rehabilitation</strong> bureau, division, or 
other organizational unit that is primarily concerned with <strong>vocational</strong> 
<strong>rehabilitation</strong> or <strong>vocational</strong> and other <strong>rehabilitation</strong> of individuals 
with disabilities and that is responsible for the administration of the 
<strong>vocational</strong> <strong>rehabilitation</strong> program of the State agency, as required 
under Sec. 361.13(b); or
    (ii) The independent State commission, board, or other agency that 
has <strong>vocational</strong> <strong>rehabilitation</strong>, or <strong>vocational</strong> and other <strong>rehabilitation</strong>, 
as its primary function.

(Authority: Sections 7(3)(B) and 101(a)(2)(A) of the Act; 29 U.S.C. 
706(3)(B) and 721(a)(2)(A))

    (14) Eligible individual means an applicant for <strong>vocational</strong> 
<strong>rehabilitation</strong> services who meets the eligibility requirements of 
Sec. 361.42(a).

(Authority: Sections 7(8)(a) and 102(a)(1) of the Act; 29 U.S.C. 
706(8) and 722(a)(1))

    (15) Employment outcome means, with respect to an individual, 
entering or retaining full-time or, if appropriate, part-time 
competitive employment in the integrated labor market to the greatest 
extent practicable; supported employment; or any other type of 
employment that is consistent with an individual's strengths, 
resources, priorities, concerns, abilities, capabilities, interests, 
and informed choice.

(Authority: Sections 7(5) and 12(c) of the Act; 29 U.S.C. 706(5) and 
711(c))

    (16) Establishment, development, or improvement of a public or 
nonprofit community <strong>rehabilitation</strong> program means--
    (i) The establishment of a facility for a public or nonprofit 
community 

[[Page 64500]]
<strong>rehabilitation</strong> program as defined in paragraph (b)(17) of this section;
    (ii) Staffing, if necessary to establish, develop, or improve a 
community <strong>rehabilitation</strong> program for a maximum period of four years, 
with Federal financial participation available at the applicable 
matching rate for the following levels of staffing costs:
    (A) 100 percent of staffing costs for the first year.
    (B) 75 percent of staffing costs for the second year.
    (C) 60 percent of staffing costs for the third year.
    (D) 45 percent of staffing costs for the fourth year; and
    (iii) Other expenditures related to the establishment, development, 
or improvement of a community <strong>rehabilitation</strong> program that are necessary 
to make the program functional or increase its effectiveness, but are 
not ongoing operating expenses of the program.

(Authority: Sections 7(6) and 12(c) of the Act; 29 U.S.C. 706(6) and 
711(c))

    (17) Establishment of a facility for a public or nonprofit 
community <strong>rehabilitation</strong> program means--
    (i) The acquisition of an existing building, and if necessary the 
land in connection with the acquisition, if the building has been 
completed in all respects for at least one year prior to the date of 
acquisition and the Federal share of the cost of the acquisition is not 
more than $300,000;
    (ii) The remodeling or alteration of an existing building, provided 
the estimated cost of remodeling or alteration does not exceed the 
appraised value of the existing building;
    (iii) The expansion of an existing building, provided that--
    (A) The existing building is complete in all respects;
    (B) The total size in square footage of the expanded building, 
notwithstanding the number of expansions, is not greater than twice the 
size of the existing building;
    (C) The expansion is joined structurally to the existing building 
and does not constitute a separate building; and
    (D) The costs of the expansion do not exceed the appraised value of 
the existing building;
    (iv) Architect's fees, site survey, and soil investigation, if 
necessary in connection with the acquisition, remodeling, alteration, 
or expansion of an existing building; and
    (v) The acquisition of fixed or movable equipment, including the 
costs of installation of the equipment, if necessary to establish, 
develop, or improve a community <strong>rehabilitation</strong> program.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (18) Extended employment means work in a non-integrated or 
sheltered setting for a public or private nonprofit agency or 
organization that provides compensation in accordance with the Fair 
Labor Standards Act and any needed support services to an individual 
with a disability to enable the individual to continue to train or 
otherwise prepare for competitive employment, unless the individual 
through informed choice chooses to remain in extended employment.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (19) Extended services, as used in the definition of ``Supported 
employment,'' means ongoing support services and other appropriate 
services that are needed to support and maintain an individual with a 
most severe disability in supported employment and that are provided by 
a State agency, a private nonprofit organization, employer, or any 
other appropriate resource, from funds other than funds received under 
this part, 34 CFR part 363, 34 CFR part 376, or 34 CFR part 380, after 
an individual with a most severe disability has made the transition 
from support provided by the designated State unit.

(Authority: Section 7(27) of the Act; 29 U.S.C. 706(27))

    (20) Extreme medical risk means a probability of substantially 
increasing functional impairment or death if medical services, 
including mental health services, are not provided expeditiously.

(Authority: Sections 12(c) and 101(a)(8) of the Act; 29 U.S.C. 
711(c) and 721(a)(8))

    (21) Family member, for purposes of receiving <strong>vocational</strong> 
<strong>rehabilitation</strong> services in accordance with Sec. 361.48(a)(9), means an 
individual--
    (i) Who either--
    (A) Is a relative or guardian of an applicant or eligible 
individual; or
    (B) Lives in the same household as an applicant or eligible 
individual;
    (ii) Who has a substantial interest in the well-being of that 
individual; and
    (iii) Whose receipt of <strong>vocational</strong> <strong>rehabilitation</strong> services is 
necessary to enable the applicant or eligible individual to achieve an 
employment outcome.
(Authority: Sections 12(c) and 103(a)(3) of the Act; 29 U.S.C. 
711(c) and 723(a)(3))
    (22) Impartial hearing officer.
    (i) Impartial hearing officer means an individual who--
    (A) Is not an employee of a public agency (other than an 
administrative law judge, hearing examiner, or employee of an 
institution of higher education);
    (B) Is not a member of the State <strong>Rehabilitation</strong> Advisory Council 
for the designated State unit;
    (C) Has not been involved in previous decisions regarding the 
<strong>vocational</strong> <strong>rehabilitation</strong> of the applicant or eligible individual;
    (D) Has knowledge of the delivery of <strong>vocational</strong> <strong>rehabilitation</strong> 
services, the State plan, and the Federal and State regulations 
governing the provision of services;
    (E) Has received training with respect to the performance of 
official duties; and
    (F) Has no personal, professional, or financial interest that would 
be in conflict with the objectivity of the individual.
    (ii) An individual shall not be considered to be an employee of a 
public agency for the purposes of this definition solely because the 
individual is paid by the agency to serve as a hearing officer.

(Authority: Section 7(28) of the Act; 29 U.S.C. 706(28))

    (23) Indian tribe means any Federal or State Indian tribe, band, 
rancheria, pueblo, colony, or community, including any Alaskan native 
village or regional village corporation (as defined in or established 
pursuant to the Alaska Native Claims Settlement Act).

(Authority: Section 7(21) of the Act; 29 U.S.C. 706(21))

    (24) Individual who is blind means a person who is blind within the 
meaning of the applicable State law.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (25) Individual with a disability, except in Secs. 361.17(a), (b), 
(c), and (j), 361.19, 361.20, and 361.51(b)(2), means an individual--
    (i) Who has a physical or mental impairment;
    (ii) Whose impairment constitutes or results in a substantial 
impediment to employment; and
    (iii) Who can benefit in terms of an employment outcome from the 
provision of <strong>vocational</strong> <strong>rehabilitation</strong> services.

(Authority: Section 7(8)(A) of the Act; 29 U.S.C. 706(8)(A))

    (26) Individual with a disability, for purposes of Secs. 361.17 
(a), (b), (c), and (j), 361.19, 361.20, and 361.51(b)(2), means an 
individual--

[[Page 64501]]

    (i) Who has a physical or mental impairment that substantially 
limits one or more major life activities;
    (ii) Who has a record of such an impairment; or
    (iii) Who is regarded as having such an impairment.

(Authority: Section 7(8)(B) of the Act; 29 U.S.C. 706(8)(B))

    (27) Individual with a most severe disability means an individual 
with a severe disability who meets the designated State unit's criteria 
for an individual with a most severe disability. This criteria must be 
consistent with the requirements in Sec. 361.36(c)(3).

(Authority: Section 101(a)(5) of the Act; 29 U.S.C. 721(a)(5))

    (28) Individual with a severe disability means an individual with a 
disability--
    (i) Who has a severe physical or mental impairment that seriously 
limits one or more functional capacities (such as mobility, 
communication, self-care, self-direction, interpersonal skills, work 
tolerance, or work skills) in terms of an employment outcome;
    (ii) Whose <strong>vocational</strong> <strong>rehabilitation</strong> can be expected to require 
multiple <strong>vocational</strong> <strong>rehabilitation</strong> services over an extended period of 
time; and
    (iii) Who has one or more physical or mental disabilities resulting 
from amputation, arthritis, autism, blindness, burn injury, cancer, 
cerebral palsy, cystic fibrosis, deafness, head injury, heart disease, 
hemiplegia, hemophilia, respiratory or pulmonary dysfunction, mental 
retardation, mental illness, multiple sclerosis, muscular dystrophy, 
musculo-skeletal disorders, neurological disorders (including stroke 
and epilepsy), spinal cord conditions (including paraplegia and 
quadriplegia), sickle cell anemia, specific learning disability, end-
stage renal disease, or another disability or combination of 
disabilities determined on the basis of an assessment for determining 
eligibility and <strong>vocational</strong> <strong>rehabilitation</strong> needs to cause comparable 
substantial functional limitation.

(Authority: Section 7(15)(A) of the Act; 29 U.S.C. 708(15)(A))

    (29) Individual's representative means any representative chosen by 
an applicant or eligible individual, including a parent, guardian, 
other family member, or advocate, unless a representative has been 
appointed by a court to represent the individual, in which case the 
court-appointed representative is the individual's representative.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (30) Integrated setting, with respect to the provision of services 
or an employment outcome, means a setting typically found in the 
community in which applicants or eligible individuals have the 
opportunity to interact on a regular basis with non-disabled 
individuals other than non-disabled individuals who are providing 
services to those applicants or eligible individuals.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    (31) Maintenance means monetary support provided to an eligible 
individual or an individual receiving extended evaluation services for 
those living expenses, such as food, shelter, and clothing, that are in 
excess of the normal living expenses of the individual and that are 
necessitated by the individual's participation in a program of 
<strong>vocational</strong> <strong>rehabilitation</strong> services.

(Authority: Sections 12(c) and 103(a)(5) of the Act; 29 U.S.C. 
711(c) and 723(a)(5))

Note: The following are examples of expenses that would meet the 
definition of maintenance.

    Example: The cost of a uniform or other suitable clothing that 
is required for an individual's job placement or job seeking 
activities.
    Example: The cost of short-term shelter that is required in 
order for an individual to participate in <strong>vocational</strong> training at a 
site that is not within commuting distance of an individual's home.
    Example: The initial one-time costs, such as a security deposit 
or charges for the initiation of utilities, that are required in 
order for an individual to relocate for a job placement.
    Example: The costs of food, clothing, and shelter for homeless 
or recently deinstitutionalized individuals until other financial 
assistance is secured for those costs.

    (32) Nonprofit, with respect to a community <strong>rehabilitation</strong> program, 
means a community <strong>rehabilitation</strong> program carried out by a corporation 
or association, no part of the net earnings of which inures, or may 
lawfully inure, to the benefit of any private shareholder or individual 
and the income of which is exempt from taxation under section 501(c)(3) 
of the Internal Revenue Code of 1954.

(Authority: Section 7(10) of the Act; 29 U.S.C. 706(10))

    (33) Ongoing support services, as used in the definition of 
``Supported employment''--
    (i) Means services that are--
    (A) Needed to support and maintain an individual with a most severe 
disability in supported employment;
    (B) Identified based on a determination by the designated State 
unit of the individual's needs as specified in an individualized 
written <strong>rehabilitation</strong> program; and
    (C) Furnished by the designated State unit from the time of job 
placement until transition to extended services, unless post-employment 
services are provided following transition, and thereafter by one or 
more extended services providers throughout the individual's term of 
employment in a particular job placement or multiple placements if 
those placements are being provided under a program of transitional 
employment;
    (ii) Must include an assessment of employment stability and 
provision of specific services or the coordination of services at or 
away from the worksite that are needed to maintain stability based on--
    (A) At a minimum, twice-monthly monitoring at the worksite of each 
individual in supported employment; or
    (B) If under special circumstances, especially at the request of 
the individual, the individualized written <strong>rehabilitation</strong> program 
provides for off-site monitoring, twice-monthly meetings with the 
individual;
    (iii) Consist of--
    (A) Any particularized assessment supplementary to the 
comprehensive assessment of <strong>rehabilitation</strong> needs described in this 
part;
    (B) The provision of skilled job trainers who accompany the 
individual for intensive job skill training at the work site;
    (C) Job development and placement;
    (D) Social skills training;
    (E) Regular observation or supervision of the individual;
    (F) Follow-up services including regular contact with the 
employers, the individuals, the parents, family members, guardians, 
advocates or authorized representatives of the individuals, and other 
suitable professional and informed advisors, in order to reinforce and 
stabilize the job placement;
    (G) Facilitation of natural supports at the worksite;
    (H) Any other service identified in the scope of <strong>vocational</strong> 
<strong>rehabilitation</strong> services for individuals, described in Sec. 361.48; or
    (I) Any service similar to the foregoing services.

(Authority: Sections 7(33) and 12(c) of the Act; 29 U.S.C. 706(33) 
and 711(c))

    (34) Personal assistance services means a range of services 
provided by one or more persons designed to assist an individual with a 
disability to perform daily living activities on or off the job that 
the individual would typically perform without assistance if 

[[Page 64502]]
the individual did not have a disability. The services must be 
necessary to the achievement of an employment outcome and may be 
provided only while the individual is receiving other <strong>vocational</strong> 
<strong>rehabilitation</strong> services. The services may include training in managing, 
supervising, and directing personal assistance services.

(Authority: Sections 7(11) and 103(a)(15) of the Act; 29 U.S.C. 
706(11) and 29 U.S.C. 723)

    (35) Physical and mental restoration services means--
    (i) Corrective surgery or therapeutic treatment that is likely, 
within a reasonable period of time, to correct or modify substantially 
a stable or slowly progressive physical or mental impairment that 
constitutes a substantial impediment to employment;
    (ii) Diagnosis of and treatment for mental or emotional disorders 
by qualified personnel in accordance with State licensure laws;
    (iii) Dentistry;
    (iv) Nursing services;
    (v) Necessary hospitalization (either inpatient or outpatient care) 
in connection with surgery or treatment and clinic services;
    (vi) Drugs and supplies;
    (vii) Prosthetic, orthotic, or other assistive devices, including 
hearing aids;
    (viii) Eyeglasses and visual services, including visual training, 
and the examination and services necessary for the prescription and 
provision of eyeglasses, contact lenses, microscopic lenses, telescopic 
lenses, and other special visual aids prescribed by personnel that are 
qualified in accordance with State licensure laws;
    (ix) Podiatry;
    (x) Physical therapy;
    (xi) Occupational therapy;
    (xii) Speech or hearing therapy;
    (xiii) Mental health services;
    (xiv) Treatment of either acute or chronic medical complications 
and emergencies that are associated with or arise out of the provision 
of physical and mental restoration services, or that are inherent in 
the condition under treatment;
    (xv) Special services for the treatment of individuals with end-
stage renal disease, including transplantation, dialysis, artificial 
kidneys, and supplies; and
    (xvi) Other medical or medically related <strong>rehabilitation</strong> services.

(Authority: Sections 12(c) and 103(a)(4) of the Act; 29 U.S.C. 
711(c) and 723(a)(4))

    (36) Physical or mental impairment means an injury, disease, or 
other condition that materially limits, or if not treated will probably 
result in materially limiting, mental or physical functioning.

(Authority: Sections 7(8)(A) and 12(c) of the Act; 29 U.S.C. 
706(8)(A) and 711(c))

    (37) Post-employment services means one or more of the services 
identified in Sec. 361.48 that are provided subsequent to the 
achievement of an employment outcome and that are necessary for an 
individual to maintain, regain, or advance in employment, consistent 
with the individual's strengths, resources, priorities, concerns, 
abilities, capabilities, and interests.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))

    Note: Post-employment services are intended to ensure that the 
employment outcome remains consistent with the individual's 
strengths, resources, priorities, concerns, abilities, capabilities, 
and interests. These services are available to meet <strong>rehabilitation</strong> 
needs that do not require a complex and comprehensive provision of 
services and, thus, should be limited in scope and duration. If more 
comprehensive services are required, then a new <strong>rehabilitation</strong> 
effort should be considered. Post-employment services are to be 
provided under an amended individualized written <strong>rehabilitation</strong> 
program; thus, a re-determination of eligibility is not required. 
The provision of post-employment services is subject to the same 
requirements in this part as the provision of any other <strong>vocational</strong> 
<strong>rehabilitation</strong> service. Post-employment services are available to 
assist an individual to maintain employment, e.g., the individual's 
employment is jeopardized because of conflicts with supervisors or 
co-workers and the individual needs mental health services and 
counseling to maintain the employment; to regain employment, e.g., 
the individual's job is eliminated through reorganization and new 
placement services are needed; and to advance in employment, e.g., 
the employment is no longer consistent with the individual's 
strengths, resources, priorities, concerns, abilities, capabilities, 
and interests.

    (38) <strong>Rehabilitation</strong> engineering means the systematic application of 
engineering sciences to design, develop, adapt, test, evaluate, apply, 
and distribute technological solutions to problems confronted by 
individuals with disabilities in functional areas, such as mobility, 
communications, hearing, vision, and cognition, and in activities 
associated with employment, independent living, education, and 
integration into the community.

(Authority: Sections 7(13) and 12(c) of the Act; 29 U.S.C. 706(13) 
and 711(c))

    (39) <strong>Rehabilitation</strong> technology means the systematic application of 
technologies, engineering methodologies, or scientific principles to 
meet the needs of, and address the barriers confronted by, individuals 
with disabilities in areas that include education, <strong>rehabilitation</strong>, 
employment, transportation, independent living, and recreation. The 
term includes <strong>rehabilitation</strong> engineering, assistive technology devices, 
and assistive technology services.

(Authority: Section 7(13) of the Act; 29 U.S.C. 706(13))

    (40) Reservation means a Federal or State Indian reservation, 
public domain Indian allotment, former Indian reservation in Oklahoma, 
and land held by incorporated Native groups, regional corporations, and 
village corporations under the provisions of the Alaska Native Claims 
Settlement Act.

(Authority: Section 130(c) of the Act; 29 U.S.C. 750(c))

    (41) Sole local agency means a unit or combination of units of 
general local government or one or more Indian tribes that has the sole 
responsibility under an agreement with, and the supervision of, the 
State agency to conduct a local or tribal <strong>vocational</strong> <strong>rehabilitation</strong> 
program, in accordance with the State plan.

(Authority: Section 7(9) of the Act; 29 U.S.C. 706(9))

    (42) State means any of the 50 States, the District of Columbia, 
the Commonwealth of Puerto Rico, the United States Virgin Islands, 
Guam, American Samoa, and the Commonwealth of the Northern Mariana 
Islands.

(Authority: Section 7(16) of the Act; 29 U.S.C. 706(16))

    (43) State plan means the State plan for <strong>vocational</strong> <strong>rehabilitation</strong> 
services or the <strong>vocational</strong> <strong>rehabilitation</strong> services part of a 
consolidated <strong>rehabilitation</strong> plan under Sec. 361.10(c).

(Authority: Sections 12(c) and 101 of the Act; 29 U.S.C. 711(c) and 
721)

    (44) Substantial impediment to employment means that a physical or 
mental impairment (in light of attendant medical, psychological, 
<strong>vocational</strong>, educational, and other related factors) hinders an 
individual from preparing for, entering into, engaging in, or retaining 
employment consistent with the individual's abilities and capabilities.

(Authority: Sections 7(8)(A) and 12(c) of the Act; 29 U.S.C. 
706(8)(A) and 711(c))

    (45) Supported employment means--
    (i) Competitive employment in an integrated setting with ongoing 
support services for individuals with the most severe disabilities--
    (A) For whom competitive employment has not traditionally occurred 
or for whom competitive 

[[Page 64503]]
employment has been interrupted or intermittent as a result of a severe 
disability; and
    (B) Who, because of the nature and severity of their disabilities, 
need intensive supported employment services from the designated State 
unit and extended services after transition in order to perform this 
work; or
    (ii) Transitional employment for individuals with the most severe 
disabilities due to mental illness.

(Authority: Section 7(18) of the Act; 29 U.S.C. 706(18)(A))

    (46) Supported employment services means ongoing support services 
and other appropriate services needed to support and maintain an 
individual with a most severe disability in supported employment that 
are provided by the designated State unit--
    (i) For a period of time not to exceed 18 months, unless under 
special circumstances the eligible individual and the <strong>rehabilitation</strong> 
counselor or coordinator jointly agree to extend the time in order to 
achieve the <strong>rehabilitation</strong> objectives identified in the individualized 
written <strong>rehabilitation</strong> program; and
    (ii) Following transition, as post-employment services that are 
unavailable from an extended services provider and that are necessary 
to maintain or regain the job placement or advance in employment.

(Authority: Sections 7(34) and 12(c) of the Act; 29 U.S.C. 706(34) 
and 711(c))

    (47) Transition services means a coordinated set of activities for 
a student designed within an outcome-oriented process that promotes 
movement from school to post-school activities, including postsecondary 
education, <strong>vocational</strong> training, integrated employment (including 
supported employment), continuing and adult education, adult services, 
independent living, or community participation. The coordinated set of 
activities must be based upon the individual student's needs, taking 
into account the student's preferences and interests, and must include 
instruction, community experiences, the development of employment and 
other post-school adult living objectives, and, if appropriate, 
acquisition of daily living skills and functional <strong>vocational</strong> 
evaluation. Transition services must promote or facilitate the 
accomplishment of long-term <strong>rehabilitation</strong> goals and intermediate 
<strong>rehabilitation</strong> objectives identified in the student's individualized 
written <strong>rehabilitation</strong> program (IWRP).

(Authority: Section 7(35) and 103(a)(14) of the Act; 29 U.S.C. 
706(35) and 723(a)(14))

    (48) Transitional employment, as used in the definition of 
``Supported employment,'' means a series of temporary job placements in 
competitive work in integrated settings with ongoing support services 
for individuals with the most severe disabilities due to mental 
illness. In transitional employment, the provision of ongoing support 
services must include continuing sequential job placements until job 
permanency is achieved.

(Authority: Sections 7(18) and 12(c) of the Act; 29 U.S.C. 706(18) 
and 711(c))

    (49) Transitioning student means a student who is an eligible 
individual in accordance with the requirements of Sec. 361.42(a)(1) and 
who is receiving transition services as defined in paragraph (b)(47) of 
this section.
(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))
    (50) Transportation means travel and related expenses that are 
necessary to enable an applicant or eligible individual to participate 
in any <strong>vocational</strong> <strong>rehabilitation</strong> service.

(Authority: Sections 12(c) and 103(a)(10) of the Act; 29 U.S.C. 
711(c) and 723(a)(10))

    Note: The following are examples of expenses that would meet the 
definition of transportation.

    Example: Travel and related expenses for a personal care 
attendant or aide if the services of that person are necessary to 
enable the applicant or eligible individual to travel to participate 
in any <strong>vocational</strong> <strong>rehabilitation</strong> service.
    Example: Short-term travel-related expenses, such as food and 
shelter, incurred by an applicant participating in evaluation or 
assessment services that necessitates travel.
    Example: Relocation expenses incurred by an eligible individual 
in connection with a job placement that is a significant distance 
from the eligible individual's current residence.
    Example: The purchase and repair of vehicles, including vans, 
but not the modification of these vehicles, as modification would be 
considered a <strong>rehabilitation</strong> technology service.

    (51) <strong>Vocational</strong> <strong>rehabilitation</strong> services--
    (i) If provided to an individual, means those services listed in 
Sec. 361.48; and
    (ii) If provided for the benefit of groups of individuals, also 
means those services listed in Sec. 361.49.

(Authority: Sections 103(a) and (b) of the Act; 29 U.S.C. 723(a) and 
(b))

Subpart B--State Plan for <strong>Vocational</strong> <strong>Rehabilitation</strong> Services


Sec. 361.10  Submission, approval, and disapproval of the State plan.

    (a) Purpose. In order for a State to receive a grant under this 
part, the designated State agency shall submit to the Secretary, and 
obtain approval of, a State plan that contains a description of the 
State's <strong>vocational</strong> <strong>rehabilitation</strong> services program, the plans and 
policies to be followed in carrying out the program, and other 
information requested by the Secretary, in accordance with the 
requirements of this part.
    (b) Separate part relating to <strong>rehabilitation</strong> of individuals who are 
blind. If a separate State agency administers or supervises the 
administration of a separate part of the State plan relating to the 
<strong>rehabilitation</strong> of individuals who are blind, that part of the State 
plan must separately conform to all requirements under this part that 
are applicable to a State plan.
    (c) Consolidated <strong>rehabilitation</strong> plan. The State may choose to 
submit a consolidated <strong>rehabilitation</strong> plan that includes the State plan 
for <strong>vocational</strong> <strong>rehabilitation</strong> services and the State's plan for its 
program for persons with developmental disabilities. The State planning 
and advisory council for developmental disabilities and the agency 
administering the State's program for persons with developmental 
disabilities must concur in the submission of a consolidated 
<strong>rehabilitation</strong> plan. A consolidated <strong>rehabilitation</strong> plan must comply 
with, and be administered in accordance with, the Act and the 
Developmental Disabilities Assistance and Bill of Rights Act, as 
amended.
    (d) Public participation. The State shall develop the State plan 
with input from the public, through public meetings, in accordance with 
the requirements of Sec. 361.20.
    (e) Duration. The State plan must cover a three-year period or, 
with the prior approval of the Secretary, some other period that 
corresponds to the period for which the State submits a plan under 
another Federal law, such as Part B of the Individuals with 
Disabilities Education Act (IDEA).
    (f) Submission of the State plan. The State shall submit the State 
plan to the Secretary for approval--
    (1) No later than July 1 of the year preceding the first fiscal 
year for which the State plan is submitted; or
    (2) With the prior approval of the Secretary, no later than the 
date on which the State is required to submit a State plan under 
another Federal law. 

[[Page 64504]]

    (g) Revisions to the State plan. The State shall submit to the 
Secretary for approval revisions to the State plan in accordance with 
the requirements of this part and 34 CFR 76.140.
    (h) Interim State plan. The Secretary may require a State to submit 
an interim State plan for a period of less than three years following a 
reauthorization of the Act and prior to the publication of final 
regulations.
    (i) Approval. The Secretary approves a State plan and revisions to 
the State plan that conform to the requirements of this part and 
section 101(a) of the Act.
    (j) Disapproval. The Secretary disapproves a State plan that does 
not conform to the requirements of this part and section 101(a) of the 
Act, in accordance with the following procedures:
    (1) Informal resolution. Prior to disapproving a State plan, the 
Secretary attempts to resolve disputes informally with State officials.
    (2) Notice. If, after reasonable effort has been made to resolve 
the dispute, no resolution has been reached, the Secretary provides 
notice to the State agency of the intention to disapprove the State 
plan and of the opportunity for a hearing.
    (3) State plan hearing. If the State agency requests a hearing, the 
Secretary designates one or more individuals, either from the 
Department or elsewhere, not responsible for or connected with the 
administration of this program, to conduct a hearing in accordance with 
the provisions of 34 CFR Part 81, Subpart A.
    (4) Initial decision. The hearing officer issues an initial 
decision in accordance with 34 CFR 81.41.
    (5) Petition for review of an initial decision. The State agency 
may seek the Secretary's review of the initial decision in accordance 
with 34 CFR 81.42.
    (6) Review by the Secretary. The Secretary reviews the initial 
decision in accordance with 34 CFR 81.43.
    (7) Final decision of the Department. The final decision of the 
Department is made in accordance with 34 CFR 81.44.
    (8) Judicial review. A State may appeal the Secretary's decision to 
disapprove the State plan by filing a petition for review with the 
United States Court of Appeals for the circuit in which the State is 
located, in accordance with section 107(d) of the Act.

(Authority: Sections 6, 101(a) and (b), and 107(d) of the Act; 29 
U.S.C. 705, 721(a) and (b), and 727(d))


Sec. 361.11   Withholding of funds.

    (a) Basis for withholding. The Secretary may withhold or limit 
payments under sections 111, 124, or 632(a) of the Act, as provided by 
section 107(c) and (d) of the Act, if the Secretary determines that--
    (1) The State plan, including the supported employment supplement 
and the strategic plan supplement, has been so changed that it no 
longer conforms with the requirements of this part or 34 CFR part 363; 
or
    (2) In the administration of the State plan, there has been a 
failure to comply substantially with any provision of that plan or a 
program improvement plan established in accordance with section 106 of 
the Act.
    (b) Informal resolution. Prior to withholding or limiting payments 
in accordance with this section, the Secretary attempts to resolve 
disputed issues informally with State officials.
    (c) Notice. If, after reasonable effort has been made to resolve 
the dispute, no resolution has been reached, the Secretary provides 
notice to the State agency of the intention to withhold or limit 
payments and of the opportunity for a hearing.
    (d) Withholding hearing. If the State agency requests a hearing, 
the Secretary designates one or more individuals, either from the 
Department or elsewhere, not responsible for or connected with the 
administration of this program, to conduct a hearing in accordance with 
the provisions of 34 CFR part 81, subpart A.
    (e) Initial decision. The hearing officer issues an initial 
decision in accordance with 34 CFR 81.41.
    (f) Petition for review of an initial decision. The State agency 
may seek the Secretary's review of the initial decision in accordance 
with 34 CFR 81.42.
    (g) Review by the Secretary. The Secretary reviews the initial 
decision in accordance with 34 CFR 81.43.
    (h) Final decision of the Department. The final decision of the 
Department is made in accordance with 34 CFR 81.44.
    (i) Judicial review. A State may appeal the Secretary's decision to 
withhold or limit payments by filing a petition for review with the 
U.S. Court of Appeals for the circuit in which the State is located, in 
accordance with section 107(d) of the Act.

(Authority: Sections 101(b), 107(c), and 107(d) of the Act; 29 
U.S.C. 721(b), 727(c)(1) and (2), and 727(d))

State Plan Content: Administration


Sec. 361.12   Methods of administration.

    The State plan must assure that the State agency, and the 
designated State unit if applicable, employs methods of administration 
found necessary by the Secretary for the proper and efficient 
administration of the plan and for carrying out all functions for which 
the State is responsible under the plan and this part. These methods 
must include procedures to ensure accurate data collection and 
financial accountability.

(Authority: Section 101(a)(6) of the Act; 29 U.S.C. 721(a)(6))


Sec. 361.13   State agency for administration.

    (a) Designation of State agency. The State plan must designate a 
State agency as the sole State agency to administer the State plan, or 
to supervise its administration in a political subdivision of the State 
by a sole local agency, in accordance with the following requirements:
    (1) General. Except as provided in paragraphs (a)(2) and (3) of 
this section, the State plan must provide that the designated State 
agency is one of the following types of agencies:
    (i) A State agency that is an independent State commission, board, 
or other agency that has as its major function <strong>vocational</strong> 
<strong>rehabilitation</strong> or <strong>vocational</strong> and other <strong>rehabilitation</strong> of individuals 
with disabilities.
    (ii) The State agency administering or supervising the 
administration of education or <strong>vocational</strong> education in the State, 
provided that it includes a <strong>vocational</strong> <strong>rehabilitation</strong> unit as provided 
in paragraph (b) of this section.
    (iii) A State agency that includes a <strong>vocational</strong> <strong>rehabilitation</strong> 
unit, as provided in paragraph (b) of this section, and at least two 
other major organizational units, each of which administers one or more 
of the State's major programs of public education, public health, 
public welfare, or labor.
    (2) American Samoa. In the case of American Samoa, the State plan 
must designate the Governor.
    (3) Designated State agency for individuals who are blind. If a 
State commission or other agency that provides assistance or services 
to individuals who are blind is authorized under State law to provide 
<strong>vocational</strong> <strong>rehabilitation</strong> services to individuals who are blind, and 
this commission or agency is primarily concerned with <strong>vocational</strong> 
<strong>rehabilitation</strong> or includes a <strong>vocational</strong> <strong>rehabilitation</strong> unit as provided 
in paragraph (b) of this section, the State plan may designate that 
agency as the sole State agency to administer the part of the plan 
under which <strong>vocational</strong> <strong>rehabilitation</strong> services are provided for 
individuals who are blind or to supervise its administration in a 
political subdivision of the State by a sole local agency.
    (b) Designation of State unit. (1) If the designated State agency 
is of the type 

[[Page 64505]]
specified in paragraph (a)(1)(ii) or (a)(1)(iii) of this section, or if 
the designated State agency specified in paragraph (a)(3) of this 
section does not have as its major function <strong>vocational</strong> <strong>rehabilitation</strong> 
or <strong>vocational</strong> and other <strong>rehabilitation</strong> of individuals with 
disabilities, the State plan must assure that the agency (or each 
agency if two agencies are designated) includes a <strong>vocational</strong> 
<strong>rehabilitation</strong> bureau, division, or unit that--
    (i) Is primarily concerned with <strong>vocational</strong> <strong>rehabilitation</strong> or 
<strong>vocational</strong> and other <strong>rehabilitation</strong> of individuals with disabilities 
and is responsible for the administration of the State agency's 
<strong>vocational</strong> <strong>rehabilitation</strong> program under the State plan, including those 
responsibilities specified in paragraph (d) of this section;
    (ii) Has a full-time director;
    (iii) Has a staff, at least 90 percent of whom are employed full 
time on the <strong>rehabilitation</strong> work of the organizational unit; and
    (iv) Is located at an organizational level and has an 
organizational status within the State agency comparable to that of 
other major organizational units of the agency or, in the case of an 
agency described in paragraph (a)(1)(ii) of this section, is so located 
and has that status or has a director who is the executive officer of 
the State agency.
    (2) In the case of a State that has not designated a separate State 
agency for individuals who are blind, as provided for in paragraph 
(a)(3) of this section, the State may assign responsibility for the 
part of the plan under which <strong>vocational</strong> <strong>rehabilitation</strong> services are 
provided to individuals who are blind to one organizational unit of the 
designated State agency and may assign responsibility for the rest of 
the plan to another organizational unit of the designated State agency, 
with the provisions of paragraph (b)(1) of this section applying 
separately to each of these units.
    (c) Responsibility for administration. The State plan must assure 
that all decisions affecting eligibility for <strong>vocational</strong> <strong>rehabilitation</strong> 
services, the nature and scope of available services, and the provision 
of these services are made by the designated State unit or the sole 
local agency under the supervision of the State unit. This 
responsibility may not be delegated to any other agency or individual.

(Authority: Sections 101(a)(1) and 101(a)(2) of the Act; 29 U.S.C. 
721(a)(1) and 721(a)(2))


Sec. 361.14   Substitute State agency.

    (a) General provisions.
    (1) If the Secretary has withheld all funding from a State under 
Sec. 361.11, the State may designate another agency to substitute for 
the designated State agency in carrying out the State's program of 
<strong>vocational</strong> <strong>rehabilitation</strong> services.
    (2) Any public or nonprofit private organization or agency within 
the State or any political subdivision of the State is eligible to be a 
substitute agency.
    (3) The substitute agency shall submit a State plan that meets the 
requirements of this part.
    (4) The Secretary makes no grant to a substitute agency until the 
Secretary approves its plan.
    (b) Substitute agency matching share. The Secretary does not make 
any payment to a substitute agency unless it has provided assurances 
that it will contribute the same matching share as the State would have 
been required to contribute if the State agency were carrying out the 
<strong>vocational</strong> <strong>rehabilitation</strong> program.

(Authority: Section 107(c)(3) of the Act; 29 U.S.C. 727(c)(3))


Sec. 361.15   Local administration.

    (a) If the State plan provides for local administration, it must--
    (1) Identify each local agency;
    (2) Assure that each local agency is under the supervision of the 
designated State unit and is the sole local agency responsible for the 
administration of the program within the political subdivision that it 
serves; and
    (3) Describe the methods each local agency will use to administer 
the <strong>vocational</strong> <strong>rehabilitation</strong> program, in accordance with the State 
plan.
    (b) A separate local agency serving individuals who are blind may 
administer that part of the plan relating to <strong>vocational</strong> <strong>rehabilitation</strong> 
of individuals who are blind, under the supervision of the designated 
State unit for individuals who are blind.

(Authority: Section 101(a)(1)(A) of the Act; 29 U.S.C. 721(a)(1)(A))


Sec. 361.16   Establishment of an independent commission or a State 
<strong>Rehabilitation</strong> Advisory Council.

    (a) General requirement. Except as provided in paragraph (b) of 
this section, the State plan must contain one of the following two 
assurances:
    (1) An assurance that the State agency is an independent State 
commission that--
    (i) Is primarily concerned with <strong>vocational</strong> <strong>rehabilitation</strong> or 
<strong>vocational</strong> and other <strong>rehabilitation</strong> services, in accordance with 
Sec. 361.13(a)(1)(i);
    (ii) Is consumer-controlled by persons who--
    (A) Are individuals with physical or mental impairments that 
substantially limit major life activities; and
    (B) Represent individuals with a broad range of disabilities;
    (iii) Includes individuals representing family members, advocates, 
and authorized representatives of individuals with mental impairments; 
and
    (iv) Conducts a review and analysis of the effectiveness of and 
consumer satisfaction with <strong>vocational</strong> <strong>rehabilitation</strong> services and 
providers in the State, in accordance with the provisions in 
Sec. 361.17(h)(3).
    (2) An assurance that--
    (i) The State has established a State <strong>Rehabilitation</strong> Advisory 
Council (Council) that meets the requirements of Sec. 361.17;
    (ii) The designated State unit seeks and seriously considers, on a 
regular and ongoing basis, advice from the Council regarding the 
development, implementation, and amendment of the State plan, the 
strategic plan, and other policies and procedures of general 
applicability pertaining to the provision of <strong>vocational</strong> <strong>rehabilitation</strong> 
services in the State;
    (iii) The designated State unit transmits to the Council--
    (A) All plans, reports, and other information required under the 
Act to be submitted to the Secretary;
    (B) Copies of all written policies, practices, and procedures of 
general applicability provided to or used by <strong>rehabilitation</strong> personnel; 
and
    (C) Copies of due process hearing decisions in a manner that 
preserves the confidentiality of the participants in the hearings; and
    (iv) The State plan summarizes annually the advice provided by the 
Council, including recommendations from the annual report of the 
Council, the survey of consumer satisfaction, and other reports 
prepared by the Council, and the State agency's response to the advice 
and recommendations, including the manner in which the State will 
modify its policies and procedures based on the survey of consumer 
satisfaction and explanations of reasons for rejecting any advice or 
recommendations of the Council.
    (b) Exception for separate State agency for individuals who are 
blind. In the case of a State that designates a separate State agency, 
under Sec. 361.13(a)(3), to administer the part of the State plan under 
which <strong>vocational</strong> <strong>rehabilitation</strong> services are provided to individuals 
who are blind, the State plan must contain one of the following four 
assurances:
    (1) An assurance that an independent commission in accordance with 
paragraph (a)(1) of this section is responsible under State law for 

[[Page 64506]]
operating or overseeing the operation of the <strong>vocational</strong> <strong>rehabilitation</strong> 
program of both the State agency that administers the part of the State 
plan under which <strong>vocational</strong> <strong>rehabilitation</strong> services are provided to 
individuals who are blind and the State agency that administers the 
remainder of the State plan.
    (2) An assurance that--
    (i) An independent commission that is consumer-controlled by, and 
represents the interests of, individuals who are blind and conducts a 
review and analysis of the effectiveness of and consumer satisfaction 
with <strong>vocational</strong> <strong>rehabilitation</strong> services and providers, in accordance 
with the provisions of Sec. 361.17(h)(3), is responsible under State 
law for operating, or overseeing the operation of, the <strong>vocational</strong> 
<strong>rehabilitation</strong> program in the State for individuals who are blind; and
    (ii) An independent commission that is consumer-controlled in 
accordance with paragraph (a)(1)(i) of this section and conducts a 
review and analysis of the effectiveness of and consumer satisfaction 
with <strong>vocational</strong> <strong>rehabilitation</strong> services and providers, in accordance 
with Sec. 361.17(h)(3), is responsible under State law for operating, 
or overseeing the operation of, the <strong>vocational</strong> <strong>rehabilitation</strong> program 
in the State for all individuals with disabilities, except individuals 
who are blind.
    (3) An assurance that--
    (i) An independent commission that is consumer-controlled by, and 
represents the interests of, individuals who are blind and that 
conducts a review and analysis of the effectiveness of and consumer 
satisfaction with <strong>vocational</strong> <strong>rehabilitation</strong> services and providers, in 
accordance with Sec. 361.17(h)(3), is responsible under State law for 
operating, or overseeing the operation of, the <strong>vocational</strong> 
<strong>rehabilitation</strong> program in the State for individuals who are blind; and
    (ii) The State has established a State <strong>Rehabilitation</strong> Advisory 
Council that meets the criteria in Sec. 361.17 and carries out the 
duties of a Council with respect to functions for, and services 
provided to, individuals with disabilities, except for individuals who 
are blind.
    (4) An assurance that--
    (i) An independent commission that is consumer-controlled in 
accordance with paragraph (a)(1)(i) of this section and conducts a 
review and analysis of the effectiveness of and consumer satisfaction 
with <strong>vocational</strong> <strong>rehabilitation</strong> services and providers, in accordance 
with the provisions of Sec. 361.17(h)(3), is responsible under State 
law for operating or overseeing the operation of the <strong>vocational</strong> 
<strong>rehabilitation</strong> services for all individuals in the State, except 
individuals who are blind; and
    (ii) The State has established a State <strong>Rehabilitation</strong> Advisory 
Council that meets the criteria in Sec. 361.17 and carries out the 
duties of a Council with respect to functions for, and services 
provided to, individuals who are blind.

(Authority: Sections 101(a)(32) and 101(a)(36) of the Act; 29 U.S.C. 
721(a)(32) and 721(a)(36))


Sec. 361.17   Requirements for a State <strong>Rehabilitation</strong> Advisory Council.

    If the State plan contains an assurance that the State has 
established a Council under Sec. 361.16(a)(2), (b)(3)(ii), or 
(b)(4)(ii), the State plan must also contain an assurance that the 
Council meets the following requirements:
    (a) Appointment. (1) The members of the Council shall be--
    (i) Appointed by the Governor; or
    (ii) If State law vests appointment authority in an entity other 
than, or in conjunction with, the Governor (such as one or more houses 
of the State legislature or an independent board that has general 
appointment authority), appointed by that entity or entities.
    (2) The appointing authority shall select members of the Council 
after soliciting recommendations from representatives of organizations 
representing a broad range of individuals with disabilities and 
organizations interested in individuals with disabilities.
    (b) Composition. (1) General. Except as provided in paragraph 
(b)(3) of this section, the Council shall be composed of at least 13 
members, including--
    (i) At least one representative of the Statewide Independent Living 
Council, who must be the chairperson of, or other individual 
recommended by, the Statewide Independent Living Council;
    (ii) At least one representative of a parent training and 
information center established pursuant to section 631(e)(1) of IDEA;
    (iii) At least one representative of the Client Assistance Program 
(CAP), established under 34 CFR part 370, who must be the director of, 
or other individual recommended by, the CAP;
    (iv) At least one <strong>vocational</strong> <strong>rehabilitation</strong> counselor with 
knowledge of and experience with <strong>vocational</strong> <strong>rehabilitation</strong> programs who 
serves as an ex officio, nonvoting member if employed by the designated 
State agency;
    (v) At least one representative of community <strong>rehabilitation</strong> program 
service providers;
    (vi) Four representatives of business, industry, and labor;
    (vii) Representatives of disability groups that include a cross 
section of--
    (A) Individuals with physical, cognitive, sensory, and mental 
disabilities; and
    (B) Parents, family members, guardians, advocates, or authorized 
representatives of individuals with disabilities who have difficulty 
representing themselves due to their disabilities;
    (viii) Current or former applicants for, or recipients of, 
<strong>vocational</strong> <strong>rehabilitation</strong> services; and
    (ix) The director of the designated State unit as an ex officio, 
nonvoting member.
    (2) Employees of the designated State agency. Employees of the 
designated State agency may serve only as nonvoting members of the 
Council.
    (3) Composition of a separate Council for a separate State agency 
for individuals who are blind. Except as provided in paragraph (b)(4) 
of this section, if the State establishes a separate Council for a 
separate State agency for individuals who are blind, that Council 
must--
    (i) Conform with all of the composition requirements for a Council 
under paragraph (b)(1) of this section, except the requirements in 
paragraph (b)(1)(vii), unless the exception in paragraph (b)(4) of this 
section applies; and
    (ii) Include--
    (A) At least one representative of a disability advocacy group 
representing individuals who are blind; and
    (B) At least one parent, family member, guardian, advocate, or 
authorized representative of an individual who is blind, has multiple 
disabilities, and has difficulty representing himself or herself due to 
disabilities.
    (4) Exception. If State law in effect on October 29, 1992 requires 
a separate Council under paragraph (b)(3) of this section to have fewer 
than 13 members, the separate Council is deemed to be in compliance 
with the composition requirements in paragraphs (b)(1)(vi) and 
(b)(1)(viii) of this section if it includes at least one representative 
who meets the requirements for each of those paragraphs.
    (c) Majority. A majority of the Council members shall be 
individuals with disabilities who are not employed by the designated 
State unit.
    (d) Chairperson. The chairperson shall be--
    (1) Selected by the members of the Council from among the voting 
members of the Council, subject to the veto power of the Governor; or

[[Page 64507]]

    (2) If the Governor does not have veto power pursuant to State law, 
selected by the Governor, or by the Council if required by the 
Governor, from among the voting members of the Council.
    (e) Terms of appointment. (1) Each member of the Council shall be 
appointed for a term of no more than three years and may serve for no 
more than two consecutive full terms.
    (2) A member appointed to fill a vacancy occurring prior to the end 
of the term for which the predecessor was appointed shall be appointed 
for the remainder of the predecessor's term.
    (3) The terms of service of the members initially appointed must be 
for varied numbers of years to ensure that terms expire on a staggered 
basis.
    (f) Vacancies. (1) A vacancy in the membership of the Council must 
be filled in the same manner as the original appointment.
    (2) No vacancy affects the power of the remaining members to 
execute the duties of the Council.
    (g) Conflict of interest. No member of the Council shall cast a 
vote on any matter that would provide direct financial benefit to the 
member or the member's organization or otherwise give the appearance of 
a conflict of interest under State law.
    (h) Functions. The Council shall--
    (1) Review, analyze, and advise the designated State unit regarding 
the performance of the State unit's responsibilities under this part, 
particularly responsibilities related to--
    (i) Eligibility, including order of selection;
    (ii) The extent, scope, and effectiveness of services provided; and
    (iii) Functions performed by State agencies that affect or 
potentially affect the ability of individuals with disabilities to 
achieve <strong>rehabilitation</strong> goals and objectives under this part;
    (2) Advise and, at the discretion of the State agency, assist the 
State unit in the preparation of applications, the State plan, the 
strategic plan, and amendments to the plans, reports, needs 
assessments, and evaluations required by this part;
    (3) To the extent feasible, conduct a review and analysis of the 
effectiveness of, and consumer satisfaction with--
    (i) The functions performed by State agencies and other public and 
private entities responsible for serving individuals with disabilities; 
and
    (ii) The <strong>vocational</strong> <strong>rehabilitation</strong> services provided by State 
agencies and other public and private entities responsible for 
providing <strong>vocational</strong> <strong>rehabilitation</strong> services to individuals with 
disabilities from funds made available under the Act or through other 
public or private sources;
    (4) Prepare and submit to the Governor, or appropriate State 
entity, and to the Secretary no later than 90 days after the end of the 
Federal fiscal year an annual report on the status of <strong>vocational</strong> 
<strong>rehabilitation</strong> programs operated within the State and make the report 
available to the public through appropriate modes of communication;
    (5) Coordinate with other councils within the State, including the 
Statewide Independent Living Council established under 34 CFR part 364, 
the advisory panel established under section 613(a)(12) of IDEA, the 
State Planning Council described in section 124 of the Developmental 
Disabilities Assistance and Bill of Rights Act, and the State mental 
health planning council established under section 1916(e) of the Public 
Health Service Act;
    (6) Advise the designated State agency and provide for coordination 
and the establishment of working relationships between the designated 
State agency and the Statewide Independent Living Council and centers 
for independent living within the State; and
    (7) Perform other comparable functions, consistent with the purpose 
of this part, that the Council determines to be appropriate.
    (i) Resources.
    (1) The Council, in conjunction with the designated State unit, 
shall prepare a plan for the provision of resources, including staff 
and other personnel, that may be necessary for the Council to carry out 
its functions under this part.
    (2) In implementing the resources plan, the Council must rely on 
existing resources to the maximum extent possible.
    (3) Any disagreements between the designated State unit and the 
Council regarding the amount of resources necessary must be resolved by 
the Governor or other appointing entity, consistent with paragraphs 
(i)(1) and (2) of this section.
    (4) The Council shall, consistent with State law, supervise and 
evaluate the staff and personnel that are necessary to carry out its 
functions.
    (5) Those staff and personnel that are assisting the Council in 
carrying out its functions may not be assigned duties by the designated 
State unit or any other agency or office of the State that would create 
a conflict of interest.
    (j) Meetings. The Council shall--
    (1) Convene at least four meetings a year to conduct Council 
business that are publicly announced, open and accessible to the 
public, including individuals with disabilities, unless there is a 
valid reason for an executive session; and
    (2) Conduct forums or hearings, as appropriate, that are publicly 
announced, open and accessible to the public, including individuals 
with disabilities.
    (k) Compensation. Funds appropriated under Title I of the Act, 
except funds to carry out sections 112 and 130 of the Act, may be used 
to compensate and reimburse the expenses of Council members in 
accordance with section 105(g) of the Act.

(Authority: Section 105 of the Act; 29 U.S.C. 725)


Sec. 361.18  Comprehensive system of personnel development.

    The State plan must describe the procedures and activities the 
State agency will undertake to establish and maintain a comprehensive 
system of personnel development designed to ensure an adequate supply 
of qualified <strong>rehabilitation</strong> personnel, including professionals and 
paraprofessionals, for the designated State unit. If the State agency 
has a State <strong>Rehabilitation</strong> Advisory Council, this description must, at 
a minimum, provide for the involvement of the Council in the 
development of personnel standards in accordance with paragraph (c) of 
this section. This description must also conform with the following 
requirements:
    (a) Data system on personnel and personnel development. The State 
plan must describe the development and maintenance of a system by the 
State agency for collecting and analyzing on an annual basis data on 
qualified personnel needs and personnel development, in accordance with 
the following requirements:
    (1) Data on qualified personnel needs must include--
    (i) The number of personnel who are employed by the State agency in 
the provision of <strong>vocational</strong> <strong>rehabilitation</strong> services in relation to the 
number of individuals served, broken down by personnel category;
    (ii) The number of personnel currently needed by the State agency 
to provide <strong>vocational</strong> <strong>rehabilitation</strong> services, broken down by personnel 
category; and
    (iii) Projections of the number of personnel, broken down by 
personnel category, who will be needed by the State agency to provide 
<strong>vocational</strong> <strong>rehabilitation</strong> services in the State in five years based on 
projections of the number of individuals to be served, including 
individuals with severe disabilities, the number of personnel 

[[Page 64508]]
expected to retire or leave the field, and other relevant factors.
    (2) Data on personnel development must include--
    (i) A list of the institutions of higher education in the State 
that are preparing <strong>vocational</strong> <strong>rehabilitation</strong> professionals, by type of 
program;
    (ii) The number of students enrolled at each of those institutions, 
broken down by type of program; and
    (iii) The number of students who graduated during the prior year 
from each of those institutions with certification or licensure, or 
with the credentials for certification or licensure, broken down by the 
personnel category for which they have received, or have the 
credentials to receive, certification or licensure.
    (b) Plan for recruitment, preparation, and retention of qualified 
personnel. The State plan must describe the development, updating, and 
implementation of a plan to address the current and projected needs for 
personnel who are qualified in accordance with paragraph (c) of this 
section. The plan must identify the personnel needs based on the data 
collection and analysis system described in paragraph (a) of this 
section and must provide for the coordination and facilitation of 
efforts between the designated State unit and institutions of higher 
education and professional associations to recruit, prepare, and retain 
personnel who are qualified in accordance with paragraph (c) of this 
section, including personnel from minority backgrounds and personnel 
who are individuals with disabilities.
    (c) Personnel standards. (1) The State plan must include the State 
agency's policies and describe the procedures the State agency will 
undertake to establish and maintain standards to ensure that 
professional and paraprofessional personnel needed within the State 
unit to carry out this part are appropriately and adequately prepared 
and trained, including--
    (i) Standards that are consistent with any national or State-
approved or recognized certification, licensing, registration, or other 
comparable requirements (including State personnel requirements) that 
apply to the profession or discipline in which that category of 
personnel is providing <strong>vocational</strong> <strong>rehabilitation</strong> services; and
    (ii) To the extent those standards are not based on the highest 
requirements in the State applicable to that profession or discipline, 
the steps the State is currently taking and the steps the State plans 
to take to retrain or hire personnel to meet standards that are based 
on the highest requirements in the State, including measures to notify 
State unit personnel, the institutions of higher education identified 
under paragraph (a)(2)(i) of this section, and other public agencies of 
these steps and the timelines for taking each step.
    (2) As used in this section--
    (i) ``Highest requirements in the State applicable to that 
profession or discipline'' means the highest entry-level academic 
degree or equivalent experience needed for any national or State-
approved or recognized certification, licensing, registration, or other 
comparable requirements that apply to that profession or discipline. 
The current requirements of all State statutes and regulations of other 
agencies in the State applicable to that profession or discipline must 
be considered and must be kept on file by the designated State unit and 
available to the public.
    (ii) ``Profession or discipline'' means a specific occupational 
category, including any paraprofessional occupational category, that--
    (A) Provides <strong>rehabilitation</strong> services to individuals with 
disabilities;
    (B) Has been established or designated by the State; and
    (C) Has a specified scope of responsibility.
    (d) Staff development. (1) The State plan must include the State 
agency's policies and describe the procedures and activities the State 
agency will undertake to ensure that all personnel employed by the 
State unit receive appropriate and adequate training, including a 
description of--
    (i) A system of staff development for <strong>rehabilitation</strong> professionals 
and paraprofessionals within the State unit, particularly with respect 
to <strong>rehabilitation</strong> technology; and
    (ii) Procedures for acquiring and disseminating to <strong>rehabilitation</strong> 
professionals and paraprofessionals within the designated State unit 
significant knowledge from research and other sources, including 
procedures for providing training regarding the amendments to the 
<strong>Rehabilitation</strong> Act of 1973 made by the <strong>Rehabilitation</strong> Act Amendments of 
1992.
    (2) The specific training areas for staff development must be based 
on the needs of each State unit and may include, but are not limited 
to, training with respect to the requirements of the Americans with 
Disabilities Act, IDEA, and Social Security work incentive programs, 
training to facilitate informed choice under this program, and training 
to improve the provision of services to culturally diverse populations.
    (e) Personnel to address individual communication needs. The State 
plan must describe how the State unit--
    (1) Includes among its personnel, or obtains the services of, 
individuals able to communicate in the native languages of applicants 
and eligible individuals who have limited English speaking ability; and
    (2) Includes among its personnel, or obtains the services of, 
individuals able to communicate with applicants and eligible 
individuals in appropriate modes of communication.
    (f) Performance evaluation system. The State plan must describe how 
the system for evaluating the performance of <strong>rehabilitation</strong> counselors, 
coordinators, and other personnel used in the State unit facilitates, 
and in no way impedes, the accomplishment of the purpose and policy of 
the program as described in sections 100(a)(2) and 100(a)(3) of the 
Act, including the policy of serving, among others, individuals with 
the most severe disabilities.
    (g) Coordination with personnel development under IDEA. The State 
plan must describe the procedures and activities the State agency will 
undertake to coordinate its comprehensive system of personnel 
development under the Act with personnel development under IDEA.

(Authority: Sections 101 (a)(7) and (a)(35) of the Act; 29 U.S.C. 
721 (a)(7) and (35))

    Note: Under the Act and the regulations in this part, the State 
agency is required to collect and analyze data regarding personnel 
needs by type or category of personnel. The personnel data must be 
collected and analyzed according to personnel category breakdowns 
that are based on the major categories of staff in the State unit. 
Similarly, the data from institutions of higher education must be 
broken down by type of program to correspond as closely as possible 
with the personnel categories of the State unit.


Sec. 361.19  Affirmative action for individuals with disabilities.

    The State plan must assure that the State agency takes affirmative 
action to employ and advance in employment qualified individuals with 
disabilities.

(Authority: Section 101(a)(6)(A) of the Act; 29 U.S.C. 721(a)(6)(A))


Sec. 361.20  State plan development.

    (a) Public participation requirements. (1) Plan development and 
revisions. The State plan must assure that the State unit conducts 
public meetings throughout the State to provide all segments of the 
public, including interested groups, organizations, and individuals, an 
opportunity to comment on the State plan prior to its 

[[Page 64509]]
development and to comment on any revisions to the State plan.
    (2) Notice requirements. The State plan must assure that the State 
unit, prior to conducting public meetings, provides appropriate and 
sufficient notice throughout the State of the meetings in accordance 
with--
    (i) State law governing public meetings; or
    (ii) In the absence of State law governing public meetings, 
procedures developed by the State unit in consultation with the State 
<strong>Rehabilitation</strong> Advisory Council.
    (3) Plan revisions based on consumer satisfaction surveys. The 
State plan must describe the manner in which the State plan will be 
revised based on the results of consumer satisfaction surveys conducted 
by the State <strong>Rehabilitation</strong> Advisory Council under Sec. 361.17(h)(3) or 
by the State agency if it is an independent commission in accordance 
with the requirements of Sec. 361.16.
    (b) Special consultation requirements. The State plan must assure 
that, as appropriate, the State unit actively consults in the 
development and revision of the State plan with the CAP director, the 
State <strong>Rehabilitation</strong> Advisory Council, and, as appropriate, those 
Indian tribes, tribal organizations, and native Hawaiian organizations 
that represent significant numbers of individuals with disabilities 
within the State.
    (c) Summary of public comments. The State plan must include a 
summary of the public comments on the State plan, including comments on 
revisions to the State plan and the State unit's response to those 
comments.
    (d) Appropriate modes of communication. The State unit shall 
provide, through appropriate modes of communication, the notices of the 
public meetings, any materials furnished prior to or during the public 
meetings, and the approved State plan.

(Authority: Sections 101(a)(20), 101(a)(23), 101(a)(32), and 
105(c)(2) of the Act; 29 U.S.C. 721(a)(20), (23), and (32) and 
725(c)(2))


Sec. 361.21  Consultations regarding the administration of the State 
plan.

    (a) The State plan must assure that, in connection with matters of 
general policy development and implementation arising in the 
administration of the State plan, the State unit seeks and takes into 
account the views of--
    (1) Individuals who receive <strong>vocational</strong> <strong>rehabilitation</strong> services or, 
as appropriate, the individuals' representatives;
    (2) Personnel working in the field of <strong>vocational</strong> <strong>rehabilitation</strong>;
    (3) Providers of <strong>vocational</strong> <strong>rehabilitation</strong> services;
    (4) The CAP director; and
    (5) The State <strong>Rehabilitation</strong> Advisory Council, if the State has a 
Council.
    (b) The State plan must specifically describe the manner in which 
the State unit will take into account the views regarding State policy 
and administration of the State plan that are expressed in the consumer 
satisfaction surveys conducted by the State <strong>Rehabilitation</strong> Advisory 
Council under Sec. 361.17(h)(3) or by the State agency if it is an 
independent commission in accordance with the requirements of 
Sec. 361.16(a)(1).

(Authority: Sections 101(a)(18), 101(a)(32), and 105(c)(2) of the 
Act; 29 U.S.C. 721(a)(18), 721(a)(32), and 725(c)(2))


Sec. 361.22  Cooperation with agencies responsible for transitioning 
students.

    (a) Transitioning students who are receiving special education 
services. (1) General. The State plan must contain plans, policies, and 
procedures that are designed to facilitate the transition of students 
who are receiving special education services from the provision of a 
free appropriate public education under the responsibility of an 
educational agency to the provision of <strong>vocational</strong> <strong>rehabilitation</strong> 
services under the responsibility of the designated State unit. These 
plans, policies, and procedures must be designed to facilitate the 
development and accomplishment of long-term <strong>rehabilitation</strong> goals, 
intermediate <strong>rehabilitation</strong> objectives, and goals and objectives 
related to enabling a transitioning student to live independently 
before leaving a school setting, to the extent the goals and objectives 
are included in an individualized education program of the 
transitioning student.
    (2) Formal interagency agreement. The State plan must assure that 
the State unit enters into formal interagency agreements with the State 
education agency and, as appropriate, with local education agencies, 
that are responsible for the free appropriate public education of 
transitioning students who are receiving special education services.
    (i) Formal interagency agreements must, at a minimum, identify--
    (A) Policies, practices, and procedures that can be coordinated 
between the agencies, including definitions, standards for eligibility, 
policies and procedures for making referrals, procedures for outreach 
to and identification of youth who are receiving special education 
services and are in need of transition services, and procedures and 
timeframes for evaluation and follow-up of those transitioning 
students; and
    (B) The roles of each agency, including provisions for determining 
State lead agencies and qualified personnel responsible for transition 
services.
    (ii) Formal interagency agreements may, as appropriate, identify--
    (A) Available resources, including sources of funds for the 
development and expansion of services;
    (B) The financial responsibility of each agency in providing 
services to transitioning students who are receiving special education 
services, consistent with State law;
    (C) Procedures for resolving disputes between the agencies that are 
parties to the agreement; and
    (D) All other components necessary to ensure meaningful cooperation 
among agencies, including procedures to facilitate the development of 
local teams to coordinate the provision of services to individuals, 
sharing data, and coordinating joint training of staff in the provision 
of transition services.

    Note: The following excerpt from page 33 of Senate Report No. 
102-357 further clarifies the provision of transition services by 
the State <strong>vocational</strong> <strong>rehabilitation</strong> agency:

    The committee intends that students with disabilities who are 
eligible for, and who need, <strong>vocational</strong> <strong>rehabilitation</strong> services will 
receive those services as soon as possible, consistent with Federal 
and State law. These provisions are not intended in any way to shift 
the responsibility of service delivery from education to 
<strong>rehabilitation</strong> during the transition years. School officials will 
continue to be responsible for providing a free and appropriate 
public education as defined by the IEP. The role of the 
<strong>rehabilitation</strong> system is primarily one of planning for the student's 
years after leaving school. (S. Rep. No. 357, 102d Cong., 2d. Sess. 
33 (1992))

    (b) Transitioning students who are not receiving special education 
services. The State plan must contain plans, policies, and procedures, 
including cooperation with appropriate agencies, designed to ensure 
that transitioning students who are not receiving special education 
services have access to and can receive <strong>vocational</strong> <strong>rehabilitation</strong> 
services, if appropriate, and to ensure outreach to and identification 
of those individuals.

(Authority: Sections 101(a)(11)(C), 101(a)(24) and 101(a)(30) of the 
Act; 29 U.S.C. 721 (a)(11), (a)(24), and (a)(30))


Sec. 361.23  Cooperation with other public agencies.

    (a) Coordination of services with <strong>vocational</strong> education and Javits-
Wagner-O'Day programs. The State plan must assure that specific 
arrangements or 

[[Page 64510]]
agreements are made for the coordination of services for any individual 
who is eligible for <strong>vocational</strong> <strong>rehabilitation</strong> services and is also 
eligible for services under the Carl D. Perkins <strong>Vocational</strong> and Applied 
Technology Education Act or the Javits-Wagner-O'Day Act.
    (b) Cooperation with other Federal, State, and local public 
agencies providing services related to the <strong>rehabilitation</strong> of 
individuals with disabilities. (1) The State plan must assure that the 
State unit cooperates with other Federal, State, and local public 
agencies providing services related to the <strong>rehabilitation</strong> of 
individuals with disabilities, including, as appropriate, establishing 
interagency working groups or entering into other interagency 
cooperative agreements with, and using the services and facilities of--
    (i) Federal agencies providing services related to the 
<strong>rehabilitation</strong> of individuals with disabilities, including the Social 
Security Administration, the Office of Workers' Compensation Programs 
of the Department of Labor, and the Department of Veterans Affairs; and
    (ii) State and local public agencies providing services related to 
the <strong>rehabilitation</strong> of individuals with disabilities, including State 
and local public agencies administering the State's social services and 
financial assistance programs and other State programs for individuals 
with disabilities, such as the State's developmental disabilities 
program, veterans programs, health and mental health programs, 
education programs (including adult education, higher education, and 
<strong>vocational</strong> education programs), workers' compensation programs, job 
training and placement programs, and public employment offices.
    (2) Interagency cooperation under paragraph (b)(1) of this section, 
to the extent practicable, must provide for training for staff of the 
agencies as to the availability, benefits of, and eligibility standards 
for <strong>vocational</strong> <strong>rehabilitation</strong> services.
    (3) Interagency cooperation under paragraph (b)(1) of this section 
also must identify policies, practices, and procedures that can be 
coordinated among the agencies (particularly definitions, standards for 
eligibility, the joint sharing and use of evaluations and assessments, 
and procedures for making referrals); identify available resources and 
define the financial responsibility of each agency for paying for 
necessary services (consistent with State law) and procedures for 
resolving disputes between agencies; and include all additional 
components necessary to ensure meaningful cooperation and coordination.
    (c) Reciprocal referral services with a separate agency for 
individuals who are blind. If there is a separate State unit for 
individuals who are blind, the State plan must assure that the two 
State units establish reciprocal referral services, use each other's 
services and facilities to the extent feasible, jointly plan activities 
to improve services in the State for individuals with multiple 
impairments, including visual impairments, and otherwise cooperate to 
provide more effective services, including, if appropriate, entering 
into a written cooperative agreement.

(Authority: Sections 101(a)(11) and 101(a)(22) of the Act; 29 U.S.C. 
721(a)(11) and 721(a)(22))


Sec. 361.24  Coordination with the Statewide Independent Living 
Council.

    The State plan must assure that the State unit will coordinate and 
establish working relationships with the Statewide Independent Living 
Council established under 34 CFR part 364 and with independent living 
centers within the State.

(Authority: Section 101(a)(33) of the Act; 29 U.S.C. 721(a)(33))


Sec. 361.25  Statewideness.

    The State plan must assure that services provided under the State 
plan will be available in all political subdivisions of the State, 
unless a waiver of statewideness is requested and approved in 
accordance with Sec. 361.26.

(Authority: Section 101(a)(4) of the Act; 29 U.S.C. 721(a)(4))


Sec. 361.26  Waiver of statewideness.

    (a) Availability. The State unit may provide services in one or 
more political subdivisions of the State that increase services or 
expand the scope of services that are available statewide under the 
State plan if--
    (1) The non-Federal share of the cost of these services is met from 
funds provided by a local public agency, including funds contributed to 
a local public agency by a private agency, organization, or individual;
    (2) The services are likely to promote the <strong>vocational</strong> 
<strong>rehabilitation</strong> of substantially larger numbers of individuals with 
disabilities or of individuals with disabilities with particular types 
of impairments; and
    (3) The State includes in its State plan, and the Secretary 
approves, a request for a waiver of the statewideness requirement, in 
accordance with the requirements of paragraph (b) of this section.
    (b) Request for waiver. The request for a waiver of statewideness 
must--
    (1) Identify the types of services to be provided;
    (2) Contain a written assurance from the local public agency that 
it will make available to the State unit the non-Federal share of 
funds;
    (3) Contain a written assurance that State unit approval will be 
obtained for each proposed service before it is put into effect; and
    (4) Contain a written assurance that all other State plan 
requirements, including a State's order of selection requirements, will 
apply to all services approved under the waiver.

(Authority: Section 101(a)(4) of the Act; 29 U.S.C. 721(a)(4))


Sec. 361.27  Shared funding and administration of joint programs.

    (a) In order to carry out a joint program involving shared funding 
and administrative responsibility with another State agency or a local 
public agency to provide services to individuals with disabilities, the 
designated State unit must request approval from the Secretary in the 
State plan.
    (b) If a proposed joint program does not comply with the 
statewideness requirement in Sec. 361.25, the State unit shall obtain a 
waiver of statewideness, in accordance with Sec. 361.26.

(Authority: Section 101(a)(1)(A) of the Act; 29 U.S.C. 721(a)(1)(A))


Sec. 361.28  Third-party cooperative arrangements involving funds from 
other public agencies.

    (a) If the designated State unit enters into a third-party 
cooperative arrangement for providing or administering <strong>vocational</strong> 
<strong>rehabilitation</strong> services with another State agency or a local public 
agency that is furnishing part or all of the non-Federal share, the 
State plan must assure that--
    (1) The services provided by the cooperating agency are not the 
customary or typical services provided by that agency but are new 
services that have a <strong>vocational</strong> <strong>rehabilitation</strong> focus or existing 
services that have been modified, adapted, expanded, or reconfigured to 
have a <strong>vocational</strong> <strong>rehabilitation</strong> focus;
    (2) The services provided by the cooperating agency are only 
available to applicants for, or recipients of, services from the 
designated State unit;
    (3) Program expenditures and staff providing services under the 
cooperative arrangement are under the administrative supervision of the 
designated State unit; and 

[[Page 64511]]

    (4) All State plan requirements, including a State's order of 
selection, will apply to all services provided under the cooperative 
program.
    (b) If a third party cooperative agreement does not comply with the 
statewideness requirement in Sec. 361.25, the State unit shall obtain a 
waiver of statewideness, in accordance with Sec. 361.26.

(Authority: Section 101(a)(1)(A) of the Act; 29 U.S.C. 721(a)(1)(A))


Sec. 361.29  Statewide studies and evaluations.

    (a) Statewide studies. The State plan must assure that the State 
unit conducts continuing statewide studies to determine the current 
needs of individuals with disabilities within the State and the best 
methods to meet those needs. The continuing statewide studies, at a 
minimum, must include--
    (1) A triennial comprehensive assessment, as part of the 
development of the State plan, of the <strong>rehabilitation</strong> needs of 
individuals with severe disabilities who reside in the State;
    (2) A review of the effectiveness of outreach procedures used to 
identify and serve individuals with disabilities who are minorities and 
individuals with disabilities who are unserved and underserved by the 
<strong>vocational</strong> <strong>rehabilitation</strong> system;
    (3) An annual analysis of the characteristics of individuals 
determined to be ineligible for services and the reasons for the 
ineligibility determinations; and
    (4) A review of a broad variety of methods to provide, expand, and 
improve <strong>vocational</strong> <strong>rehabilitation</strong> services to individuals with the most 
severe disabilities, including individuals receiving supported 
employment services under 34 CFR Part 363.
    (b) Annual evaluation. The State plan must assure that the State 
unit conducts an annual evaluation of the effectiveness of the State's 
<strong>vocational</strong> <strong>rehabilitation</strong> program in providing <strong>vocational</strong> 
<strong>rehabilitation</strong> and supported employment services, especially to 
individuals with the most severe disabilities. The annual evaluation 
must analyze the extent to which--
    (1) The State has achieved the goals and priorities established in 
the State plan and annual amendments to the plan;
    (2) The State has achieved the objectives of the strategic plan and 
revisions to the plan developed under Subpart D of this part;
    (3) The State is in compliance with the evaluation standards and 
performance indicators established by the Secretary, pursuant to 
section 106 of the Act; and
    (4) The State unit has adopted and is implementing procedures and 
activities to improve staff effectiveness and has made reasonable 
progress toward meeting the personnel standards established in 
accordance with Sec. 361.18(c).
    (c) Reporting requirements. (1) The State plan must describe 
annually those changes that have been adopted in policy, in the State 
plan and its amendments, and in the strategic plan and its amendments 
as a result of the statewide studies and the annual program evaluation.
    (2) The State plan must contain an annual description of the 
methods used to expand and improve <strong>vocational</strong> <strong>rehabilitation</strong> services 
to individuals with the most severe disabilities, including the State 
unit's criteria for determining which individuals are individuals with 
the most severe disabilities.
    (3) The State unit shall submit summaries or copies of the 
statewide studies and the annual evaluations as attachments to the 
State plan.
    (d) Role of the State <strong>Rehabilitation</strong> Advisory Council. The State 
plan must assure that the State unit seeks the advice of the State 
<strong>Rehabilitation</strong> Advisory Council, if the State has a Council, regarding 
the continuing statewide studies and the annual evaluation and, at the 
discretion of the State agency, seeks assistance from the Council in 
the preparation and analysis of the studies and evaluation.

(Authority: Sections 101(a)(5) (A) and (B), 101(a)(9)(D), 101(a)(15) 
(B) and (D), 101(a)(19), and 105(c)(2) of the Act; 29 U.S.C. 721(a) 
(5), (9), (15), and (19) and 725(c)(2))


Sec. 361.30  Services to special groups of individuals with 
disabilities.

    (a) Civil employees of the United States. The State plan must 
assure that <strong>vocational</strong> <strong>rehabilitation</strong> services are available to civil 
employees of the U.S. Government who are disabled in the line of duty, 
under the same terms and conditions applied to other individuals with 
disabilities.
    (b) Public safety officers. (1) The State plan must assure that 
special consideration will be given to those individuals with 
disabilities whose disability arose from an impairment sustained in the 
line of duty while performing as a public safety officer and the 
immediate cause of that impairment was a criminal act, apparent 
criminal act, or a hazardous condition resulting directly from the 
officer's performance of duties in direct connection with the 
enforcement, execution, and administration of law or fire prevention, 
firefighting, or related public safety activities.
    (2) For the purposes of paragraph (b) of this section, ``special 
consideration'' for States under an order of selection means that those 
public safety officers who meet the requirements of paragraph (b)(1) of 
this section must receive priority for services over other eligible 
individuals in the same priority category of the order of selection.
    (3) For the purposes of paragraph (b) of this section, ``criminal 
act'' means any crime, including an act, omission, or possession under 
the laws of the United States, a State, or a unit of general local 
government that poses a substantial threat of personal injury, 
notwithstanding that by reason of age, insanity, intoxication, or 
otherwise, the person engaging in the act, omission, or possession was 
legally incapable of committing a crime.
    (4) For the purposes of paragraph (b) of this section, ``public 
safety officer'' means a person serving the United States or a State or 
unit of local government, with or without compensation, in any activity 
pertaining to--
    (i) The enforcement of the criminal laws, including highway patrol, 
or the maintenance of civil peace by the National Guard or the Armed 
Forces;
    (ii) A correctional program, facility, or institution if the 
activity is potentially dangerous because of contact with criminal 
suspects, defendants, prisoners, probationers, or parolees;
    (iii) A court having criminal or juvenile delinquent jurisdiction 
if the activity is potentially dangerous because of contact with 
criminal suspects, defendants, prisoners, probationers, or parolees; or
    (iv) Firefighting, fire prevention, or emergency rescue missions.
    (c) American Indians. (1) The State plan must assure that 
<strong>vocational</strong> <strong>rehabilitation</strong> services are provided to American Indians 
with disabilities residing in the State to the same extent that these 
services are provided to other significant groups of individuals with 
disabilities residing in the State.
    (2) The State plan also must assure that the designated State unit 
continues to provide <strong>vocational</strong> <strong>rehabilitation</strong> services, including, as 
appropriate, services traditionally used by Indian tribes, to American 
Indians with disabilities who reside on reservations and are eligible 
for services by a special tribal program under 34 CFR part 371.

(Authority: Sections 7, 101(a)(13), 101(a)(20), and 130(b)(3) of the 
Act; 29 U.S.C. 706, 721(a)(13), 721(a)(20), and 750(b)(3)) 

[[Page 64512]]



Sec. 361.31  Utilization of community resources.

    The State plan must assure that, in providing <strong>vocational</strong> 
<strong>rehabilitation</strong> services, public or other <strong>vocational</strong> or technical 
training programs or other appropriate community resources are used to 
the maximum extent feasible.

(Authority: Section 101(a)(12)(A) of the Act; 29 U.S.C. 
721(a)(12)(A))


Sec. 361.32  Utilization of profitmaking organizations for on-the-job 
training in connection with selected projects.

    The State plan must assure that the State unit has the authority to 
enter into contracts with profitmaking organizations for the purpose of 
providing on-the-job training and related programs for individuals with 
disabilities under the Projects With Industry program, 34 CFR part 379, 
if it has been determined that they are better qualified to provide 
needed services than nonprofit agencies, organizations, or programs in 
the State.

(Authority: Section 101(a)(21) of the Act; 29 U.S.C. 721(a)(21))


Sec. 361.33  Utilization of community <strong>rehabilitation</strong> programs.

    (a) The State plan must assure that the designated State unit uses 
community <strong>rehabilitation</strong> programs to the maximum extent feasible to 
provide <strong>vocational</strong> <strong>rehabilitation</strong> services in the most integrated 
settings possible, consistent with the informed choices of the 
individuals.
    (b) The State plan must contain a description of--
    (1) The capacity and effectiveness of community <strong>rehabilitation</strong> 
programs, including programs under the Javits-Wagner-O'Day Act, based 
on the utilization patterns of those programs; and
    (2) The methods used to ensure the appropriate use of community 
<strong>rehabilitation</strong> programs, including methods for entering into agreements 
with the operators of those programs and for entering into cooperative 
agreements with private nonprofit <strong>vocational</strong> <strong>rehabilitation</strong> service 
providers.

(Authority: Sections 101(a)(5)(A), 101(a)(12)(B), 101(a)(15)(B), 
101(a)(27), and 101(a)(28) of the Act; 29 U.S.C. 721(a) (5), (12), 
(15), (27), and (28))


Sec. 361.34  Supported employment plan.

    (a) The State plan must assure that the State has an acceptable 
plan under 34 CFR part 363 that provides for the use of funds under 
that part to supplement funds under this part for the cost of services 
leading to supported employment.
    (b) The supported employment plan, including annual revisions, must 
be submitted as a supplement to the State plan.

(Authority: Sections 101(a)(25) and 635(a) of the Act; 29 U.S.C. 
721(a)(25))


Sec. 361.35  Strategic plan.

    (a) The State plan must assure that the State--
    (1) Has developed and implemented a strategic plan for expanding 
and improving <strong>vocational</strong> <strong>rehabilitation</strong> services for individuals with 
disabilities on a statewide basis in accordance with subpart D of this 
part; and
    (2) Will use at least 1.5 percent of its allotment under this 
program for expansion and improvement activities in accordance with 
Sec. 361.73(b).
    (b) The strategic plan must be submitted as a supplement to the 
State plan.

(Authority: Sections 101(a)(34) and 120 of the Act; 29 U.S.C. 
721(a)(34) and 740)


Sec. 361.36  [Reserved]


Sec. 361.37  Establishment and maintenance of information and referral 
resources.

    (a) General provisions. The State plan must assure that--
    (1) The designated State unit will establish and maintain 
information and referral programs adequate to ensure that individuals 
with disabilities within the State are given accurate information about 
State <strong>vocational</strong> <strong>rehabilitation</strong> services, independent living services, 
<strong>vocational</strong> <strong>rehabilitation</strong> services available from other agencies, 
organizations, and community <strong>rehabilitation</strong> programs, and, to the 
extent possible, other Federal and State services and programs that 
assist individuals with disabilities, including client assistance and 
other protection and advocacy programs;
    (2) The State unit will refer individuals with disabilities to 
other appropriate Federal and State programs that might be of benefit 
to them; and
    (3) The State unit will use existing information and referral 
systems in the State to the greatest extent possible.
    (b) Appropriate modes of communication. The State plan further must 
assure that information and referral programs use appropriate modes of 
communication.
    (c) Special Circumstances. If the State unit is operating under an 
order of selection for services, the State unit may elect to establish 
an expanded information and referral program that includes referral for 
job placements for those eligible individuals who are not in the 
priority category or categories to receive <strong>vocational</strong> <strong>rehabilitation</strong> 
services under the State's order of selection. If a State unit elects 
to establish this kind of program, the State plan must include--
    (1) A description of how the expanded information and referral 
program will be established and how it will function, including the 
level of commitment of State unit staff and resources;
    (2) An assurance that, in carrying out this program, the State unit 
will not use case services funds that are needed to provide <strong>vocational</strong> 
<strong>rehabilitation</strong> services under individualized written <strong>rehabilitation</strong> 
programs for eligible individuals in the priority category or 
categories receiving services under the State unit's order of 
selection; and
    (3) A description of the method to be used by the State unit to 
track the results of the expanded information and referral program, 
including the State unit's procedures for identifying those eligible 
individuals who achieve an employment outcome through participation in 
the expanded information and referral program.

(Authority: Section 101(a)(22) of the Act; 29 U.S.C. 721(a)(22))


Sec. 361.38  Protection, use, and release of personal information.

    (a) General provisions.
    (1) The State plan must assure that the State agency and the State 
unit will adopt and implement policies and procedures to safeguard the 
confidentiality of all personal information, including photographs and 
lists of names. These policies and procedures must assure that--
    (i) Specific safeguards protect current and stored personal 
information;
    (ii) All applicants and eligible individuals and, as appropriate, 
those individuals' representatives, service providers, cooperating 
agencies, and interested persons are informed through appropriate modes 
of communication of the confidentiality of personal information and the 
conditions for accessing and releasing this information;
    (iii) All applicants or their representatives are informed about 
the State unit need to collect personal information and the policies 
governing its use, including--
    (A) Identification of the authority under which information is 
collected;
    (B) Explanation of the principal purposes for which the State unit 
intends to use or release the information;
    (C) Explanation of whether providing requested information to the 
State unit is mandatory or voluntary and the 

[[Page 64513]]
effects of not providing requested information;
    (D) Identification of those situations in which the State unit 
requires or does not require informed written consent of the individual 
before information may be released; and
    (E) Identification of other agencies to which information is 
routinely released;
    (iv) An explanation of State policies and procedures affecting 
personal information will be provided to each individual in that 
individual's native language or through the appropriate mode of 
communication; and
    (v) These policies and procedures provide no fewer protections for 
individuals than State laws and regulations.
    (2) The State unit may establish reasonable fees to cover 
extraordinary costs of duplicating records or making extensive searches 
and shall establish policies and procedures governing access to 
records.
    (b) State program use. All personal information in the possession 
of the State agency or the designated State unit must be used only for 
the purposes directly connected with the administration of the 
<strong>vocational</strong> <strong>rehabilitation</strong> program. Information containing identifiable 
personal information may not be shared with advisory or other bodies 
that do not have official responsibility for administration of the 
program. In the administration of the program, the State unit may 
obtain personal information from service providers and cooperating 
agencies under assurances that the information may not be further 
divulged, except as provided under paragraphs (c), (d), and (e) of this 
section.
    (c) Release to applicants and eligible individuals. (1) Except as 
provided in paragraphs (c)(2) and (c)(3) of this section, if requested 
in writing by an applicant or eligible individual, the State unit shall 
release all requested information in that individual's record of 
services to the individual or the individual's representative in a 
timely manner.
    (2) Medical, psychological, or other information that the State 
unit determines may be harmful to the individual may not be released 
directly to the individual, but must be provided through a third party 
chosen by the individual, which may include, among others, an advocate, 
a family member, or a qualified medical or mental health professional.
    (3) If personal information has been obtained from another agency 
or organization, it may be released only by, or under the conditions 
established by, the other agency or organization.
    (d) Release for audit, evaluation, and research. Personal 
information may be released to an organization, agency, or individual 
engaged in audit, evaluation, or research only for purposes directly 
connected with the administration of the <strong>vocational</strong> <strong>rehabilitation</strong> 
program, or for purposes that would significantly improve the quality 
of life for applicants and eligible individuals and only if the 
organization, agency, or individual assures that--
    (1) The information will be used only for the purposes for which it 
is being provided;
    (2) The information will be released only to persons officially 
connected with the audit, evaluation, or research;
    (3) The information will not be released to the involved 
individual;
    (4) The information will be managed in a manner to safeguard 
confidentiality; and
    (5) The final product will not reveal any personal identifying 
information without the informed written consent of the involved 
individual or the individual's representative.
    (e) Release to other programs or authorities. (1) Upon receiving 
the informed written consent of the individual or, if appropriate, the 
individual's representative, the State unit may release personal 
information to another agency or organization for its program purposes 
only to the extent that the information may be released to the involved 
individual or the individual's representative and only to the extent 
that the other agency or organization demonstrates that the information 
requested is necessary for its program.
    (2) Medical or psychological information that the State unit 
determines may be harmful to the individual may be released if the 
other agency or organization assures the State unit that the 
information will be used only for the purpose for which it is being 
provided and will not be further released to the individual.
    (3) The State unit shall release personal information if required 
by Federal law or regulations.
    (4) The State unit shall release personal information in response 
to investigations in connection with law enforcement, fraud, or abuse, 
unless expressly prohibited by Federal or State laws or regulations, 
and in response to an order issued by a judicial officer.
    (5) The State unit also may release personal information in order 
to protect the individual or others if the individual poses a threat to 
his or her safety or to the safety of others.

(Authority: Sections 12(c) and 101(a)(6)(A) of the Act; 29 U.S.C. 
711(c) and 721(a)(6)(A))


Sec. 361.39  State-imposed requirements.

    The State plan must assure that the designated State unit 
identifies upon request those regulations and policies relating to the 
administration or operation of its <strong>vocational</strong> <strong>rehabilitation</strong> program 
that are State-imposed, including any regulations or policy based on 
State interpretation of any Federal law, regulations, or guideline.

(Authority: Section 17 of the Act; 29 U.S.C. 716)


Sec. 361.40  Reports.

    The State plan must assure that the State unit--
    (a) Will submit reports in the form and detail and at the time 
required by the Secretary, including reports required under sections 
13, 14, and 101(a)(10) of the Act; and
    (b) Will comply with any requirements necessary to ensure the 
correctness and verification of those reports.

(Authority: Section 101(a)(10) of the Act; 29 U.S.C. 721(a)(10))

State Plan Content: Provision and Scope of Services


Sec. 361.41  Processing referrals and applications.

    (a) Referrals. The State plan must assure that the designated State 
unit has established and implemented standards for the prompt and 
equitable handling of referrals of individuals for <strong>vocational</strong> 
<strong>rehabilitation</strong> services. The standards must include timelines for 
making good faith efforts to inform these individuals of application 
requirements and to gather information necessary to initiate an 
assessment for determining eligibility and priority for services.
    (b) Applications. (1) The State plan must assure that once an 
individual has submitted an application for <strong>vocational</strong> <strong>rehabilitation</strong> 
services, an eligibility determination will be made within 60 days, 
unless--
    (i) Exceptional and unforeseen circumstances beyond the control of 
the agency preclude a determination within 60 days and the individual 
is so notified and agrees that an extension of time is warranted; or
    (ii) An extended evaluation is necessary, in accordance with 
Sec. 361.42(d).
    (2) An individual is considered to have submitted an application 
when the individual or the individual's representative, as appropriate, 
has completed and signed an agency application form or has otherwise 
requested services and has provided 

[[Page 64514]]
information necessary to initiate an assessment to determine 
eligibility and priority for services.
    (3) The designated State unit shall ensure that its application 
forms are widely available throughout the State.

(Authority: Sections 101(a)(6)(A) and 102(a)(5)(A) of the Act; 29 
U.S.C. 721(a)(6)(A) and 722(a)(5)(A))


Sec. 361.42  Assessment for determining eligibility and priority for 
services.

    The State plan must assure that, in order to determine whether an 
individual is eligible for <strong>vocational</strong> <strong>rehabilitation</strong> services and the 
individual's priority under an order of selection for services (if the 
State is operating under an order of selection), the designated State 
unit will conduct an assessment for determining eligibility and 
priority for services. The assessment must be conducted in the most 
integrated setting possible, consistent with the individual's needs and 
informed choice, and in accordance with the following provisions:
    (a) Eligibility requirements. (1) Basic requirements. The State 
plan must assure that the State unit's determination of an applicant's 
eligibility for <strong>vocational</strong> <strong>rehabilitation</strong> services is based only on the 
following requirements:
    (i) A determination that the applicant has a physical or mental 
impairment, as determined by qualified personnel licensed or certified 
in accordance with State law or regulation.
    (ii) A determination that the applicant's physical or mental 
impairment constitutes or results in a substantial impediment to 
employment for the applicant.
    (iii) A determination, in accordance with paragraph (a)(2) of this 
section, that the applicant can benefit in terms of an employment 
outcome from the provision of <strong>vocational</strong> <strong>rehabilitation</strong> services.
    (iv) A determination that the applicant requires <strong>vocational</strong> 
<strong>rehabilitation</strong> services to prepare for, enter into, engage in, or 
retain gainful employment consistent with the applicant's strengths, 
resources, priorities, concerns, abilities, capabilities, and informed 
choice.
    (2) Presumption of benefit. The State plan must assure that the 
designated State unit will presume that an applicant who meets the 
eligibility requirements in paragraphs (a)(1) (i) and (ii) of this 
section can benefit in terms of an employment outcome unless it 
determines, based on clear and convincing evidence, that the applicant 
is incapable of benefitting in terms of an employment outcome from 
<strong>vocational</strong> <strong>rehabilitation</strong> services.
    (3) Limited presumption for Social Security beneficiaries. The 
State plan must assure that, if an applicant has appropriate evidence, 
such as an award letter, that establishes the applicant's eligibility 
for Social Security benefits under Title II or Title XVI of the Social 
Security Act, the designated State unit will presume that the 
applicant--
    (i) Meets the eligibility requirements in paragraphs (a)(1) (i) and 
(ii) of this section; and
    (ii) Has a severe physical or mental impairment that seriously 
limits one or more functional capacities in terms of an employment 
outcome.
    (b) Prohibited factors. The State plan must assure that--
    (1) No duration of residence requirement is imposed that excludes 
from services any applicant who is present in the State;
    (2) No applicant or group of applicants is excluded or found 
ineligible solely on the basis of the type of disability;
    (3) The eligibility requirements are applied without regard to the 
age, gender, race, color, creed, or national origin of the applicant; 
and
    (4) The eligibility requirements are applied without regard to the 
particular service needs or anticipated cost of services required by an 
applicant or the income level of an applicant or applicant's family.
    (c) Review and assessment of data for eligibility determination. 
Except as provided in paragraph (d) of this section, the designated 
State unit shall base its determination of each of the basic 
eligibility requirements in paragraph (a) of this section on--
    (1) A review and assessment of existing data, including counselor 
observations, education records, information provided by the individual 
or the individual's family, information used by the Social Security 
Administration, and determinations made by officials of other agencies; 
and
    (2) To the extent existing data do not describe the current 
functioning of the individual or are unavailable, insufficient, or 
inappropriate to make an eligibility determination, an assessment of 
additional data resulting from the provision of <strong>vocational</strong> 
<strong>rehabilitation</strong> services, including assistive technology devices and 
services and worksite assessments, that are necessary to determine 
whether an individual is eligible.
    (d) Extended evaluation for individuals with severe disabilities.  
(1) Prior to any determination that an individual with a severe 
disability is incapable of benefitting from <strong>vocational</strong> <strong>rehabilitation</strong> 
services in terms of an employment outcome because of the severity of 
that individual's disability, the State unit shall conduct an extended 
evaluation to determine whether or not there is clear and convincing 
evidence to support such a determination.
    (2) During the extended evaluation period, which may not exceed 18 
months, <strong>vocational</strong> <strong>rehabilitation</strong> services must be provided in the most 
integrated setting possible, consistent with the informed choice of the 
individual.
    (3) During the extended evaluation period, the State unit shall 
develop a written plan for determining eligibility and for determining 
the nature and scope of services required to achieve an employment 
outcome. The State unit may provide during this period only those 
services that are necessary to make these two determinations.
    (4) The State unit shall assess the individual's progress as 
frequently as necessary, but at least once every 90 days, during the 
extended evaluation period.
    (5) The State unit shall terminate extended evaluation services at 
any point during the 18-month extended evaluation period if the State 
unit determines that--
    (i) There is sufficient evidence to conclude that the individual 
can benefit from the provision of <strong>vocational</strong> <strong>rehabilitation</strong> services in 
terms of an employment outcome; or
    (ii) There is clear and convincing evidence that the individual is 
incapable of benefitting from <strong>vocational</strong> <strong>rehabilitation</strong> services in 
terms of an employment outcome.
    (e) Data for determination of priority for services under an order 
of selection. If the State unit is operating under an order of 
selection for services, as provided in Sec. 361.36, the State unit 
shall base its priority assignments on--
    (1) A review of the data that was developed under paragraphs (c) 
and (d) of this section to make the eligibility determination; and
    (2) An assessment of additional data, to the extent necessary.

(Authority: Sections 7(22)(A)(ii), 7(22)(C)(iii), 101(a)(9)(A), 
101(a)(14), 101(a)(31), 102(a)(1), 102(a)(2), 102(a)(3), and 
102(a)(4) of the Act; 29 U.S.C. 706(22)(A)(ii), 706(22)(C)(iii), 
721(a)(9)(a), 721(a)(14), 721(a)(31), 722(a)(1), 722(a)(2), 
722(a)(3), and 722(a)(4))

    Note: ``Clear and convincing evidence'' means that the 
designated State unit must have a high degree of certainty before it 
can conclude that an individual is incapable of benefitting from 
services in terms of an employment outcome. The ``clear and 
convincing'' standard constitutes the highest standard used in our 
civil system of law and 

[[Page 64515]]
is to be individually applied on a case-by-case basis. The term 
``clear'' means unequivocal. Given these requirements, a review of 
existing information generally would not provide clear and 
convincing evidence. For example, the use of an intelligence test 
result alone would not constitute clear and convincing evidence. 
Clear and convincing evidence might include a description of 
assessments, including situational assessments and supported 
employment assessments, from service providers who have concluded 
that they would be unable to meet the individual's needs due to the 
severity of the individual's disability. The demonstration of 
``clear and convincing evidence'' must include, if appropriate, a 
functional assessment of skill development activities, with any 
necessary supports (including assistive technology), in real life 
settings.

    Note: Under the statute and paragraph (a)(1)(iv) of Sec. 361.42, 
an individual with a disability is not eligible for <strong>vocational</strong> 
<strong>rehabilitation</strong> services if the individual does not require the 
services to prepare for, enter, engage in, or retain gainful 
employment. The following examples illustrate how an individual with 
a disability may or may not meet this final eligibility criterion. 
The examples are purely illustrative, do not address all possible 
circumstances, and are not intended to substitute for individual 
counselor judgment. State units shall determine eligibility for 
<strong>vocational</strong> <strong>rehabilitation</strong> services on a case-by-case basis, taking 
into account those individual circumstances relating to an 
individual's strengths, resources, priorities, concerns, abilities, 
and capabilities.

    Example: An individual with a disability who is not currently 
employed and is unable to obtain employment consistent with the 
individual's abilities and capabilities would likely meet this 
eligibility criterion.
    Example: An individual with a disability who is already employed 
in a setting consistent with the individual's abilities and 
capabilities, but who desires to change jobs for reasons unrelated 
to the individual's disability, would likely not meet this 
eligibility criterion.
    Example: An individual with a disability who is already 
employed, but not in a setting consistent with the individual's 
abilities and capabilities, and who desires to obtain new employment 
that is consistent with his or her abilities and capabilities, would 
meet this eligibility criterion.
    Example: An individual with a disability who is currently 
employed, but is in jeopardy of losing that employment due to 
disability-related factors (e.g., the individual's disability is 
progressive and results in additional functional limitations), would 
meet this eligibility criterion.
    Example: An individual with a disability who was previously 
employed in a setting consistent with the individual's abilities and 
capabilities, who lost that employment for reasons unrelated to the 
disability, and whose job skills are transferable would likely not 
meet this eligibility criterion.
    Example: An individual with a disability whose disability is of 
a temporary nature (e.g., an allowed Social Security beneficiary who 
has been assigned a diaried date (date of a follow-up review to 
determine whether the individual has recovered medically) because 
his or her disability is expected to improve within 12 months) might 
not meet this eligibility criterion.


Sec. 361.43  Procedures for ineligibility determination.

    The State plan must assure that if the State unit determines that 
an applicant is ineligible for <strong>vocational</strong> <strong>rehabilitation</strong> services or 
determines that an individual receiving services under an 
individualized written <strong>rehabilitation</strong> program is no longer eligible for 
services, the State unit shall--
    (a) Make the determination only after providing an opportunity for 
full consultation with the individual or, as appropriate, with the 
individual's representative;
    (b) Inform the individual in writing, or by appropriate modes of 
communication, of the ineligibility determination, including the 
reasons for that determination, the requirements under this section, 
and the means by which the individual may express and seek remedy for 
any dissatisfaction, including the procedures for review of a 
determination by the <strong>rehabilitation</strong> counselor or coordinator in 
accordance with Sec. 361.57;
    (c) Provide the individual with a description of services available 
from a client assistance program established under 34 CFR part 370 and 
information on how to contact that program; and
    (d) Review the ineligibility determination--
    (1) Within 12 months, unless the individual has refused the review, 
is no longer present in the State, or the individual's whereabouts are 
unknown; or
    (2) In the case of an ineligibility determination based on a 
determination that the individual is incapable of achieving an 
employment outcome, within 12 months in accordance with paragraph 
(d)(1) of this section and annually thereafter if requested by the 
individual or, if appropriate, by the individual's representative.

(Authority: Sections 101(a)(9)(D), 102(a)(6), and 102(c) of the Act; 
29 U.S.C. 721(a)(9), 722(a)(6), and 722(c))


Sec. 361.44  Closure without eligibility determination.

    The State plan must assure that the State unit may not close an 
applicant's case prior to making an eligibility determination unless 
the applicant declines to participate in, or is unavailable to complete 
an assessment for determining eligibility and priority for services, 
and the State unit has made a reasonable number of attempts to contact 
the applicant or, if appropriate, the applicant's representative to 
encourage the applicant's participation.

(Authority: Sections 12(c) and 101(a)(6)(A) of the Act; 29 U.S.C. 
711(c) and 721(a)(6))


Sec. 361.45  Development of the individualized written <strong>rehabilitation</strong> 
program.

    (a) Purpose. The State plan must assure that the State unit 
conducts an assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs 
for each eligible individual or, if the State is operating under an 
order of selection, for each eligible individual to whom the State is 
able to provide services. The purpose of this assessment is to 
determine the long-term <strong>vocational</strong> goal, intermediate <strong>rehabilitation</strong> 
objectives, and the nature and scope of <strong>vocational</strong> <strong>rehabilitation</strong> 
services to be included in the IWRP, which must be designed to achieve 
an employment outcome that is consistent with the individual's unique 
strengths, priorities, concerns, abilities, capabilities, and career 
interests.
    (b) Procedural requirements. The State plan must assure that--
    (1) The IWRP is developed jointly, agreed to, and signed by the 
<strong>vocational</strong> <strong>rehabilitation</strong> counselor or coordinator and the individual 
or, as appropriate, the individual's representative within the 
framework of a counseling and guidance relationship;
    (2) The State unit has established and implemented standards for 
the prompt development of IWRPs for the individuals identified under 
paragraph (a) of this section, including timelines that take into 
consideration the needs of the individual;
    (3) The State unit advises each individual or, as appropriate, the 
individual's representative of all State unit procedures and 
requirements affecting the development and review of an IWRP, including 
the availability of appropriate modes of communication;
    (4) In developing an IWRP for a transitioning student, the State 
unit considers the student's individualized education program;
    (5) The State unit reviews the IWRP with the individual or, as 
appropriate, the individual's representative as often as necessary, but 
at least once each year to assess the individual's progress in meeting 
the objectives identified in the IWRP;
    (6) The State unit incorporates into the IWRP any revisions that 
are necessary to reflect changes in the individual's <strong>vocational</strong> goal, 
intermediate objectives, or <strong>vocational</strong> <strong>rehabilitation</strong> needs, after 
obtaining the agreement and signature of the individual or, as 
appropriate, the 

[[Page 64516]]
agreement and signature of the individual's representative; and
    (7) The State unit promptly provides each individual or, as 
appropriate, the individual's representative, a copy of the IWRP and 
its amendments in the native language, or appropriate mode of 
communication, of the individual or, as appropriate, of the 
individual's representative.
    (c) Data for preparing the IWRP.
    (1) Preparation without comprehensive assessment. To the extent 
possible, the <strong>vocational</strong> goal, intermediate objectives, and the nature 
and scope of <strong>rehabilitation</strong> services to be included in the individual's 
IWRP must be determined based on the data used for the assessment of 
eligibility and priority for services under Sec. 361.42.
    (2) Preparation based on comprehensive assessment.
    (i) If additional data are necessary to prepare the IWRP, the 
designated State unit shall conduct a comprehensive assessment of the 
unique strengths, resources, priorities, interests, and needs, 
including the need for supported employment services of an eligible 
individual, in the most integrated setting possible, consistent with 
the informed choice of the individual.
    (ii) The comprehensive assessment must be limited to information 
that is necessary to identify the <strong>rehabilitation</strong> needs of the 
individual and develop the IWRP and may, to the extent needed, 
include--
    (A) An analysis of pertinent medical, psychiatric, psychological, 
neuropsychological, and other pertinent <strong>vocational</strong>, educational, 
cultural, social, recreational, and environmental factors, and related 
functional limitations, that affect the employment and <strong>rehabilitation</strong> 
needs of the individual;
    (B) An analysis of the individual's personality, career interests, 
interpersonal skills, intelligence and related functional capacities, 
educational achievements, work experience, <strong>vocational</strong> aptitudes, 
personal and social adjustments, and employment opportunities;
    (C) An appraisal of the individual's patterns of work behavior and 
services needed to acquire occupational skills and to develop work 
attitudes, work habits, work tolerance, and social and behavior 
patterns suitable for successful job performance; and
    (D) An assessment, through provision of <strong>rehabilitation</strong> technology 
services, of the individual's capacities to perform in a work 
environment, including in an integrated setting, to the maximum extent 
feasible and consistent with the individual's informed choice.
    (iii) In preparing a comprehensive assessment, the State unit shall 
use, to the maximum extent possible and appropriate and in accordance 
with confidentiality requirements, existing information, including 
information that is provided by the individual, the family of the 
individual, and education agencies.

(Authority: Sections 7(22)(B), 102(b)(1)(A), and 102(b)(2); 29 
U.S.C. 706(5), 721(a)(9), 722, and 723(a)(1))


Sec. 361.46  Content of the individualized written <strong>rehabilitation</strong> 
program.

    (a) General requirements. The State plan must assure that each IWRP 
includes, as appropriate, statements concerning--
    (1) The specific long-term <strong>vocational</strong> goal, which must be based on 
the assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs, 
including the individual's career interests, and must be, to the extent 
appropriate and consistent with the informed choice of the individual, 
in an integrated setting;
    (2) The specific and measurable intermediate <strong>rehabilitation</strong> 
objectives related to the attainment of the long-term <strong>vocational</strong> goal, 
based on the assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs 
and consistent with the informed choice of the individual;
    (3) The specific <strong>rehabilitation</strong> services under Sec. 361.48 to be 
provided to achieve the established intermediate <strong>rehabilitation</strong> 
objectives, including, if appropriate, <strong>rehabilitation</strong> technology 
services and on-the-job and related personal assistance services;
    (4) The projected dates for the initiation of each <strong>vocational</strong> 
<strong>rehabilitation</strong> service, the anticipated duration of each service, and 
the projected date for the achievement of the individual's <strong>vocational</strong> 
goal;
    (5) A procedure and schedule for periodic review and evaluation of 
progress toward achieving intermediate <strong>rehabilitation</strong> objectives based 
upon objective criteria and a record of these reviews and evaluations;
    (6) How, in the words of the individual or, as appropriate, in the 
words of the individual's representative, the individual was--
    (i) Informed about and involved in choosing among alternative 
goals, objectives, services, providers, and methods used to procure or 
provide services; and
    (ii) Provided information regarding the availability and 
qualifications of alternative providers of services;
    (7) The terms and conditions for the provision of <strong>vocational</strong> 
<strong>rehabilitation</strong> services, including--
    (i) The responsibilities of the individual in implementing the 
IWRP;
    (ii) The extent of the individual's participation in the cost of 
services;
    (iii) The extent to which goods and services will be provided in 
the most integrated settings possible, consistent with the informed 
choices of the individual;
    (iv) The extent to which comparable services and benefits are 
available to the individual under any other program; and
    (v) The entity or entities that will provide the services and the 
process used to provide or procure the services;
    (8) The rights of the individual under this part and the means by 
which the individual may express and seek remedy for any 
dissatisfaction, including the opportunity for a review of 
<strong>rehabilitation</strong> counselor or coordinator determinations under 
Sec. 361.57;
    (9) The availability of a client assistance program established 
under 34 CFR part 370; and
    (10) The basis on which the individual has been determined to have 
achieved an employment outcome.
    (b) Supported employment placements. The State plan must assure 
that the IWRP for individuals with the most severe disabilities for 
whom a <strong>vocational</strong> goal in a supported employment setting has been 
determined to be appropriate will also contain--
    (1) A description of the supported employment services to be 
provided by the State unit; and
    (2) A description of the extended services needed and 
identification of the source of extended services or, in the event that 
identification of the source is not possible at the time the IWRP is 
developed, a statement explaining the basis for concluding that there 
is a reasonable expectation that services will become available.
    (c) Post-employment services. The State plan must assure that the 
IWRP for each individual contains statements concerning--
    (1) The expected need for post-employment services, based on an 
assessment during the development of the IWRP;
    (2) A reassessment of the need for post-employment services prior 
to the determination that the individual has achieved an employment 
outcome;
    (3) A description of the terms and conditions for the provision of 
any post-employment services, including the anticipated duration of 
those services, subsequent to the achievement of an employment outcome 
by the individual; and 

[[Page 64517]]

    (4) If appropriate, a statement of how post-employment services 
will be provided or arranged through cooperative agreements with other 
service providers.
    (d) Coordination of services for transitioning students. The State 
plan must assure that the IWRP for a transitioning student is 
coordinated with the individualized education program (IEP) for that 
individual in terms of the goals, objectives, and services identified 
in the IEP.
    (e) Ineligibility. The State plan must assure that the decision 
that an individual is not capable of achieving an employment outcome 
and is no longer eligible to receive services under an IWRP is made in 
accordance with the requirements in Sec. 361.43. The decision, and the 
reasons on which the decision was based, must be included as an 
amendment to the IWRP.

(Authority: Sections 101(a)(9), 102(b)(1), 102(c), and 635(b)(6) of 
the Act; 29 U.S.C. 721(a)(9), 722, and 795n)


Sec. 361.47  Record of services.

    The State plan must assure that the designated State unit maintains 
for each applicant or eligible individual a record of services that 
includes, to the extent pertinent, the following documentation:
    (a) If an applicant has been determined to be an eligible 
individual, documentation supporting that determination in accordance 
with the requirements in Sec. 361.42.
    (b) If an applicant has been determined to be ineligible, 
documentation supporting that determination in accordance with the 
requirements of Sec. 361.43.
    (c) Documentation supporting the determination that an individual 
has a severe disability or a most severe disability.
    (d) If an individual with a severe disability requires an extended 
evaluation in order to determine whether the individual is an eligible 
individual, documentation supporting the need for an extended 
evaluation, documentation supporting the periodic assessments conducted 
during the extended evaluation, and the written plan developed during 
the extended evaluation, in accordance with the requirements in 
Sec. 361.42(d).
    (e) The IWRP, and any amendments to the IWRP, containing the 
information required under Sec. 361.46.
    (f) In accordance with Sec. 361.45(a), documentation supporting the 
development of the long-term <strong>vocational</strong> goal, intermediate 
<strong>rehabilitation</strong> objectives, and nature and scope of services included in 
the individual's IWRP and, for individuals who are transitioning 
students, in the individual's IEP.
    (g) In the event that an individual's IWRP provides for services or 
a job placement in a non-integrated setting, a justification for that 
non-integrated setting.
    (h) Documentation of the reason for terminating services to an 
individual and, if an individual has achieved an employment outcome, 
the basis on which the requirements of Sec. 361.56 were determined to 
be met.
    (i) Documentation concerning any action and decision resulting from 
a request by an individual for review of a <strong>rehabilitation</strong> counselor or 
coordinator determination under Sec. 361.57.

(Authority: Sections 101(a)(6) and 101(a)(9) of the Act; 29 U.S.C. 
721(a)(6) and 721(a)(9))


Sec. 361.48  Scope of <strong>vocational</strong> <strong>rehabilitation</strong> services for 
individuals with disabilities.

    (a) The State plan must assure that, as appropriate to the 
<strong>vocational</strong> <strong>rehabilitation</strong> needs of each individual and consistent with 
each individual's informed choice, the following <strong>vocational</strong> 
<strong>rehabilitation</strong> services are available:
    (1) Assessment for determining eligibility and priority for 
services in accordance with Sec. 361.42.
    (2) Assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs in 
accordance with Sec. 361.45.
    (3) <strong>Vocational</strong> counseling and guidance.
    (4) Referral and other services necessary to help applicants and 
eligible individuals secure needed services from other agencies and to 
advise those individuals about client assistance programs established 
under 34 CFR part 370.
    (5) Physical and mental restoration services in accordance with the 
definition of that term in Sec. 361.5(b)(35).
    (6) <strong>Vocational</strong> and other training services, including personal and 
<strong>vocational</strong> adjustment training, books, tools, and other training 
materials, except that no training or training services in an 
institution of higher education (universities, colleges, community or 
junior colleges, <strong>vocational</strong> schools, technical institutes, or hospital 
schools of nursing) may be paid for with funds under this part unless 
maximum efforts have been made by the State unit to secure grant 
assistance in whole or in part from other sources to pay for that 
training.
    (7) Maintenance, in accordance with the definition of that term in 
Sec. 361.5(b)(31).
    (8) Transportation in connection with the rendering of any 
<strong>vocational</strong> <strong>rehabilitation</strong> service and in accordance with the definition 
of that term in Sec. 361.5(b)(50).
    (9) <strong>Vocational</strong> <strong>rehabilitation</strong> services to family members of an 
applicant or eligible individual if necessary to enable the applicant 
or eligible individual to achieve an employment outcome.
    (10) Interpreter services for individuals who are deaf and tactile 
interpreting services for individuals who are deaf-blind.
    (11) Reader services, <strong>rehabilitation</strong> teaching services, and 
orientation and mobility services for individuals who are blind.
    (12) Recruitment and training services to provide new employment 
opportunities in the fields of <strong>rehabilitation</strong>, health, welfare, public 
safety, law enforcement, and other appropriate public service 
employment.
    (13) Job search and placement assistance and job retention 
services.
    (14) Supported employment services in accordance with the 
definition of that term in Sec. 361.5(b)(46).
    (15) Personal assistance services in accordance with the definition 
of that term in Sec. 361.5(b)(34).
    (16) Post-employment services in accordance with the definition of 
that term in Sec. 361.5(b)(37).
    (17) Occupational licenses, tools, equipment, initial stocks, and 
supplies.
    (18) <strong>Rehabilitation</strong> technology in accordance with the definition of 
that term in Sec. 361.5(b)(39), including vehicular modification, 
telecommunications, sensory, and other technological aids and devices.
    (19) Transition services in accordance with the definition of that 
term in Sec. 361.5(b)(47).
    (20) Other goods and services determined necessary for the 
individual with a disability to achieve an employment outcome.
    (b) The State plan also must describe annually--
    (1) The manner in which a broad range of <strong>rehabilitation</strong> technology 
services will be provided at each stage of the <strong>rehabilitation</strong> process 
and on a statewide basis;
    (2) The training that will be provided to <strong>vocational</strong> <strong>rehabilitation</strong> 
counselors, client assistance personnel, and other related services 
personnel on the provision of <strong>rehabilitation</strong> technology services; and
    (3) The manner in which on-the-job and other related personal 
assistance services will be provided to assist individuals while they 
are receiving <strong>vocational</strong> <strong>rehabilitation</strong> services, including a 
description of strategies for developing statewide capacity to provide 
those services to an increasing number of individuals to improve their 
employment potential.


[[Page 64518]]

(Authority: Sections 101(a)(5)(C), 101(a)(26), and 103(a) of the 
Act; 29 U.S.C. 721(a)(5)(C), 721(a)(26), and 723(a))


Sec. 361.49  Scope of <strong>vocational</strong> <strong>rehabilitation</strong> services for groups of 
individuals with disabilities.

    (a) The State plan may also provide for the following <strong>vocational</strong> 
<strong>rehabilitation</strong> services for the benefit of groups of individuals with 
disabilities:
    (1) The establishment, development, or improvement of a public or 
other nonprofit community <strong>rehabilitation</strong> program that is used to 
provide services that promote integration and competitive employment, 
including under special circumstances, the construction of a facility 
for a public or nonprofit community <strong>rehabilitation</strong> program. Examples of 
``special circumstances'' include the destruction by natural disaster 
of the only available center serving an area or a State determination 
that construction is necessary in a rural area because no other public 
agencies or private nonprofit organizations are currently able to 
provide services to individuals.
    (2) Telecommunications systems that have the potential for 
substantially improving <strong>vocational</strong> <strong>rehabilitation</strong> service delivery 
methods and developing appropriate programming to meet the particular 
needs of individuals with disabilities, including telephone, 
television, satellite, tactile-vibratory devices, and similar systems, 
as appropriate.
    (3) Special services to provide recorded material for individuals 
who are blind, captioned television, films or video cassettes for 
individuals who are deaf, tactile materials for individuals who are 
deaf-blind, and other special services that provide information through 
tactile, vibratory, auditory, and visual media.
    (4) Technical assistance and support services, such as job site 
modification and other reasonable accommodations, to businesses that 
are not subject to Title I of the Americans with Disabilities Act of 
1990 and that are seeking to employ individuals with disabilities.
    (5) In the case of small business enterprises operated by 
individuals with the most severe disabilities under the supervision of 
the State unit, including enterprises established under the Randolph-
Sheppard program, management services and supervision, initial stocks 
and supplies, and initial operating expenses, in accordance with the 
following requirements:
    (i) ``Management services and supervision'' includes inspection, 
quality control, consultation, accounting, regulating, in-service 
training, and related services provided on a systematic basis to 
support and improve small business enterprises operated by individuals 
with the most severe disabilities. ``Management services and 
supervision'' may be provided throughout the operation of the small 
business enterprise.
    (ii) ``Initial stocks and supplies'' includes those items necessary 
to the establishment of a new business enterprise during the initial 
establishment period, which shall not exceed six months.
    (iii) Costs of establishing a small business enterprise may include 
operational costs during the initial establishment period, which shall 
not exceed six months.
    (iv) If the State plan provides for these services, it must contain 
an assurance that only individuals with the most severe disabilities 
will be selected to participate in this supervised program.
    (v) If the State plan provides for these services and the State 
unit chooses to set aside funds from the proceeds of the operation of 
the small business enterprises, the State plan also must assure that 
the State unit maintains a description of the methods used in setting 
aside funds and the purposes for which funds are set aside. Funds may 
be used only for small business enterprises purposes, and benefits that 
are provided to operators from set-aside funds must be provided on an 
equitable basis.
    (6) Other services that promise to contribute substantially to the 
<strong>rehabilitation</strong> of a group of individuals but that are not related 
directly to the IWRP of any one individual. Examples of those other 
services might include the purchase or lease of a bus to provide 
transportation to a group of applicants or eligible individuals or the 
purchase of equipment or instructional materials that would benefit a 
group of applicants or eligible individuals.
    (b) If the State plan provides for <strong>vocational</strong> <strong>rehabilitation</strong> 
services for groups of individuals, the State plan must assure that the 
designated State unit maintains information to ensure the proper and 
efficient administration of those services in the form and detail and 
at the time required by the Secretary, including the types of services 
provided, the costs of those services, and, to the extent feasible, 
estimates of the numbers of individuals benefitting from those 
services.

(Authority: Section 103(b) of the Act; 29 U.S.C. 711(c), 723(b), 
721(a)(6))


Sec. 361.50  Written policies governing the provision of services.

    The State plan must assure that the State unit develops and 
maintains written policies covering the nature and scope of each of the 
<strong>vocational</strong> <strong>rehabilitation</strong> services specified in Sec. 361.48 and 
Sec. 361.49 and the criteria under which each service is provided. The 
policies must ensure that the provision of services is based on the 
<strong>rehabilitation</strong> needs of each individual as identified in that 
individual's IWRP. The written policies may not establish any arbitrary 
limits on the nature and scope of <strong>vocational</strong> <strong>rehabilitation</strong> services to 
be provided to the individual to achieve an employment outcome. The 
policies must be developed in accordance with the following provisions:
    (a) Out-of-State services. (1) The State unit may establish a 
preference for in-State services, provided that the preference does not 
effectively deny an individual a necessary service. If the individual 
chooses an out-of-State service at a higher cost than an in-State 
service, if either service would meet the individual's <strong>rehabilitation</strong> 
needs, the designated State unit is not responsible for those costs in 
excess of the cost of the in-State service.
    (2) The State unit may not establish an absolute prohibition on the 
provision of out-of-State services.
    (b) Payment for services. (1) The State unit shall establish and 
maintain written policies to govern the rates of payment for all 
purchased <strong>vocational</strong> <strong>rehabilitation</strong> services.
    (2) The State unit may establish a reasonable fee schedule designed 
to ensure the lowest reasonable cost to the program for each service, 
provided that the schedule is--
    (i) Not so low as to effectively deny an individual a necessary 
service; and
    (ii) Not absolute and permits exceptions so that individual needs 
can be addressed.
    (3) The State unit may not place absolute dollar limits on specific 
service categories or on the total services provided to an individual.
    (c) Duration of services. (1) The State unit may establish 
reasonable time periods for the provision of services provided that the 
time periods are--
    (i) Not so short as to effectively deny an individual a necessary 
service; and
    (ii) Not absolute and permit exceptions so that individual needs 
can be addressed.
    (2) The State unit may not establish absolute time limits on the 
provision of specific services or on the provision of services to an 
individual. The duration of each service needed by an individual must 
be determined on an individual basis and reflected in that individual's 
IWRP. 

[[Page 64519]]

    (d) Authorization of services. The State unit shall establish 
policies related to the timely authorization of services, including 
conditions under which verbal authorization can be given.

(Authority: Sections 12(c), 12(e)(2)(A), and 101(a)(6) of the Act 
and 29 U.S.C. 711(c), 711(e)(2)(A), and 721(a)(6))


Sec. 361.51  Written standards for facilities and providers of 
services.

    The State plan must assure that the designated State unit 
establishes, maintains, makes available to the public, and implements 
written minimum standards for the various types of facilities and 
providers of services used by the State unit in providing <strong>vocational</strong> 
<strong>rehabilitation</strong> services, in accordance with the following requirements:
    (a) Accessibility of facilities. Any facility in which <strong>vocational</strong> 
<strong>rehabilitation</strong> services are provided must be accessible to individuals 
receiving services and must comply with the requirements of the 
Architectural Barriers Act of 1968, the Uniform Accessibility Standards 
and their implementing regulations in 41 CFR part 101, subpart 101-
19.6, the American National Standards Institute, No. A117.1-1986, the 
Americans with Disabilities Act of 1990, and section 504 of the Act.
    (b) Personnel standards. (1) Qualified personnel. Providers of 
<strong>vocational</strong> <strong>rehabilitation</strong> services shall use qualified personnel, in 
accordance with any applicable national or State-approved or recognized 
certification, licensing, registration or other comparable requirements 
(including State personnel requirements) that apply to the profession 
or discipline in which that category of personnel is providing 
<strong>vocational</strong> <strong>rehabilitation</strong> services.
    (2) Affirmative action. Providers of <strong>vocational</strong> <strong>rehabilitation</strong> 
services shall take affirmative action to employ and advance in 
employment qualified individuals with disabilities.
    (3) Special communication needs personnel. Providers of <strong>vocational</strong> 
<strong>rehabilitation</strong> services shall--
    (i) Include among their personnel, or obtain the services of, 
individuals able to communicate in the native languages of applicants 
and eligible individuals who have limited English speaking ability; and
    (ii) Ensure that appropriate modes of communication for all 
applicants and eligible individuals are used.
    (c) Fraud, waste, and abuse. Providers of <strong>vocational</strong> <strong>rehabilitation</strong> 
services shall have adequate and appropriate policies and procedures to 
prevent fraud, waste, and abuse.

(Authority: Sections 12(e)(2) (B), (D), and (E) and 101(a)(6)(B) of 
the Act; 29 U.S.C. 711(e) and 721(a)(6)(B))


Sec. 361.52  Opportunity to make informed choices regarding the 
selection of services and providers.

    The State plan must describe the manner in which the State unit 
will provide each applicant, including individuals who are receiving 
services during an extended evaluation, and each eligible individual 
the opportunity to make informed choices throughout the <strong>vocational</strong> 
<strong>rehabilitation</strong> process in accordance with the following requirements:
    (a) Each State unit, in consultation with its State <strong>Rehabilitation</strong> 
Advisory Council, if it has one, shall develop and implement policies 
and procedures that enable each individual to make an informed choice 
with regard to the selection of a long-term <strong>vocational</strong> goal, 
intermediate <strong>rehabilitation</strong> objectives, <strong>vocational</strong> <strong>rehabilitation</strong> 
services, including assessment services, and service providers.
    (b) In developing an individual's IWRP, the State unit shall 
provide the individual, or assist the individual in acquiring, 
information necessary to make an informed choice about the specific 
services, including the providers of those services, that are needed to 
achieve the individual's <strong>vocational</strong> goal. This information must 
include, at a minimum, information relating to the cost, accessibility, 
and duration of potential services, the level of consumer satisfaction 
with those services, the qualifications of potential service providers, 
the types of services offered by those providers, and the degree to 
which services are provided in integrated settings.
    (c) In providing, or assisting the individual in acquiring, the 
information required under paragraph (b) of this section, the State 
unit may use, but is not limited to, the following methods or sources 
of information:
    (1) State or regional lists of services and service providers.
    (2) Periodic consumer satisfaction surveys and reports.
    (3) Referrals to other consumers, local consumer groups, or 
disability advisory councils qualified to discuss the services or 
service providers.
    (4) Relevant accreditation, certification, or other information 
relating to the qualifications of service providers.

(Authority: Sections 12(e)(1) and 12(e)(2)(C) of the Act; 29 U.S.C. 
711(e))


Sec. 361.53  Availability of comparable services and benefits.

    (a) The State plan must assure that--
    (1) Prior to providing any <strong>vocational</strong> <strong>rehabilitation</strong> services to an 
eligible individual, or to members of the individual's family, except 
those services listed in paragraph (b) of this section, the State unit 
shall determine whether comparable services and benefits exist under 
any other program and whether those services and benefits are available 
to the individual;
    (2) If comparable services or benefits exist under any other 
program and are available to the eligible individual within a 
reasonable period of time so that the intermediate <strong>rehabilitation</strong> 
objectives of the individual's IWRP can be met, the State unit shall 
use those comparable services or benefits to meet, in whole or in part, 
the cost of <strong>vocational</strong> <strong>rehabilitation</strong> services; and
    (3) If comparable services or benefits exist under any other 
program, but are not available to the individual within a reasonable 
period of time, the State unit shall provide <strong>vocational</strong> <strong>rehabilitation</strong> 
services until those comparable services and benefits become available.
    (b) A prior determination of the availability of comparable 
services and benefits is not required in connection with the provision 
of any of the following services:
    (1) Assessment for determining eligibility and priority for 
services.
    (2) Assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs.
    (3) <strong>Vocational</strong> counseling, guidance, and referral services.
    (4) <strong>Vocational</strong> and other training services, such as personal and 
<strong>vocational</strong> adjustment training, books (including alternative format 
books accessible by computer and taped books), tools, and other 
training materials in accordance with Sec. 361.48(a)(6).
    (5) Placement services.
    (6) <strong>Rehabilitation</strong> technology.
    (7) Post-employment services consisting of the services listed 
under paragraphs (b) (1) through (6) of this section.
    (c) The requirements of paragraph (a) of this section also do not 
apply if--
    (1) The determination of the availability of comparable services 
and benefits under any other program would delay the provision of 
<strong>vocational</strong> <strong>rehabilitation</strong> services to any individual who is determined 
to be at extreme medical risk, based on medical evidence provided by an 
appropriate qualified medical professional; or
    (2) An immediate job placement would be lost due to a delay in the 

[[Page 64520]]
    provision of comparable services and benefits.

(Authority: Section 101(a)(8) of the Act; 29 U.S.C. 721(a)(8))


Sec. 361.54  Participation of individuals in cost of services based on 
financial need.

    (a) No Federal requirement. There is no Federal requirement that 
the financial need of individuals be considered in the provision of 
<strong>vocational</strong> <strong>rehabilitation</strong> services.
    (b) State unit requirements. (1) The State unit may choose to 
consider the financial need of eligible individuals or individuals who 
are receiving services during an extended evaluation for purposes of 
determining the extent of their participation in the costs of 
<strong>vocational</strong> <strong>rehabilitation</strong> services, other than those services 
identified in paragraph (b)(3) of this section.
    (2) If the State unit chooses to consider financial need--
    (i) It shall maintain written policies covering the determination 
of financial need;
    (ii) The State plan must specify the types of <strong>vocational</strong> 
<strong>rehabilitation</strong> services for which the unit has established a financial 
needs test;
    (iii) The policies must be applied uniformly to all individuals in 
similar circumstances;
    (iv) The policies may require different levels of need for 
different geographic regions in the State, but must be applied 
uniformly to all individuals within each geographic region; and
    (v) The policies must ensure that the level of an individual's 
participation in the cost of <strong>vocational</strong> <strong>rehabilitation</strong> services is--
    (A) Reasonable;
    (B) Based on the individual's financial need; and
    (C) Not so high as to effectively deny the individual a necessary 
service.
    (3) The State plan must assure that no financial needs test is 
applied and no financial participation is required as a condition for 
furnishing the following <strong>vocational</strong> <strong>rehabilitation</strong> services:
    (i) Assessment for determining eligibility and priority for 
services, except those non-assessment services that are provided during 
an extended evaluation for an individual with a severe disability under 
Sec. 361.42(d).
    (ii) Assessment for determining <strong>vocational</strong> <strong>rehabilitation</strong> needs.
    (iii) <strong>Vocational</strong> counseling, guidance, and referral services.
    (iv) Placement services.

(Authority: Section 12(c) of the Act; 29 U.S.C. 711(c))


Sec. 361.55  Review of extended employment in community <strong>rehabilitation</strong> 
programs or other employment under section 14(c) of the Fair Labor 
Standards Act.

    The State plan must assure that the State unit--
    (a) Reviews and re-evaluates at least annually the status of each 
individual determined by the State unit to have achieved an employment 
outcome in an extended employment setting in a community <strong>rehabilitation</strong> 
program or other employment setting in which the individual is 
compensated in accordance with section 14(c) of the Fair Labor 
Standards Act. This review or re-evaluation must include input from the 
individual or, in an appropriate case, the individual's representative 
to determine the interests, priorities, and needs of the individual for 
employment in, or training for, competitive employment in an integrated 
setting in the labor market;
    (b) Makes maximum effort, including the identification of 
<strong>vocational</strong> <strong>rehabilitation</strong> services, reasonable accommodations, and 
other support services, to enable the eligible individual to benefit 
from training in, or to be placed in employment in, an integrated 
setting; and
    (c) Provides services designed to promote movement from extended 
employment to integrated employment, including supported employment, 
independent living, and community participation.

(Authority: Section 101(a)(16) of the Act; 29 U.S.C. 721(a)(16))


Sec. 361.56  Individuals determined to have achieved an employment 
outcome.

    The State plan must assure that an individual is determined to have 
achieved an employment outcome only if the following requirements are 
met:
    (a) The provision of services under the individual's IWRP has 
contributed to the achievement of the employment outcome.
    (b) The employment outcome is consistent with the individual's 
abilities, capabilities, interests, and informed choice.
    (c) The employment outcome is in the most integrated setting 
possible, consistent with the individual's informed choice.
    (d) The individual has maintained the employment outcome for the 
duration of the probationary period established by the employer for its 
employees or, if the employer does not have an established probationary 
period, for a period of at least 90 days.
    (e) The individual and the <strong>rehabilitation</strong> counselor or coordinator 
consider the employment outcome to be satisfactory and agree that the 
individual is performing well on the job.

(Authority: Sections 12(c), 101(a)(6), and 106(a)(2) of the Act; 29 
U.S.C. 711(c), 721(a)(6), and 726(a)(2))


Sec. 361.57  Review of <strong>rehabilitation</strong> counselor or coordinator 
determinations.

    The State plan must contain procedures established by the director 
of the designated State unit to ensure that any applicant or eligible 
individual who is dissatisfied with any determinations made by a 
<strong>rehabilitation</strong> counselor or coordinator concerning the furnishing or 
denial of services may request timely review of those determinations. 
The procedures established by the director of the State unit must be in 
accordance with the following provisions:
    (a) Informal resolution. The State unit may establish an informal 
process to resolve a request for review without conducting a formal 
hearing. However, a State's informal process must be conducted and 
concluded within the time period established under paragraph (c)(1) of 
this section for holding a formal hearing. If informal resolution is 
not successful, a formal hearing must be conducted by the end of this 
same period, unless the parties jointly agree to a delay.
    (b) Formal hearing procedures. Except as provided in paragraph (e) 
of this section, the State unit shall establish formal review 
procedures that provide that--
    (1) A hearing by an impartial hearing officer, selected in 
accordance with paragraph (d) of this section, must be held within the 
time period established under paragraph (c)(1) of this section, unless 
informal resolution was achieved prior to the expiration of the time 
period or the parties jointly agreed to a delay;
    (2) The State unit may not institute a suspension, reduction, or 
termination of services being provided under an IWRP pending a final 
determination of the formal hearing under this paragraph or informal 
resolution under paragraph (a) of this section, unless the individual 
or, in an appropriate case, the individual's representative so requests 
or the agency has evidence that the services have been obtained through 
misrepresentation, fraud, collusion, or criminal conduct on the part of 
the individual;
    (3) The individual or, if appropriate, the individual's 
representative shall be afforded an opportunity to present additional 
evidence, information, and witnesses to the impartial hearing officer, 
to be represented by counsel or other appropriate advocate, and to 
examine all witnesses and other 

[[Page 64521]]
relevant sources of information and evidence;
    (4) The impartial hearing officer shall make a decision based on 
the provisions of the approved State plan, the Act, and Federal and 
State <strong>vocational</strong> <strong>rehabilitation</strong> regulations and policies and shall 
provide to the individual or, if appropriate, the individual's 
representative and to the director of the designated State unit a full 
written report of the findings and grounds for the decision within the 
time period established under paragraph (c)(2) of this section;
    (5) If the director of the designated State unit decides to review 
the decision of the impartial hearing officer, the director shall 
notify in writing the individual or, if appropriate, the individual's 
representative of that intent within 20 days of the mailing of the 
impartial hearing officer's decision;
    (6) If the director of the designated State unit fails to provide 
the notice required by paragraph (b)(5) of this section, the impartial 
hearing officer's decision becomes a final decision;
    (7) The decision of the director of the designated State unit to 
review any impartial hearing officer's decision must be based on 
standards of review contained in written State unit policy;
    (8) If the director of the designated State unit decides to review 
the decision of the impartial hearing officer, the director shall 
provide the individual or, if appropriate, the individual's 
representative an opportunity to submit additional evidence and 
information relevant to the final decision;
    (9) The director may not overturn or modify a decision, or part of 
a decision, of an impartial hearing officer that supports the position 
of the individual unless the director concludes, based on clear and 
convincing evidence, that the decision of the impartial hearing officer 
is clearly erroneous because it is contrary to the approved State plan, 
the Act, or Federal or State <strong>vocational</strong> <strong>rehabilitation</strong> regulations or 
policy;
    (10) The director of the designated State unit shall make a final 
decision and provide a full report in writing of the decision, and of 
the findings and grounds for the decision, to the individual or, if 
appropriate, the individual's representative within the time period 
established under paragraph (c)(3) of this section;
    (11) The director of the designated State unit may not delegate 
responsibility to make any final decision to any other officer or 
employee of the designated State unit; and
    (12) Except for the time limitations established in paragraphs 
(b)(5) and (c)(1) of this section, each State's review procedures may 
provide for reasonable time extensions for good cause shown at the 
request of a party or at the request of both parties.
    (c) Timelines. Each State unit, in consultation with its State 
<strong>Rehabilitation</strong> Advisory Council, if it has one, shall develop and 
implement reasonable timelines for the prompt handling of appeals, 
including, at a minimum, timelines for--
    (1) Holding a formal hearing after an individual's request for 
review;
    (2) Rendering the decision of the impartial hearing officer after 
completion of the formal hearing; and
    (3) Rendering the final decision of the director of the designated 
State unit after providing notice of intent to review the decision of 
the impartial hearing officer in accordance with paragraph (b)(5) of 
this section.
    (d) Selection of impartial hearing officers. Except as provided in 
paragraph (e) of this section, the impartial hearing officer for a 
particular case must be selected--
    (1) From among the pool of persons qualified to be an impartial 
hearing officer, as defined in Sec. 361.5(b)(22), who are identified by 
the State unit, if the State unit is an independent commission, or 
jointly by the designated State unit and the State <strong>Rehabilitation</strong> 
Advisory Council, if the State has a Council; and
    (2)(i) On a random basis; or
    (ii) By agreement between the director of the designated State unit 
and the individual or, if appropriate, the individual's representative.
    (e) State fair hearing board. The provisions of paragraphs (b), 
(c), and (d) of this section are not applicable if the State has a fair 
hearing board that was established before January 1, 1985, that is 
authorized under State law to review <strong>rehabilitation</strong> counselor or 
coordinator determinations and to carry out the responsibilities of the 
director of the designated State unit under this section.
    (f) Informing affected individuals. The State unit shall inform, 
through appropriate modes of communication, all applicants and eligible 
individuals of--
    (1) Their right to review under this section, including the names 
and addresses of individuals with whom appeals may be filed; and
    (2) The manner in which an impartial hearing officer will be 
selected consistent with the requirements of paragraph (d) of this 
section.
    (g) Data collection. The director of the designated State unit 
shall collect and submit, at a minimum, the following data to the 
Secretary for inclusion each year in the annual report to Congress 
under section 13 of the Act:
    (1) The number of appeals to impartial hearing officers and the 
State director, including the type of complaints and the issues 
involved.
    (2) The number of decisions by the State director reversing in 
whole or in part a decision of the impartial hearing officer.
    (3) The number of decisions affirming the position of the 
dissatisfied individual assisted through the client assistance program, 
when that assistance is known to the State unit.

(Authority: Sections 102(b) and 102(d) of the Act; 29 U.S.C. 722(b) 
and 722(d))

Subpart C--Financing of State <strong>Vocational</strong> <strong>Rehabilitation</strong> Programs


Sec. 361.60  Matching requirements.

    (a) Federal share. (1) General. Except as provided in paragraphs 
(a)(2) and (a)(3) of this section, the Federal share for expenditures 
made by the State unit under the State plan, including expenditures for 
the provision of <strong>vocational</strong> <strong>rehabilitation</strong> services, administration of 
the State plan, and the development and implementation of the strategic 
plan, is 78.7 percent.
    (2) Construction projects. The Federal share for expenditures made 
for the construction of a facility for community <strong>rehabilitation</strong> program 
purposes may not be more than 50 percent of the total cost of the 
project.
    (3) Innovation and expansion grant activities. The Federal share 
for the cost of innovation and expansion grant activities funded by 
appropriations under Part C of Title I of the Act is 90 percent.
    (b) Non-Federal share.  (1) General. Except as provided in 
paragraphs (b)(2) and (b)(3) of this section, expenditures made under 
the State plan to meet the non-Federal share under this section must be 
consistent with the provisions of 34 CFR 80.24.
    (2) Third party in-kind contributions. Third party in-kind 
contributions specified in 34 CFR 80.24(a)(2) may not be used to meet 
the non-Federal share under this section.
    (3) Contributions by private entities. Expenditures made from 
contributions by private organizations, agencies, or individuals that 
are deposited in the account of the State agency or sole local agency 
in accordance with State law and that are earmarked, under a condition 
imposed by the contributor, may be used as part of the non-Federal 
share under this section if the following requirements are met:
    (i) The funds are earmarked for meeting in whole or in part the 
State's 

[[Page 64522]]
share for establishing a community <strong>rehabilitation</strong> program or 
constructing a particular facility for community <strong>rehabilitation</strong> program 
purposes.
    (ii) If the funds are earmarked for any other purpose under the 
State plan, the expenditures do not benefit in any way the donor, an 
individual to whom the donor is related by blood or marriage or with 
whom the donor has a close personal relationship, or an individual, 
entity, or organization with whom the donor shares a financial 
interest. The Secretary does not consider a donor's receipt from the 
State unit of a grant, subgrant, or contract with funds allotted under 
this part to be a benefit for the purposes of this paragraph if the 
grant, subgrant, or contract is awarded under the State's regular 
competitive procedures.

(Authority: Sections 7(7), 101(a)(3), and 104 of the Act; 29 U.S.C. 
706(7), 721(a)(3) and 724)

    Note: The Secretary notes that contributions may be earmarked in 
accordance with paragraph (b)(3)(ii) of this section for providing 
particular services (e.g., <strong>rehabilitation</strong> technology services); 
serving individuals with certain types of disabilities (e.g., 
individuals who are blind), consistent with the State's order of 
selection, if applicable; providing services to special groups that 
State or Federal law permits to be targeted for services (e.g., 
transitioning students), consistent with the State's order of 
selection, if applicable; or carrying out particular types of 
administrative activities permissible under State law. Contributions 
also may be restricted to particular geographic areas to increase 
services or expand the scope of services that are available 
statewide under the State plan. However, if a contribution is 
earmarked for a restricted geographic area, expenditures from that 
contribution may be used to meet the non-Federal share requirement 
only if the State unit requests and the Secretary approves a waiver 
of statewideness, in accordance with Sec. 361.26.


Sec. 361.61  Limitation on use of funds for construction expenditures.

    No more than 10 percent of a State's allotment for any fiscal year 
under section 110 of the Act may be spent on the construction of 
facilities for community <strong>rehabilitation</strong> program purposes.

(Authority: Section 101(a)(17)(A) of the Act; 29 U.S.C. 
721(a)(17)(A))


Sec. 361.62  Maintenance of effort requirements.

    (a) General requirements. (1) The Secretary reduces the amount 
otherwise payable to a State for a fiscal year by the amount by which 
the total expenditures from non-Federal sources under the State plan 
for the previous fiscal year were less than the total of those 
expenditures for the fiscal year two years prior to the previous fiscal 
year. For example, for fiscal year 1996, a State's maintenance of 
effort level is based on the amount of its expenditures from non-
Federal sources for fiscal year 1994. Thus, if the State's non-Federal 
expenditures in 1996 are less than they were in 1994, the State has a 
maintenance of effort deficit, and the Secretary reduces the State's 
allotment in 1997 by the amount of that deficit.
    (2) If, at the time the Secretary makes a determination that a 
State has failed to meet its maintenance of effort requirements, it is 
too late for the Secretary to make a reduction in accordance with 
paragraph (a)(1) of this section, then the Secretary recovers the 
amount of the maintenance of effort deficit through audit disallowance.
    (b) Specific requirements for construction of facilities. If the 
State plan provides for the construction of a facility for community 
<strong>rehabilitation</strong> program purposes, the amount of the State's share of 
expenditures for <strong>vocational</strong> <strong>rehabilitation</strong> services under the plan, 
other than for the construction of a facility for community 
<strong>rehabilitation</strong> program purposes or the establishment of a facility for 
community <strong>rehabilitation</strong> purposes, must be at least equal to the 
expenditures for those services for the second prior fiscal year. If a 
State fails to meet the requirements of this paragraph, the Secretary 
recovers the amount of the maintenance of effort deficit through audit 
disallowance.
    (c) Separate State agency for <strong>vocational</strong> <strong>rehabilitation</strong> services 
for individuals who are blind. If there is a separate part of the State 
plan administered by a separate State agency to provide <strong>vocational</strong> 
<strong>rehabilitation</strong> services for individuals who are blind--
    (1) Satisfaction of the maintenance of effort requirements under 
paragraphs (a) and (b) of this section are determined based on the 
total amount of a State's non-Federal expenditures under both parts of 
the State plan; and
    (2) If a State fails to meet any maintenance of effort requirement, 
the Secretary reduces the amount otherwise payable to the State for 
that fiscal year under each part of the plan in direct relation to the 
amount by which expenditures from non-Federal sources under each part 
of the plan in the previous fiscal year were less than they were for 
that part of the plan for the fiscal year two years prior to the 
previous fiscal year.
    (d) Waiver or modification. (1) The Secretary may waive or modify 
the maintenance of effort requirement in paragraph (a)(1) of this 
section if the Secretary determines that a waiver or modification is 
necessary to permit the State to respond to exceptional or 
uncontrollable circumstances, such as a major natural disaster or a 
serious economic downturn, that--
    (i) Cause significant unanticipated expenditures or reductions in 
revenue; and
    (ii) Result in--
    (A) A general reduction of programs within the State; or
    (B) The State making substantial expenditures in the <strong>vocational</strong> 
<strong>rehabilitation</strong> program for long-term purposes due to the one-time costs 
associated with the construction of a facility for community 
<strong>rehabilitation</strong> program purposes, the establishment of a facility for 
community <strong>rehabilitation</strong> program purposes, or the acquisition of 
equipment.
    (2) The Secretary may waive or modify the maintenance of effort 
requirement in paragraph (b) of this section or the 10 percent 
allotment limitation in Sec. 361.61 if the Secretary determines that a 
waiver or modification is necessary to permit the State to respond to 
exceptional or uncontrollable circumstances, such as a major natural 
disaster, that result in significant destruction of existing facilities 
and require the State to make substantial expenditures for the 
construction of a facility for community <strong>rehabilitation</strong> program 
purposes or the establishment of a facility for community 
<strong>rehabilitation</strong> program purposes in order to provide <strong>vocational</strong> 
<strong>rehabilitation</strong> services.
    (3) A written request for waiver or modification, including 
supporting justification, must be submitted to the Secretary as soon as 
the State determines that an exceptional or uncontrollable circumstance 
will prevent it from making its required expenditures from non-Federal 
sources.

(Authority: Sections 101(a)(17) and 111(a)(2) of the Act; 29 U.S.C. 
721(a)(17) and 731(a)(2))


Sec. 361.63  Program income.

    (a) Definition. Program income means gross income received by the 
State that is directly generated by an activity supported under this 
part.
    (b) Sources. Sources of program income include, but are not limited 
to, payments from the Social Security Administration for rehabilitating 
Social Security beneficiaries, payments received from workers' 
compensation funds, fees for services to defray part or all of the 
costs of services provided to particular individuals, and income 
generated by a State-operated community <strong>rehabilitation</strong> program. 

[[Page 64523]]

    (c) Use of program income. (1) Except as provided in paragraph 
(c)(2) of this section, program income, whenever earned, must be used 
for the provision of <strong>vocational</strong> <strong>rehabilitation</strong> services, the 
administration of the State plan, and developing and implementing the 
strategic plan. Program income is considered earned when it is 
received.
    (2) Payments provided to a State from the Social Security 
Administration for rehabilitating Social Security beneficiaries may 
also be used to carry out programs under Part B of Title I of the Act 
(client assistance), Part C of Title I of the Act (innovation and 
expansion), Part C of Title VI of the Act (supported employment) and 
Title VII of the Act (independent living).
    (3) The State is authorized to treat program income as--
    (i) An addition to the grant funds to be used for additional 
allowable program expenditures, in accordance with 34 CFR 80.25(g)(2); 
or
    (ii) A deduction from total allowable costs, in accordance with 34 
CFR 80.25(g)(1).
    (4) Program income may not be used to meet the non-Federal share 
requirement under Sec. 361.60.

(Authority: Section 108 of the Act; 29 U.S.C. 728; 34 CFR 80.25)


Sec. 361.64  Obligation of Federal funds and program income.

    (a) Except as provided in paragraph (b) of this section, any 
Federal funds, including reallotted funds, that are appropriated for a 
fiscal year to carry out a program under this part that are not 
obligated by the State unit by the beginning of the succeeding fiscal 
year and any program income received during a fiscal year that is not 
obligated by the State unit by the beginning of the succeeding fiscal 
year must remain available for obligation by the State unit during that 
succeeding fiscal year.
    (b) Federal funds appropriated for a fiscal year remain available 
for obligation in the succeeding fiscal year only to the extent that 
the State unit met the matching requirement for those Federal funds by 
obligating, in accordance with 34 CFR 76.707, the non-Federal share in 
the fiscal year for which the funds were appropriated.

(Authority: Section 19 of the Act; 29 U.S.C. 718)


Sec. 361.65  Allotment and payment of Federal funds for <strong>vocational</strong> 
<strong>rehabilitation</strong> services.

    (a) Allotment. (1) The allotment of Federal funds for <strong>vocational</strong> 
<strong>rehabilitation</strong> services for each State is computed in accordance with 
the requirements of section 110 of the Act, and payments are made to 
the State on a quarterly basis, unless some other period is established 
by the Secretary.
    (2) If the State plan designates one State agency to administer, or 
supervise the administration of, the part of the plan under which 
<strong>vocational</strong> <strong>rehabilitation</strong> services are provided for individuals who are 
blind and another State agency to administer the rest of the plan, the 
division of the State's allotment is a matter for State determination.
    (b) Reallotment. (1) The Secretary determines not later than 45 
days before the end of a fiscal year which States, if any, will not use 
their full allotment.
    (2) As soon as possible, but not later than the end of the fiscal 
year, the Secretary reallots these funds to other States that can use 
those additional funds during the current or subsequent fiscal year, 
provided the State can meet the matching requirement by obligating the 
non-Federal share of any reallotted funds in the fiscal year for which 
the funds were appropriated.
    (3) Funds reallotted to another State are considered to be an 
increase in the recipient State's allotment for the fiscal year for 
which the funds were appropriated.

(Authority: Sections 110 and 111 of the Act; 29 U.S.C. 730 and 731)

Subpart D--Strategic Plan for Innovation and Expansion of 
<strong>Vocational</strong> <strong>Rehabilitation</strong> Services


Sec. 361.70  Purpose of the strategic plan.

    The State shall prepare a statewide strategic plan, in accordance 
with Sec. 361.71, to develop and use innovative approaches for 
achieving long-term success in expanding and improving <strong>vocational</strong> 
<strong>rehabilitation</strong> services, including supported employment services, 
provided under the State plan, including the supported employment 
supplement to the State plan required under 34 CFR part 363.

(Authority: Section 120 of the Act; 29 U.S.C. 740)


Sec. 361.71  Procedures for developing the strategic plan.

    (a) Public input. (1) The State unit shall meet with and receive 
recommendations from members of the State <strong>Rehabilitation</strong> Advisory 
Council, if the State has a Council, and the Statewide Independent 
Living Council prior to developing the strategic plan.
    (2) The State unit shall solicit public input on the strategic plan 
prior to or at the public meetings on the State plan, in accordance 
with the requirements of Sec. 361.20.
    (3) The State unit shall consider the recommendations received 
under paragraphs (a)(1) and (a)(2) of this section and, if the State 
rejects any recommendations, shall include a written explanation of the 
reasons for those rejections in the strategic plan.
    (4) The State unit shall develop a procedure to ensure ongoing 
comment from the Council or Councils, if applicable, as the plan is 
being implemented.
    (b) Duration. The strategic plan must cover a three-year period.
    (c) Revisions. The State unit shall revise the strategic plan on an 
annual basis to reflect the unit's actual experience over the previous 
year and input from the State <strong>Rehabilitation</strong> Advisory Council, if the 
State has a Council, individuals with disabilities, and other 
interested parties.
    (d) Dissemination. The State unit shall disseminate widely the 
strategic plan to individuals with disabilities, disability 
organizations, <strong>rehabilitation</strong> professionals, and other interested 
persons and shall make the strategic plan available in accessible 
formats and appropriate modes of communication.

(Authority: Section 122 of the Act; 29 U.S.C. 742)


Sec. 361.72  Content of the strategic plan.

    The strategic plan must include--
    (a) A statement of the mission, philosophy, values, and principles 
of the <strong>vocational</strong> <strong>rehabilitation</strong> program in the State;
    (b) Specific goals and objectives for expanding and improving the 
system for providing <strong>vocational</strong> <strong>rehabilitation</strong> services;
    (c) Specific multi-faceted and systemic approaches for 
accomplishing the objectives, including interagency coordination and 
cooperation, that build upon state-of-the-art practices and research 
findings and that implement the State plan and the supplement to the 
State plan submitted under 34 CFR part 363;
    (d) A description of the specific programs, projects, and 
activities funded under this subpart, including how the programs, 
projects, and activities accomplish the objectives of the subpart, and 
the resource allocation and budget for the programs, projects, and 
activities; and
    (e) Specific criteria for determining whether the objectives have 
been achieved, including an assurance that the State will conduct an 
annual evaluation to determine the extent to which the objectives have 
been achieved and, if specific objectives have not been achieved, the 
reasons that the objectives have not been achieved and a description of 
alternative approaches that will be taken.


[[Page 64524]]

(Authority: Section 121 of the Act; 29 U.S.C. 741)


Sec. 361.73  Use of funds.

    (a) A State unit shall use all grant funds received under Title I, 
Part C of the Act to carry out programs and activities that are 
identified under the State's strategic plan, including but not limited 
to those programs and activities that are identified in paragraph (b) 
of this section.
    (b) A State unit shall use at least 1.5 percent of the funds 
received under section 111 of the Act to carry out one or more of the 
following types of programs and activities that are identified in the 
State's strategic plan:
    (1) Programs to initiate or expand employment opportunities for 
individuals with severe disabilities in integrated settings that allow 
for the use of on-the-job training to promote the objectives of Title I 
of the Americans with Disabilities Act of 1990.
    (2) Programs or activities to improve or expand the provision of 
employment services in integrated settings to individuals with sensory, 
cognitive, physical, and mental impairments who traditionally have not 
been served by the State <strong>vocational</strong> <strong>rehabilitation</strong> agency.
    (3) Programs or activities to maximize the ability of individuals 
with disabilities to use <strong>rehabilitation</strong> technology in employment 
settings.
    (4) Programs or activities that assist employers in accommodating, 
evaluating, training, or placing individuals with disabilities in the 
workplace of the employer consistent with the provisions of the Act and 
Title I of the Americans with Disabilities Act of 1990. These programs 
or activities may include short-term technical assistance or other 
effective strategies.
    (5) Programs or activities that expand and improve the extent and 
type of an individual's involvement in the review and selection of his 
or her training and employment goals.
    (6) Programs or activities that expand and improve opportunities 
for career advancement for individuals with severe disabilities.
    (7) Programs, projects, or activities designed to initiate, expand, 
or improve working relationships between <strong>vocational</strong> <strong>rehabilitation</strong> 
services provided under Title I of the Act and independent living 
services provided under Title VII of the Act.
    (8) Programs, projects, or activities designed to improve 
functioning of the system for delivering <strong>vocational</strong> <strong>rehabilitation</strong> 
services and to improve coordination and working relationships with 
other State agencies and local public agencies, business, industry, 
labor, community <strong>rehabilitation</strong> programs, and centers for independent 
living, including projects designed to--
    (i) Increase the ease of access to, timeliness of, and quality of 
<strong>vocational</strong> <strong>rehabilitation</strong> services through the development and 
implementation of policies, procedures, systems, and interagency 
mechanisms for providing <strong>vocational</strong> <strong>rehabilitation</strong> services;
    (ii) Improve the working relationships between State <strong>vocational</strong> 
<strong>rehabilitation</strong> agencies and other State agencies, centers for 
independent living, community <strong>rehabilitation</strong> programs, educational 
agencies involved in higher education, adult basic education, and 
continuing education, and businesses, industry, and labor 
organizations, in order to create and facilitate cooperation in--
    (A) Planning and implementing services; and
    (B) Developing an integrated system of community-based <strong>vocational</strong> 
<strong>rehabilitation</strong> services that includes appropriate transitions between 
service systems; and
    (iii) Improve the ability of professionals, advocates, business, 
industry, labor, and individuals with disabilities to work in 
cooperative partnerships to improve the quality of <strong>vocational</strong> 
<strong>rehabilitation</strong> services and job and career opportunities for 
individuals with disabilities.
    (9) Projects or activities that ensure that the annual evaluation 
of the effectiveness of the program in meeting the goals and objectives 
in the State plan, including the system for evaluating the performance 
of <strong>rehabilitation</strong> counselors, coordinators, and other personnel used in 
the State, facilitates and does not impede the accomplishment of the 
purpose of this part, including serving individuals with the most 
severe disabilities.
    (10) Projects or activities to support the initiation, expansion, 
and improvement of a comprehensive system of personnel development.
    (11) Programs, projects, or activities to support the provision of 
training and technical assistance to individuals with disabilities, 
business, industry, labor, community <strong>rehabilitation</strong> programs, and 
others regarding the implementation of the <strong>Rehabilitation</strong> Act 
Amendments of 1992, of Title V of the Act, and of the Americans with 
Disabilities Act of 1990.
    (12) Projects or activities to support the funding of the State 
<strong>Rehabilitation</strong> Advisory Council and the Statewide Independent Living 
Council.

(Authority: Sections 101(a)(34)(B) and 123 of the Act; 29 U.S.C. 
721(a)(34)(B) and 743)


Sec. 361.74  Allotment of Federal funds.

    (a) The allotment and any reallotment of Federal funds under Title 
I, Part C of the Act are computed in accordance with the requirements 
of section 124 of the Act.
    (b) If at any time the Secretary determines that any amount will 
not be expended by a State in carrying out the purpose of this subpart, 
the Secretary makes that amount available to one or more other States 
that the Secretary determines will be able to use additional amounts 
during the fiscal year. Any amount made available to any State under 
this paragraph of this section is regarded as an increase in the 
State's allotment for that fiscal year.

(Authority: Section 124 of the Act; 29 U.S.C. 744)

[FR Doc. 95-30344 Filed 12-14-95; 8:45 am]
BILLING CODE 4000-01-P

</pre>
</body>
</html>

