VERSION 2.00
Begin Form TaskList 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   4905
   ClientLeft      =   1170
   ClientTop       =   1470
   ClientWidth     =   5640
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   5400
   Icon            =   TASKLIST.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1065
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4905
   ScaleWidth      =   5640
   Top             =   1080
   Width           =   5850
   Begin PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   525
      Left            =   4515
      ScaleHeight     =   495
      ScaleWidth      =   480
      TabIndex        =   14
      Top             =   60
      Visible         =   0   'False
      Width           =   510
   End
   Begin OptionButton UseModules 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Walk Module List"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   5.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   4140
      TabIndex        =   13
      Top             =   3585
      Width           =   1395
   End
   Begin OptionButton UseTasks 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Walk Task List"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   5.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   2865
      TabIndex        =   12
      Top             =   3585
      Width           =   1245
   End
   Begin OptionButton UseWins 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Scan Windows"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   5.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   1575
      TabIndex        =   11
      Top             =   3585
      Value           =   -1  'True
      Width           =   1245
   End
   Begin CommandButton RefreshList 
      Caption         =   "Re&fresh"
      Default         =   -1  'True
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   120
      TabIndex        =   10
      Top             =   3525
      Width           =   1300
   End
   Begin CommandButton NukeTask 
      Caption         =   "&Nuke Task"
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   4245
      TabIndex        =   9
      Top             =   3975
      Width           =   1300
   End
   Begin CommandButton CloseTask 
      Caption         =   "&Close Task"
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   2865
      TabIndex        =   8
      Top             =   3975
      Width           =   1300
   End
   Begin CommandButton SwitchTo 
      Caption         =   "&Switch To"
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   1500
      TabIndex        =   7
      Top             =   3975
      Width           =   1300
   End
   Begin CommandButton ClassInfo 
      Caption         =   "Class &Info"
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   120
      TabIndex        =   6
      Top             =   3975
      Width           =   1300
   End
   Begin CommandButton ArrangeIcons 
      Caption         =   "Arrang&e icons"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   4245
      TabIndex        =   5
      Top             =   4425
      Width           =   1300
   End
   Begin CommandButton TileWindows 
      Caption         =   "&Tile"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   2865
      TabIndex        =   3
      Top             =   4425
      Width           =   1300
   End
   Begin CommandButton CascadeWindows 
      Caption         =   "C&ascade"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   1500
      TabIndex        =   2
      Top             =   4425
      Width           =   1300
   End
   Begin CommandButton RunProgram 
      Caption         =   "&Run ..."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   120
      TabIndex        =   1
      Top             =   4425
      Width           =   1300
   End
   Begin MListBox List1 
      AddItemHeight   =   0
      Alignment       =   1  'Left
      AllowFocusRect  =   0   'False
      AutoCheck       =   -1  'True
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   2  'Inset
      CheckColor      =   &H00000000&
      CheckStyle      =   0  'Cross Style
      DefPicture      =   TASKLIST.FRX:0302
      DrawRegions     =   2
      EnableVirtualMsgs=   0   'False
      ExtendedSelect  =   0   'False
      FallColor       =   &H00808080&
      FindDirection   =   0  'Forward
      FindResult      =   0  'Update ListIndex
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      GridColor       =   &H00808080&
      GridStyle       =   0  'Solid
      Height          =   3105
      HiliteBackColor =   &H00FF0000&
      HiliteForeColor =   &H00FFFFFF&
      HorizontalGrids =   -1  'True
      ImageRegion     =   1
      ImageType       =   1  'Bitmap
      ItemHeight      =   610
      ItemWidth       =   1560
      Left            =   120
      ListBoxStyle    =   0  'Fixed
      MaskingColor    =   &H00C0C0C0&
      MultiColumn     =   0   'False
      MultiSelect     =   0   'False
      NoIntegralHeight=   0   'False
      OwnerCompare    =   0   'False
      OwnerDraw       =   0   'False
      RiseColor       =   &H00FFFFFF&
      SearchCompare   =   1  'Case Insensitive
      SelectMode      =   0  'Normal
      SortColumn      =   0
      Sorted          =   0   'False
      SortOrder       =   0  'Ascending
      StringCompare   =   0  'Case Sensitive
      TabIndex        =   0
      Top             =   330
      Version         =   "04.56"
      VerticalGrids   =   0   'False
      VirtualMsgZone  =   0
      Width           =   5415
   End
   Begin MsgBlaster Msg1 
      Prop8           =   "Click on ""..."" for the About Box ---->"
      Prop9           =   "Click on ""..."" for the Message Center --->"
      Left            =   5115
      MsgList         =   TASKLIST.FRX:059C
      MsgPassage      =   TASKLIST.FRX:0600
      TargetName      =   "TaskList"
      Top             =   45
      UserMsgs        =   TASKLIST.FRX:0632
      Version         =   "2.0"
   End
   Begin Label CaptionLabel 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      BackStyle       =   0  'Transparent
      Caption         =   "Task List (traditional) - Copyright 1994 michiel de bruijn     v1.01"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   5.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   135
      Left            =   255
      TabIndex        =   4
      Top             =   15
      Width           =   3855
   End
End

'====================================================================================
'TaskList.Frm - Copyright 1994 michiel de bruijn, Rotterdam, The Netherlands
' Released for public use 16/08/1994. See TASKLIST.WRI for licensing details
'====================================================================================

DefInt A-Z

Dim mScreenRect As rect
Dim mCaptionColor&, mInSysMenu%, mhSysMenu%

Static Sub AddTaskEntryToList (te As TASKENTRY, hWndTest%)
    
'AddTaskEntryToList: add the icon and task information for
' the TASKENTRY to our list

CRLF$ = Chr$(13) & Chr$(10)

'First, get more information on the Task Module
'  (we need the path to extract the icon)
Dim mo As MODULEENTRY
mo.dwSize = Len(mo)
res% = ModuleFindName(mo, te.szModule)
If res% = 0 Then
    MsgBox "Could not retrieve module information for " & te.szModule, 48, "Error"
    List1.AddItem ZTrim$(te.szModule) & CRLF$ & "(error getting module information)"
    Exit Sub
End If

'Then, extract the first Icon from the file we just found
'  into our Picture1 control
fil$ = ZTrim$(mo.szExePath)
hIcon% = ExtractIcon(hInst%, fil$, 0)
Picture1.Picture = LoadPicture("")
res% = DrawIcon%(Picture1.hDC, 0, 0, hIcon%)
'Destroy the icon, releasing its memory
res% = DestroyIcon(hIcon%)

'Get the (main) Window title for this task, if the caller
'  did not specify it
If hWndTest% = 0 Then
    hWndTest% = GetWindow(Me.hWnd, GW_HWNDFIRST)
    While hWndTest%
        If GetWindow(hWndTest%, GW_OWNER) = 0 Then
            hInst% = GetWindowWord(hWndTest%, GWW_HINSTANCE)
            If hInst% = te.hInstance Then GoTo UglyBailOut  'Yup!
        End If
        hWndTest% = GetWindow(hWndTest%, GW_HWNDNEXT)
    Wend
End If

UglyBailOut:
buf$ = Space$(256)
res% = GetWindowText(hWndTest%, buf$, 256)
If res% < 2 Then buf$ = "(No window title)" & Chr$(0)

'Display Window/task info and type
flags$ = "hWnd=" & Hex4$(hWndTest%) & ", hTask=" & Hex4$(te.hTask) & ", hInstance=" & Hex4$(te.hInstance) & ", hModule=" & Hex4$(te.hModule)
If IsWindowVisible(hWndTest%) = 0 Then flags2$ = "[invisible] " Else flags2$ = ""
If IsIconic(hWndTest%) <> 0 Then flags2$ = flags2$ & "[minimized] "
If IsZoomed(hWndTest%) <> 0 Then flags2$ = flags2$ & "[maximized] "

List1.AddItem fil$ & " (" & ZTrim$(te.szModule) & ") " & flags2$ & CRLF$ & ZTrim$(buf$) & CRLF$ & flags$
List1.ItemPicture(List1.ListCount - 1) = Picture1.Image
List1.ItemData(List1.ListCount - 1) = hWndTest%

End Sub

Sub ArrangeIcons_Click ()

'ArrangeIcons: Arrange all Icons on the Desktop

res% = ArrangeIconicWindows(GetDeskTopWindow())

End Sub

Static Sub BuildModuleList ()

'BuildModuleList: Build Module List by walking the MODULEENTRY struct list

CRLF$ = Chr$(13) & Chr$(10)

Dim mo As MODULEENTRY
mo.dwSize = Len(mo)

screen.MousePointer = 11
yield% = DoEvents()

If ModuleFirst(mo) = 0 Then
    MsgBox "Could not retrieve the first module in the module list. This is probably due to a corrupted system or an incompatible Windows version.", 16, "Fatal Error"
    DoEnd
End If

Do
    'Extract the first Icon from the module file into our Picture1 control
    fil$ = ZTrim$(mo.szExePath)
    hIcon% = ExtractIcon(hInst%, fil$, 0)
    Picture1.Picture = LoadPicture("")
    res% = DrawIcon%(Picture1.hDC, 0, 0, hIcon%)
    'Destroy the icon, releasing its memory
    res% = DestroyIcon(hIcon%)
    
    List1.AddItem ZTrim$(mo.szExePath) & " (" & ZTrim$(mo.szModule) & ")" & CRLF$ & "wcUsage=" & Hex4$(mo.wcUsage) & ", hModule=" & Hex4$(mo.hModule)
    List1.ItemPicture(List1.ListCount - 1) = Picture1.Image
    List1.ItemData(List1.ListCount - 1) = mo.hModule

Loop While ModuleNext(mo)

screen.MousePointer = 0

End Sub

Static Sub BuildTaskList ()

'BuildTaskList: Build Task List using a GetWindow() loop (TASKMAN style)

Dim te As TASKENTRY

screen.MousePointer = 11
yield% = DoEvents()

'Get the first window known to Windows. The Me.hWnd is just
' here because we need to pass a *valid* hWnd
hWndTest% = GetWindow(Me.hWnd, GW_HWNDFIRST)
'As long as the hWnd we got is valid ...
While hWndTest%
    'Test to see if the associated window has a owner. If
    ' it has, it's not a top-level window and we don't
    ' bother with it
    If GetWindow(hWndTest%, GW_OWNER) = 0 Then
        'Otherwise, get the window caption (text)
        buf$ = Space$(256)
        res% = GetWindowText(hWndTest%, buf$, 256)
        If res% > 1 Then
            'And if that went well add it to our list ...
            GetTaskEntry GetWindowTask(hWndTest%), te
            AddTaskEntryToList te, hWndTest%
        End If
    End If
    'Get the handle of the next window, if any
    hWndTest% = GetWindow(hWndTest%, GW_HWNDNEXT)
Wend

screen.MousePointer = 0

End Sub

Static Sub BuildTaskList2 ()

'BuildTaskList2: Build Task List by walking the TASKENTRY struct list

screen.MousePointer = 11
yield% = DoEvents()

Dim te As TASKENTRY
te.dwSize = Len(te)

If TaskFirst(te) = 0 Then
    'Sanity check
    MsgBox "Could not retrieve the first task in the task list. This is probably due to a corrupted system or an incompatible Windows version.", 16, "Fatal Error"
    End
End If

'Simply walk get all TASKENTRY structs and process 'em
Do
    AddTaskEntryToList te, 0
Loop While TaskNext(te)

screen.MousePointer = 0

End Sub

Sub CascadeWindows_Click ()

'CascadeWindows: Cascade all Windows on the Desktop
'This code is based on information and sample source code
'from UNDOCUMENTED WINDOWS

'Check SHIFT key state. If the user depresses it while
'  clicking the Cascade button, do a horizontal cascade
'  (stacked windows). Do a vertical cascase (windows side
'  by side) otherwise. This also works with the normal
'  Windows 3.1 Task Manager.

If GetKeyState(VK_SHIFT) = &H8000 Then
    CascadeChildWindows GetDeskTopWindow(), MDITILE_HORIZONTAL
Else
    CascadeChildWindows GetDeskTopWindow(), MDITILE_VERTICAL
End If

End Sub

Sub ClassInfo_Click ()

'ClassInfo: display all window classes associated with the
' current task

screen.MousePointer = 11
CRLF$ = Chr$(13) & Chr$(10)

'Init description and list
ClassList!DescLabel.Caption = "Window Class Information for " & Left$(List1.Text, InStr(List1.Text, Chr$(13)) - 1)
ClassList!List2.DrawFlags(1) = &H110

'Which hModule are we looking for?
hModuleTest% = GetCurrentModuleFromList%()

Dim ce As CLASSENTRY, wc As WNDCLASS
ce.dwSize = Len(ce)

'Get first class from TOOLHELP class list
If ClassFirst(ce) = 0 Then
    'Sanity check failed
    MsgBox "Could not retrieve the first class in the class list. This is probably due to a corrupted system or an incompatible Windows version.", 16, "Fatal Error"
    DoEnd
End If

Do
    'If the window class' hInst matches the hModule we're looking for ...
    If ce.hInst = hModuleTest% Then
        'Get the class info ...
        res% = GetClassInfo(ce.hInst, ce.szClassName, wc)
        'Add it to our list
        ClassList!List2.AddItem "Class: " & ZTrim$(ce.szClassName) & CRLF$ & XlateClassStyle$(wc.style) & CRLF$ & "hInstance=" & Hex4$(wc.hInstance) & ", hIcon=" & Hex4$(wc.hIcon) & ", hCursor=" & Hex4$(wc.hCursor) & ", hBrush=" & Hex4$(wc.hbrBackground)
    End If
'Get next window class, if any
Loop While ClassNext(ce)

screen.MousePointer = 0

'Show class list form until user closes it
ClassList.Show 1

End Sub

Sub CloseTask_Click ()

'CloseTask_Click: end the selected task

'Is the user trying to close a DOS box?
If IsWinOldApTask(GetCurrentTaskFromList%()) Then
    'If so, ask him/her if he/she is *really* sure about that
    If MsgBox("The effects of closing a DOS box this way might surprise you. Continue anyway?", 36, "Government Health Warning") <> 6 Then
        Exit Sub
    End If
End If

'Post a WM_QUIT message to the application window
res% = PostMessage(List1.ItemData(List1.ListIndex), WM_QUIT, 0, 0&)
'Give Windows time to catch up
yield% = DoEvents()
'And do some catching up of our own
Call RefreshList_Click

End Sub

Sub Form_KeyUp (KeyCode As Integer, Shift As Integer)

'Form_Keyup: check if a certain key combination was pressed,
' and act accordingly

'Alt+F4?
If (KeyCode = 115) And (Shift = 4) Then DoEnd
'Alt+Space?
If (KeyCode = 18) And (Shift = 0) Then ShowSysMenu
'Escape?
If (KeyCode = 27) And (Shift = 0) Then mInSysMenu = False

End Sub

Sub Form_Load ()
   
'Get our Instance Handle
hInst% = GetWindowWord(Me.hWnd, GWW_HINSTANCE)

'Make our window topmost ('floating')
res% = SetWindowPos(Me.hWnd, -1, 0, 0, 0, 0, 3)

'Init the Message Blaster
Msg1.hWndTarget = Me.hWnd 'Set target form
'Intercept 'COMMAND' message so we can handle the Move, Close and 'On Top' commands ourselves
Msg1.MsgList(0) = WM_COMMAND: Msg1.MsgPassage(0) = PREPROCESS
'Intercept 'ACTIVATE' message so we can change the caption color if our window gets (de)activated
Msg1.MsgList(1) = WM_NCACTIVATE: Msg1.MsgPassage(1) = POSTPROCESS
'Intercept 'HIT TEST' message to allow us to determine which part of the form the mouse cursor is over
Msg1.MsgList(2) = WM_NCHITTEST: Msg1.MsgPassage(2) = EATMESSAGE
'Intercept 'Left BUTTON DBLCLK' message (ends app)
Msg1.MsgList(3) = WM_NCLBUTTONDBLCLK: Msg1.MsgPassage(3) = EATMESSAGE
'Intercept 'Left BUTTON DOWN' message (show our system menu)
Msg1.MsgList(4) = WM_NCLBUTTONDOWN: Msg1.MsgPassage(4) = POSTPROCESS
'Intercept undocumented Window creation/destruction messages
Msg1.MsgList(5) = WM_OTHERWINDOWCREATED: Msg1.MsgPassage(5) = EATMESSAGE
Msg1.MsgList(6) = WM_OTHERWINDOWDESTROYED: Msg1.MsgPassage(6) = EATMESSAGE

'Set ScaleMode to Pixels
Me.ScaleMode = 3

'Get color to use to draw window caption
mCaptionColor& = GetSysColor(COLOR_ACTIVECAPTION) And &HFFFFFF
    
'Crate our 'system menu'
mhSysMenu = CreatePopupMenu()
res% = AppendMenu(mhSysMenu, MF_ENABLED Or MF_STRING, IDM_SYSMOVE, "&Move")
res% = AppendMenu(mhSysMenu, MF_ENABLED Or MF_STRING, IDM_SYSCLOSE, "&Close  Alt+F4")
res% = AppendMenu(mhSysMenu, MF_SEPARATOR, 0, "")
res% = AppendMenu(mhSysMenu, MF_ENABLED Or MF_STRING Or MF_CHECKED, IDM_FLOAT, "&Always on Top")

'Set bounding rectangle for screen
mScreenRect.Left = 0
mScreenRect.right = screen.Width / screen.TwipsPerPixelX
mScreenRect.Top = 0
mScreenRect.bottom = screen.Height / screen.TwipsPerPixelY

'Set up multicolumn list box
List1.ItemLength(1) = 650
List1.DrawFlags(1) = &H100

'Build list for the first time
Call RefreshList_Click

End Sub

Sub Form_Paint ()

'Form_Paint: paint the 'fake' window caption onto our (captionless) window
'Taken from SMALLCAP with some small modifications

'Paint caption background
Line (1, -1)-Step(Me.Width, 15), mCaptionColor&, BF
'Horizontal line under caption
Line (0, 14)-Step(Me.ScaleWidth, 0), QBColor(0)
'Vertical line beteen control menu and caption
Line (12, 0)-Step(0, 15), QBColor(0)
'Background for control menu
Line (1, 0)-Step(10, 13), QBColor(7), BF
'Box for bar in control menu
Line (3, 5)-Step(5, 2), QBColor(0), B
'Line inside bar in control menu
Line (4, 6)-Step(4, 0), QBColor(15)
'Vertical shadow on bar in control menu
Line (9, 6)-Step(0, 3), QBColor(8)
'Horizontal shadow on bar in control menu
Line (4, 8)-Step(5, 0), QBColor(8)

End Sub

Static Function GetCurrentModuleFromList% ()

'Extract the hModule value from the currently selected task

tmp$ = List1.List(List1.ListIndex)
x% = InStr(tmp$, "hModule=") + 8
x2% = Len(tmp$) + 1
GetCurrentModuleFromList% = Val("&H" & Mid$(tmp$, x%, x2% - x%))

End Function

Static Function GetCurrentTaskFromList% ()
    
'Extract the hTask value from the currently selected task

tmp$ = List1.List(List1.ListIndex)
x% = InStr(tmp$, "hTask=") + 6
x2% = InStr(x%, tmp$, " ")
GetCurrentTaskFromList% = Val("&H" & Mid$(tmp$, x%, x2% - x%))

End Function

Static Function GetCurrentUsageFromList% ()

'Extract the wcUsage value from the currently selected task

tmp$ = List1.List(List1.ListIndex)
x% = InStr(tmp$, "wcUsage=") + 8
x2% = InStr(x%, tmp$, " ")
GetCurrentUsageFromList% = Val("&H" & Mid$(tmp$, x%, x2% - x%))

End Function

Static Sub GetTaskEntry (hTask%, te As TASKENTRY)

'GetTaskEntry: Get TASKENTRY structure for a given hTask

te.dwSize = Len(te)

If TaskFirst(te) = 0 Then
    MsgBox "Could not retrieve the first task in the task list. This is probably due to a corrupted system or an incompatible Windows version.", 16, "Fatal Error"
    DoEnd
End If

Do
    If te.hTask = hTask% Then Exit Sub
Loop While TaskNext(te)

MsgBox "TASKENTRY for hTask not found", 16, "Fatal Internal Error"
End

End Sub

Sub List1_Click ()

If List1.ListIndex > -1 Then
    ClassInfo.Enabled = True
    If Not UseModules.Value Then SwitchTo.Enabled = True
    If Not UseModules.Value Then CloseTask.Enabled = True
    NukeTask.Enabled = True
End If

End Sub

Sub Msg1_Message (MsgVal As Integer, wParam As Integer, lParam As Long, ReturnVal As Long)

'Msg1_Message: handle Windows messages
'Adapted from code in SMALLCAP (see TASKLIST.WRI for details)

'Flag to keep 'floating' status
Static MenuFlag%

'Check the message we just got
Select Case MsgVal
        
    'Did we get (de)activated?
    Case WM_NCACTIVATE
        If wParam% Then
            'Draw 'active' caption
            mCaptionColor& = GetSysColor(COLOR_ACTIVECAPTION) And &HFFFFFF
        Else
            'Draw 'inactive' caption
            mCaptionColor& = GetSysColor(COLOR_INACTIVECAPTION) And &HFFFFFF
        End If
        Me.Refresh
        
    'Was the mouse moved over our form?
    Case WM_NCHITTEST
        mxPos% = (lParam And &HFFFF&)
        myPos% = (lParam / 65536)
        mFormTop% = Top / screen.TwipsPerPixelY
        mFormLeft% = Left / screen.TwipsPerPixelX
        'Is it now over the caption bar?
        If (myPos% - mFormTop% < 20) And (mxPos% - mFormLeft% > 17) Then
            ReturnVal = HTCAPTION
            mInSysMenu% = False
        'Is it within the System Menu box?
        ElseIf (myPos% - mFormTop% < 20) And (mxPos% - mFormLeft% < 20) Then
            ReturnVal = HTSYSMENU
        'Otherwise it's in the client area ...
        Else
            ReturnVal = HTCLIENT
            mInSysMenu% = False
        End If
        
    'Was there a dubble click with the left mouse button?
    Case WM_NCLBUTTONDBLCLK
        'If the cursor was within the system menu box, exit
        If wParam% = HTSYSMENU Then
            DoEnd
        End If
        
    'Was the left mouse button pressed?
     Case WM_NCLBUTTONDOWN
        'If the cursor was in the system menu box ...
        If wParam% = HTSYSMENU Then
            'Check if we're currently showing the system menu
            If mInSysMenu% Then
                'And if yes, do nothing and reset flag
                '(menu will 'disappear' later because of the click)
                mInSysMenu% = False
                Exit Sub
            Else
                'Otherwise, start showing the menu
                ShowSysMenu
            End If
        End If
        
    'System command?
    Case WM_COMMAND
        Select Case wParam%
            Case IDM_SYSMOVE
                'Allow user to move the form
                rc& = SendMessage(Me.hWnd, WM_SYSCOMMAND, SC_MOVE, 0)
            Case IDM_SYSCLOSE
                'Close -- exit app
                DoEnd
            Case IDM_FLOAT
                'Toggle floating
                MenuFlag% = Not MenuFlag%
                If MenuFlag% Then
                    'Make our window non-topmost
                    res% = SetWindowPos(Me.hWnd, -2, 0, 0, 0, 0, 3)
                    'And uncheck the menu option
                    res% = ModifyMenu(mhSysMenu%, 3, MF_ENABLED Or MF_STRING Or MF_BYPOSITION, IDM_FLOAT, "&Always on Top")
                Else
                    'Make our window topmost
                    res% = SetWindowPos(Me.hWnd, -1, 0, 0, 0, 0, 3)
                    'And check the menu option
                    res% = ModifyMenu(mhSysMenu%, 3, MF_ENABLED Or MF_STRING Or MF_CHECKED Or MF_BYPOSITION, IDM_FLOAT, "&Always on Top")
                End If
        
        End Select

    'Did another Window get created/destroyed (so we should refresh)?
    Case WM_OTHERWINDOWCREATED, WM_OTHERWINDOWDESTROYED
        MsgBox "WM_OTHERWINDOWxxx received", 64, "Test"
        Call RefreshList_Click
    
End Select

End Sub

Sub NukeTask_Click ()

'This button does something completely different depending
'on the kind of list displayed:
If Not UseModules.Value Then
    'Task list: close app
    If MsgBox("Closing this app the hard way might reduce your once-working Windows system to a huge GPF-feast. Continue anyway?", 36, "Government Health Warning") = 6 Then
        TerminateApp GetCurrentTaskFromList%(), 1
    End If
Else
    'Module list: unload module
    If List1.ListIndex < 7 Then
        tmp$ = "Unloading a Windows Kernel module will CRASH the system"
    Else
        tmp$ = "Unloading a module may crash the system"
    End If
    If MsgBox(tmp$ & ". Continue anyway?", 36, "Government Health Warning") = 6 Then
        For a% = 1 To GetCurrentUsageFromList%()
            FreeModule List1.ItemData(List1.ListIndex)
        Next a%
    End If
End If

yield% = DoEvents()
Call RefreshList_Click

End Sub

Sub RefreshList_Click ()

'RefreshList_Click: Decide what kind of list to display,
'   update buttons accordingly and call list function

List1.Clear

ClassInfo.Enabled = False
SwitchTo.Enabled = False
CloseTask.Enabled = False
NukeTask.Enabled = False

If UseWins.Value Or UseTasks.Value Then
    NukeTask.Caption = "&Nuke task"
    Call BuildTaskList
ElseIf UseModules.Value Then
    NukeTask.Caption = "&Unload module"
    Call BuildModuleList
Else
    MsgBox "I'm confused!", 64, "Nothing to refresh"
End If

End Sub

Sub RunProgram_Click ()

'RunProgram_Click: ask user for a program to run and do it

On Local Error Resume Next

resp$ = InputBox$("Enter command line", "Run")
If Len(resp$) Then
    Err = 0
    pid% = Shell(resp$)
    If Err Then
        MsgBox Error$(Err), 48, "Cannot execute"
    Else
        yield% = DoEvents()
        Call RefreshList_Click
    End If
End If

End Sub

Sub ShowSysMenu ()
    
'ShowSysMenu: Drop down our own 'system menu'
'Adapted from code in SMALLCAP (see TASKLIST.WRI)

InPixels% = Me.ScaleWidth
Me.ScaleMode = 1
    
'Determine if we should show the menu below or above our window
x% = (Left) \ (Me.ScaleWidth \ InPixels)
Y% = (9 * screen.TwipsPerPixelY + (Me.Top + (Me.Height - Me.ScaleHeight - (Me.Width - Me.ScaleWidth)))) \ (Me.ScaleWidth \ InPixels)
ScaleMode = 3
If (Y% + (3 * GetSystemMetrics(SM_CYMENU))) > (screen.Height / screen.TwipsPerPixelY) Then
    res% = TrackPopupMenu(mhSysMenu%, 0, x%, Y% - (3 * GetSystemMetrics(SM_CYMENU)) - 9, 0, Me.hWnd, mScreenRect)
Else
    res% = TrackPopupMenu(mhSysMenu%, 0, x%, Y% + 5, 0, Me.hWnd, mScreenRect)
End If

'Set global flag to indicate system menu is being shown
mInSysMenu% = True

End Sub

Sub SwitchTo_Click ()

'SwitchTo_Click: use SwitchToThisWindow API call to switch
' to the window associated with the selected task (ItemData
' contains the hWnd)

Call SwitchToThisWindow(List1.ItemData(List1.ListIndex), 1)

End Sub

Sub TileWindows_Click ()

'TileWindows: Tile all Windows on the Desktop
'This code is based on information and sample source code
'from UNDOCUMENTED WINDOWS

'Check SHIFT key state. If the user depresses it while
'  clicking the Tile button, do a horizontal tile
'  (left to right). Do a vertical tile (top to bottom)
'  This also works with the normal Windows 3.1 Task Manager.

If GetKeyState(VK_SHIFT) = &H8000 Then
    TileChildWindows GetDeskTopWindow(), MDITILE_HORIZONTAL
Else
    TileChildWindows GetDeskTopWindow(), MDITILE_VERTICAL
End If

End Sub

Sub UseModules_Click ()

CaptionLabel.Caption = "Module List"
Call RefreshList_Click

End Sub

Sub UseTasks_Click ()

CaptionLabel.Caption = "Task List (via TaskInfo structs)"
Call RefreshList_Click

End Sub

Sub UseWins_Click ()

CaptionLabel.Caption = "Task List (traditional)"
Call RefreshList_Click

End Sub

Static Function XlateClassStyle$ (style%)

'XlateClassStyle$: returns a string describing the
' windows style bits (CS_xxx) for a class

Dim bitvalue%(11), xlat$(11)

If bitvalue%(1) <> &H1 Then
    bitvalue%(1) = &H1: xlat$(1) = "VRedraw"
    bitvalue%(2) = &H2: xlat$(2) = "HRedraw"
    bitvalue%(3) = &H8: xlat$(3) = "DblClks"
    bitvalue%(4) = &H20: xlat$(4) = "OwnDC"
    bitvalue%(5) = &H40: xlat$(5) = "ClassDC"
    bitvalue%(6) = &H80: xlat$(6) = "ParentDC"
    bitvalue%(7) = &H200: xlat$(7) = "NoClose"
    bitvalue%(8) = &H800: xlat$(8) = "SaveBits"
    bitvalue%(9) = &H1000: xlat$(9) = "ByteAlignClient"
    bitvalue%(10) = &H2000: xlat$(10) = "ByteAlignWindow"
    bitvalue%(11) = &H4000: xlat$(11) = "GlobalClass"
End If

tmp$ = ""
For a% = 1 To 11
    If (style% And bitvalue%(a%)) = bitvalue%(a%) Then
        tmp$ = tmp$ & xlat$(a%) & ", "
    End If
Next a%

If Len(tmp$) > 2 Then
    XlateClassStyle$ = Left$(tmp$, Len(tmp$) - 2)
Else
    XlateClassStyle$ = ""
End If

End Function

