/*  DELAY.C  */
/*          Copyright 1995 by Ethan Brodsky.  All right reserved.           */

#ifndef __LARGE__
#error DELAY must be compiled in the LARGE model
#endif

// Configuration (Only SB16 supported)
#define BASE_IO 0x220
#define IRQ     5
#define DMA8    1
#define DMA16   5

#define BLOCK_LEN   220               /* Block length (2 blocks/DMA buffer) */
#define BLOCK_DELAY 50                /* Number of blocks to delay          */
#define RATE        44100             /* Sampling rate                      */

#include <alloc.h>
#include <conio.h>
#include <dos.h>
#include <math.h>
#include <mem.h>
#include <stdio.h>

#include "simul.h"

int curinbuf  = BLOCK_DELAY-1;
int curoutbuf = 0;

signed  short (far *tempbuf_16)[BLOCK_DELAY][BLOCK_LEN];
unsigned char (far *tempbuf_8)[BLOCK_DELAY][BLOCK_LEN];

void far inthandler_16(void)
 /* Copies data from 16-bit input buffer and converts it to 8-bit data */
  {
    int i;

   /* Copy data from DMA input buffer to 16-bit temporary buffer */
    _fmemcpy((*tempbuf_16)[curinbuf], blockptr_16[curblock_16], 2*BLOCK_LEN);

   /* Convert 16-bit data to 8-bit data */
    for (i = 0; i < BLOCK_LEN; i++)
      (*tempbuf_8)[curinbuf][i] =
       ((unsigned char)((*tempbuf_16)[curinbuf][i] >> 8) + 128);

   /* Change temporary input block */
    curinbuf = (curinbuf+1) % BLOCK_DELAY;
  }

void far inthandler_8(void)
 /* Copies 8-bit data from temporary buffer to output buffer */
  {
   /* Copy data from 8-bit temporary buffer to DMA output buffer */
    _fmemcpy(blockptr_8[curblock_8], (*tempbuf_8)[curoutbuf], BLOCK_LEN);

   /* Change temporary output block */
    curoutbuf = (curoutbuf+1) % BLOCK_DELAY;
  }

char vol_char(int vol)
 /* Graphical display of sound volume */
  {
    if ((vol >= 0)     && (vol < 250))   return '';
    if ((vol >= 250)   && (vol < 1000))  return '';
    if ((vol >= 1000)  && (vol < 2500))  return '';
    if ((vol >= 2500)  && (vol < 5000))  return '';
    if ((vol >= 5000)  && (vol < 10000)) return '';
    if ((vol >= 10000) && (vol < 15000)) return '';
    if ((vol >= 15000))                  return '';

    return ''; /* Satisfy complainer^H^H^H^H^Hiler ;-) */
  }

int avg_vol(short far *buf16)
 /* Calculates average amplitude in buffer */
  {
    int i;
    long sum = 0;

    for (i = 0; i < BLOCK_LEN; i++)
      sum += abs(buf16[i]);

    return sum / BLOCK_LEN;

  }

void main(void)
  {
    int i;

    init_sb(BASE_IO, IRQ, DMA8, DMA16, RATE);
    set_blocklength(BLOCK_LEN);
    get_buffers();

    install_handler_16(inthandler_16);
    install_handler_8(inthandler_8);

   /* Allocate and clear all buffers */
    tempbuf_16 = farmalloc(sizeof(*tempbuf_16));
    tempbuf_8  = farmalloc(sizeof(*tempbuf_8));

    _fmemset((*tempbuf_16), 0x00, sizeof(*tempbuf_16));
    _fmemset((*tempbuf_8),  0x80, sizeof(*tempbuf_8));

    start_output8();
    start_input16();

    do
      {
       /*       buffer#     volume  intcounts */
        printf("(%02u %02u) (%c %c) (%lu: %lu %lu) \n",
               curinbuf, curoutbuf,
               vol_char(avg_vol((*tempbuf_16)[((curinbuf-1) + BLOCK_DELAY) % BLOCK_DELAY])),
               vol_char(avg_vol((*tempbuf_16)[curoutbuf])),
               intcount, intcount_8, intcount_16);

       /* May occur at end, but I'm not sure why */
        if (error)
          {
            printf("\a       **************** ERROR **************** \n");
            error = 0;
          }
      }
    while (!kbhit());

    getch();

    stop_sound();

    farfree(tempbuf_8);
    farfree(tempbuf_16);

    free_buffers();
    shutdown_sb();
  }