/****************************************************************************

    Module  : FreeDock.h

*****************************************************************************/

#define VersionText "v2.5a"		// Current version of FreeDock


#ifdef  WIN32
#define OS_Bits "(32 Bit)"		// WIN32 (NT or Windows 95, or WIN32s system)
#else
#define OS_Bits "(16 Bit)"		// Windows 3.x system
#endif

#define STRICT

/*******************************************************************************
    Define the various constants used
*******************************************************************************/

#define DEFAULT_DOCK_SIZE     10    // defualt number of slots (if not in .ini)
#define MAX_FPATH_LEN        128    // Max length of a path
#define TMP_BUFF_LEN          32    // Length of temp string buffer in main
#define MAX_CMDLINE_LEN     1024    // Max len of command line
#define DEF_SLOT_WIDTH  	 38     // 32x32 icon + border of 3 on each side
#define DEF_SLOT_HEIGHT 	 38     // ditto (this is really the size of the blank button BitMap)
#define MAX_SLOT_SCALE		 76		// Maximum size for the slots when scaling the dock (double normal size) 2:1
#define MAX_SLOT_WIDTH		 76		// ditto, included for better readability in code
#define MAX_SLOT_HEIGHT		 76		// ditto, included for better readability in code
#define MIN_SLOT_SCALE		  8		// Minimum size for the Slots when scaling the dock (probably too small anyway)	1:4ish
#define DEF_SLOT_SCALE       38		// Default size for the slots in the dock, this is 1:1


#define DEF_MAX_SLOTCOUNT    32     // This is the default size of array which is malloc'd to hold the slots in the
								 	// Dock, it can be altered by specifying a smaller/larger value in the .ini file
									// as required.

#define DEF_STORE_X         0       // Initial non-fatal values for
#define DEF_STORE_Y         0       // stored window position, incase
#define DEF_STORE_W       400       // user selects "stored" without
#define DEF_STORE_H       200       // then grabbing a window

#define MAIL_TIMER	    1	    	// Timer ID for the mail checking slot

typedef enum  _SlotType{ SLOT_FREE,			 // slot is empty
		 	     SLOT_USED,	         // Slot is being used
				 SLOT_SPECIAL_TITLE, // slot is a special slot type (Title Icon)
	  			 SLOT_SPECIAL_EXIT,	 // slot is a special slot type (Exit Windows)
			  	 SLOT_SPECIAL_CLOCK, // slot is a special slot type (Clock slot)
		  	     SLOT_SPECIAL_MAIL,	 // slot is a special slot type (Mail Check)
 			     SLOT_SPECIAL_SUB	 // slot is a special slot type (Has a sub-dock)
}SLOT_TYPE;

typedef enum  _StartType{ START_MINIMUM,		 // Startup option "Start Minimised"
				  START_MAXIMUM,		 // Startup option "Start Maximised"
				  START_NORMAL,			 // Startup option "Start Normal"
				  START_STORE			 // Startup option "Start In Stored Postion"
}START_TYPE;

typedef enum _DockPos{ DOCK_HORZ = 0,			 // Dock Orientation is Horizontal
			   		   DOCK_VERT = 1			 // Dock Orientation is Vertical
}DOCK_POS ;

typedef enum _DockType{ ROOT_DOCK,			 // Dock is the root Dock
		        		SUB_DOCK			 // Dock is a sub-Dock
}DOCK_TYPE;

/*************************************
	Predeclare typedefs to avoid
	compiler complaints.
*************************************/
struct _SLOT_ENTRY;

/******************************************************************
	Data structure to hold all global system metrics used
******************************************************************/
typedef struct _GlobalMetrics{
		int          ScreenWidth;		// Width of Screen
		int          ScreenHeight;		// Height of screen
		int          IconWidth;		// Width of Icons
		int          IconHeight;		// Height of Icons
		int 	  	 DlgTitleHeight;	// Height of the title bar
		int 	  	 DlgFrameWidth;	// Width of dialog frame
		int 	  	 DlgFrameHeight;	// Height of dialog frame
}GLOBAL_METRICS;

/******************************************************************
	Data structure to hold all global Dock Options used
	Global means : applies to root dock and all sub-docks
******************************************************************/
typedef struct _GlobalOptions{
    char    szAppName[256];					 // Name of the Application
    BOOL 	ClockActive;					 // is the Clock Built-in Active ?
    BOOL 	WinExitActive;					 // is the Exit Windows Built-in Active ?
    BOOL 	WinExitConfirm;					 // Ask user to confirm Exit windows ?
    BOOL 	MailActive;						 // is the Mail Built-in Active ?
    BOOL 	MaxView;						 // is MaxView option active ?
    BOOL 	AlwaysOnTop;					 // is Dock set to always on top ?
    BOOL 	SingleClickStart;				 // start applications with a single click ?
	BOOL 	HideDlgOnGrab;					 // hide App Options dialog when grabbing a window ?
	BOOL    DockLocked;						 // Are the slots locked in the dock ? (can't be dragged)
    char 	MailPath[MAX_FPATH_LEN];		 // Path to Mail Box
    int  	MailFreq;						 // Frequency to check mail box (minutes)
    BOOL 	MailSound;						 // Beep when mail arrives ?
    long 	MailBoxSize;					 // Last known size of mail box
    long 	MailBoxDateTime;				 // Last known date stamp of mail box
    BOOL	bMailInBox;						 // Is there mail in the mailbox ?
	int     SlotWidth;						 // Slot Width	(Used in scaling dock)
	int     SlotHeight;						 // Slot Height (Used in scaling dock)
	int     SlotScale;						 // Slot Scale (same as Width&Height) Width & Height used in code
											 // to improve understanding.
	int     MaxDockSize;					 // Maximum Size of the dock (number of slots malloced at startup
	int     SleepTime;						 // Period to sleep before enumerating windows (NT Only)
	BOOL    bFoundWindow;					 // Used when enumerating windows.
	HANDLE  hAppInst;						 // handle to application instance
}GLOBAL_OPTIONS;

/********************************************************************
    Data structure to hold main dock options
********************************************************************/

typedef struct _DOCK_STRUCT{
	HWND        hwndDock;
    DOCK_POS    Orientation;
	DOCK_TYPE   DockType;
    int  	    SlotCount;
    int  	    DockLeft;
    int  	    DockTop;
    HBITMAP	    hbmIconCache;       // Handle to Icon Cache Bitmap
    HDC         hdcIconCache;       // Handle to Icon Cache DC
	struct _SLOT_ENTRY *Slot;				// Pointer to Slot array for this dock.
}DOCK_STRUCT;


/******************************************************************
    Data structure to hold all data relating to a single slot 
******************************************************************/

typedef struct _SLOT_ENTRY{
    SLOT_TYPE   SlotType;                   // type of the slot
	DOCK_STRUCT	*Dock;			    		// Pointer to the sub-dock if one is attached, otherwise
											// Points to dock containing this slot.
	BOOL		bSubDockOut;				// Is the sub-dock popped out ?
    int         ID;                         // Slot ID Number
    char        AppName[MAX_FPATH_LEN];     // Application pathname
    char        CmdLine[MAX_CMDLINE_LEN];   // Application command line
    char        RunTimeDir[MAX_FPATH_LEN];  // Application Runtime dir
    START_TYPE  StartState;                 // Application Start State (normal/min/max)
    BOOL        StartOnTop;                 // Application started on top of others ?
    BOOL        StartSeparate;              // Application started separate memory space ?
    int         WinX;                       // Application window x position
    int         WinY;                       // Application window y position
    int         WinWidth;                   // Application window width
    int         WinHeight;                  // Application window height
    char        IconFile[MAX_FPATH_LEN];    // Application icon file name
    int         IconPos;                    // Position in file of app icon
    int         IconTotal;                  // Total Number of Icons in icon file
    int         IconIndex;                  // Index into the icon Cache
}SLOT_ENTRY;

/**************************************************************************
 *  Declare function prototypes for all of the procs associated with a    *
 *  specific window.                                                      *
 **************************************************************************/

/******************
	DrawBmp.c
******************/
void DrawBitmap(HDC hdc, HBITMAP hBitmap, int xStart, int yStart);
void PaintSlot(HDC hdc, DOCK_STRUCT *DockOptions, SLOT_ENTRY *Slot);
void RePaintSlot(DOCK_STRUCT *DockOptions, SLOT_ENTRY *Slot, BOOL bErase);
void BlankSlot( HDC hdc, DOCK_STRUCT *DockOptions, SLOT_ENTRY *Slot);
void UtilDrawIcon( HDC hdcDest, DOCK_STRUCT *DockOptions, SLOT_ENTRY *Slot, int X, int Y, BOOL bScale );

/********************
	DockUtil.c
********************/
void ReadGlobalOptions( void );
void ReadDockOptions( DOCK_STRUCT *Dock );
void ReadAllSlotOptions( DOCK_STRUCT *Dock, SLOT_ENTRY *Slot );
void WriteGlobalOptions( void );
void WriteDockOptions( DOCK_STRUCT *Dock );
void WriteSlotOptions( DOCK_STRUCT *Dock, SLOT_ENTRY *Slot );
int  FindSlotHit(DOCK_POS Orientation, int XHit, int YHit);
BOOL IsCursorOutOfDock(DOCK_STRUCT *Dock, int X, int Y);
BOOL FAR PASCAL	AppOptionsDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL MainOptionsDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinExitOptionsDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL MailOptionsDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL ClockOptionsDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL AboutDockDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL BrowseIconFile( HWND hwnd, char *FileName );
BOOL FAR PASCAL BrowseFileName( HWND hwnd, char *FileName );
BOOL FAR PASCAL ChooseIconDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL PreviewerDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK UtilSetupStartedWin( HWND hwnd, LPARAM lParam );
void ExecSlot( SLOT_ENTRY *Slot, char *CmdLine );
void SetDockWinPos( DOCK_STRUCT *Dock, int DockPos );
void UtilLoadIcon( DOCK_STRUCT *Dock, SLOT_ENTRY *Slot );
void UtilEmptySlot( SLOT_ENTRY *Slot );
void SwapSlots( SLOT_ENTRY *Slot1, SLOT_ENTRY *Slot2 );


long FAR PASCAL DockWinProc(HWND, UINT, WPARAM, LPARAM);

/***************************************************************
 * Definitions for the Dialog boxes                            *
 * These values are included from the resource header file     *
 ***************************************************************/
#include "resource.h"
