;*********************************************************************
;
;       Multi-tasking kernel Version 1.0 by Andy Yuen 1995 (C)
;
;*********************************************************************
;
;
;          ASSUME CS:MAIN,DS:MAIN,ES:NOTHING
;
MAX_SEM   EQU      60               ;NUMBER OF SEMAPHORE QUEUES
MAX_TASK  EQU      16               ;MAX NUMBER OF TASKS SUPPORTED
Q_MARK    EQU      8000H            ;MSB OF WORD
TRUE      EQU      0FFH
FALSE     EQU      0
;
SEM       DW       MAX_SEM DUP(?)   ;SEMAPHORE QUEUES
RUNID     DW       ?                ;RUNNING TASK ID
READYQ    DW       ?                ;READY TASK QUEUE

ROTATE_FLAG  DB    TRUE             ;IF TRUE USE ROTATE ALGORITHM
	  EVEN
BOTTOM_PMASK DW    8000H            ;BOTTOM PRIORITY MASK
BOTTOM_PNUM  DW    15               ;BOTTOM PRIORITY NUMBER
STACKPTR  DW       MAX_TASK DUP(?)          ;STACK POINTER STORAGE
STACKSEG  DW       MAX_TASK DUP(?)          ;STACK SEGMENT STORAGE
TASK_BIT  DW       1,2,4,8,10H,20H,40H,80H  ;TASK BIT PATTERN
	  DW       100H,200H,400H,800H
	  DW       1000H,2000H,4000H,8000H
;
;
;
JTABLE    DW       INIT_KERN        ;JUMP TABLE FOR KERNEL FUNCTIONS
	  DW       DECLARE
	  DW       GO
	  DW       SIGNAL
	  DW       SWAIT
	  DW       PREEMPT
	  DW       PREEMPT
	  DW       ME
MAX_TABLE EQU      $-JTABLE

IFDEF MSDOS
CRITICAL  DD       ?
ENDIF
;
;*********************************************************************
;
;MULTITASKING SERVICES
;
;THERE ARE A TOTAL OF 8 SERVICES. THE CALLER SPECIFIES THE REQUIRED
;SERVICE USING REGISTER AH. THESE SERVICES ARE:
;
;AH = 0 INITIALIZE MULTI-TASKER (INIT)
;    (AL) SPECIFY SCHEDULING ALGORITHM
;         0 FOR FIXED PRIORITY
;         1 FOR ROTATE PRIORITY
;
;AH = 1 DECLARE A TASK (DECLARE)
;    (AL) TASK NUMBER (0..14)
;    (DI) STARTING ADDRESS OF TASK (OFFSET FROM CODE SEGMENT)
;    (CX) START OF STACK AREA FOR THE TASK
;    (DX) INITIAL BP VALUE
;
;AH = 2 START ALL DECLARED TASKS (GO)
;
;AH = 3 SIGNAL A SEMAPHORE (SIGNAL)
;    (AL) SEMAPHORE TO BE OPERATED ON (0..59)
;
;AH = 4 WAIT ON A SEMAPHORE  (WAIT)
;    (AL) SEMAPHORE TO BE OPERATED ON (0..59)
;
;AH = 5 PREEMPT RUNNING TASK AND DISPATCH THE NEXT READY TASK (PREEMPT)
;       CALLED BY A TASK
;
;AH = 6 SAME AS 5, BUT CALLED BY AN INTERRUPT SERVICE ROUTINE (IPREEMPT)
;
;AH = 7 GET THE CURRENTLY RUNNING TASK'S NUMBER (ME)
;    RETURNS THE TASK NUMBER (0..14) IN (AL)
;
;*********************************************************************
KERN_HANDLER   PROC   FAR
	  CMP      AH,6             ;DISCARD FLAGS AND RETURN ADDRESS IF IT IS IPREEMPT
	  JNZ      SAVEREGS
	  ADD      SP,6
	  JMP      DECODE
SAVEREGS:
	  PUSH     AX               ;SAVE ALL REGISTERS
	  PUSH     BX
	  PUSH     CX
	  PUSH     DX
	  PUSH     BP
	  PUSH     SI
	  PUSH     DI
	  PUSH     ES
	  PUSH     DS
;
DECODE:
	  MOV      BX,CS            ;SETUP DS AND ES
	  MOV      DS,BX
	  MOV      ES,BX
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
;
	  MOV      BL,AH            ;CALC OFFSET INTO JUMP TABLE
	  XOR      BH,BH
	  SHL      BX,1
	  CMP      BX,MAX_TABLE
	  JAE      KERN_RETURN      ;IF OUTSIDE RANGE THEN RETURN
	  CALL     [JTABLE+BX]
;
KERN_RETURN:
	  POP      DS
	  POP      ES               ;RESTORE ALL REGISTERS
	  POP      DI
	  POP      SI
	  POP      BP
	  POP      DX
	  POP      CX
	  POP      BX
	  POP      AX
	  IRET                      ;RETURN FROM INTERRUPT
;
KERN_HANDLER   ENDP
;
;
;
INIT_KERN   PROC      NEAR
	  ASSUME   CS:MAIN,DS:MAIN,ES:MAIN
	  OR       AL,AL            ;DETERMINE USE OF SCHEDULING ALGORITHM
	  JZ       SET_SCHEME
	  MOV      AL,TRUE
SET_SCHEME:
	  MOV      ROTATE_FLAG,AL
	  CLD                       ;SET STRING DIRECTION
	  MOV      CX,MAX_SEM+2     ;SETUP COUNT
	  XOR      AX,AX            ;ZERO ALL Q'S AND DATA STRUCTURES
	  LEA      DI,SEM
	  REP      STOSW
	  MOV      BOTTOM_PMASK,8000H  ;SET UP BOTTOM PRIORITY
	  MOV      BOTTOM_PNUM,15
	  RET                       ;RETURN
INIT_KERN   ENDP
;
;
;
DECLARE   PROC     NEAR
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
	  CMP      AL,MAX_TASK-1    ;IF TASK # OUTSIDE RANGE THEN RET
	  JAE      DECLARE_RETURN
	  MOV      BP,CX
	  SUB      BP,24
	  XOR      AH,AH
	  SHL      AX,1
	  MOV      SI,AX
	  MOV      AX,[TASK_BIT+SI] ;PUT IN READY Q
	  OR       READYQ,AX
	  MOV      [STACKSEG+SI],SS
	  MOV      [BP+24],200H      ;SET UP FLAG
	  MOV      AX,CS
	  MOV      [BP+22],AX       ;SET UP CS
	  MOV      [BP+20],DI       ;SET UP TASK START ADDRESS
	  MOV      [BP+10],DX       ;SET UP BP
	  MOV      [BP+2],AX        ;SET UP DS
	  MOV      [BP+4],AX        ;SET UP ES
	  MOV      [BP],OFFSET KERN_RETURN
	  MOV      [STACKPTR+SI],BP ;STORE IN TASK SP STORAGE
DECLARE_RETURN:
	  RET                       ;RETURN
;
DECLARE   ENDP
;
;
;
GO        PROC     NEAR
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
;
;         CHANGE TIMER TO HAVE LOWEST EXTERNAL INTERRUPT PRIORITY ON 8259
;
	  MOV      AL,0C0H
	  OUT      20H,AL
IFDEF MSDOS
;         GET DOS CRITICAL FLAG LOCATION          
	  MOV      AH,34H
	  INT      21H
	  MOV      WORD PTR CRITICAL,BX
	  MOV      WORD PTR CRITICAL+2,ES
ENDIF     
	  MOV      BP,SP            ;MODIFY STACK TO POINT TO IDLE TASK
	  MOV      [BP+24],200H     ;SET UP FLAG REGISTER
	  MOV      [BP+22],CS       ;SET UP CS
	  MOV      [BP+20],OFFSET IDLE  ;SETUP IDLE TASK
	  MOV      RUNID,30         ;SET UP IDLE AS RUNNING TASK
	  RET                       ;RETURN
;
GO        ENDP
;
;
;
SIGNAL    PROC     NEAR
;
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
	  CMP      AL,MAX_SEM       ;IF SEM# OUTSIDE RANGE THEN RETURN
	  JAE      SIGNAL_RETURN
	  MOV      BL,AL            ;GET SEMAPHORE #
	  XOR      BH,BH
	  SHL      BX,1
	  CMP      [SEM+BX],Q_MARK  ;IF SEMAPHORE Q EMPTY THEN
	  JAE      UNBLOCK
	  INC      [SEM+BX]         ;   INCREMENT SEMAPHORE COUNT
	  JNS      SIGNAL_RETURN
	  DEC      [SEM+BX]         ;   MAKE SURE NOT CHANGE TO Q FORMAT
SIGNAL_RETURN:
	  RET                       ;   RETURN
;
UNBLOCK:
	  MOV      AX,[SEM+BX]      ;GET SEMAPHORE QUEUE
	  PUSH     AX               ;SAVE IT
	  TEST     ROTATE_FLAG,TRUE
	  JZ       FIX1
;
;PRIORITY ROTATE ALGORITHM
;
	  AND      AX,NOT Q_MARK    ;MASK OUT Q_MARK
	  MOV      DX,BOTTOM_PMASK  ;GET WAITING TASK WITH
	  MOV      CX,MAX_TASK      ;   PRIORITY ROTATION
GETBIT:   ROL      DX,1
	  TEST     AX,DX
	  LOOPZ    GETBIT
	  MOV      BOTTOM_PMASK,DX  ;SAVE CURRENT MASK
COMMON:   POP      CX               ;RESTORE SEMAPHORE QUEUE
	  XOR      CX,DX
	  CMP      CX,Q_MARK        ;IF Q EMPTY THEN
	  JA       MREADY
	  XOR      CX,CX            ;   SWITCH TO COUNT FORMAT
MREADY:   MOV      [SEM+BX],CX
	  OR       READYQ,DX        ;ADD TASK TO READY Q
	  RET                       ;RETURN
;
;FIXED PRIORITY ALGORITHM
;
FIX1:     MOV      DX,AX
	  NEG      DX
	  AND      DX,AX
	  JMP      COMMON
;
SIGNAL    ENDP
;
;
;
SWAIT      PROC     NEAR
;
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
	  CMP      AL,MAX_SEM       ;IF SEM# OUTSIDE RANGE THEN RETURN
	  JAE      WAIT_RETURN
	  MOV      BL,AL            ;GET SEMAPHORE #
	  XOR      BH,BH
	  SHL      BX,1
	  CMP      [SEM+BX],1       ;IF SEMAPHORE Q NOT EMPTY THEN
	  JL       BLOCK
	  DEC      [SEM+BX]         ;   DECREMENT SEMAPHORE COUNT
WAIT_RETURN:
	  RET                       ;   AND RETURN
	  ;
BLOCK:
	  MOV      SI,RUNID         ;GET RUNNING TASK ID
	  MOV      AX,[TASK_BIT+SI] ;GET TASK BIT PATTERN
	  OR       AX,Q_MARK        ;SET MSB TO MARK AS Q
	  OR       [SEM+BX],AX      ;ADD TO SEMAPHORE Q
	  XOR      DX,DX
DISPATCH: MOV      [STACKPTR+SI],SP ;SAVE RUNNING TASK'S SP
	  MOV      [STACKSEG+SI],SS
	  MOV      AX,READYQ        ;GET READY Q
	  CMP      AX,Q_MARK        ;IF ONLY IDLE TASK READY
	  JNZ      GET_TASK
	  MOV      BX,30            ;   THEN SET UP ITS ID
	  JZ       NEXT_TASK
GET_TASK: 
	  AND      AX,NOT Q_MARK
	  TEST     ROTATE_FLAG,TRUE
	  JZ       FIX2
;
;PRIORITY ROTATE ALGORITHM
;
	  MOV      BX,BOTTOM_PNUM   ;GET TASK WITH PRIORITY ROTATION
	  PUSH     BX
	  SHL      BX,1
	  MOV      BX,[TASK_BIT+BX]
	  MOV      CX,MAX_TASK
GETID:    ROL      BX,1
	  TEST     AX,BX
	  LOOPZ    GETID
	  POP      BX
	  ADD      BX,16
	  SUB      BX,CX
	  AND      BX,0FH
	  MOV      BOTTOM_PNUM,BX   ;SAVE CURRENT PRIORITY NUMBER
	  SHL      BX,1
NEXT_TASK:
	  MOV      RUNID,BX         ;SAVE RUNNING TASK ID
	  MOV      AX,[TASK_BIT+BX] ;DELETE TASK FROM READY Q
	  XOR      READYQ,AX
	  OR       READYQ,DX
	  MOV      SP,[STACKPTR+BX] ;GET ITS SP
	  MOV      SS,[STACKSEG+BX]
	  RET                       ;RETURN
;
;FIXED PRIORITY ALGORITHM
;
FIX2:     MOV      BX,-1
GETTOP:   INC      BX
	  SHR      AX,1
	  JNC      GETTOP
	  SHL      BX,1
	  JMP      NEXT_TASK
;
SWAIT      ENDP
;
;
;
;
PREEMPT   PROC     NEAR
;
	  ASSUME   CS:MAIN,DS:MAIN,ES:MAIN
IFDEF MSDOS
;         ONLY PREEMPT IF WE ARE NOT IN DOS CRITICAL SECTION
	  LES      BX,CRITICAL
	  TEST     BYTE PTR ES:[BX],TRUE
	  JNZ      PREEMPT_RETURN
ENDIF             
	  TEST     READYQ,NOT Q_MARK   ;IF READYQ EMPTY THEN RETURN
	  JZ       PREEMPT_RETURN
	  MOV      SI,RUNID         ;GET RUNNING TASK ID
	  MOV      DX,[TASK_BIT+SI] ;GET TASK BIT PATTERN
	  JMP      DISPATCH         ;DISPATCH ANOTHER TASK
;
PREEMPT_RETURN:
	  RET                       ;RETURN
;
PREEMPT   ENDP
;
;
;
;
;
ME        PROC     NEAR
	  ASSUME   CS:MAIN,DS:MAIN,ES:NOTHING
	  MOV      AX,RUNID         ;GET RUNNING TASK ID
	  SHR      AX,1
	  MOV      BP,SP            ;PUT ON STACK
	  MOV      BYTE PTR[BP+18],AL
	  RET
ME        ENDP
;
;
;
; IDLE TASK
IDLE      PROC     NEAR
	  ASSUME   CS:MAIN,DS:NOTHING,ES:NOTHING
FOREVER:  MOV      AH,5             ;IDLE TASK
	  INT      KERNEL           ;PREEMPT ITSELF
	  JMP      FOREVER
;
IDLE      ENDP
;
;

