/*****	Building the parser and its FIRST(), FOLLOW() sets etc...
	(C)opyright 1995, Thor R. Mirchandani
	All Rights Reserved
*/
#include <stdlib.h>
#include "lite.h"
static int lowterm=LOWTERM,hiterm;
NON_LIST *top;
/** augment FIRST() or FOLLOW() sets */
int augment(int token,NON_LIST *n,int arg){
	int i;
	int *set;
	set=(arg)?n->follow:n->first;
	for(i=0;*(set+i)!=-1;i++)
		if(*(set+i)==token)
			return 0;
	*(set+i)=token;
	i++;
	*(set+i)=-1;
	if(i>=MAXTOK){
		yyerror("Too many terminals in FIRST() Set");
		exit(1);
	}
	return 1;
}
/** construct the FIRST() sets **/
int buildFIRST(int empty){
	RUL_LIST *r;
	NON_LIST *n;
	int owner=-1,aug=0;
	for(r=rul_list.next;r;r=r->next){
		if(owner!=r->owner){
			owner=r->owner;
			n=find_by_num(owner);
			if(NULL==n){
				yyerror("Cannot Construct FIRST() Set. Invalid Non-Terminal");
				exit(1);
			}
		}
		if(r->prod[0]==owner){
		}
		else if(r->prod[0]==empty){
		}
		/* single char operator token */
		else if(r->prod[0]<lowterm){
			aug+=augment(r->prod[0],n,0);
		}
		/* terminal token*/
		else if(r->prod[0]<=hiterm){
			aug+=augment(r->prod[0],n,0);
		}
		/* non-terminal */
		else{
			NON_LIST *n1;
			int i=0,j;
			/* check each nullable token */
			do{
				if(r->prod[i]>hiterm){
					n1=find_by_num(r->prod[i]);
					if(NULL==n1){
						yyerror("Cannot Construct FIRST() Set. Invalid Non-Terminal");
						exit(1);
					}
					for(j=0;n1->first[j]!=-1;j++)
						aug+=augment(n1->first[j],n,0);
				}
				else if(!r->prod[i]){
					break;
				}
				/* skip empty */
				else if(r->prod[i]==empty);
				else{
					aug+=augment(r->prod[i],n,0);
					break;
				}
				i++;
			}while(n1->empty);
		}
	}
	return aug;
}
/** Find the top level non-terminal i.e. entry point to parser */
NON_LIST *findtop(void){
	NON_LIST *n,*top;
	RUL_LIST *r;
	int i;
	for(n=non_list.next;n;n=n->next){
		for(r=rul_list.next;r;r=r->next){
			if(n->idx!=r->owner){
				for(i=0;r->prod[i];i++){
					if(r->prod[i]==n->idx){
						n->istop=0;
						break;
					}
				}
			}
			if(!n->istop)break;
		}
	}
	top=NULL;
	for(n=non_list.next,i=0;n;n=n->next)
		if(n->istop){
			top=n;
			i++;
		}
	if(NULL==top){
		yyerror("Cannot Build Parser. No Top-Level Non-Terminal");
		exit(1);
	}
	if(1!=i){
		yyerror("Cannot Build Parser. Multiple Top-Level Non-Terminals");
		exit(1);
	}
	augment(EOI,top,1);	/* EOI is the only member of FOLLOW(top) */
	return top;
}
/* see if a non-terminal is nullable */
int nullable(int empty){
	RUL_LIST *r;
	NON_LIST *n;
	int owner=-1,aug=0,null;
	for(r=rul_list.next;r;r=r->next){
		null=0;
		if(owner!=r->owner){ /* find the owner of this rule */
			owner=r->owner;
			n=find_by_num(r->owner);
			if(NULL==n){
				yyerror("Checking Null Status.Unknown Non-terminal.");
				exit(1);
			}
		}
		if(r->prod[0]==empty){		/* an empty rule */
			null=1;
		}
		else if(r->prod[0]>hiterm){ /* a non-terminal found */
			NON_LIST *n1;
			int i;
			null=1;
			for(i=0;r->prod[i];i++){
				if(empty==r->prod[i]){
					continue;
				}
				/* a terminal token found */
				else if(r->prod[i]<=hiterm){
					null=0;
					break;				/* i.e. rule not nullable */
				}
				else{		/* non-terminal */
					n1=find_by_num(r->prod[i]);
					if(NULL==n1){
						yyerror(
							"Checking Null Status.Unknown Non-terminal.");
						exit(1);
					}
					if(0==n1->empty){	/* rule is not nullable */
						null=0;
						break;
					}
				}
			}
		}
		if(null){
			if(!n->empty){
				aug+=1;
				n->empty=1;
			}
		}
	}
	return aug;
}
/* check if a character is in first set */
int notinfirst(NON_LIST *n,int token){
	int i;
	for(i=0;n->first[i]!=-1;i++)
		if(token==n->first[i])
			return 0;
	return 1;
}
/* build follow-set for each non-terminal */
int buildFOLLOW(int empty){
	int aug=0,i,found;
	RUL_LIST *r;
	NON_LIST *n;
	for(n=non_list.next;n;n=n->next){		/* check all non-terminals */
		for(r=rul_list.next;r;r=r->next){	/* check every rule */
			for(i=0;r->prod[i];i++){		/* go through each production */
				found=0;
				if(r->prod[i]==n->idx)
					found=1;
				if(found){							/* part of this rule */
					i++;                            /* move to next */
					while(r->prod[i]==empty) i++;   /* skip over empty */
					if(!r->prod[i]){		/* was the last in this rule */
						NON_LIST *n1;
						int j;
						/* the last one on a line can obviously be replaced
						by the FOLLOW() of the left hand side */
						--i;	/* back up */
						while(r->prod[i]==empty) i--;
						n1=find_by_num(r->owner);
						if(n1){
							for(j=0;n1->follow[j]!=-1;j++)
								if(notinfirst(n,n1->follow[j]))
									aug+=augment(n1->follow[j],n,1);
						}
						break;
					}
					else if(r->prod[i]<=hiterm){ /* a terminal token */
						if(notinfirst(n,r->prod[i]))
							aug+=augment(r->prod[i],n,1);/* add to FOLLOW() */
					}
					else{						/* non terminal */
						NON_LIST *n1;
						int j;
						n1=find_by_num(r->prod[i]);
						if(NULL!=n1){	/* add its first set to follow set */
							for(j=0;n1->first[j]!=-1;j++)
								if(notinfirst(n,n1->first[j]))
									aug+=augment(n1->first[j],n,1);
							/* add the follow set, too */
							if(n1->empty){
								for(j=0;n1->follow[j]!=-1;j++)
									if(notinfirst(n,n1->follow[j]))
										aug+=augment(n1->follow[j],n,1);
							}
						}
					}
				}
			}
		}
	}
	return aug;
}
#ifdef LIST
void trace_follow(void){
	NON_LIST *n;
	TOK_LIST *t;
	int i;
	for(n=non_list.next;n;n=n->next){
		fprintf(stdout,"\n%s: ",n->name);
		if(n->empty) fprintf(stdout,"(nullable) ");
		fprintf(stdout,"\nFIRST(): ");
		for(i=0;n->first[i]!=-1;i++)
			if(n->first[i]<lowterm){
				fprintf(stdout,"'%c' ",n->first[i]);
			}
			else{
				for(t=tok_list.next;t;t=t->next){
					if(t->idx==n->first[i]){
						fprintf(stdout,"%s ",t->name);
						break;
					}
				}
			}
		fprintf(stdout,"\nFOLLOW(): ");
		for(i=0;n->follow[i]!=-1;i++)
			if(n->follow[i]<lowterm){
				fprintf(stdout,"'%c' ",n->follow[i]);
			}
			else{
				for(t=tok_list.next;t;t=t->next){
					if(t->idx==n->follow[i]){
						fprintf(stdout,"%s ",t->name);
						break;
					}
				}
			}
	}
	fprintf(stdout,"\n");
}
void trace_first(void){
	NON_LIST *n;
	TOK_LIST *t;
	int i;
	for(n=non_list.next;n;n=n->next){
		fprintf(stdout,"\n%s: ",n->name);
		if(n->empty) fprintf(stdout,"(nullable) ");
		for(i=0;n->first[i]!=-1;i++)
			if(n->first[i]<lowterm){
				fprintf(stdout,"'%c' ",n->first[i]);
			}
			else{
				for(t=tok_list.next;t;t=t->next){
					if(t->idx==n->first[i]){
						fprintf(stdout,"%s ",t->name);
						break;
					}
				}
			}
	}
	fprintf(stdout,"\n");
}
void trace_top(NON_LIST *n){
	fprintf(stdout,"Top level non-terminal : %s\n",n->name);
}
#else
#define trace_first()
#define trace_top(x)
#define trace_follow()
#endif
/***** entry point to building parser sets etc
*/
int gen_parser(void){
	TOK_LIST *e;
	int empty;
	empty=(NULL!=(e=find_tok("EMPTY")))?empty=e->idx:0;
	hiterm=tok_list.next->idx;			/* highest terminal token... */
	if(empty){							/* only if empty statements */
		while(nullable(empty));
		while(buildFIRST(empty));
		while(buildFOLLOW(empty));
	}
	else while(buildFIRST(empty));			/* building FIRST() */
	if (empty) trace_follow();
    else trace_first();
	top=findtop();
	trace_top(top);
	return 0;
}
/******************* end of file *****************************/
