/*****
	functions for rules section
	(C)opyright 1995, Thor R. Mirchandani
	All Rights Reserved
*/
#include <stdlib.h>
#include "lite.h"
static int lowterm=LOWTERM,hiterm;
/* check to see if a token is a quoted character operator */
int isquotedchar(void){
	return (isprint(lookahead))?lookahead:-1;
}
RUL_LIST rul_list={NULL,NULL,0,0};
/* add a new production rule */
RUL_LIST *addrule(int owner){
	RUL_LIST *p;
	if(NULL==(p=(RUL_LIST *)malloc(sizeof(RUL_LIST)))){
		yyerror("Internal Error Adding Rule");
		exit(1);
	}
	p->owner=owner;
	p->prod[0]=0;
	p->next=rul_list.next;
	rul_list.next=p;
	return p;
}
/* builds a production rule */
int build_rules(int idx){
	int i;
	int rc;
	static char name[33];
	RUL_LIST *rule;
	i=0;
	rule=addrule(idx);
	/* a ';' will end the rule */
	while(!match(';')){
		/* a '|' will end a production */
		if(match('|')){
			rule->prod[i]=0;
			rule=addrule(idx);
			i=0;
		}
		/* new lines are ignored */
		else if(match(CRLF)){
			next();
		}
		/* identifier */
		else if(match(ID)){
			NON_LIST *nont;
			TOK_LIST *tok;
			strncpy(name,yytext,yyleng)[yyleng]='\0';
			/* terminal token ? */
			if(NULL!=(tok=find_tok(name)))
				rule->prod[i++]=tok->idx;
			/* non-terminal token */
			else if(NULL!=(nont=find_nont(name)))
				rule->prod[i++]=nont->idx;
			else{
				nont=add_nont(name);
				rule->prod[i++]=nont->idx;
			}
		}
		/* quoted character operator */
		else if(-1!=(rc=isquotedchar())){
			rule->prod[i++]=rc;
		}
		else{
			yyerror("Invalid Character");
			return -1;
		}
		next();
	}
	rule->prod[i]=0;
	return 0;
}
NON_LIST non_list;
/* find a terminal token by name */
TOK_LIST *find_tok(char *name){
	TOK_LIST *q;
	for(q=tok_list.next;q;q=q->next)
		if(!strcmp(name,q->name))
			return q;
	return (TOK_LIST *)NULL;
}
/* find non-terminal by name */
NON_LIST *find_nont(char *name){
	NON_LIST *p;
	for(p=non_list.next;p;p=p->next)
		if(!strcmp(name,p->name))
			return p;
	return (NON_LIST *)NULL;
}
/* find non-terminal by index */
NON_LIST *find_by_num(int idx){
	NON_LIST *p;
	for(p=non_list.next;p;p=p->next)
		if(p->idx==idx)
			return p;
	return (NON_LIST *)NULL;
}
/* add a new non-terminal */
NON_LIST *add_nont(char *name){
	NON_LIST *p;
	if(NULL==(p=(NON_LIST *)malloc(sizeof(NON_LIST)))){
		yyerror("Internal Error Adding Non-Terminal");
		exit(1);
	}
	fprintf(head,"#define %s %d\n",name,defnum);
	p->name=strdup(name);
	p->next=non_list.next;
	p->idx=defnum++;
	p->empty=0;
	p->istop=1;
	*p->first=-1;
	*p->follow=-1;
	non_list.next=p;
	return p;
}
/* parse left hand side */
int parse_rule(char *name){
	NON_LIST *p;
	int rc;
	if((TOK_LIST *)NULL!=find_tok(name)){
		yyerror("Invalid Non-Terminal");
		return -1;
	}
	if((NON_LIST *)NULL==(p=find_nont(name)))
		p=add_nont(name);
	rc=build_rules(p->idx);
	return rc;
}
#ifdef LIST
void trace_non_list(void){
	NON_LIST *p;
	for(p=non_list.next;p;p=p->next)
		fprintf(stdout,"%s %d\n",p->name,p->idx);
}
void trace_rul_list(void){
	RUL_LIST *p;
	TOK_LIST *t;
	NON_LIST *n;
	int owner=-1,idx,i;
	char *name;
	hiterm=tok_list.next->idx;
	for(p=rul_list.next;p;p=p->next){
		if(owner!=p->owner){
			owner=p->owner;
			for(n=non_list.next;n;n=n->next)
				if(owner==n->idx){
					name=n->name;
					break;
				}
			fprintf(stdout,"%s:\n",name);
		}
		if(NULL==n){
			yyerror("Undefined non-terminal.");
			return;
		}
		for(i=0;p->prod[i];i++){
			int found=0;
			if(p->prod[i]<lowterm){
				if(isprint(p->prod[i])){
					fprintf(stdout,"  '%c'",p->prod[i]);
					found=1;
				}
			}
			else if(p->prod[i]<=hiterm){
				for(t=tok_list.next;t;t=t->next){
					if(p->prod[i]==t->idx){
						fprintf(stdout,"  %s",t->name);
						found=1;
						break;
					}
				}
			}
			else{
				for(n=non_list.next;n;n=n->next)
					if(p->prod[i]==n->idx){
						fprintf(stdout,"  %s",n->name);
						found=1;
						break;
					}
			}
			if(!found){
				yyerror("Undefined rule.");
				return;
			}
		}
		fprintf(stdout,"\n");
	}
}
#else
#define trace_non_list()
#define trace_rul_list()
#endif
int rules_sect(void){
	static char name[33];
	while(!match(EOI)){
		/* end of rule section */
		if(match(NEW_SECT)){
			next();
			break;
		}
		/* matched whitespace */
		else if(match(CRLF)){
			next();
		}
		/* matched left hand side */
		else if(match(ID)){
			strncpy(
			name,yytext,(yyleng>32)?32:yyleng)[(yyleng>32)?32:yyleng]='\0';
			next();
			if(!match(':')){
				yyerror("Expected Non-Terminal");
				return -1;
			}
			next();
			if(parse_rule(name))
				return -1;
			next();
		}
		else{
			yyerror("Rule Expected");
			return -1;
		}
	}
	trace_non_list();
	trace_rul_list();
	return 0;
}
/************ end of file ******************************/