/*****	 input file scanning functions
	(C)opyright 1995, Thor R. Mirchandani
	All Rights Reserved
*/
#include "lite.h"
FILE *in,*out,*head;
char *yytext="";		/* pointer to character pattern of token */
int yyleng=0;			/* length of current token */
int lookahead=NO_TOKEN;	/* look-ahead token */
int lineno=0;			/* line-number */
char inbuf[LINELEN]={'\0'};
int yylex(void){
	static char *p="";
	do{
		if(!*p){
			if(!fgets(inbuf,LINELEN,in)) return EOI;
			p=inbuf;
			lineno++;
		}
	}while(!*p);
	while(isspace(*p)){
		/* a CR or LF character */
		if(*p=='\r'||*p=='\n'){
			yytext=p++;
			yyleng=1;
			return CRLF;
		}
		p++;
	}
	yytext=p;
	yyleng=1;
	switch(*p++){
		case '%':
			/* new section */
			if('%'==*p){
				p++;
				return NEW_SECT;
			}
			else if(isalpha(*p)){
				/* token definition */
				if(!strncmp("token",p,5)){
					p+=5;
					return TOKEN;
				}
			}
			break;
		case '\'':
			/* return ASCII value of a single-quoted character */
			if(*(p+1)=='\''){
				p++;
				return (int)*(p-1);
			}
			break;
		/* characters with special meaning in rules-section */
		case ':':
		case '|':
		case '{':
		case '}':
		case ';':
			return (int)*(p-1);
		default:
			/* identifier or number */
			if(isalpha(*yytext)){
				while((isalnum(*p)||*p=='_')){
					++p;
					++yyleng;
				}
				return ID;
			}
			else if(isdigit(*yytext)){
				while(isdigit(*p)){
					++p;
					++yyleng;
				}
				return NUMBER;
			}
	}
	return NO_TOKEN;
}
/* match a token */
int match(int t){
	if(NO_TOKEN==lookahead)
		lookahead=yylex();
	return lookahead==t;
}
/* advance the lookahead to the next token */
void next(void){
	lookahead=yylex();
}
int main(int argc,char *argv[]){
	if(argc<2) in=stdin;
	else if(NULL==(in=fopen(argv[1],"rb")))
		return fprintf(stderr,"leopard: Error opening %s\n",argv[1]);
	if(!def_sect()&&!rules_sect()&&!user_sect()&&!gen_parser()&&!gen_code())
		fprintf(stderr,"leopard: Successfully compiled %d lines\n",lineno);
	return (fclose(in)+fclose(out)+fclose(head));
}
/********** end of file *************************************************/