// airvcvw.cpp : implementation of the CAirvcView class
//

#include "stdafx.h"
#include "airvc.h"
#include <stdlib.h>
#include <math.h>

#include "airvcdoc.h"
#include "airvcvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAirvcView

IMPLEMENT_DYNCREATE(CAirvcView, CFormView)

BEGIN_MESSAGE_MAP(CAirvcView, CFormView)
	//{{AFX_MSG_MAP(CAirvcView)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAirvcView construction/destruction

CAirvcView::CAirvcView()
	: CFormView(CAirvcView::IDD)
{
	//{{AFX_DATA_INIT(CAirvcView)
	Turn = NULL;
	RMI = NULL;
	OBI = NULL;
	HSI = NULL;
	Horizon = NULL;
	Heading = NULL;
	Climbrate = NULL;
	Altimeter = NULL;
	Airspeed = NULL;
	ADF = NULL;
	//}}AFX_DATA_INIT
	
}

CAirvcView::~CAirvcView()
{
}

void CAirvcView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAirvcView)
	DDX_VBControl(pDX, IDC_TURN, Turn);
	DDX_VBControl(pDX, IDC_RMI, RMI);
	DDX_VBControl(pDX, IDC_OBI, OBI);
	DDX_VBControl(pDX, IDC_HSI, HSI);
	DDX_VBControl(pDX, IDC_HORIZON, Horizon);
	DDX_VBControl(pDX, IDC_HEADING, Heading);
	DDX_VBControl(pDX, IDC_CLIMBRATE, Climbrate);
	DDX_VBControl(pDX, IDC_ALTIMETER, Altimeter);
	DDX_VBControl(pDX, IDC_AIRSPEED, Airspeed);
	DDX_VBControl(pDX, IDC_ADF, ADF);
	//}}AFX_DATA_MAP
	
	Altimeter->SetFloatProperty("Value",11250);
    Airspeed->SetFloatProperty("Value",95);

    SetTimer(1,55,NULL);
    srand( (unsigned)time( NULL ) );  //set randomizer seed
	
}

/////////////////////////////////////////////////////////////////////////////
// CAirvcView diagnostics

#ifdef _DEBUG
void CAirvcView::AssertValid() const
{
	CFormView::AssertValid();
}

void CAirvcView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CAirvcDoc* CAirvcView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAirvcDoc)));
	return (CAirvcDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAirvcView message handlers

int CAirvcView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFormView::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

void CAirvcView::OnTimer(UINT nIDEvent)
{
float bank,pitch,speed,alt,climb,heading,turn;

	
	
	//this is not a real flight simulator
	bank = Horizon->GetFloatProperty("Bank") + (float) rand()/(float) RAND_MAX - (float) .5;
	if (bank>30) bank = 30;
    if (bank<-30) bank = -30;
    Horizon->SetFloatProperty("Bank",bank);
	
	pitch = Horizon->GetFloatProperty("Pitch") + (float) rand()/(float) RAND_MAX - (float) .5;
    if (pitch > 30) pitch = 30;
    if (pitch < -30) pitch = -30;
    Horizon->SetFloatProperty("Pitch",pitch);
	
	speed = Airspeed->GetFloatProperty("Value");
    climb = 50 * speed * sin(pitch * cos(bank * 3.14159 / 180) * 3.14159 / 180);
    Climbrate->SetFloatProperty("Value",climb);
    
    alt = Altimeter->GetFloatProperty("Value") + climb / 100;
    Altimeter->SetFloatProperty("Value",alt);
	
    speed = speed - climb / 2000;
    if (speed > 120) speed = 120;
    if (speed < 60) speed = 60;
    Airspeed->SetFloatProperty("Value",speed);
	
    heading = Heading->GetFloatProperty("Value") - speed * sin(bank * 3.14159 / 180) / 20;
    Heading->SetFloatProperty("Value",heading);
    
    OBI->SetFloatProperty("OBICourse",heading);
    ADF->SetFloatProperty("ADFBearing",heading + 30);
    RMI->SetFloatProperty("RMIBearing",heading + 45);
    HSI->SetFloatProperty("Value",heading);
	
	turn = speed * sin(bank * 3.14159 / 180) * sin(pitch * 3.14159 / 180);
	Turn->SetFloatProperty("Turn",turn);
	
    //In this cockpit demo, all instruments have the AutoRedraw property
    //set to false for improved refresh rates.  This requires that
    //you force the instruments to redraw after all the instruments'
    //properties have been updated.  Setting the Redraw property to
    //True forces the instruments to be refreshed immediately.
    
    Heading->SetNumProperty("Redraw",-1);
    Airspeed->SetNumProperty("Redraw",-1);
    Altimeter->SetNumProperty("Redraw",-1);
    Climbrate->SetNumProperty("Redraw",-1);
    Turn->SetNumProperty("Redraw",-1);
    HSI->SetNumProperty("Redraw",-1);
    Horizon->SetNumProperty("Redraw",-1);
    OBI->SetNumProperty("Redraw",-1);
    RMI->SetNumProperty("Redraw",-1);
    ADF->SetNumProperty("Redraw",-1);
    
	
	CFormView::OnTimer(nIDEvent);
}

void CAirvcView::OnDestroy()
{
	CFormView::OnDestroy();
	
	KillTimer(1);
	
}
