/*
 *	gdit - GDInTerpreter
 *
 *	File:	gdit.c
 *	Author:	D B Harvey-George
 *	Date:	30 March 1995
 *
 *	Copyright (C) 1995	DB Harvey-George
 *	http://www.demon.co.uk/3Wiz/webhead/gdit.html
 *
 *	A command which processes drawing directives on standard input and
 *	produces a gif file representing that image.  This program can be called
 *	from a cgi-script to produce images 'on the fly' based on variable
 *	input data.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	
 *	$Log:	gdit.c,v $
 * Revision 1.4  95/12/18  11:26:37  david
 * Increment version number.
 * 
 * Revision 1.3  95/07/20  16:50:40  david
 * Changed rindex to portable strchr.
 * 
 * Revision 1.2  95/05/30  00:04:37  david
 * Fixed bug 6.
 * Added -f for running script files directly.
 * Added image file parameter for loading initial image file directly.
 * 
 * Revision 1.1  95/05/01  11:39:21  david
 * Initial revision
 * 
 */

static char rcsid[] = "$Id: gdit.c,v 1.4 95/12/18 11:26:37 david Exp $";

#include <stdio.h>
#include "gd.h"


gdImagePtr open_as_gif(char *filename);
gdImagePtr open_as_xbm(char *filename);

static int debug = 0;

int silent = 0;
int prompt = 1;

void usage(char *);
void help(char *);

int main(
	int	argc,
	char	*argv[]	) 
{
	int		opt;
	extern int	optind;
	extern char	*optarg;
	extern FILE	*yyin;
	extern gdImagePtr      image_out;

	char		*file;

	(void) init_gdit();
    	if (!isatty(0)) {
/*
 *		work silently if there's no one to listen.
 */
		silent = 1;
		prompt = 0;
	}
	while ((opt=getopt(argc,argv,"sdvw?hf:")) != EOF)
                switch (opt) {
		case 'd':
			debug=1;
			fprintf(stderr, "turned on debug\n");
			break;
		case 's':
			silent = 1;
			break;
		case 'w':
			silent = 0;
			break;
		case 'v':
			printf("%s\n", rcsid);
			break;
                case '?':
                        usage(argv[0]);
			return 0;
                case 'h':
                        help(argv[0]);
			return 0;
		case 'f':
			file = optarg;
			if (strncmp(strrchr(file, '.'), ".gdt", 4)) {
				break;
			}
			printf("script: %s\n", file);
			if ((yyin = fopen(file, "rb")) == NULL) {
                		fprintf(stderr, "cannot open script file: %s\n",
					file);
			}
			break;
		default:
			return 0;
                }/* switch */

	if (optind < argc) {
		file = argv[optind++];
		if (strncmp(strrchr(file, '.'), ".gif", 4) == 0) {
			image_out = open_as_gif(file);
		} else if (strncmp(strrchr(file, '.'), ".xbm", 4) == 0) {
			image_out = open_as_xbm(file);
		}
	}

	if (prompt) {
		printf("gdit (C) Copyright 1995, DB Harvey George\n\n");
		printf("> ");
	}
	return yyparse();
}/* main */

int
yyerror(
	char *s	)
{
	if (!silent) {
		fprintf(stderr, "%s: ", s);
	}
}/* yyerror */


void
usage(
	char	*name	)
{
	printf("Usage: %s -sd?\n", name);
	printf("\t-s\tsilent operation\n");
	printf("\t-w\tturn warning on [default is on]\n");
	printf("\t-d\tturn on parser debugging\n");
	printf("\t-v\tprint version number\n");
	printf("\t-?\tprint usage message\n");
	printf("\t-h\thelp\n");
}/* usage */


void
help(
	char	*name	)
{
	printf("Help on %s\n\n", name);
	printf("for more complete help run gdit and enter:\n");
	printf("help topic at the prompt\n\n");
}/* help */
