program Flash;

{$N-,E-,Q+,S+,R+,I-,O-,F+,P+,T-,X-,V-,B+,A+,G+,D-,L-,Y-}
{$M 1024,0,0}  (* < Make the program calculate its own memory needs! *)

(* Compiled in Borland Turbo Pascal 7.0 for DOS *)

uses crt,drivers;

var
Adjuster : char;
TimeValue,ColorValue : shortint;

label Start,Next,Third;

procedure Beep;
begin
sound(262);
delay(100);
nosound;
end;

procedure Exit_Program;
begin
textcolor(7);
textbackground(0);
clrscr;
gotoxy(1,12);
textcolor(1);
write(' If you like "Flash", please send a small amount (address in the .Doc).....');
textcolor(129);
writeln('.');
gotoxy(1,24);
textcolor(7);
donesyserror;
halt;
end;

begin         (* main *)
initsyserror; (* In drivers unit, turns off Ctrl-Break. *)
directvideo:=true;  (* Skip video bios, write to directly Vram or Dram on
                       video card. For speed & clarity. *)
ColorValue:=0;
repeat
begin
textcolor(ColorValue);
textbackground(ColorValue);
clrscr;
ColorValue := ColorValue + 1;
delay(200);
end;
until ColorValue = 8;

Start:
textcolor(7);
textbackground(0);
clrscr;
gotoxy(1,3);
write(' "Flash');
textcolor(135);
write('!');
textcolor(7);
writeln('" 5.0 Copyright (C) 1995.');
writeln(' Multi-color, multi-speed strobe light;');
writeln;
writeln(' Enter 0 if you want to exit now, or from anywhere within this program.....');
writeln(' What speed strobe light? 4 times per second thru 20 initially. While it''s');
writeln(' flashing you make it Fast or Slow it down by hitting the F key or the S key.');
writeln(' (Fast or Slow, f or s.) Please read the Flash.Doc file for help or details.');
writeln(' (However, it''s easy to use and it keeps you inside this range.)');
write(' Enter a whole number from 4 thru 20  >  ');
reset(input);
if not eoln(input) then (* Checks for end-of-line marker at screen file. *)
readln(TimeValue) (* Initial assignment of TimeValue. *)
else goto Start; (* If Enter pressed by itself, don't drop down one line. *)

if ioresult = 106 then goto Start; (* Any entry other than a whole number, *)
                                   (* such as a character or a period, etc. *)
if  TimeValue = 0 then Exit_Program;

if (TimeValue < 4) or (TimeValue > 20) then goto Start;

case TimeValue of (* Here TimeValue gets RE-assigned; (Conserve on variables.) *)
 4 : TimeValue := 125; (* (1000/4)/2, 125 exactly. *)
 5 : TimeValue := 100;
 6 : TimeValue :=  83; (* (1000/6)/2, rounded to 83, etc. *)
 7 : TimeValue :=  71;
 8 : TimeValue :=  63;
 9 : TimeValue :=  56;
10 : TimeValue :=  50;
11 : TimeValue :=  45;
12 : TimeValue :=  42;
13 : TimeValue :=  38;
14 : TimeValue :=  36;
15 : TimeValue :=  33;
16 : TimeValue :=  31;
17 : TimeValue :=  29;
18 : TimeValue :=  28;
19 : TimeValue :=  26;
20 : TimeValue :=  25;
end;

writeln;
writeln(' What color strobe light? (Blue, Green, Turquoise, Red, Purple, Clay, White).');
write(' Here are the colors in order:');
textcolor(1);
write('  ');
textcolor(2);
write('');
textcolor(3);
write('');
textcolor(4);
write('');
textcolor(5);
write('');
textcolor(6);
write('');
textcolor(7);
write('  ');
writeln('Hit the B, G, T, R, P, C, or W key.');
writeln(' Starts immediately. While it''s flashing: If you hit one of the above color');
writeln(' keys, it flashes in the new color, same speed. F is for Faster, S for Slower.');
writeln(' If you hit some other key such Esc or Enter, etc you go back to the top, the');
writeln(' speed menu. From there you can begin over, or exit. If you hit 0, now or from');
writeln(' within the light, then you exit Flash. Enjoy!');
gotoxy(39,14);
Adjuster:=readkey; (* Chooses color. *)

Next:
case Adjuster of
'B','b' : ColorValue := 1; (* The ANSI values for low-intensity blue thru white. *)
'G','g' : ColorValue := 2;
'T','t' : ColorValue := 3;
'R','r' : ColorValue := 4;
'P','p' : ColorValue := 5;
'C','c' : ColorValue := 6;
'W','w' : ColorValue := 7;
'0'     : Exit_Program;
else
begin
gotoxy(1,21);
write(' Wrong key. Hit any key now to try again from the top....(or 0 to exit)');
gotoxy(39,14);
Adjuster:=readkey; (* Here Adjuster only pauses the display mostly. *)
if Adjuster = '0' then Exit_Program
else goto Start;
end;
end;

Third:  (* Strobe section itself. *)
repeat
begin
textcolor(ColorValue);
textbackground(ColorValue);
clrscr;
delay(TimeValue);
textcolor(0);
textbackground(0);
clrscr;
delay(TimeValue);
end;
until keypressed;

Adjuster:=readkey;

case Adjuster of (* Color adjustment section. *)
'b','B','g','G','t','T','r','R','p','P','c','C','w','W','0' : goto Next
else
begin (* Speed adjustment section. *)
case Adjuster of
'f','F','s','S' :
begin

if TimeValue > 125 then
begin
if (Adjuster = 's') or (Adjuster = 'S') then Beep;
Adjuster := 'F';
TimeValue := 125;
end;
if TimeValue < 25 then
begin
if (Adjuster = 'f') or (Adjuster = 'F') then Beep;
Adjuster := 'S';
TimeValue := 25;
end;

if (Adjuster = 'f') or (Adjuster = 'F') then TimeValue := TimeValue - 1;
if (Adjuster = 's') or (Adjuster = 'S') then TimeValue := TimeValue + 1;
goto Third;

end;
end;
end;
goto Start;
end;

end.