/**************************************************************************/
/*                             Reformat Utility                           */
/*                                                                        */
/*                                 M\Cooper                               */
/*                        3425 Chestnut Ridge Rd.                         */
/*                        Grantsville, MD 21536-9801                      */
/*                        --------------------------                      */
/*                        Email:  thegrendel@aol.com                      */
/*                                                                        */
/*                $2.00 to register the entire WORDY package              */
/*                                                                        */
/*      Reformats the files created by the pattern matching utilities     */
/*          so that they print in an "optimum" number of columns.         */
/*                                                                        */
/**************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define MAXLEN 82
#define LINE_LEN 80
#define NOARGS 1
#define FULLARGS 3
#define INCREMENT 1
#define SPACE ' '
#define MAXWORDLEN 24
#define WORDSPACING 3
//#define COLUMNS 5 (see below)
#define BUFFERSIZE 4096

typedef enum { LESS_THAN, EQUAL, GREATER_THAN, ANOMALY } A_flag;
typedef enum { OFF, ON } Mod_flag;


void reformat( char *fname, int maxwordlength, int thr_wlen, A_flag action );
A_flag parse_action( char *second_arg );
int parse_threshhold ( char *second_arg );
int get_max_word_length( char *fname );
void center( char *strg ); 

char ad[] =
"REFORMAT utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536";




typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char filename[ MAXLEN ];
   int mwl,
       threshhold = MAXWORDLEN;
   A_flag action_flag;

	 if( argc == NOARGS )
	    {
	    clrscr();
	    puts("Enter a FILENAME to reformat... ");
	    gets( filename );
	    }
	 else
	    strcpy( filename, *( argv + 1 ) );

      if( argc == FULLARGS )
          {
          action_flag = parse_action( *( argv + 2 ) );
          threshhold =  parse_threshhold( *( argv + 2 ) );
          }
      else
         {
         action_flag = ANOMALY;
         threshhold = MAXWORDLEN;
         }

	 mwl = get_max_word_length( filename );
	 reformat( filename, mwl, threshhold, action_flag );
}




/*************************************************************/
void reformat( char *filename, int maxwl, int threshlen, A_flag action )
{

	char	word [ MAXLEN ],
      desc_messg [ MAXLEN ],
      count_messg [ MAXLEN ],
		tempstr [ MAXLEN + 3 ],
		targetfile [ MAXLEN ],
		tempfilename [ MAXWORDLEN ] = "tmp$$$.$$$",
		bar [ LINE_LEN + 1 ],
		double_bar [ LINE_LEN + 1 ];

	FILE *fptr,
		*tfile;
	long wcount = 0L;
     int columns,
         interval,
         t_up = MAXWORDLEN,
         t_down = 0;


	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

	   /*************opening credits*************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /****************************************/


	   /*   Create name of temp file to store derived words in  */
	   /*********************************************************/
	   strcpy( targetfile, tempfilename );
	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to reformat!" );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 1 );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open temp working file!" );
		 exit ( FILE_OPENING_ERROR + 2 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 3 );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "Reformatting file %s.\n", filename );
	   printf( "It may take a few seconds, depending on file length.\n\n" );
	   /*****************************************/


		 /*********************Check for word limits*********************/	 

      threshlen += 1; //Compensate for CR at end of each word.

      switch ( action )
             {
             case EQUAL:
                  t_up = threshlen + 1;
                  t_down = threshlen - 1;
                  sprintf( desc_messg, "List restricted to words exactly %d letters long.", threshlen - 1 );
                  break;
             case LESS_THAN:
                  t_up = threshlen;
                  t_down = 0;
                  sprintf( desc_messg, "List restricted to words less than %d letters long.", threshlen - 1 );
                  break;
             case GREATER_THAN:
                  t_up = MAXWORDLEN;
                  t_down = threshlen;
                  sprintf( desc_messg, "List restricted to words more that %d letters long.", threshlen - 1 );     
                  break;
             case ANOMALY:        //accept all...
                  t_up = MAXWORDLEN;
                  t_down = 0;
             default: 
                  break;

             }
      maxwl = maxwl > t_up ? t_up : maxwl;
      //Readjust column width, as necessary.

	   columns = LINE_LEN / ( maxwl + WORDSPACING );
      interval = maxwl + WORDSPACING;

		 /*********************Main Loop*************/	 

      printf( "\nThe file will be reformatted in %d columns.", columns );

		  while( fgets( word, MAXLEN, fptr ) != NULL )

                              /*****888copy action888***/
    if( strlen( word ) > t_down &&
       strlen( word ) < t_up &&
       !isspace( *word )  )


			   {
      wcount++;

			   *( word + strlen( word ) -1 ) = NULL;  //Gets rid of CR

			   fprintf( tfile, "%-*s", interval, word );

			   if( !( wcount % columns ) )
				  fprintf( tfile, CR );
			   }
			else
    if( strlen( word)  >= MAXWORDLEN  && !iscntrl( *word ) )
			   fprintf( tfile, "\n%s", word );

     /**************999*************/


      sprintf( count_messg, "From the original list, %ld words have been selected.", wcount );
      center( count_messg );
      fprintf( tfile, "\n\n%s", count_messg );
      center ( desc_messg );
      fprintf( tfile, "\n\n%s", desc_messg );

		  /*******************************************/

		  fcloseall();

		  remove( filename );
		  rename( targetfile, filename );

		  sprintf( tempstr,
				 "The file %s has been reformatted.", filename );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}

int get_max_word_length( char *filename )
{
   int wlen,
	  maxwlen = 0; // Longest word in file
   char word [ MAXLEN ];
   FILE *fp;

      if( !( fp = fopen( filename, "rt" ) ) )
	        {
		    printf( "\7\7\7Cannot open file to reformat!" );
		    exit( FILE_OPENING_ERROR );
		    }

      clrscr();
      printf( "Getting formatting information from file... \n" );
      printf( "Please wait." );

	  while( fgets( word, MAXLEN, fp ) != NULL )
		{
		wlen = strlen( word );
		if( wlen > maxwlen && wlen < MAXWORDLEN )
		   maxwlen = wlen;  //Bump up to new value.
		}

	 return( maxwlen );
}

void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}

A_flag parse_action( char *arg2 )
{

      switch ( *arg2 )
         {
         case 'g':
         case 'G':
         case 'm':
         case 'M':
         case 'O':
         case 'o':
              return( GREATER_THAN );
         case 'l':
         case 'L':
         case 'f':
         case 'F':
         case 'U':
         case 'u':
         case 's':
         case 'S':
              return( LESS_THAN );
        case 'e':
        case 'E':
        case '=':
             return( EQUAL );
        }

      return( ANOMALY );
}

int parse_threshhold ( char *arg2b )
{

      return( atoi( arg2b + 1 ) );
}
