/* ------------------------------------------------------------------------ */
/* Hard Disk Maintenance                                                    */
/* by Ricard Forner           Internet: <se03421@els.url.es>                */
/*                            Fidonet:  Ricard_Forner, 2:343/130.5          */
/*                                                                          */
/* You may freely use or incorporate these routines into your own programs  */
/* without royalty to me, as I believe this is beneficial to programmers.   */
/* However, I would like to request that if you distribute the source code, */
/* you would include this header in the source file and not remove it.      */
/* Of course, I would have no way of knowing, but I am appealing to your    */
/* sense of good will and morality.  Thank you, and I hope these routines   */
/* are useful.                                                              */
/*                                                                          */
/* December, 1995 - Version 1.0                                 [FREEWARE]  */
/* ------------------------------------------------------------------------ */


#include <conio.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>

#define FALSE 0
#define TRUE  1

/* -------------------------------------------------------------------- */

struct Card {
   char subpath[MAXPATH];
   long jump;
   struct Card *pointer;
} *capf, *pf, *qf;

struct _Drive_ {
   int hdinit;
   int hdnumber;
} driveinit;

char StatusTXT[4] = { '|', '/', '-', '\\'};
char StatusNUM;
char final;
char ophelp;
char option[3];
char filename[15];
char TextLog[5][32];
char TextError[5][44];
int  numerror;
int  drive;
int  ch;

FILE* FileWork;
FILE* FileWorkLog;

/* -------------------------------------------------------------------- */

int	  NumberOfDrives   (void) ;
void  MAIN_Start	   (void) ;
void  MAIN_End		   (void) ;
void  MAIN_Parameters  (int, char**) ;
void  MAIN_Operate	   (void) ;
void  Help			   (void) ;
void  Concatena        (void) ;
void  DIR_Dir		   (struct ffblk) ;
void  DIR_Write		   (struct ffblk) ;
void  DIR_File		   (struct ffblk) ;
void  DIR_All		   (struct ffblk) ;
void  LIST_Create	   (char*) ;
void  LIST_Delete      (void) ;
char  LIST_Search      (struct Card*, char*) ;
void  FILE_Create      (char*) ;
void  FILE_CreateLog   (void) ;
void  FILE_WritePath   (void) ;
void  FILE_WriteFile   (struct ffblk) ;
void  FILE_ReadAll     (void) ;
char* FILE_ReadStr     (void) ;
void  FILE_JumpChar    (void) ;
void  Status           (void) ;
void  FileNoDir        (struct ffblk, int) ;
void  OptionCreate     (void) ;
void  OptionMaint      (void) ;
void  OptionLook       (void) ;
void  LookAll          (void) ;
void  LookPath         (char*, struct Card*) ;
void  LookNoIs         (char*, int) ;

/* -------------------------------------------------------------------- */

void main (int ac, char** av)
{
   MAIN_Start();
   MAIN_Parameters(ac, av);
   MAIN_Operate();
   MAIN_End();
}

/* */

int NumberOfDrives(void)
{
int save, disk, num_d=0;

   save=getdisk();
   setdisk(save);
   for (disk=0; disk<26; ++disk)
   {
	  setdisk(disk);
	  if (disk == getdisk()) num_d++;
   }
   setdisk(save);
   return num_d-2;
}

/* */

void MAIN_Start(void)
{
   capf=pf=qf=NULL;
   ophelp=final=FALSE;
   option[0]=option[1]=option[2]=FALSE;
   drive=numerror=-1;
   StatusNUM=0;
   strcpy(TextError[0]," Memory exhausted.");
   strcpy(TextError[1]," Destination file did not create.");
   strcpy(TextError[2]," Operating system error.");
   strcpy(TextError[3]," Archive not found.");
   strcpy(TextError[4]," Archive incorrect.");
   strcpy(TextLog[0],"[HDCTRL.LOG v1.00]");
   strcpy(TextLog[1],"  Directory deleted..:  ");
   strcpy(TextLog[2],"  File deleted.......:  ");
   strcpy(TextLog[3],"  Miss (directory)...:  ");
   strcpy(TextLog[4],"  Miss (file)........:  ");
   driveinit.hdinit = getdisk();
   driveinit.hdnumber = NumberOfDrives();
   setdisk(driveinit.hdinit);

   _setcursortype(_NOCURSOR);
   printf("\n");
   printf("HDCTRL.EXE v1.00\n");
   printf("by Ricard Forner\n");
}

/* */

void MAIN_End(void)
{
   LIST_Delete();
   setdisk(driveinit.hdinit);
   getdisk();
   _setcursortype(_NORMALCURSOR);
   if ((drive>-1) && (ophelp==FALSE) && (numerror<0))
	  if (driveinit.hdinit==(drive+2)) chdir("\\");
}

/* */

void MAIN_Parameters(int argc, char** argv)
{
char i, j, texttmp[3];

   strcpy(texttmp, "A:\0");
   for (i=1; i<argc; i++)
   {
	  strupr(argv[i]);
	  for (j=0; j<driveinit.hdnumber; j++)
	  {
		 texttmp[0]=j+'C';
		 if (strstr(argv[i], texttmp)) { drive=j; break; }
	  }
	  if (strstr(argv[i], "/?")) { ophelp=TRUE; break; }
	  if (strstr(argv[i], "/C")) { option[0]=TRUE; continue; }
	  if (strstr(argv[i], "/R")) { option[1]=TRUE; continue; }
	  if (strstr(argv[i], "/M")) { option[2]=TRUE; continue; }
   }
   if ((option[0]==FALSE) && (option[1]==FALSE) && (option[2]==FALSE)) ophelp=TRUE;
   if (drive<0) ophelp=TRUE;
}

/* */

void MAIN_Operate(void)
{
   if (ophelp==TRUE) { Help(); return; }
   if (option[0]==TRUE) { OptionCreate(); return; }
   if (option[1]==TRUE) { OptionMaint(); return; }
   if (option[2]==TRUE) { OptionLook(); return; }
}

/* */

void Help(void)
{
   printf("\n");
   printf("Usage: HDCTRL.EXE  drive: /C|R|M|?\n");
   printf("\n");
   printf("             drive:   Logical drive\n");
   printf("             /C       Create archive\n");
   printf("             /R       Maintenance\n");
   printf("             /M       Which files were missed ?\n");
   printf("             /?       This help\n");
   printf("\n");
}

/* */

void error (int num)
{
   numerror=num;
   printf("\nERROR:%s", TextError[num]);
   MAIN_End();
   exit(0);
}

/* */

void Concatena(void)
{
char *file_tmp = "\\Hdctrl.___\0";

   strcpy(filename, file_tmp);
   filename[strlen(filename)-2] = drive + 'C';
}

/* */

void DIR_Dir(struct ffblk p)
{
int fin;
	fin = findfirst("*.*", &p, (FA_DIREC | FA_HIDDEN | FA_SYSTEM));
	DIR_Write(p);
	while (!fin)
	{
		if (p.ff_name[0]!='.')
		{
			if (p.ff_attrib & FA_DIREC)
			{
			   if (chdir(p.ff_name)) error(2);
			   DIR_Write(p);
			   DIR_Dir(p);
			}
		}
		fin = findnext(&p);
	}
	chdir("..");
}

/* */

void DIR_Write(struct ffblk p)
{
char buffer[MAXPATH];

   getcwd(buffer, MAXPATH); strupr(buffer);
   if (p.ff_name[0]!='.') LIST_Create(buffer);
}

/* */

void DIR_File(struct ffblk p)
{
int fin;

   fin = findfirst("*.*", &p, (FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH));
   if (!fin)
   {
	  FILE_WritePath();
	  while (!fin)
	  {
		 if (p.ff_name[0]!='.')
		 {
			if (!(p.ff_attrib & FA_DIREC)) FILE_WriteFile(p);
		 }
		 fin = findnext(&p);
		 Status();
	  }
   }
}

/* */

void DIR_All(struct ffblk p)
{
int fin;
	fin = findfirst("*.*", &p, (FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH));
	while (!fin)
	{
		if (p.ff_name[0]!='.')
		{
			if (p.ff_attrib & FA_DIREC)
			{
				  if (chdir(p.ff_name)) error(2);
				  DIR_All(p);
				  FileNoDir(p,FALSE);
			}
			else { FileNoDir(p,TRUE); }
		}
		fin = findnext(&p);
		Status();
	}
	chdir("..");
}

/* */

void LIST_Create(char *name)
{
   if (capf==NULL)
   {
	  capf = (struct Card*)malloc(sizeof(struct Card));
	  pf = capf;
   }
   else
   {
	  qf = (struct Card*)malloc(sizeof(struct Card));
	  pf->pointer = qf; pf = qf;
   }
   if (pf==NULL) error(0);
   pf->pointer = NULL;
   if ((option[1]==TRUE) || (option[2]==TRUE)) pf->jump = ftell(FileWork);
   strcpy(pf->subpath, name);
}

/* */

void LIST_Delete(void)
{
   pf = capf;
   while (capf!=NULL)
   {
	  capf = pf->pointer;
	  free(pf);
	  pf = capf;
   }
}

/* */

char LIST_Search(struct Card* valuef, char *name)
{
char path_Ok;

   path_Ok = FALSE;
   qf = capf;
   while (qf!=NULL)
   {
	  if (strcmp(qf->subpath, name)==0)
	  {
		 path_Ok = TRUE;
		 break;
	  }
	  else path_Ok = FALSE;
	  qf = qf->pointer;
   }
   *valuef=*qf;
   return path_Ok;
}

/* */

void FILE_Create(char* mode)
{
   FileWork=fopen(filename, mode);
   if (FileWork == NULL) error(1);
}

/* */

void FILE_CreateLog(void)
{
char *file_temp = "\\Hdctrl.Log\0";

   FileWorkLog=fopen(file_temp, "wt");
   if (FileWorkLog == NULL) error(1);

   fputc(10, FileWorkLog);
   fputs(TextLog[0], FileWorkLog);
   fputc(10, FileWorkLog);
}

/* */

void FILE_WritePath(void)
{
char buffer[MAXPATH];

   getcwd(buffer, MAXPATH); strupr(buffer);
   if (buffer[strlen(buffer)-1]!='\\') strcat(buffer, "\\\0");
   fprintf(FileWork, "%s", buffer);
   fprintf(FileWork, "%c%c", 254, 10);
   if (buffer[3]=='\0') fprintf(FileWork, "HDCTRL.LOG%c", 10);
}

/* */

void FILE_WriteFile(struct ffblk p)
{
   if (p.ff_name[0]!='.')
   {
	  if (!(p.ff_attrib & FA_DIREC))
	  {
		 fprintf(FileWork, "%s%c", strupr(p.ff_name), 10);
	  }
   }
}

/* */

void FILE_ReadAll(void)
{
char *nametmp;
char nameok[MAXPATH];

   ch = fgetc(FileWork);
   nametmp = FILE_ReadStr();
   strcpy(nameok, nametmp);
   if (strcmp(nameok, "_DIR_\0")) error(4);
   while ((!feof(FileWork)) && (final==FALSE))
   {
	  nametmp = FILE_ReadStr();
	  strcpy(nameok, nametmp);
	  LIST_Create(nameok);
	  FILE_JumpChar();
   }
}

/* */

char* FILE_ReadStr(void)
{
char name[MAXPATH];
unsigned char i;

   i=0;
   while ( (!feof(FileWork)) && (ch!=10) )
   {
	  name[i++] = ch;
	  ch = fgetc(FileWork);
   }
   name[i]='\0';
   if (feof(FileWork)) { final=TRUE; }
   else { ch=fgetc(FileWork); }
   return name;
}

/* */

void FILE_JumpChar(void)
{
char *name;

   while ( (!feof(FileWork)) && (final==FALSE) )
   {
	  name = FILE_ReadStr();
	  if (!strcmp(name, "_DIR_\0")) break;
   }
}

/* */

void Status(void)
{
   gotoxy(wherex()-3, wherey()); printf("<%c>", StatusTXT[StatusNUM]);
   StatusNUM=(StatusNUM==3)?0:StatusNUM+1;
}

/* */

void FileNoDir(struct ffblk p, int isafile)
{
char buffer[MAXPATH], *bar_inv="\\\0";
char name[MAXPATH];
char find;
struct Card cardtmp;
int i;

   find = FALSE;
   getcwd(buffer, MAXPATH);
   if (buffer[strlen(buffer)-1]!='\\') strcat(buffer, bar_inv);
   strcat(buffer, "\0");

   if (isafile==FALSE)
   {
	  strncpy(buffer, buffer, strlen(buffer)-2);
	  buffer[strlen(buffer)-1]='\0';
	  strcat(buffer, p.ff_name);
	  if (buffer[strlen(buffer)-1]!='\\') strcat(buffer, bar_inv);
	  strcat(buffer, "\0");
	  find = LIST_Search(&cardtmp, buffer);
   }
   else {
	  if (LIST_Search(&cardtmp, buffer)==TRUE)
	  {
		 rewind(FileWork);
		 final = FALSE;
		 fseek(FileWork, cardtmp.jump-1, SEEK_SET);
		 ch = fgetc(FileWork);
		 strcpy(name, FILE_ReadStr());
		 while ((final==FALSE) && (strcmp(name, "_DIR_\0")))
		 {
			if (strcmp(name, p.ff_name)==0) { find=TRUE; break; }
			strcpy(name, FILE_ReadStr());
			find=FALSE;
		 }
	  }
	  strncpy(buffer, buffer, strlen(buffer)-2);
	  buffer[strlen(buffer)-1]='\0';
	  strcat(buffer, p.ff_name);
   }
   if (find==FALSE)
   {
	  if (p.ff_attrib & FA_RDONLY) if (chmod(p.ff_name, S_IWRITE)) error(2);
	  if (isafile==TRUE)
	  {
		 if (unlink(p.ff_name)) error(2);
		 fputs(TextLog[2], FileWorkLog);
		 fputs(buffer, FileWorkLog);
		 fputc(10, FileWorkLog);
	  }
	  else
	  {
		 if (rmdir(p.ff_name)) error(2);
		 buffer[strlen(buffer)-2]='\0';
		 fputs(TextLog[1], FileWorkLog);
		 fputs(buffer, FileWorkLog);
		 fputc(10, FileWorkLog);
	  }
   }
}

/* */

void OptionCreate(void)
{
struct ffblk p;

   Concatena();
   setdisk(drive+2);
   if (chdir("\\")) error(2);
   printf("In process ...");
   DIR_Dir(p);
   pf = capf;
   if (pf!=NULL) FILE_Create("wt");
   while (pf!=NULL)
   {
	  if (chdir("\\")) error(2);
	  if (chdir(pf->subpath)) error(2);
	  fprintf(FileWork, "%c_DIR_%c%c", 249, 249, 10);
	  DIR_File(p);
	  pf = pf->pointer;
   }
   if (chdir("\\")) error(2);
   gotoxy(wherex()-3, wherey()); printf(" OK\n");
   printf("File %c:\\HDCTRL._%c_ created\n", drive+'C', drive+'C');
   fclose(FileWork);
}

/* */

void OptionMaint(void)
{
struct ffblk p;

   Concatena();
   setdisk(drive+2);
   if (access(filename, 0)) error(3);
   if (chdir("\\")) error(2);
   printf("In process ...");
   FILE_Create("rt");
   FILE_CreateLog();
   FILE_ReadAll();
   rewind(FileWork);
   DIR_All(p);
   fputs("[EOF]", FileWorkLog);
   fputc(10, FileWorkLog);
   if (chdir("\\")) error(2);
   gotoxy(wherex()-3, wherey()); printf(" OK\n");
   printf("File %c:\\HDCTRL.LOG created\n", drive+'C');
   fclose(FileWork);
}

/* */

void OptionLook(void)
{
   Concatena();
   setdisk(drive+2);
   if (access(filename, 0)) error(3);
   if (chdir("\\")) error(2);
   printf("In process ...");
   FILE_Create("rt");
   FILE_ReadAll();
   FILE_CreateLog();
   LookAll();
   if (chdir("\\")) error(2);
   gotoxy(wherex()-3, wherey()); printf(" OK\n");
   printf("File %c:\\HDCTRL.LOG created\n", drive+'C');
   fclose(FileWork);
   fclose(FileWorkLog);
}

/* */

void LookAll(void)
{
char buffer[MAXPATH];
struct Card *cardtmp;

   rewind(FileWork);
   cardtmp = capf;
   while (cardtmp!=NULL)
   {
	  strcpy(buffer, cardtmp->subpath);
	  buffer[strlen(buffer)-1]='\0';
	  LookPath(buffer, cardtmp);
	  cardtmp = cardtmp->pointer;
   }
   fputs("[EOF]", FileWorkLog);
   fputc(10, FileWorkLog);
}

/* */

void LookPath(char *namepath, struct Card *temp)
{
char namefile[MAXPATH];
char destino[MAXPATH];

   Status();
   strcpy(destino, namepath); destino[strlen(destino)-1] = '\0';
   if (access(destino, 0)!=FALSE) LookNoIs(destino, FALSE);
   final = FALSE;
   fseek(FileWork, temp->jump-1, SEEK_SET);
   ch = fgetc(FileWork);
   strcpy(namefile, FILE_ReadStr());
   while ( (final==FALSE) && (strcmp(namefile, "_DIR_\0")) )
   {
	  strcpy(destino, namepath);
	  strcat(destino, namefile);
	  if (access(destino, 0)!=FALSE) LookNoIs(destino, TRUE);
	  Status();
	  strcpy(namefile, FILE_ReadStr());
   }
   if (final==TRUE)
   {
	  if (strlen(namefile))
	  {
		 strcpy(destino, namepath);
		 strcat(destino, namefile);
		 if (access(destino, 0)!=FALSE) LookNoIs(destino, TRUE);
	  }
   }
}

/* */

void LookNoIs(char *name, int isafile)
{
   if (strlen(name)==2) return;
   if (isafile==FALSE) fputs(TextLog[3], FileWorkLog);
   else fputs(TextLog[4], FileWorkLog);
   fputs(name, FileWorkLog);
   fputc(10, FileWorkLog);
}

/* [EOF] */
